/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.list.range;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.util.StringUtils;
import kd.fi.gl.formplugin.voucher.list.range.IRangeProperty;
import kd.fi.gl.formplugin.voucher.list.range.VoucherRange;

public class VoucherRanges {
    private final List<VoucherRange> ranges;

    @JsonCreator
    public VoucherRanges(@JsonProperty(value="ranges") List<VoucherRange> ranges) {
        this.ranges = Collections.unmodifiableList(ranges);
    }

    public List<VoucherRange> getRanges() {
        return this.ranges;
    }

    @JsonIgnore
    public List<VoucherRange> getSubRanges(int start, int limit) {
        int endIndex = start + limit - 1;
        return Collections.unmodifiableList(this.ranges.stream().filter(x -> start <= x.getEndIndex() && endIndex >= x.getStartIndex()).collect(Collectors.toList()));
    }

    @JsonIgnore
    public String serialization() {
        return SerializationUtils.toJsonString((Object)this);
    }

    @JsonIgnore
    public static VoucherRanges deserialization(String value) throws JsonProcessingException {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        return (VoucherRanges)mapper.readValue(value, VoucherRanges.class);
    }

    public String toString() {
        return "PropertyRanges{ranges=" + this.ranges + '}';
    }

    public static class Builder {
        private final int start;
        private int totalCount = 0;
        private VoucherRange last;
        private final List<VoucherRange> ranges = new ArrayList<VoucherRange>(10);

        public Builder() {
            this.start = 0;
        }

        public void add(IRangeProperty property, int count) {
            if (count <= 0) {
                return;
            }
            if (this.last == null || !this.last.getProperty().equals(property)) {
                int startIndex = this.last == null ? this.start : this.last.getEndIndex() + 1;
                this.last = new VoucherRange(property, startIndex, startIndex + count - 1);
                this.ranges.add(this.last);
            } else {
                this.last.setEndIndex(this.last.getEndIndex() + count);
            }
            this.totalCount = Math.addExact(this.totalCount, count);
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public VoucherRanges build() {
            return new VoucherRanges(this.ranges);
        }
    }
}

