/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.list.result;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.RowUtil;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.SummaryResult;
import kd.fi.gl.formplugin.voucher.list.result.RowsResult;

public class VoucherRowsResultBuilder {
    private static final String ENTRIES = "entries.";
    private final QueryBuilder queryBuilder;
    private final boolean querySumFields;
    private final int pkSize;
    private final BigDecimal[] amounts;
    private final String[] fields;
    private final boolean isDistinctSum;
    private int rowCount;
    private int billDataCount;
    private RowsResult rowsResult;
    private RowMeta rowMeta;
    private Object prePK = null;
    private int seqIndex = 0;
    private Object billPrePk = null;
    private RowMeta newRowMeta = null;
    private Row lastRow = null;

    public VoucherRowsResultBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
        this.querySumFields = true;
        this.pkSize = queryBuilder.getPkFields().size();
        List sumFields = queryBuilder.getSumFields();
        int sumFieldsSize = sumFields.size();
        this.amounts = new BigDecimal[sumFieldsSize];
        this.fields = new String[sumFieldsSize];
        for (int i = 0; i < sumFieldsSize; ++i) {
            String fieldName;
            this.amounts[i] = BigDecimal.ZERO;
            this.fields[i] = fieldName = ((ListField)sumFields.get(i)).getFieldName();
        }
        this.isDistinctSum = this.isDistinctSum(queryBuilder);
        this.rowCount = 0;
        this.billDataCount = 0;
        this.rowsResult = new RowsResult(new ArrayList<Row>(queryBuilder.getLimit() <= 0 ? 10 : queryBuilder.getLimit()), this.billDataCount, new ArrayList<SummaryResult>(sumFieldsSize == 0 ? 1 : sumFieldsSize));
    }

    private boolean isDistinctSum(QueryBuilder queryBuilder) {
        boolean existHeadAmt = queryBuilder.getSumFields().stream().anyMatch(x -> x.getFieldName().startsWith(ENTRIES));
        boolean existEntry = Arrays.stream(queryBuilder.getSelectFields().split(",")).anyMatch(x -> x.startsWith(ENTRIES));
        return existHeadAmt && existEntry;
    }

    public VoucherRowsResultBuilder addRow(Row persistRow) {
        Row seqRow;
        String sqFieldStr = this.queryBuilder.getSeqField();
        if (this.newRowMeta == null && StringUtils.isNotBlank((CharSequence)sqFieldStr)) {
            this.newRowMeta = this.rowMetaAddField(((AbstractRow)persistRow).getRowMeta(), sqFieldStr, (DataType)DataType.IntegerType);
        }
        if (!this.queryBuilder.getSumFields().isEmpty()) {
            this.addRowSummaryResult(persistRow);
        }
        this.lastRow = persistRow;
        if (this.pkSize > 1) {
            String billPkStr = this.queryBuilder.getEntityType().getPrimaryKey().getName();
            Object billCurPK = persistRow.get(billPkStr);
            if (!billCurPK.equals(this.billPrePk)) {
                ++this.billDataCount;
            }
            this.billPrePk = billCurPK;
        } else {
            ++this.billDataCount;
        }
        if (StringUtils.isEmpty((CharSequence)sqFieldStr)) {
            seqRow = persistRow;
        } else if (this.pkSize > 1 && this.queryBuilder.isMergeRow()) {
            String pkStr = this.queryBuilder.getEntityType().getPrimaryKey().getName();
            Object curPK = persistRow.get(pkStr);
            this.seqIndex = this.prePK != null && !curPK.equals(this.prePK) ? 1 : ++this.seqIndex;
            this.prePK = curPK;
            seqRow = this.rowAddField(persistRow, this.seqIndex, this.newRowMeta);
        } else {
            seqRow = this.rowAddField(persistRow, this.seqIndex, this.newRowMeta);
            ++this.seqIndex;
        }
        ++this.rowCount;
        this.rowsResult.getDealRows().add(seqRow);
        return this;
    }

    private RowMeta rowMetaAddField(RowMeta rowMeta, String fieldName, DataType fieldType) {
        int count = rowMeta.getFieldCount();
        String[] fieldNames = new String[count + 1];
        DataType[] dataTypes = new DataType[count + 1];
        List dsDataType = rowMeta.getTypes();
        for (int i = 0; i < count; ++i) {
            fieldNames[i] = rowMeta.getFieldName(i);
            dataTypes[i] = (DataType)dsDataType.get(i);
        }
        fieldNames[count] = fieldName;
        dataTypes[count] = fieldType;
        return RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
    }

    private void addRowSummaryResult(Row row) {
        if (!this.querySumFields) {
            return;
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.isDistinctSum && !this.fields[i].startsWith(ENTRIES) && this.lastRow != null && row.getLong("id").equals(this.lastRow.getLong("id"))) continue;
            this.amounts[i] = this.amounts[i].add(row.getBigDecimal(this.fields[i]) == null ? BigDecimal.ZERO : row.getBigDecimal(this.fields[i]));
        }
    }

    private Row rowAddField(Row row, Object fieldValue, RowMeta newRowMeta) {
        Object[] rowValues = RowUtil.toArray((Row)row);
        int len = rowValues.length;
        Object[] newValues = new Object[len + 1];
        System.arraycopy(rowValues, 0, newValues, 0, len);
        newValues[len] = fieldValue;
        return RowFactory.createRow((RowMeta)newRowMeta, (Object[])newValues);
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public RowsResult build() {
        this.rowsResult.setBillDataCount(this.billDataCount);
        this.rowsResult.getSummaryResults().addAll(this.getSummaryResult(this.queryBuilder, this.fields, this.amounts).values());
        return this.rowsResult;
    }

    private Map<String, SummaryResult> getSummaryResult(QueryBuilder qb, String[] fields, BigDecimal[] amounts) {
        HashMap<String, SummaryResult> sumResultsMap = new HashMap<String, SummaryResult>();
        block0: for (ListField sumField : qb.getSumFields()) {
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].equalsIgnoreCase(sumField.getFieldName())) continue;
                SummaryResult summaryResult = new SummaryResult(sumField.getListFieldKey().replace('.', '_'), amounts[i], sumField.getSummary());
                sumResultsMap.put(sumField.getListFieldKey().replace('.', '_'), summaryResult);
                continue block0;
            }
        }
        return sumResultsMap;
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public void setRowMeta(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }
}

