/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.mc.backcalc;

import java.util.Optional;
import java.util.function.BiFunction;
import kd.fi.gl.business.service.voucher.mc.MulLocalConfig;
import kd.fi.gl.formplugin.voucher.VoucherEditValueGetter;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateChangedValue;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateResult;
import kd.fi.gl.formplugin.voucher.backcalculate.IEmptyValueBackCalculator;

public abstract class AbstractMulLocalBackCalculator
implements IEmptyValueBackCalculator {
    @Override
    public String group() {
        return AbstractMulLocalBackCalculator.class.getSimpleName();
    }

    @Override
    public Optional<BackCalculateResult> backCalculateEmptyValue(BackCalculateChangedValue emptyValue) {
        return this.doBackCalculate(emptyValue, this::backCalculateEmptyValue);
    }

    @Override
    public Optional<BackCalculateResult> backCalculateNormalValue(BackCalculateChangedValue normalValue) {
        return this.doBackCalculate(normalValue, this::backCalculateNormalValue);
    }

    private Optional<BackCalculateResult> doBackCalculate(BackCalculateChangedValue changedValue, BiFunction<BackCalculateChangedValue, MulLocalConfig, Optional<BackCalculateResult>> func) {
        VoucherEditValueGetter valueGetter = changedValue.getVoucherEditView().getValueGetter();
        MulLocalConfig[] configs = MulLocalConfig.enabledConfigs((long)valueGetter.getOrgId(), (long)valueGetter.getBookTypeId());
        BackCalculateResult result = null;
        for (MulLocalConfig config : configs) {
            Optional<BackCalculateResult> backCalculateResult;
            if (!this.applicable(changedValue.getPropKey(), config) || !(backCalculateResult = func.apply(changedValue, config)).isPresent()) continue;
            if (result == null) {
                result = backCalculateResult.get();
                continue;
            }
            result.add(backCalculateResult.get());
        }
        return Optional.ofNullable(result);
    }

    public abstract Optional<BackCalculateResult> backCalculateEmptyValue(BackCalculateChangedValue var1, MulLocalConfig var2);

    public abstract Optional<BackCalculateResult> backCalculateNormalValue(BackCalculateChangedValue var1, MulLocalConfig var2);

    public abstract boolean applicable(String var1, MulLocalConfig var2);
}

