/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.mc.backcalc;

import java.math.BigDecimal;
import java.util.Optional;
import kd.fi.bd.rate.RateType;
import kd.fi.gl.business.service.voucher.mc.MulLocalConfig;
import kd.fi.gl.business.vo.voucher.mc.IMCVoucherModel;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateChangedValue;
import kd.fi.gl.formplugin.voucher.backcalculate.BackCalculateResult;
import kd.fi.gl.formplugin.voucher.mc.backcalc.AbstractMulLocalBackCalculator;
import kd.fi.gl.formplugin.voucher.mc.service.MCVoucherFormService;

public class MulLocalAmountChanged
extends AbstractMulLocalBackCalculator {
    @Override
    public String[] applicableChangedFields() {
        return MulLocalConfig.getEnabledAmountFieldKeys();
    }

    @Override
    public Optional<BackCalculateResult> backCalculateEmptyValue(BackCalculateChangedValue emptyValue, MulLocalConfig config) {
        return Optional.empty();
    }

    @Override
    public Optional<BackCalculateResult> backCalculateNormalValue(BackCalculateChangedValue normalValue, MulLocalConfig config) {
        int rowIndex;
        IMCVoucherModel voucherModel = MCVoucherFormService.get(normalValue.getVoucherEditView()).getMCVoucherModel();
        BigDecimal amountForMulLocal = voucherModel.getMCOriAmt(config, rowIndex = normalValue.getRowIndex());
        if (amountForMulLocal.signum() == 0) {
            return Optional.empty();
        }
        RateType exRateType = voucherModel.getMCExRateType(config, rowIndex);
        BigDecimal exRate = exRateType.getRateCalculator().calRate(amountForMulLocal, normalValue.getValue(), voucherModel.getMCExRatePrecision(config, rowIndex));
        return Optional.of(new BackCalculateResult(config.getExRateField(), exRate));
    }

    @Override
    public boolean applicable(String changedField, MulLocalConfig config) {
        return changedField.equalsIgnoreCase(config.getDebitField()) || changedField.equalsIgnoreCase(config.getCreditField());
    }
}

