/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.mc.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.fi.gl.business.service.voucher.mc.MulLocalConfig;
import kd.fi.gl.business.vo.voucher.AmountField;
import kd.fi.gl.business.vo.voucher.IVoucherModel;
import kd.fi.gl.business.vo.voucher.mc.IMCVoucherModel;
import kd.fi.gl.business.vo.voucher.mc.MCVoucherModel;
import kd.fi.gl.formplugin.voucher.VoucherEditView;
import kd.fi.gl.formplugin.voucher.args.AutoBalanceArg;
import kd.fi.gl.formplugin.voucher.args.EntryExRateArg;
import kd.fi.gl.formplugin.voucher.args.EntryGridBindDataExRateArg;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportDataCollection;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportEntryInfo;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportEntryInfoCollection;
import kd.fi.gl.formplugin.voucher.ipt.VoucherImportInfo;
import kd.fi.gl.formplugin.voucher.mc.service.IMCVoucherFormService;
import kd.fi.gl.formplugin.voucher.mc.service.IMCVoucherFormView;
import kd.fi.gl.formplugin.voucher.mc.service.MCVoucherFormView;
import kd.fi.gl.formplugin.voucher.mc.service.handler.AbstractMCFormEventHandler;
import kd.fi.gl.formplugin.voucher.mc.service.handler.AutoBalanceHandler;
import kd.fi.gl.formplugin.voucher.mc.service.handler.ColumnVisibleHandler;
import kd.fi.gl.formplugin.voucher.mc.service.handler.CopyLineHandler;
import kd.fi.gl.formplugin.voucher.mc.service.handler.CurrencyChangedHandler;
import kd.fi.gl.formplugin.voucher.mc.service.handler.EntryDCChangedHandler;
import kd.fi.gl.formplugin.voucher.mc.service.handler.ExRateHandler;
import kd.fi.gl.formplugin.voucher.mc.service.handler.LocalCurrencyHandler;
import kd.fi.gl.formplugin.voucher.valuechange.events.CopyRowEventArgs;
import kd.fi.gl.formplugin.voucher.valuechange.events.UpdateRowEventArgs;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.ImportUtil;
import kd.fi.gl.util.VoucherImportUtil;

public class MCVoucherFormService
implements IMCVoucherFormService {
    private final VoucherEditView view;
    private final Map<String, Object> context = new ConcurrentHashMap<String, Object>(8);

    public static MCVoucherFormService get(VoucherEditView view) {
        return view.getService(MCVoucherFormService.class);
    }

    public MCVoucherFormService(VoucherEditView view) {
        this.view = view;
    }

    @Override
    public VoucherEditView getView() {
        return this.view;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    @Override
    public IMCVoucherModel getMCVoucherModel() {
        return (IMCVoucherModel)this.context.computeIfAbsent("getVoucherModel", k -> new MCVoucherModel((IVoucherModel)this.getView().getValueGetter()));
    }

    @Override
    public IMCVoucherFormView getMCVoucherFormView() {
        return (IMCVoucherFormView)this.context.computeIfAbsent("getMCVoucherFormView", k -> new MCVoucherFormView(this.getView().getVchFormView()));
    }

    @Override
    public final <H extends AbstractMCFormEventHandler> H getHandler(Class<H> clazz) {
        return (H)((AbstractMCFormEventHandler)this.context.computeIfAbsent(clazz.getName(), k -> {
            try {
                AbstractMCFormEventHandler handler = (AbstractMCFormEventHandler)clazz.newInstance();
                handler.setService(this);
                return handler;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    public void initVisible() {
        this.getHandler(ColumnVisibleHandler.class).initVisible();
    }

    public void setLocalCurrency() {
        this.getHandler(LocalCurrencyHandler.class).setLocalCurrency();
    }

    public void onCurrencyChanged(UpdateRowEventArgs args) {
        this.getHandler(CurrencyChangedHandler.class).onCurrencyChanged(args);
    }

    public void onEntryDCChanged(UpdateRowEventArgs args) {
        this.getHandler(EntryDCChangedHandler.class).onEntryDCChanged(args);
    }

    public void onCopyRow(CopyRowEventArgs args) {
        this.getHandler(CopyLineHandler.class).onCopyRow(args);
    }

    public void setExRateType(EntryExRateArg arg) {
        this.getHandler(ExRateHandler.class).setExRateType(arg);
    }

    public void setExRateType(EntryGridBindDataExRateArg arg) {
        this.getHandler(ExRateHandler.class).setExRateType(arg);
    }

    public void setExRate(EntryExRateArg arg) {
        this.getHandler(ExRateHandler.class).setExRate(arg);
    }

    public void autoBalance(AutoBalanceArg arg) {
        this.getHandler(AutoBalanceHandler.class).autoBalance(arg);
    }

    public boolean isExistsForeignCurrencyEntry(DynamicObjectCollection entries) {
        return this.getHandler(ExRateHandler.class).isExistsForeignCurrencyEntry(entries);
    }

    public void initImportData(InitImportDataEventArgs e) {
        VoucherImportDataCollection collection = new VoucherImportDataCollection(e.getSourceDataList());
        for (VoucherImportInfo voucher : collection) {
            MulLocalConfig[] configs;
            long orgId = voucher.getOrgId();
            long bookTypeId = voucher.getBookTypeId();
            for (MulLocalConfig config : configs = MulLocalConfig.enabledConfigs((long)voucher.getOrgId(), (long)bookTypeId)) {
                Map currencyMap = (Map)voucher.getSourceDataInfoMap().computeIfAbsent(config.getCurrencyField(), k -> new HashMap(2));
                currencyMap.computeIfAbsent("id", k -> config.getCurrencyId(Long.valueOf(orgId), Long.valueOf(bookTypeId)));
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        VoucherImportInfo voucher = new VoucherImportInfo(e.getSourceData());
        MulLocalConfig[] enabledConfigs = MulLocalConfig.enabledConfigs((long)voucher.getOrgId(), (long)voucher.getBookTypeId());
        MulLocalConfig[] disabledConfigs = MulLocalConfig.disabledConfigs((Long)voucher.getOrgId(), (Long)voucher.getBookTypeId());
        if (enabledConfigs.length == 0 && disabledConfigs.length == 0) {
            return;
        }
        VoucherImportEntryInfoCollection entries = voucher.getVoucherImportEntryInfoCollection();
        for (VoucherImportEntryInfo entry : entries) {
            Map<String, Object> source = entry.getSourceEntryMap();
            String dc = entry.initEntryDC();
            for (MulLocalConfig config : enabledConfigs) {
                VoucherImportUtil.getEntryDCByAmount(source, (AmountField[])new AmountField[]{config.getAmountField()}).ifPresent(x -> {
                    if (!dc.equalsIgnoreCase((String)x)) {
                        e.getCancelMessages().computeIfAbsent(entry.getExcelRowNum(), ArrayList::new).add(ResManager.loadKDString((String)"%1$s\u91d1\u989d\u501f\u8d37\u65b9\u5411\u9700\u8981\u4e0e\u5206\u5f55\u65b9\u5411\u4e00\u81f4\u3002", (String)"VoucherEditMulLocalService_0", (String)GLApp.instance.formpluginModule(), (Object[])new Object[]{config.getConfig().getName()}));
                        e.setCancel(true);
                    }
                });
            }
            for (MulLocalConfig config : disabledConfigs) {
                if (ImportUtil.getBigDecimal(source, (String)config.getExRateField()).signum() == 0 && ImportUtil.getBigDecimal(source, (String)config.getDebitField()).signum() == 0 && ImportUtil.getBigDecimal(source, (String)config.getCreditField()).signum() == 0) continue;
                e.getCancelMessages().computeIfAbsent(entry.getExcelRowNum(), ArrayList::new).add(ResManager.loadKDString((String)"%1$s\u672a\u542f\u7528\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\u3002", (String)"VoucherEditMulLocalService_1", (String)GLApp.instance.formpluginModule(), (Object[])new Object[]{config.getConfig().getName()}));
                e.setCancel(true);
            }
        }
    }
}

