/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.service;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.logging.Log;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.logger.ExtLogFactory;
import kd.fi.gl.business.GLServiceFactory;
import kd.fi.gl.formplugin.voucher.VoucherEditView;
import kd.fi.gl.interfaces.service.voucher.journal.IVoucherJournalService;
import kd.fi.gl.util.GLApp;

public class VoucherEditJournalService {
    private final VoucherEditView view;

    public VoucherEditJournalService(VoucherEditView view) {
        this.view = view;
    }

    protected IVoucherJournalService getJournalService() {
        return (IVoucherJournalService)GLServiceFactory.getService(IVoucherJournalService.class);
    }

    protected Map<Long, Integer> getEntryId2Seq() {
        DynamicObjectCollection voucherEntries = this.view.getValueGetter().getVoucherEntries();
        DynamicProperty idProp = voucherEntries.getDynamicObjectType().getProperty("id");
        DynamicProperty seqProp = voucherEntries.getDynamicObjectType().getProperty("seq");
        return voucherEntries.stream().filter(x -> (Long)idProp.getValueFast(x) > 0L).collect(Collectors.toMap(x -> (Long)idProp.getValueFast(x), x -> (Integer)seqProp.getValueFast(x)));
    }

    public void lockOnBindData() {
        if (!"B".equalsIgnoreCase(this.view.getValueGetter().getStatus())) {
            return;
        }
        Map<Long, Integer> id2seq = this.getEntryId2Seq();
        if (id2seq.isEmpty()) {
            return;
        }
        Set checkedVoucherEntryIds = this.getJournalService().getCheckedVoucherEntryIds(Long.valueOf(this.view.getValueGetter().getId()), id2seq.keySet());
        Set<Integer> checkedRowIndexes = checkedVoucherEntryIds.stream().map(id2seq::get).filter(Objects::nonNull).map(x -> x - 1).filter(x -> x >= 0).collect(Collectors.toSet());
        Lock.lock(this.view, checkedRowIndexes);
    }

    protected Map<Long, Integer> getEntryId2Index(EntryGridBindDataEvent e) {
        return e.getRows().stream().filter(x -> x.getDataEntity().getLong("id") > 0L).collect(Collectors.toMap(x -> x.getDataEntity().getLong("id"), RowDataEntity::getRowIndex));
    }

    public void lockOnEntryGridBindData(EntryGridBindDataEvent e) {
        if (!"B".equalsIgnoreCase(this.view.getValueGetter().getStatus())) {
            return;
        }
        Map<Long, Integer> id2index = this.getEntryId2Index(e);
        if (id2index.isEmpty()) {
            return;
        }
        Set checkedVoucherEntryIds = this.getJournalService().getCheckedVoucherEntryIds(Long.valueOf(this.view.getValueGetter().getId()), id2index.keySet());
        Set<Integer> checkedRowIndexes = checkedVoucherEntryIds.stream().map(id2index::get).filter(Objects::nonNull).filter(x -> x >= 0).collect(Collectors.toSet());
        Lock.lock(this.view, checkedRowIndexes);
    }

    public boolean onDeleteRow(BeforeDeleteRowEventArgs e, int row) {
        if (row < 0) {
            return true;
        }
        if (Lock.isLocked(this.view, row)) {
            this.view.getVchFormView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u8bb0\u8d26\u5df2\u52fe\u5bf9\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"VoucherEditJournalService_0", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            e.setCancel(true);
            return false;
        }
        return true;
    }

    static class Cache {
        Cache() {
        }

        public static void cacheLockedRowIndexes(VoucherEditView view, Set<Integer> checkedRowIndexes) {
            Set<Integer> lockedRowIndexesFromCache = Cache.getLockedRowIndexesFromCache(view);
            lockedRowIndexesFromCache.addAll(checkedRowIndexes);
            view.getCacheManager().set("VoucherEditJournalService_lock", SerializationUtils.toJsonString(lockedRowIndexesFromCache));
        }

        public static Set<Integer> getLockedRowIndexesFromCache(VoucherEditView view) {
            String cacheVal = view.getCacheManager().get("VoucherEditJournalService_lock");
            if (StringUtils.isEmpty((String)cacheVal)) {
                return new HashSet<Integer>(1);
            }
            return (Set)SerializationUtils.fromJsonString((String)cacheVal, Set.class);
        }
    }

    static class Lock {
        private static final Log LOG = ExtLogFactory.getLog(Lock.class);
        private static final String[] V_FIELDS = new String[]{"booktype", "bizdate", "bookeddate", "vouchertype"};
        private static final String[] E_FIELDS = new String[]{"account", "oriamount", "debitori", "creditori", "debitlocal", "creditlocal", "currency", "localrate", "edescription", "assgrp"};

        Lock() {
        }

        public static void lock(VoucherEditView view, Set<Integer> checkedRowIndexes) {
            if (CollectionUtils.isNotEmpty(checkedRowIndexes)) {
                LOG.info("lock by cas, indexes:{}", checkedRowIndexes);
                view.getVchFormView().setEnable(Boolean.valueOf(false), V_FIELDS);
                for (Integer checkedRowIndex : checkedRowIndexes) {
                    view.getVchFormView().setEnable(Boolean.valueOf(false), checkedRowIndex.intValue(), E_FIELDS);
                }
                Cache.cacheLockedRowIndexes(view, checkedRowIndexes);
            }
        }

        public static boolean isLocked(VoucherEditView view, Integer rowIndex) {
            return Cache.getLockedRowIndexesFromCache(view).contains(rowIndex);
        }
    }
}

