/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.template.impl;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.formplugin.voucher.template.IRowBuilder;
import kd.fi.gl.formplugin.voucher.template.TemplateVoucherContext;
import kd.fi.gl.util.CashFlowItemHelper;
import kd.fi.gl.util.GLUtil;

public class CashFlowFieldBuilder
implements IRowBuilder {
    private final boolean localSet;

    public CashFlowFieldBuilder(boolean localSet) {
        this.localSet = localSet;
    }

    @Override
    public Map<String, Object> values(TemplateVoucherContext ctx, DynamicObject entry) {
        DynamicObject mainCfItem = entry.getDynamicObject("maincfitem");
        DynamicObject suppCfItem = entry.getDynamicObject("suppcfitem");
        long mainCfAssgrpId = 0L;
        long mainCfId = 0L;
        long suppCfId = 0L;
        BigDecimal mainCfAmount = BigDecimal.ZERO;
        BigDecimal suppCfAmount = BigDecimal.ZERO;
        DynamicObject accDyn = entry.getDynamicObject("account");
        boolean isBudgetType = accDyn != null && AccountType.isBudgetType((long)accDyn.getLong("accounttype_id"));
        boolean isCashAccount = GLUtil.isCashAcct((DynamicObject)accDyn);
        boolean isPLAccount = GLUtil.isPLAcct((DynamicObject)accDyn);
        if (CashFlowItemHelper.permitDesignCashflow((IDataModel)ctx.getVoucherEditView().getVoucherEditModel())) {
            if (mainCfItem != null && !isBudgetType) {
                if (this.localSet && isCashAccount || !this.localSet && !isCashAccount) {
                    mainCfId = mainCfItem.getLong("id");
                    mainCfAmount = entry.getBigDecimal("maincfamount");
                    mainCfAssgrpId = entry.getLong("maincfassgrp.id");
                    boolean isDealactivity = mainCfItem.getBoolean("isdealactivity");
                    if (suppCfItem != null && (this.localSet && isDealactivity || !this.localSet && (isPLAccount && !isDealactivity || !isPLAccount && isDealactivity))) {
                        suppCfId = suppCfItem.getLong("id");
                        suppCfAmount = entry.getBigDecimal("suppcfamount");
                    }
                }
            } else if (suppCfItem != null && !isBudgetType && (this.localSet && isPLAccount || !this.localSet && !isCashAccount && !isPLAccount)) {
                suppCfId = suppCfItem.getLong("id");
                suppCfAmount = entry.getBigDecimal("suppcfamount");
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put("maincfitem", mainCfId);
        result.put("maincfamount", mainCfAmount);
        result.put("suppcfitem", suppCfId);
        result.put("suppcfamount", suppCfAmount);
        result.put("maincfassgrp", mainCfAssgrpId);
        return result;
    }
}

