/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher.valuechange;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.fi.gl.formplugin.voucher.valuechange.IRowValueChangedListener;
import kd.fi.gl.formplugin.voucher.valuechange.events.CopyRowEventArgs;
import kd.fi.gl.formplugin.voucher.valuechange.events.CreateRowEventArgs;
import kd.fi.gl.formplugin.voucher.valuechange.events.DeleteRowEventArgs;
import kd.fi.gl.formplugin.voucher.valuechange.events.InitRowsEventArgs;
import kd.fi.gl.formplugin.voucher.valuechange.events.UpdateRowEventArgs;
import kd.fi.gl.formplugin.voucher.valuechange.impl.RatePrecisionRoundingHandler;
import kd.fi.gl.formplugin.voucher.valuechange.impl.VoucherBackCalculationHandler;
import kd.fi.gl.formplugin.voucher.valuechange.impl.VoucherBudgetHandler;

public class AspectPluginProxy {
    private static final CopyOnWriteArrayList<Class<? extends IRowValueChangedListener>> ALL_LISTENERS = new CopyOnWriteArrayList();
    private static final Map<Class<? extends IRowValueChangedListener>, IRowValueChangedListener> INSTANCE_MAP = new ConcurrentHashMap<Class<? extends IRowValueChangedListener>, IRowValueChangedListener>(16);

    public static void register(Class<? extends IRowValueChangedListener> clazz) {
        ALL_LISTENERS.add(clazz);
    }

    private static IRowValueChangedListener getInstance(Class<? extends IRowValueChangedListener> clazz) {
        return INSTANCE_MAP.computeIfAbsent(clazz, k -> {
            try {
                return (IRowValueChangedListener)k.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void fireOnCopyRow(CopyRowEventArgs args) {
        for (Class<? extends IRowValueChangedListener> clazz : ALL_LISTENERS) {
            AspectPluginProxy.getInstance(clazz).onCopy(args);
        }
    }

    public void fireOnCreate(CreateRowEventArgs args) {
        for (Class<? extends IRowValueChangedListener> clazz : ALL_LISTENERS) {
            AspectPluginProxy.getInstance(clazz).onCreate(args);
        }
    }

    public void fireOnInit(InitRowsEventArgs args) {
        for (Class<? extends IRowValueChangedListener> clazz : ALL_LISTENERS) {
            AspectPluginProxy.getInstance(clazz).onInit(args);
        }
    }

    private List<IRowValueChangedListener> getUpdateListeners(String propKey) {
        return (List)ThreadCache.get((Object)("AspectPluginProxy#getUpdateListeners_" + propKey), () -> ALL_LISTENERS.stream().map(AspectPluginProxy::getInstance).filter(x -> x.isOnUpdate(propKey)).collect(Collectors.toList()));
    }

    public void fireOnUpdate(UpdateRowEventArgs args) {
        for (IRowValueChangedListener listener : this.getUpdateListeners(args.getPropKey())) {
            listener.onUpdate(args);
        }
    }

    public void fireOnDelete(DeleteRowEventArgs args) {
        for (Class<? extends IRowValueChangedListener> clazz : ALL_LISTENERS) {
            AspectPluginProxy.getInstance(clazz).onDelete(args);
        }
    }

    static {
        AspectPluginProxy.register(VoucherBudgetHandler.class);
        AspectPluginProxy.register(RatePrecisionRoundingHandler.class);
        AspectPluginProxy.register(VoucherBackCalculationHandler.class);
    }
}

