/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucherref;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.FmtField;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.business.service.synbook.VoucherRefTrackerService;
import kd.fi.gl.business.vo.synbook.VoucherRefTrackerVO;
import kd.fi.gl.enums.synbook.VoucherRefType;
import kd.fi.gl.formplugin.voucher.VoucherListDataProvider;
import kd.fi.gl.model.schema.VoucherSchema;
import kd.fi.gl.util.MetaUtils;
import kd.fi.gl.util.QFBuilder;

public class VoucherRefListDataProvider
extends VoucherListDataProvider {
    private VoucherSchema schema = new VoucherSchema();
    private long sourceOrgId;
    private long sourceBookTypeId;
    private long targetOrgId;
    private long targetBookTypeId;
    private static final String[] VOUCHER_FIELDS = new String[]{"period", "bookeddate", "vouchertype", "billno", "vdescription", "localcur", "debitlocamount"};
    private static final String[] RESULT_FIELDS = new String[]{"reftype", "failedreason"};
    private static final String REF_PREFIX = "ref";

    public VoucherRefListDataProvider(IFormView view) {
        super(view);
    }

    protected void setSourceBookTypeId(long sourceBookTypeId) {
        this.sourceBookTypeId = sourceBookTypeId;
    }

    protected void setTargetOrgId(long targetOrgId) {
        this.targetOrgId = targetOrgId;
    }

    protected void setTargetBookTypeId(long targetBookTypeId) {
        this.targetBookTypeId = targetBookTypeId;
    }

    private static String getRefVoucherFiledKey(String voucherKey) {
        return REF_PREFIX + voucherKey;
    }

    public List<ListField> getVisibleSelectFieldList() {
        List visibleSelectFieldList = super.getVisibleSelectFieldList();
        for (ListField listField : visibleSelectFieldList) {
            String propertyKey;
            IDataEntityProperty prop;
            IDataEntityProperty fieldProp = listField.getFieldProp();
            if (null != fieldProp || null == (prop = this.getProp(propertyKey = listField.getFieldName().split("\\.")[0]))) continue;
            listField.setFieldProp(prop);
        }
        return visibleSelectFieldList;
    }

    private IDataEntityProperty getProp(String propertyKey) {
        QueryBuilder queryBuilder = this.getQueryBuilder();
        if (null == queryBuilder) {
            return null;
        }
        DynamicObjectType entityType = queryBuilder.getReturnEntityType();
        return (IDataEntityProperty)entityType.getProperties().get((Object)propertyKey);
    }

    private void registerRefPorperty(DynamicObjectType dt) {
        DataEntityPropertyCollection fullProperties = this.getQueryBuilder().getEntityType().getProperties();
        for (String selectField : VOUCHER_FIELDS) {
            String propertyKey = VoucherRefListDataProvider.getRefVoucherFiledKey(selectField);
            if (dt.getProperty(propertyKey) != null) continue;
            IDataEntityProperty property = (IDataEntityProperty)fullProperties.get((Object)propertyKey);
            MetaUtils.registerIDataEntityProperty((IDataEntityProperty)property, (DynamicObjectType)dt);
        }
        for (String resultField : RESULT_FIELDS) {
            IDataEntityProperty property = (IDataEntityProperty)fullProperties.get((Object)resultField);
            MetaUtils.registerIDataEntityProperty((IDataEntityProperty)property, (DynamicObjectType)dt);
        }
    }

    @Override
    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection vouchers = super.getData(start, limit);
        if (vouchers.isEmpty()) {
            return vouchers;
        }
        this.sourceOrgId = BusinessDataServiceHelper.loadSingleFromCache((Object)((DynamicObject)vouchers.get(0)).getPkValue(), (String)this.schema.entity, (String)this.schema.org.toFullName()).getLong(this.schema.org.toStringWithID());
        this.registerRefPorperty(vouchers.getDynamicObjectType());
        List<Long> voucherIds = vouchers.parallelStream().map(x -> x.getLong("id")).collect(Collectors.toList());
        Map<Long, Long> voucherRelation = this.getVoucherRelation(voucherIds);
        Map voucherRefTrackerMap = VoucherRefTrackerService.getLatestLogsBySourceAndTarget(voucherIds, (Long)this.getBookIdByOrgAndBookType(this.targetOrgId, this.targetBookTypeId));
        Collection<Long> refVoucherIds = voucherRelation.values();
        Map<Object, DynamicObject> refVouchers = this.getRefVouchers(refVoucherIds);
        for (DynamicObject voucher : vouchers) {
            VoucherRefTrackerVO voucherRefTrackerBuf;
            long sourceVoucherId = voucher.getLong("id");
            Long destVoucherId = voucherRelation.get(sourceVoucherId);
            if (null == destVoucherId) {
                voucherRefTrackerBuf = (VoucherRefTrackerVO)voucherRefTrackerMap.get(sourceVoucherId);
                if (voucherRefTrackerBuf != null) {
                    voucher.set("reftype", (Object)VoucherRefType.CONVERSION_FAILED.getValue());
                    voucher.set("failedreason", (Object)voucherRefTrackerBuf.getOpDesc());
                    continue;
                }
                voucher.set("reftype", (Object)VoucherRefType.UNCONVERTED.getValue());
                continue;
            }
            voucherRefTrackerBuf = (VoucherRefTrackerVO)voucherRefTrackerMap.get(sourceVoucherId);
            if (voucherRefTrackerBuf != null) {
                voucher.set("reftype", (Object)VoucherRefType.CONVERSION_FAILED.getValue());
                voucher.set("failedreason", (Object)voucherRefTrackerBuf.getOpDesc());
            } else {
                voucher.set("reftype", (Object)VoucherRefType.CONVERTED.getValue());
            }
            DynamicObject destVoucher = refVouchers.get(destVoucherId);
            if (null == destVoucher) continue;
            for (String key : VOUCHER_FIELDS) {
                voucher.set(VoucherRefListDataProvider.getRefVoucherFiledKey(key), destVoucher.get(key));
            }
        }
        this.getQueryResult().setCollection(vouchers);
        List fmtFields = this.getQueryResult().getNumberFormatProvider().getFmtFields();
        String key = VoucherRefListDataProvider.getRefVoucherFiledKey("debitlocamount");
        FmtField fmtField = new FmtField((IDataEntityProperty)vouchers.getDynamicObjectType().getProperty(key), key, VoucherRefListDataProvider.getRefVoucherFiledKey("localcur"));
        fmtField.setControlFieldKey(VoucherRefListDataProvider.getRefVoucherFiledKey("localcur"));
        fmtFields.add(fmtField);
        this.getQueryResult().setNumberFormatProvider(new NumberFormatProvider(fmtFields, vouchers));
        return vouchers;
    }

    private Long getBookIdByOrgAndBookType(long orgId, long bookTypeId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("org", "=", (Object)orgId);
        qfBuilder.add("bookstype", "=", (Object)bookTypeId);
        DynamicObject manageBook = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (String)"id", (QFilter[])qfBuilder.toArray());
        return manageBook == null ? 0L : manageBook.getLong("id");
    }

    private Map<Long, Long> getVoucherRelation(Collection<Long> voucherIds) {
        Long manageBookId = this.getBookIdByOrgAndBookType(this.sourceOrgId, this.sourceBookTypeId);
        Long targetBookId = this.getBookIdByOrgAndBookType(this.targetOrgId, this.targetBookTypeId);
        if (manageBookId == 0L || targetBookId == 0L) {
            return Collections.emptyMap();
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("srcbook", "=", (Object)manageBookId);
        qfBuilder.add("destbook", "=", (Object)targetBookId);
        qfBuilder.add("srcvoucherid", "in", voucherIds);
        Map relations = BusinessDataServiceHelper.loadFromCache((String)"gl_voucher_relation", (String)String.join((CharSequence)",", "srcvoucherid", "destvoucherid"), (QFilter[])qfBuilder.toArray());
        return relations.values().stream().collect(Collectors.toMap(x -> x.getLong("srcvoucherid"), x -> x.getLong("destvoucherid"), (oldVal, newVal) -> newVal));
    }

    private Map<Object, DynamicObject> getRefVouchers(Collection<Long> refVoucherIds) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("org", "=", (Object)this.targetOrgId);
        qfBuilder.add("booktype", "=", (Object)this.targetBookTypeId);
        qfBuilder.add("id", "in", refVoucherIds);
        return BusinessDataServiceHelper.loadFromCache((String)"gl_voucher", (String)String.join((CharSequence)",", VOUCHER_FIELDS), (QFilter[])qfBuilder.toArray());
    }

    @Override
    protected Long getBookTypeID(String entity) {
        return AccSysUtil.getMainBookTypeId();
    }
}

