/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.init;

import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.accsys.AccountInfo;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.reciprocal.ReciprocalInitUtils;
import kd.fi.gl.util.AssgrpDetailF7Handler;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLUtil;

public class ReciprocalInitEdit
extends AbstractBillPlugIn {
    private static final String NUMBER = "number";
    private static final String ACCTKEY = "initaccuacctkey";
    private static final String FLEXPROPERTY = "initaccu-import-flex";
    private static final String PARENTDATA = "initaccu-import-parent";
    private static final String IS_SAME_CURRENCY = "isSameCurrency";
    private static final Log LOG = LogFactory.getLog(ReciprocalInitEdit.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setBookInfoRefValue();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FlexEdit flex = (FlexEdit)this.getControl("assgrp");
        flex.registerBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent e) {
                AssgrpDetailF7Handler handler = new AssgrpDetailF7Handler(ReciprocalInitEdit.this.getModel());
                handler.handleAssgrpDetail(e);
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty prop = e.getProperty();
        String key = prop.getName();
        Object value = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "account": {
                this.handleAccountNull(value != null);
                break;
            }
            case "amountlocal": {
                String isSame = this.getPageCache(IS_SAME_CURRENCY);
                if (!"true".equals(isSame)) break;
                this.getModel().setValue("amountfor", value);
                break;
            }
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        Serializable acctSet;
        super.initImportData(e);
        List data = e.getSourceDataList();
        HashMap searchMap = new HashMap();
        HashMap<String, AccountBookInfo> bookInfoMap = new HashMap<String, AccountBookInfo>();
        for (Object map : data) {
            Map map2 = (Map)map.get("account");
            Map orgMap = (Map)map.get("org");
            Map bookTypeMap = (Map)map.get("booktype");
            if (map2 == null || orgMap == null || bookTypeMap == null) continue;
            String orgNumber = (String)orgMap.get(NUMBER);
            String btNumber = (String)bookTypeMap.get(NUMBER);
            String acctNumber = (String)map2.get(NUMBER);
            String key = orgNumber + "-" + btNumber;
            if (searchMap.containsKey(key)) {
                ((Set)searchMap.get(key)).add(acctNumber);
                continue;
            }
            AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((String)orgNumber, (String)btNumber);
            if (bookInfo == null) continue;
            bookInfoMap.put(key, bookInfo);
            acctSet = new HashSet<String>();
            acctSet.add(acctNumber);
            searchMap.put(key, acctSet);
        }
        HashMap<String, Long> resultMap = new HashMap<String, Long>(searchMap.size());
        for (Map.Entry entry : searchMap.entrySet()) {
            String key = (String)entry.getKey();
            AccountBookInfo bookInfo = (AccountBookInfo)bookInfoMap.get(key);
            Set acctSet2 = (Set)entry.getValue();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            ReciprocalInitUtils.addReciprocalAccountF7Filter(filters, (Long)bookInfo.getOrgId(), (Long)bookInfo.getAccountTableId(), (boolean)true);
            DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"enddate", (QFilter[])new QFilter("id", "=", (Object)bookInfo.getCurPeriodId()).toArray());
            QFilter dateFilter = new QFilter("startdate", "<=", (Object)period.getDate("enddate"));
            dateFilter.and(new QFilter("enddate", ">=", (Object)period.getDate("enddate")));
            filters.add(dateFilter);
            filters.add(new QFilter(NUMBER, "in", (Object)acctSet2));
            DataSet ds = QueryServiceHelper.queryDataSet((String)(this.getPluginName() + "initImportData"), (String)"bd_accountview", (String)"id,number", (QFilter[])filters.toArray(new QFilter[0]), null);
            acctSet = null;
            try {
                if (ds == null) continue;
                for (Row row : ds) {
                    Long id = row.getLong("id");
                    String number = row.getString(NUMBER);
                    resultMap.put(key + number, id);
                }
            }
            catch (Throwable throwable) {
                acctSet = throwable;
                throw throwable;
            }
            finally {
                if (ds == null) continue;
                if (acctSet != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)acctSet).addSuppressed(throwable);
                    }
                    continue;
                }
                ds.close();
            }
        }
        int index = 0;
        for (Map map : data) {
            Map accountMap = (Map)map.get("account");
            Map orgMap = (Map)map.get("org");
            Map bookTypeMap = (Map)map.get("booktype");
            if (accountMap != null && orgMap != null && bookTypeMap != null) {
                String orgNumber = (String)orgMap.get(NUMBER);
                String btNumber = (String)bookTypeMap.get(NUMBER);
                String acctNumber = (String)accountMap.get(NUMBER);
                String key = orgNumber + "-" + btNumber + acctNumber;
                Long id = (Long)resultMap.get(key);
                if (id == null || id == 0L) {
                    ArrayList<String> errorMsgs = new ArrayList<String>(8);
                    errorMsgs.add(ResManager.loadKDString((String)"\u975e\u5f80\u6765\u79d1\u76ee\u4e0d\u53ef\u65b0\u589e\u5f80\u6765\u521d\u59cb\u5316\u6570\u636e\u3002", (String)"InitBalanceEdit_23", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    e.setCancelMessages(Integer.valueOf(index), Integer.valueOf(index), Integer.valueOf(index), errorMsgs);
                    continue;
                }
                accountMap.put("id", id);
            }
            ++index;
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        IDataModel m = this.getModel();
        DynamicObject acct = (DynamicObject)m.getValue("account");
        if (acct == null) {
            return;
        }
        DynamicObject act = this.getAcct(acct.getLong("id"));
        AccountInfo accountInfo = new AccountInfo(act);
        DynamicObject assgrp = (DynamicObject)m.getValue("assgrp");
        if (accountInfo.isAssist() && Objects.nonNull(assgrp)) {
            try {
                Map json = (Map)JSONUtils.cast((String)assgrp.getString("value"), Map.class);
                for (Map.Entry entry : json.entrySet()) {
                    boolean isNotleaf;
                    Map flex;
                    String valueSource;
                    String flexField = (String)entry.getKey();
                    if (!Objects.nonNull(accountInfo.getFlexToIsLeaf().get(flexField)) || !((Boolean)accountInfo.getFlexToIsLeaf().get(flexField)).booleanValue() || !Objects.nonNull(valueSource = (String)(flex = FlexUtils.getFlex()).get(flexField)) || !(isNotleaf = FlexUtils.isNotLeafData((String)valueSource, (Long)Long.parseLong(entry.getValue().toString())))) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6%s\u4e0d\u80fd\u4e3a\u975e\u660e\u7ec6\u6570\u636e", (String)"InitBalanceEdit_18", (String)"fi-gl-formplugin", (Object[])new Object[]{accountInfo.getAssFlexToNameMap().get(flexField)}));
                }
            }
            catch (IOException ioException) {
                LOG.error(ioException.getMessage(), (Throwable)ioException);
                throw new KDBizException((Throwable)ioException, BosErrorCode.systemError, new Object[0]);
            }
        }
    }

    private void handleAccountNull(boolean isNull) {
        this.getView().setEnable(Boolean.valueOf(isNull), new String[]{"assgrp"});
    }

    private Boolean setAccountEnable() {
        AccountBookInfo bookInfo = this.getAccountBookCache();
        BasedataEdit accountEdit = (BasedataEdit)this.getControl("account");
        List accountFilter = accountEdit.getQFilters();
        List list = accountFilter = accountFilter == null ? new ArrayList() : accountFilter;
        if (bookInfo != null) {
            accountFilter.add(new QFilter("accounttable", "=", (Object)bookInfo.getAccountTableId()));
        }
        accountFilter.add(new QFilter("accheck", "=", (Object)true));
        Boolean existReciprocal = QueryServiceHelper.exists((String)"bd_accountview", (QFilter[])accountFilter.toArray(new QFilter[0]));
        this.getView().setEnable(existReciprocal, new String[]{"account"});
        return existReciprocal;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        AccountBookInfo bookInfo = this.getAccountBookCache();
        Long currencyId = (Long)model.getValue(GLField.id_((String)"currency"));
        if (bookInfo == null) {
            Long orgId = (Long)model.getValue(GLField.id_((String)"org"));
            Long bookTypeId = (Long)model.getValue(GLField.id_((String)"booktype"));
            bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
        }
        if (bookInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u8d26\u7c3f\u4fe1\u606f\u3002", (String)"ReciprocalInitEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        String bookInfoStr = GLUtil.toSerializedString((Object)bookInfo);
        this.setPageCache("book", bookInfoStr);
        if (currencyId.equals(bookInfo.getBaseCurrencyId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"amountfor"});
            this.setPageCache(IS_SAME_CURRENCY, "true");
        }
    }

    private void setPageCache(String key, String value) {
        this.getPageCache().put(key, value);
    }

    private void setBookInfoRefValue() {
        FormShowParameter formShowParam = this.getView().getFormShowParameter();
        String bookInfoStr = (String)formShowParam.getCustomParam("book");
        if (bookInfoStr == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u8d26\u7c3f\u4fe1\u606f\u3002", (String)"ReciprocalInitEdit_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setPageCache("book", bookInfoStr);
        IDataModel model = this.getModel();
        AccountBookInfo bookInfo = (AccountBookInfo)GLUtil.fromSerializedString((String)bookInfoStr);
        model.setValue("org", (Object)bookInfo.getOrgId());
        model.setValue("booktype", (Object)bookInfo.getBookTypeId());
        model.setValue("accounttable", (Object)bookInfo.getAccountTableId());
        model.setValue("curlocal", (Object)bookInfo.getBaseCurrencyId());
        Long acctId = (Long)ObjectConverter.convert((Object)formShowParam.getCustomParam("account"), Long.class);
        Long currencyId = (Long)ObjectConverter.convert((Object)formShowParam.getCustomParam("currency"), Long.class);
        Long assgrpId = (Long)ObjectConverter.convert((Object)formShowParam.getCustomParam("assgrp"), Long.class);
        Boolean existReciprocal = this.setAccountEnable();
        if (existReciprocal.booleanValue()) {
            model.setValue("account", (Object)acctId);
            boolean notNull = acctId != null;
            model.setValue("assgrp", (Object)(notNull ? assgrpId : null));
            this.handleAccountNull(notNull);
        } else {
            this.handleAccountNull(existReciprocal);
        }
        if (currencyId != null) {
            model.setValue("currency", (Object)currencyId);
        }
        Date date = (Date)ObjectConverter.convert((Object)formShowParam.getCustomParam("date"), Date.class);
        try {
            if (date != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                date = sdf.parse(sdf.format(date));
                model.setValue("bizdate", (Object)date);
                model.setValue("deadlinedate", (Object)date);
            }
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b0\u589e\u643a\u5e26\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff1a%s", (String)"ReciprocalInitEdit_1", (String)"fi-gl-formplugin", (Object[])new Object[]{e.getMessage()}));
        }
    }

    private String getPageCache(String key) {
        return this.getPageCache().get(key);
    }

    private AccountBookInfo getAccountBookCache() {
        String book = this.getPageCache("book");
        if (book != null) {
            return (AccountBookInfo)GLUtil.fromSerializedString((String)book);
        }
        return null;
    }

    private DynamicObject getAcct(long acctId) {
        HashMap<Long, DynamicObject> acctMap = (HashMap<Long, DynamicObject>)ThreadCache.get((Object)ACCTKEY);
        if (acctMap == null) {
            acctMap = new HashMap<Long, DynamicObject>(16);
            DynamicObject acct = BusinessDataServiceHelper.loadSingleFromCache((Object)acctId, (String)"bd_accountview");
            acctMap.put(acctId, acct);
            ThreadCache.put((Object)ACCTKEY, acctMap);
            return acct;
        }
        if (acctMap.containsKey(acctId)) {
            return (DynamicObject)acctMap.get(acctId);
        }
        DynamicObject acct = BusinessDataServiceHelper.loadSingleFromCache((Object)acctId, (String)"bd_accountview");
        acctMap.put(acctId, acct);
        ThreadCache.put((Object)ACCTKEY, acctMap);
        return acct;
    }
}

