/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.SingleOrgContextHelper;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportList;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.report.GLRptTemplatePlugin;
import kd.fi.gl.report.NavToAssRpt;
import kd.fi.gl.report.NavToSubLedgerRpt;
import kd.fi.gl.report.accbalance.v2.AccBalProcessRowDataHelper;
import kd.fi.gl.util.AccountUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;

public class AccBalanceFormRpt
extends GLRptTemplatePlugin
implements ClickListener {
    private static final String[] localAmountFields = new String[]{"yearbdebitlocal", "yearbcreditlocal", "begindebitlocal", "begincreditlocal", "debitlocal", "creditlocal", "yeardebitlocal", "yearcreditlocal", "enddebitlocal", "endcreditlocal"};
    private static final Log LOG = LogFactory.getLog(AccBalanceFormRpt.class);
    public static final String NUMBER_ID = "number_id";
    public static final String NUMBER = "number";
    public static final String ACCOUNT_NUMBER = "accountnumber";
    public static final String ACCOUNT_NUMBER_ID = "accountnumber_id";
    public static final String EXPORTEXCEL = "exportexcel";
    public static final String DISTINCNAMEMAP = "distincNameMap";

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        if (this.getQueryParam().getFilter().containProp("enablev2")) {
            this.getPageCache().remove(EXPORTEXCEL);
        }
        queryParam.getCustomParam().put("flexorgidfield", "flexorgid");
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("showtreeorg".equals(e.getProperty().getName())) {
            Object value = e.getChangeSet()[0].getNewValue();
            if ("1".equals(value)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"showorg"});
                this.getModel().setValue("showorg", (Object)true);
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"showorg"});
            }
        }
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        String showOrgtype = this.getQueryParam().getFilter().getString("showtreeorg");
        if (this.getQueryParam().getFilter().containProp("enablev2")) {
            if (!this.getQueryParam().getFilter().containProp("disabletree")) {
                event.setTreeReportList(Objects.equals(showOrgtype, "1"));
                if (Objects.equals(showOrgtype, "1")) {
                    event.setTreeExpandColId("orgname");
                }
            }
            return;
        }
        event.setTreeReportList(true);
        if (Objects.equals(showOrgtype, "1")) {
            event.setTreeExpandColId("orgname");
        } else {
            event.setTreeExpandColId(NUMBER);
        }
        this.getPageCache().put(DISTINCNAMEMAP, SerializationUtils.toJsonString((Object)Maps.newHashMap()));
    }

    @Override
    protected BasedataEdit getOrgEdit() {
        return (BasedataEdit)this.getControl("orgs");
    }

    @Override
    protected List<Long> getOrgValue() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
        return orgs.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    @Override
    protected void setDefaultOrg(Long orgId) {
        if (orgId == null || orgId == 0L) {
            this.getModel().setValue("orgs", null);
        } else {
            this.getModel().setValue("orgs", (Object)new Long[]{orgId});
        }
    }

    @Override
    protected List<Long> getFilterOrg(FilterInfo filterInfo) {
        List value;
        ArrayList<Long> result = new ArrayList<Long>();
        FilterItemInfo itemInfo = filterInfo.getFilterItem("orgs");
        if (itemInfo != null && (value = (List)itemInfo.getValue()) != null) {
            for (DynamicObject dyn : value) {
                result.add(dyn.getLong("id"));
            }
        }
        return result;
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        DynamicObject acct;
        if (queryParam.getFilter().containProp("enablev2")) {
            AccBalProcessRowDataHelper.processRowData(rowData, this.getView(), queryParam);
            return;
        }
        Long defaultOrg = this.getParentOrg();
        String accountNameField = GLUtil.getAcctNameBySysParam((Long)defaultOrg);
        boolean isShowPrice = super.isShowPrice();
        HashSet<Long> accountIdSet = new HashSet<Long>(rowData.size());
        for (DynamicObject obj2 : rowData) {
            DynamicObject orgDyn;
            DynamicObject acct2 = obj2.getDynamicObject(ACCOUNT_NUMBER);
            if (acct2 != null) {
                accountIdSet.add(acct2.getLong("id"));
            }
            if (!Objects.nonNull(orgDyn = obj2.getDynamicObject("orgid"))) continue;
            obj2.set("org_id", (Object)orgDyn.getLong("id"));
        }
        Map<Long, String> idAndNames = this.getAccountNames(accountIdSet, accountNameField);
        boolean baseCurrency = this.isBaseCurrency(queryParam.getFilter());
        Map<String, String> accMap = (Map<String, String>)SerializationUtils.fromJsonString((String)this.getPageCache().get(DISTINCNAMEMAP), Map.class);
        if (Objects.nonNull(this.getPageCache().get(EXPORTEXCEL)) && Objects.isNull(queryParam.getFilter().getFilterItem("excluedOrg"))) {
            queryParam.getFilter().addFilterItem("excluedOrg", (Object)false);
        }
        accMap = AccBalanceFormRpt.processData(accMap, rowData, queryParam, obj -> this.process(baseCurrency, isShowPrice, (DynamicObject)obj, idAndNames));
        String showOrgtype = queryParam.getFilter().getString("showtreeorg");
        this.getPageCache().put(DISTINCNAMEMAP, SerializationUtils.toJsonString(accMap));
        if (this.getPageCache().get(EXPORTEXCEL) != null) {
            for (DynamicObject row : rowData) {
                acct = row.getDynamicObject(ACCOUNT_NUMBER);
                if (Objects.nonNull(acct)) {
                    row.set(NUMBER, (Object)acct);
                    row.set("name", (Object)acct.getLocaleString(accountNameField));
                }
                if (!Objects.equals(showOrgtype, "1")) continue;
                row.set("orgname", (Object)row.getString("forgname"));
            }
        }
        if (Objects.equals(showOrgtype, "1")) {
            for (DynamicObject row : rowData) {
                acct = row.getDynamicObject(ACCOUNT_NUMBER);
                if (!Objects.nonNull(acct)) continue;
                row.set(NUMBER, (Object)acct);
                row.set("name", (Object)acct.getLocaleString(accountNameField));
            }
        }
    }

    private Map<Long, String> getAccountNames(Set<Long> accountIdSet, String accountNameField) {
        HashMap<Long, String> idAndNameMap = new HashMap<Long, String>();
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_accountview", (String)("id," + accountNameField + " name"), (QFilter[])new QFilter("id", "in", accountIdSet).toArray());
        for (DynamicObject obj : coll) {
            idAndNameMap.put(obj.getLong("id"), obj.getString("name"));
        }
        return idAndNameMap;
    }

    private void process(boolean baseCurrency, boolean isShowPrice, DynamicObject obj, Map<Long, String> idAndNames) {
        DynamicObject acct = obj.getDynamicObject(NUMBER);
        if (acct != null) {
            Long id = acct.getLong("id");
            String name = idAndNames.get(id);
            if (name != null) {
                obj.set("name", (Object)name);
            }
        } else {
            String name = obj.getString("name");
            if (!name.equals(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AccBalanceFormRpt_0", (String)"fi-gl-formplugin", (Object[])new Object[0]))) {
                obj.set("name", null);
            }
        }
        if (obj.get("currencylocalid") == null) {
            DynamicObjectType objectType = obj.getDynamicObjectType();
            for (String field : localAmountFields) {
                if (!Objects.nonNull(objectType.getProperty(field))) continue;
                obj.set(field, null);
            }
        }
        if (isShowPrice) {
            String field = "yearbdebit#,yearbcredit#,begindebit#,begincredit#,debit#,credit#,enddebit#,endcredit#,yeardebit#,yearcredit#";
            this.setPrice(baseCurrency, obj, field);
        }
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        boolean isSingleOrgManageMode;
        String formatedFilterString = evt.getFormatedFilterString();
        FilterInfo filter = evt.getFilter();
        if (Objects.equals(this.getPageCache().get("enableMulCur"), "true")) {
            formatedFilterString = GlFormUtil.getMulCurFormatedFilterString(filter.getString("mulcur"), formatedFilterString);
            evt.setFormatedFilterString(formatedFilterString);
        }
        if (isSingleOrgManageMode = SingleOrgContextHelper.isSingleOrgManageMode()) {
            return;
        }
        Long parentOrg = this.getParentOrg();
        String name = "";
        if (parentOrg != null && parentOrg != 0L) {
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)parentOrg, (String)"bos_org", (String)"name");
            name = org.getString("name");
        }
        String result = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff1a%1$s; %2$s", (String)"AccBalanceFormRpt_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), name, formatedFilterString);
        evt.setFormatedFilterString(result);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "navassistbal": {
                ReportList control = (ReportList)this.getControl("reportlistap");
                int[] selectRows = control.getEntryState().getSelectedRows();
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u8054\u67e5\u6838\u7b97\u7ef4\u5ea6\u4f59\u989d\u8868\u3002", (String)"AccBalanceFormRpt_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                IReportListModel reportModel = control.getReportModel();
                DynamicObject rowData = reportModel.getRowData(selectRows[0]);
                DynamicObject account = rowData.getDynamicObject(ACCOUNT_NUMBER);
                if (account == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u660e\u7ec6\u884c\u3002", (String)"AccBalanceFormRpt_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                Date endDate = this.getQueryParam().getFilter().getDynamicObject("endperiod").getDate("enddate");
                QFilter fstartDate = new QFilter("startdate", "<=", (Object)endDate);
                QFilter fendDate = new QFilter("enddate", ">=", (Object)endDate);
                QFilter fmasterId = new QFilter("masterid", "=", (Object)account.getLong("masterid"));
                Long orgID = this.getParentOrg();
                QFilter fids = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgID);
                DynamicObject[] acctDyo = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"id,checkitementry.asstactitem", (QFilter[])new QFilter[]{fids, fstartDate, fendDate, fmasterId});
                DynamicObjectCollection acctEntry = null;
                if (acctDyo.length == 0) {
                    DynamicObject acct = BusinessDataServiceHelper.loadSingle((Object)account.get("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
                    acctEntry = acct.getDynamicObjectCollection("checkitementry");
                } else {
                    acctEntry = acctDyo[0].getDynamicObjectCollection("checkitementry");
                }
                if (acctEntry.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u6ca1\u6709\u6838\u7b97\u7ef4\u5ea6\uff0c\u4e0d\u80fd\u8054\u67e5\u3002", (String)"AccBalanceFormRpt_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                ReportQueryParam queryParam = this.getQueryParam();
                DynamicObjectCollection orgs = queryParam.getFilter().getDynamicObjectCollection("orgs");
                if (orgs.isEmpty()) {
                    return;
                }
                String showOrgtype = queryParam.getFilter().getString("showtreeorg");
                if (Objects.equals(showOrgtype, "1")) {
                    DynamicObject org = rowData.getDynamicObject("orgid");
                    DynamicObject bookType = (DynamicObject)this.getModel().getValue("booktype");
                    AccountBookInfo accountBook = AccSysUtil.getBookFromAccSys((long)((Long)org.getPkValue()), (long)((Long)bookType.getPkValue()));
                    if (null == accountBook || !accountBook.isIsbizunit()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u865a\u4f53\u7ec4\u7ec7\u4e0d\u652f\u6301\u8054\u67e5\u6838\u7b97\u7ef4\u5ea6\u4f59\u989d\u8868\u3002", (String)"AccBalanceFormRpt_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                ArrayList<Long> orgIds = new ArrayList<Long>(16);
                Long orgId = rowData.getLong("org_id");
                if (Objects.nonNull(orgId) && !Objects.equals(orgId, 0L)) {
                    orgIds.add(orgId);
                } else {
                    orgs.stream().forEach(x -> orgIds.add((Long)x.getPkValue()));
                }
                Long curId = rowData.getLong("curfor_id");
                Long measureunit = null;
                if (queryParam.getFilter().getBoolean("showqty")) {
                    measureunit = rowData.getLong("measureunit_id");
                }
                Long assgrpId = rowData.getLong("assgrp_id");
                new NavToAssRpt.Builder(queryParam, (IFormView)this.getView()).navKey("gl_rpt_assistbalance").rowData(rowData).currencyId(curId).measureunitId(measureunit).orgIds(orgIds).accountId(Long.valueOf(account.getLong("id"))).assgrpId(assgrpId).build().apply();
                break;
            }
            case "syncexportall": {
                this.unlimitedSyncexportall(false);
                break;
            }
            case "exportassistdetail": {
                this.unlimitedSyncexportall(true);
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "exportexcel": {
                this.getPageCache().put(EXPORTEXCEL, "true");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equals(EXPORTEXCEL) && !this.getQueryParam().getFilter().containProp("enablev2")) {
            this.getPageCache().remove(EXPORTEXCEL);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList rlist = (ReportList)this.getControl("reportlistap");
        rlist.addHyperClickListener(arg0 -> {
            String name = arg0.getFieldName();
            int rowIndex = this.getModel().getEntryCurrentRowIndex("reportlistap");
            IReportListModel reportModel = rlist.getReportModel();
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            ReportQueryParam queryParam = this.getQueryParam();
            if (name.startsWith("assgrp")) {
                name = "assgrp";
            }
            FilterInfo filter = queryParam.getFilter();
            switch (name) {
                case "number": {
                    Long accId = rowData.getLong(ACCOUNT_NUMBER_ID);
                    List orgs = filter.getDynamicObjectCollection("orgs").stream().map(orgDyo -> orgDyo.getLong("id")).collect(Collectors.toList());
                    Long orgViewId = filter.getLong("orgview");
                    new NavToSubLedgerRpt.SLBuilder(queryParam, (IFormView)this.getView()).orgIds(orgs).accountId(accId).orgView(orgViewId).build().apply();
                    break;
                }
                case "assgrp": {
                    boolean showOrg;
                    Long assgrpId = rowData.getLong("assgrp_id");
                    Long accId = rowData.getLong(ACCOUNT_NUMBER_ID);
                    Long orgId = rowData.getLong("org_id");
                    if (orgId == 0L) {
                        DynamicObjectCollection orgs = queryParam.getFilter().getDynamicObjectCollection("orgs");
                        if (orgs.size() == 0) {
                            return;
                        }
                        orgId = ((DynamicObject)orgs.get(0)).getLong("id");
                    }
                    if (showOrg = queryParam.getFilter().getBoolean("showorg")) {
                        Date endDate = queryParam.getFilter().getDynamicObject("endperiod").getDate("enddate");
                        ArrayList<QFilter> accountFilterList = new ArrayList<QFilter>(8);
                        accountFilterList.add(new QFilter("startdate", "<=", (Object)endDate));
                        accountFilterList.add(new QFilter("enddate", ">=", (Object)endDate));
                        accountFilterList.add(new QFilter("isassist", "=", (Object)"1"));
                        Map leafAcctIdMap = AccountUtils.getLeafAcctIdById((long)orgId, (long)filter.getLong("accounttable"), Collections.singleton(accId), accountFilterList);
                        if (!CollectionUtils.isEmpty((Map)leafAcctIdMap)) {
                            accId = (Long)((Set)leafAcctIdMap.get(accId)).iterator().next();
                        }
                    }
                    Long curId = rowData.getLong("curfor_id");
                    Long measureunit = null;
                    if (queryParam.getFilter().getBoolean("showqty")) {
                        measureunit = rowData.getLong("measureunit_id");
                    }
                    new NavToAssRpt.Builder(queryParam, (IFormView)this.getView()).rowData(rowData).accountId(accId).currencyId(curId).orgId(orgId).measureunitId(measureunit).assgrpId(assgrpId).navKey("gl_rpt_subsidiaryledger").build().apply();
                    break;
                }
                case "orgname": 
                case "orgid": {
                    Long orgId = rowData.getLong("org_id");
                    Long accId = rowData.getLong(ACCOUNT_NUMBER_ID);
                    Long curId = rowData.getLong("curfor_id");
                    Long orgViewId = filter.getLong("orgview");
                    new NavToSubLedgerRpt.SLBuilder(queryParam, (IFormView)this.getView()).accountId(accId).orgId(orgId).orgView(orgViewId).currencyId(curId).build().apply();
                    break;
                }
                case "currencyid": {
                    Long accId = rowData.getLong(ACCOUNT_NUMBER_ID);
                    DynamicObjectCollection orgs = queryParam.getFilter().getDynamicObjectCollection("orgs");
                    if (orgs.size() == 0) {
                        return;
                    }
                    long orgId = ((DynamicObject)orgs.get(0)).getLong("id");
                    Long curId = rowData.getLong("curfor_id");
                    new NavToSubLedgerRpt.SLBuilder(queryParam, (IFormView)this.getView()).orgId(Long.valueOf(orgId)).accountId(accId).currencyId(curId).build().apply();
                }
            }
        });
    }
}

