/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.HashSet;
import java.util.List;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.gl.report.FlexPrintFormatter;
import kd.fi.gl.report.ReportPrintHelper;

public class AccBalanceRptPrint
extends AbstractPrintServicePlugin {
    private static final String[] rowDataStringFieldKeys = new String[]{"fseq", "number.number", "name", "currencylocalid.name", "curfor.name", "currencyrptid.name", "orgid.name", "measureunit.name"};
    private static final String[] rowDataFlexFieldKeys = new String[]{"assgrp"};
    private static final String[] rowDataAmountLocalFieldKeys = new String[]{"yearbdebitlocal", "begindebitlocal", "debitlocal", "yeardebitlocal", "enddebitlocal", "yearbcreditlocal", "begincreditlocal", "creditlocal", "yearcreditlocal", "endcreditlocal"};
    private static final String[] rowDataAmountForFieldKeys = new String[]{"yearbdebitfor", "begindebitfor", "debitfor", "yeardebitfor", "enddebitfor", "yearbcreditfor", "begincreditfor", "creditfor", "yearcreditfor", "endcreditfor"};
    private static final String[] rowDataAmountRptFieldKeys = new String[]{"yearbdebitrpt", "begindebitrpt", "debitrpt", "yeardebitrpt", "enddebitrpt", "yearbcreditrpt", "begincreditrpt", "creditrpt", "yearcreditrpt", "endcreditrpt"};
    private static final String[] rowDataQtyFieldKeys = new String[]{"yearbdebitqty", "begindebitqty", "debitqty", "yeardebitqty", "enddebitqty", "yearbcreditqty", "begincreditqty", "creditqty", "yearcreditqty", "endcreditqty"};
    private static final String[] headBaseDataFieldKeys = new String[]{"orgview", "booktype", "periodtype", "startperiod", "endperiod", "accounttable", "currencyrpt"};
    private static final String CURRENCY_HEAD = "currency";
    private static final String CURRENCY_LOCAL = "currencylocalid";
    private static final String CURRENCY_FOR = "curfor";
    private static final String CURRENCY_RPT = "currencyrptid";
    private static final String MEASUREUNITFIELD = "measureunit";
    private static final String PARENT_ORG = "parentorg";
    private FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
    private FlexPrintFormatter flexPrintFormatter = null;
    private final Boolean enableBOSFormatter = Boolean.parseBoolean(System.getProperty("fi.gl.report.print.enablebosflexformatter", Boolean.TRUE.toString()));

    private void getParentOrgName(FilterInfo filterInfo, DynamicObject printDyn, String parentOrg) {
        Object parentOrgId = filterInfo.getCommFilter("parentOrg").getValue();
        String orgName = (String)ThreadCache.get((Object)("AccBalanceRptPrint-getParentOrg-" + parentOrgId), () -> {
            QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(parentOrgId.toString()));
            DynamicObject orgDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"name", (QFilter[])idFilter.toArray());
            if (orgDyn != null) {
                return orgDyn.getString("name");
            }
            return "";
        });
        printDyn.set(parentOrg, (Object)orgName);
    }

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        super.customPrintDataEntities(e);
        List dyns = e.getDataEntities();
        String pageId = e.getPageId();
        ReportListModel listModel = ReportPrintHelper.getListModel(pageId);
        if (listModel == null) {
            return;
        }
        ReportQueryParam param = listModel.getReportQueryParam();
        FilterInfo filterInfo = param.getFilter();
        if (e.isMainDs()) {
            DynamicObjectType customDT = new DynamicObjectType();
            customDT.registerProperty("id", String.class, (Object)"", false);
            DynamicObject printDyn = new DynamicObject(customDT);
            printDyn.set("id", (Object)"1");
            dyns.add(printDyn);
            e.setDataEntities(dyns);
        } else if ("reporthead".equals(e.getDataSourceName())) {
            DynamicObjectType customDT = new DynamicObjectType();
            String[] headBaseDataFields = ReportPrintHelper.getExistFileds(e, headBaseDataFieldKeys);
            ReportPrintHelper.registerStringProperty(customDT, headBaseDataFields);
            ReportPrintHelper.registerStringProperty(customDT, CURRENCY_HEAD, PARENT_ORG);
            DynamicObject printDyn = new DynamicObject(customDT);
            ReportPrintHelper.handleBaseDataFilterInfo(filterInfo, printDyn, headBaseDataFields);
            ReportPrintHelper.handleCurrencyNameById(filterInfo, printDyn, CURRENCY_HEAD);
            this.getParentOrgName(filterInfo, printDyn, PARENT_ORG);
            dyns.add(printDyn);
            e.setDataEntities(dyns);
        } else {
            int count = listModel.getRowCount();
            DynamicObjectCollection ds = listModel.getRowData(0, count);
            if (ds == null || ds.isEmpty()) {
                return;
            }
            if (this.enableBOSFormatter.booleanValue()) {
                this.flexPrintFormatter = new FlexPrintFormatter(listModel, ds);
            }
            DynamicObjectType customDt = new DynamicObjectType("reportlist");
            String[] rowDataStringFields = ReportPrintHelper.getExistFileds(e, rowDataStringFieldKeys);
            String[] rowDataFlexFields = ReportPrintHelper.getExistFileds(e, rowDataFlexFieldKeys);
            String[] rowDataAmountForFields = ReportPrintHelper.getExistFileds(e, rowDataAmountForFieldKeys);
            String[] rowDataAmountLocalFields = ReportPrintHelper.getExistFileds(e, rowDataAmountLocalFieldKeys);
            String[] rowDataAmountRptFields = ReportPrintHelper.getExistFileds(e, rowDataAmountRptFieldKeys);
            String[] rowDataQtyFields = ReportPrintHelper.getExistFileds(e, rowDataQtyFieldKeys);
            ReportPrintHelper.registerStringProperty(customDt, new String[][]{rowDataAmountLocalFields, rowDataAmountForFields, rowDataAmountRptFields, rowDataStringFields, rowDataFlexFields, rowDataQtyFields});
            boolean isShowAssgrp = filterInfo.getBoolean("showassist");
            boolean showrpt = filterInfo.getBoolean("showrpt");
            boolean showqty = filterInfo.getBoolean("showqty");
            HashSet<String> hgValueSet = new HashSet<String>(ds.size());
            for (DynamicObject rowData : ds) {
                DynamicObject printRow = new DynamicObject(customDt);
                ReportPrintHelper.handleStringFields(rowData, printRow, rowDataStringFields);
                if (rowData.getInt("fseq") == count) {
                    printRow.set("name", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AccBalanceRptPrint_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                }
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_LOCAL, (boolean)Boolean.FALSE, rowDataAmountLocalFields);
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_FOR, (boolean)Boolean.FALSE, rowDataAmountForFields);
                if (showrpt) {
                    ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_RPT, (boolean)Boolean.FALSE, rowDataAmountRptFields);
                }
                if (showqty) {
                    ReportPrintHelper.handleQtyFields(rowData, printRow, (boolean)Boolean.FALSE, MEASUREUNITFIELD, this.fobj, rowDataQtyFields);
                }
                if (isShowAssgrp) {
                    if (!this.enableBOSFormatter.booleanValue()) {
                        ReportPrintHelper.handleFlexFields(rowData, printRow, hgValueSet, rowDataFlexFields);
                    } else if (this.flexPrintFormatter != null && customDt.getProperty("assgrp") != null) {
                        printRow.set("assgrp", (Object)this.flexPrintFormatter.getFlexString(rowData));
                    }
                }
                dyns.add(printRow);
            }
            if (isShowAssgrp && !this.enableBOSFormatter.booleanValue()) {
                ReportPrintHelper.handleFlexIntoToStr(dyns, hgValueSet, rowDataFlexFields);
            }
            e.setDataEntities(dyns);
        }
    }
}

