/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.TreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.SingleOrgContextHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.ReportTree;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.DebugTraceHelper;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.report.GLRptTemplatePlugin;
import kd.fi.gl.report.ReportFormUtil;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLUtil;
import org.apache.commons.lang.math.NumberUtils;

public class AgingScheduleReportPlugin
extends GLRptTemplatePlugin {
    private static final String QUERY_TYPE = "QUERY_TYPE";
    private static final String AGINGENTITY = "agingentity";
    private static final String OVERDUE_AGE = "overdueage";
    private static final String OVERDUE_DAY = "overdueday";
    private static final String UNDUE_AGE = "undueage";
    private static final String UNDUE_DAY = "undueday";
    private static final String BOOKEDDATE = "bookeddate";
    private static final String EXPIREDATE = "expiredate";
    private static final String SHOWBYEXPIREDATE = "showbyexpiredate";
    private static final String SHOWBYAMOUNT = "showbyamount";
    private static final String COLKEY_BALTOTAL = "baltotal";
    private static final String COLKEY_UNDUETOTAL = "unduetotal";
    private static final String COLKEY_OVERDUETOTAL = "overduetotal";
    private static final String COLKEY_UNDUE = "undue";
    private static final String COLKEY_OVERDUE = "overdue";
    private static final String COLKEY_CUR = "currencyid";
    private boolean isPropertyChanged = true;
    private static final String ACCOUNT_NUM = "accountnum";
    private static final String ACCOUNT_NAME = "accountname";
    protected static final String REPORT_LIST_AP = "reportlistap";
    private static final String BTN_EXPORT_ALL = "exportAllAccountExcel";
    private static final String AGINGDETAILORG = "agingdetailorg";
    private static final String RANGE1 = "1 - %s";
    private static final String RANGE2 = "0 - -%s";
    private static final String RANGE3 = "0 - ";
    private static final String RANGE4 = "%s - ";
    private static final String RANGE5 = "%s - %s";
    private static final String RANGE6 = "-%s - ";
    private static final String RANGE7 = "-%s - -%s";
    private static final Log logger = LogFactory.getLog(AgingScheduleReportPlugin.class);

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        super.setOtherEntryFilter(filterInfo);
        HashMap otherEntryFilter = new HashMap();
        DynamicObjectCollection agingEntity = this.getModel().getEntryEntity(AGINGENTITY);
        ArrayList<DynamicObject> saveEntrys = new ArrayList<DynamicObject>();
        for (DynamicObject entry : agingEntity) {
            saveEntrys.add(entry);
        }
        otherEntryFilter.put(AGINGENTITY, saveEntrys);
        filterInfo.setOtherEntryFilter(otherEntryFilter);
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        DynamicObjectCollection agingEntity = scheme.getDynamicObjectCollection(AGINGENTITY);
        if (agingEntity.size() > 0) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.deleteEntryData(AGINGENTITY);
            model.batchCreateNewEntryRow(AGINGENTITY, agingEntity.size());
            int i = 0;
            for (DynamicObject entry : agingEntity) {
                model.setValue(UNDUE_AGE, entry.get(UNDUE_AGE), i);
                model.setValue(UNDUE_DAY, entry.get(UNDUE_DAY), i);
                model.setValue(OVERDUE_AGE, entry.get(OVERDUE_AGE), i);
                model.setValue(OVERDUE_DAY, entry.get(OVERDUE_DAY), i);
                ++i;
            }
            model.endInit();
            this.getView().updateView(AGINGENTITY);
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        Map assistNumberValues;
        String assistTypeName;
        super.processRowData(gridPK, rowData, queryParam);
        DynamicObject account = this.getSelectAccount();
        for (DynamicObject row : rowData) {
            String rowType = row.getString("rowtype");
            if (rowType.equals("1")) {
                String curField = COLKEY_CUR;
                String curStr = queryParam.getFilter().getString("currency");
                if ("basecurrency".equals(curStr)) {
                    curField = "currencylocal";
                }
                DynamicObject currency = row.getDynamicObject(curField);
                row.set("currencyname", (Object)currency.getString("name"));
            } else if (rowType.equals("2")) {
                row.set("currencyname", (Object)ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"AgingScheduleReportPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                continue;
            }
            Iterator accountId = row.get("accountid");
            if (null != accountId) {
                row.set(ACCOUNT_NUM, accountId);
                continue;
            }
            if (account == null) continue;
            row.set(ACCOUNT_NUM, (Object)account);
        }
        List flexFilterItems = queryParam.getFilter().getFlexFilterItems();
        List flexFields = flexFilterItems.stream().map(FilterItemInfo::getPropName).collect(Collectors.toList());
        ArrayList<String> assistBaseCols = new ArrayList<String>(10);
        for (String flexField : flexFields) {
            if (!FlexUtils.isBaseDataAndMasteridProperty((String)flexField)) continue;
            assistBaseCols.add(flexField);
        }
        HashMap<Long, Map> assistMasterIdToId = new HashMap<Long, Map>(10);
        boolean isShowOrg = queryParam.getFilter().getBoolean("showorg");
        Long defaultOrg = this.getParentOrg();
        long orgid = 0L;
        for (DynamicObject dyn : rowData) {
            if (isShowOrg) {
                DynamicObject orgObj = dyn.getDynamicObject("orgname");
                if (orgObj == null) continue;
                orgid = orgObj.getLong("id");
            } else {
                orgid = defaultOrg;
            }
            for (String assistBaseCol : assistBaseCols) {
                DynamicObject assistObj;
                if (!dyn.containsProperty(assistBaseCol) || (assistObj = dyn.getDynamicObject(assistBaseCol)) == null) continue;
                long masterid = assistObj.getLong("masterid");
                assistTypeName = assistObj.getDynamicObjectType().getName();
                assistMasterIdToId.computeIfAbsent(orgid, k -> new HashMap()).computeIfAbsent(assistTypeName, k -> new HashMap(10)).put(masterid, assistObj);
            }
        }
        Date enddate = (Date)this.getModel().getValue(BOOKEDDATE);
        for (Map.Entry assistDataEntry : assistMasterIdToId.entrySet()) {
            orgid = (Long)assistDataEntry.getKey();
            assistNumberValues = (Map)assistDataEntry.getValue();
            for (Map.Entry assistNumberValuesEntry : assistNumberValues.entrySet()) {
                String assistTypeName2 = (String)assistNumberValuesEntry.getKey();
                if (StringUtils.isEmpty((String)assistTypeName2)) continue;
                String nameField = "name";
                String nameNumberField = "number,name";
                String nameFieldCache = this.getPageCache().get(assistTypeName2);
                if (StringUtils.isNotEmpty((String)nameFieldCache)) {
                    nameNumberField = nameFieldCache;
                    String[] fieldArr = nameFieldCache.split(",");
                    nameField = fieldArr[0];
                    if (Objects.equals(fieldArr[0], fieldArr[1])) {
                        nameNumberField = fieldArr[0];
                    }
                }
                Map masterIdToId = (Map)assistNumberValuesEntry.getValue();
                Set masterids = masterIdToId.keySet();
                QFilter qFilter = new QFilter("masterid", "in", masterids);
                if (DebugTrace.enable()) {
                    logger.info("AgingScheduleReportPlugin_masterid:" + new ArrayList(masterids).toString());
                }
                DynamicObjectCollection assistObjs = BaseDataServiceHelper.queryBaseDataByDate((String)assistTypeName2, (Long)orgid, (QFilter)qFilter, (String)("id,masterid," + nameNumberField), (Date)enddate);
                for (DynamicObject assistObj : assistObjs) {
                    DynamicObject dynamicObject = (DynamicObject)masterIdToId.get(assistObj.getLong("masterid"));
                    dynamicObject.set("id", (Object)assistObj.getLong("id"));
                    dynamicObject.set(nameField, (Object)new LocaleString(assistObj.getString(nameField)));
                }
            }
        }
        if (DebugTrace.enable()) {
            logger.info("AgingScheduleReportPlugin_assistMasterIdToId:", (Object)DebugTraceHelper.toString(assistMasterIdToId));
        }
        for (DynamicObject dyn : rowData) {
            if (isShowOrg) {
                DynamicObject orgObj = dyn.getDynamicObject("orgname");
                if (orgObj == null) continue;
                orgid = orgObj.getLong("id");
            } else {
                orgid = defaultOrg;
            }
            assistNumberValues = (Map)assistMasterIdToId.get(orgid);
            for (String assistBaseCol : assistBaseCols) {
                DynamicObject assistObj;
                if (!dyn.containsProperty(assistBaseCol) || (assistObj = dyn.getDynamicObject(assistBaseCol)) == null || !assistNumberValues.containsKey(assistTypeName = assistObj.getDynamicObjectType().getName())) continue;
                Map masterIdToId = (Map)assistNumberValues.get(assistTypeName);
                DynamicObject id = (DynamicObject)masterIdToId.get(assistObj.getLong("masterid"));
                dyn.set(assistBaseCol, (Object)id);
                dyn.set(assistBaseCol + "_id", (Object)id.getLong("id"));
            }
        }
    }

    private List<Tuple2<String, String>> getAssistCols(List<FilterItemInfo> flexFilterItems) {
        return null;
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        boolean isHideAccount = !this.isExportExcel();
        List columns = event.getColumns();
        Long orgId = this.getParentOrg();
        String accountNameField = GLUtil.getAcctNameBySysParam((Long)orgId);
        for (AbstractReportColumn column : columns) {
            if (!(column instanceof ReportColumn)) continue;
            ReportColumn col = (ReportColumn)column;
            String key = col.getFieldKey();
            if (ACCOUNT_NUM.equals(key) || ACCOUNT_NAME.equals(key)) {
                col.setHide(isHideAccount);
            }
            if (!ACCOUNT_NAME.equals(key)) continue;
            col.setDisplayProp(accountNameField);
        }
    }

    private boolean isExportExcel() {
        StackTraceElement[] stackTrace;
        boolean isExportExcel = false;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            String methodName = element.getMethodName();
            if (!methodName.equals("exportExcel") && !methodName.equals(BTN_EXPORT_ALL)) continue;
            isExportExcel = true;
            break;
        }
        return isExportExcel;
    }

    private DynamicObject getSelectAccount() {
        List ids;
        DynamicObject account = null;
        TreeView reportTree = (TreeView)this.getView().getControl("reporttreeap");
        if (reportTree != null && !(ids = reportTree.getTreeState().getSelectedNodeId()).isEmpty()) {
            try {
                Long accountId = Long.valueOf((String)ids.get(0));
                account = BusinessDataServiceHelper.loadSingleFromCache((Object)accountId, (String)"bd_accountview");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return account;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(AGINGENTITY);
        model.batchCreateNewEntryRow(AGINGENTITY, 4);
        model.setValue(OVERDUE_DAY, (Object)30, 0);
        model.setValue(OVERDUE_DAY, (Object)60, 1);
        model.setValue(OVERDUE_DAY, (Object)90, 2);
        model.setValue(OVERDUE_AGE, (Object)"1 - 30", 0);
        model.setValue(OVERDUE_AGE, (Object)"31 - 60", 1);
        model.setValue(OVERDUE_AGE, (Object)"61 - 90", 2);
        model.setValue(OVERDUE_AGE, (Object)ResManager.loadKDString((String)"%s\u4e0d\u8bbe\u7f6e", (String)"AgingScheduleReportPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[]{"91 - "}), 3);
        model.setValue(UNDUE_DAY, (Object)30, 0);
        model.setValue(UNDUE_DAY, (Object)60, 1);
        model.setValue(UNDUE_DAY, (Object)90, 2);
        model.setValue(UNDUE_AGE, (Object)"0 - -29", 0);
        model.setValue(UNDUE_AGE, (Object)"-30 - -59", 1);
        model.setValue(UNDUE_AGE, (Object)"-60 - -89", 2);
        model.setValue(UNDUE_AGE, (Object)ResManager.loadKDString((String)"%s\u4e0d\u8bbe\u7f6e", (String)"AgingScheduleReportPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[]{"-90 - "}), 3);
        this.setAgingEntityEnable();
        model.endInit();
        this.orgChangeEvent();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList control = (ReportList)this.getControl(REPORT_LIST_AP);
        control.addHyperClickListener(evt -> this.showDetailRpt(evt));
        BasedataEdit account = (BasedataEdit)this.getControl("account");
        account.addBeforeF7SelectListener(evt -> {
            QFilter acctRefFilter;
            DynamicObject period;
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            filters.add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
            filters.add(new QFilter("accheck", "=", (Object)"1"));
            String str = this.getPageCache().get("_childOrgSet");
            Set childOrgSet = new HashSet();
            if (str != null) {
                childOrgSet = (Set)GLUtil.fromSerializedString((String)str);
            }
            Long bookTypeId = (Long)this.getModel().getValue("booktype_id");
            filters.add(ReciprocalUtils.queryEndInitActFilter(childOrgSet, (Long)bookTypeId));
            Date bookedDate = (Date)this.getModel().getValue(BOOKEDDATE);
            Long periodType = (Long)this.getModel().getValue("periodtype_id");
            if (Objects.isNull(bookedDate)) {
                bookedDate = new Date();
                this.getModel().setValue(BOOKEDDATE, (Object)bookedDate);
            }
            if ((period = GLUtil.getPeriodByDate((Date)bookedDate, (long)periodType)) != null && (acctRefFilter = BalanceTransferUtils.getAccountRefFilter((Date)period.getDate("enddate"))) != null) {
                filters.add(acctRefFilter);
            }
        });
        BasedataEdit assgrp = (BasedataEdit)this.getControl("fieldname");
        assgrp.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            DynamicObjectCollection accts = (DynamicObjectCollection)this.getModel().getValue("account");
            List<Long> assgrpIds = new ArrayList();
            if (accts == null || accts.size() <= 0) {
                long parentOrgId = AgingScheduleReportPlugin.getParentOrgByChildre(this.getOrgValue());
                Long actTableId = (Long)this.getModel().getValue("accounttable_id");
                String strAssgrpIds = this.getPageCache().get(parentOrgId + "-" + actTableId);
                if (StringUtils.isEmpty((String)strAssgrpIds)) {
                    ArrayList<QFilter> filters = new ArrayList<QFilter>();
                    filters.add(new QFilter("checkitementry.enaccheck", "=", (Object)"1"));
                    try (DataSet dSet = AccountUtils.queryAccountDataSet((long)parentOrgId, (long)actTableId, (String)"checkitementry.asstactitem assist", filters);){
                        while (dSet.hasNext()) {
                            assgrpIds.add(dSet.next().getLong("assist"));
                        }
                    }
                    this.getPageCache().put(parentOrgId + "-" + actTableId, GLUtil.toSerializedString(assgrpIds));
                } else {
                    assgrpIds = (List)GLUtil.fromSerializedString((String)strAssgrpIds);
                }
            } else {
                for (DynamicObject dyo : accts) {
                    DynamicObject acct = dyo.getDynamicObject("fbasedataid");
                    DynamicObjectCollection entry = acct.getDynamicObjectCollection("checkitementry");
                    for (DynamicObject item : entry) {
                        boolean isAccheck = item.getBoolean("enaccheck");
                        if (!isAccheck) continue;
                        DynamicObject asstactitem = item.getDynamicObject("asstactitem");
                        assgrpIds.add((Long)asstactitem.getPkValue());
                    }
                }
            }
            if (assgrpIds != null) {
                QFilter qf = new QFilter("id", "in", assgrpIds);
                param.getListFilterParameter().getQFilters().add(qf);
            }
        });
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        if (!this.isPropertyChanged) {
            return;
        }
        ChangeData data = e.getChangeSet()[0];
        Object oldVal = data.getOldValue();
        Object newVal = data.getNewValue();
        switch (key = e.getProperty().getName()) {
            case "orgs": {
                this.orgChangeEvent();
                this.setAccountTable();
                break;
            }
            case "booktype": {
                this.setDefaultDate();
                this.setAccountTable();
                break;
            }
            case "bookeddate": {
                this.setAccountTable();
                break;
            }
            case "overdueday": {
                this.updateAgingDay(OVERDUE_DAY, OVERDUE_AGE, oldVal, newVal);
                break;
            }
            case "undueday": {
                this.updateAgingDay(UNDUE_DAY, UNDUE_AGE, oldVal, newVal);
                break;
            }
            case "account": {
                DynamicObjectCollection accCols = (DynamicObjectCollection)newVal;
                if (accCols.size() != 0) break;
                return;
            }
        }
    }

    private void setAccountTable() {
        DynamicObjectCollection periods;
        String str = this.getPageCache().get("_childOrgSet");
        Set childOrgSet = new HashSet(6);
        if (str != null) {
            childOrgSet = (Set)GLUtil.fromSerializedString((String)str);
        }
        long bookTypeId = (Long)this.getModel().getValue("booktype_id");
        long periodTypeId = (Long)this.getModel().getValue("periodtype_id");
        Date endDate = (Date)this.getModel().getValue(BOOKEDDATE);
        if (Objects.isNull(endDate)) {
            endDate = new Date();
            this.getModel().setValue(BOOKEDDATE, (Object)endDate);
        }
        if (Objects.isNull(periods = PeriodUtil.getPeriodByDate((Date)endDate, (String)"id", (long)periodTypeId, (Boolean)false)) || periods.size() == 0) {
            return;
        }
        long periodId = ((DynamicObject)periods.get(0)).getLong("id");
        List acctTableIds = ReportFormUtil.getVerAcctTable(new ArrayList(childOrgSet), (long)bookTypeId, (long)periodId);
        if (!acctTableIds.isEmpty()) {
            this.getModel().setValue("accounttable", acctTableIds.get(0));
            BasedataEdit acctTblEdit = (BasedataEdit)this.getControl("accounttable");
            acctTblEdit.setQFilters(Collections.singletonList(new QFilter("id", "in", (Object)acctTableIds)));
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection agingEntity = this.getModel().getEntryEntity(AGINGENTITY);
        ArrayList<Integer> overDueRange = new ArrayList<Integer>();
        ArrayList<Integer> unDueRange = new ArrayList<Integer>();
        for (DynamicObject row : agingEntity) {
            String undueAge = row.getString(UNDUE_AGE);
            int undueDay = row.getInt(UNDUE_DAY);
            this.fillRangeToList(undueAge, undueDay, unDueRange);
            String overdueAge = row.getString(OVERDUE_AGE);
            int overdueDay = row.getInt(OVERDUE_DAY);
            this.fillRangeToList(overdueAge, overdueDay, overDueRange);
        }
        filterInfo.addFilterItem("OVERDUERANGE", overDueRange);
        filterInfo.addFilterItem("UNDUERANGE", unDueRange);
        this.setQueryType(queryParam, 0);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        for (int idx = 0; idx < selectRows.length; ++idx) {
            String valueType;
            int i = selectRows[idx];
            DynamicObject assisType = (DynamicObject)this.getModel().getValue("fieldname", i);
            if (Objects.isNull(assisType) || AssistValueType.isManualTxt((String)(valueType = assisType.getString("valuetype")))) continue;
            String valueSource = assisType.getString("valuesource_id");
            BasedataEntityType entityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)valueSource);
            this.getPageCache().put(valueSource, String.join((CharSequence)",", entityType.getNameProperty(), entityType.getNumberProperty()));
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        this.agingentityDelRow(e);
    }

    private void agingentityDelRow(AfterDeleteRowEventArgs e) {
        if (!AGINGENTITY.equals(e.getEntryProp().getName())) {
            return;
        }
        IDataModel model = this.getModel();
        int idx = e.getRowIndexs()[0];
        DynamicObjectCollection entity = this.getModel().getEntryEntity(AGINGENTITY);
        if (idx == 0 && entity.size() >= 2) {
            Integer overdueAge = (Integer)model.getValue(OVERDUE_DAY, 0);
            Integer undueAge = (Integer)model.getValue(UNDUE_DAY, 0);
            if (overdueAge != null && overdueAge != 0) {
                model.setValue(OVERDUE_AGE, (Object)String.format(RANGE1, overdueAge), idx);
            }
            if (undueAge != null && undueAge != 0) {
                model.setValue(UNDUE_AGE, (Object)String.format(RANGE2, undueAge - 1), idx);
            }
        } else if (idx == 0 && entity.size() == 1) {
            model.setValue(OVERDUE_AGE, (Object)ResManager.loadKDString((String)"%s\u4e0d\u8bbe\u7f6e", (String)"AgingScheduleReportPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[]{RANGE3}), idx);
            model.setValue(OVERDUE_DAY, (Object)0, idx);
            model.setValue(UNDUE_AGE, (Object)ResManager.loadKDString((String)"%s\u4e0d\u8bbe\u7f6e", (String)"AgingScheduleReportPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[]{RANGE3}), idx);
            model.setValue(UNDUE_DAY, (Object)0, idx);
        } else if (idx > 0 && idx == entity.size() - 1) {
            Integer overdueAgeStart = (Integer)model.getValue(OVERDUE_DAY, idx - 1);
            Integer undueAgeStart = (Integer)model.getValue(UNDUE_DAY, idx - 1);
            model.setValue(OVERDUE_AGE, (Object)ResManager.loadKDString((String)"%s - \u4e0d\u8bbe\u7f6e", (String)"AgingScheduleReportPlugin_12", (String)"fi-gl-formplugin", (Object[])new Object[]{overdueAgeStart + 1}), idx);
            model.setValue(UNDUE_AGE, (Object)ResManager.loadKDString((String)"%s - \u4e0d\u8bbe\u7f6e", (String)"AgingScheduleReportPlugin_12", (String)"fi-gl-formplugin", (Object[])new Object[]{undueAgeStart}), idx);
        } else if (idx > 0 && idx < entity.size()) {
            Integer overdueAgeStart = (Integer)model.getValue(OVERDUE_DAY, idx - 1);
            Integer overdueAgeEnd = (Integer)model.getValue(OVERDUE_DAY, idx);
            if (overdueAgeStart != null && overdueAgeStart != 0 && overdueAgeEnd != null && overdueAgeEnd != 0) {
                model.setValue(OVERDUE_AGE, (Object)String.format(RANGE5, overdueAgeStart + 1, overdueAgeEnd), idx);
            }
            Integer undueAgeStart = (Integer)model.getValue(UNDUE_DAY, idx - 1);
            Integer undueAgeEnd = (Integer)model.getValue(UNDUE_DAY, idx);
            if (undueAgeStart != null && undueAgeStart != 0 && undueAgeEnd != null && undueAgeEnd != 0) {
                model.setValue(UNDUE_AGE, (Object)String.format(RANGE7, undueAgeStart, undueAgeEnd - 1), idx);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        switch (e.getOperateKey()) {
            case "newentry": {
                this.setAgingEntityEnable();
                break;
            }
            case "exportAllAccountExcel": {
                this.exportAllToExcel();
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "exportAllAccountExcel": {
                this.exportAllToExcel();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate sourceOperate = (AbstractOperate)args.getSource();
        String key = sourceOperate.getOperateKey();
        if ("exportexcel".equals(key)) {
            TreeModel treeModel;
            List nodes;
            ReportTree reportTree = (ReportTree)this.getView().getControl("reporttreeap");
            boolean hasAccount = false;
            if (reportTree != null && !CollectionUtils.isEmpty((Collection)(nodes = (treeModel = reportTree.getReportModel().getTreeModel()).getNodes()))) {
                for (TreeNode node : nodes) {
                    if (!Objects.equals("0", node.getParentid())) continue;
                    hasAccount = true;
                    break;
                }
            }
            if (!hasAccount) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u79d1\u76ee\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5bfc\u51fa\u3002", (String)"AgingScheduleReportPlugin_14", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private void showDetailRpt(HyperLinkClickEvent evt) {
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId("gl_rpt_agingdetail");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ReportQueryParam queryParam = this.getRptParam();
        if (queryParam == null) {
            return;
        }
        parameter.setQueryParam(queryParam);
        this.addCustomParams(parameter, evt);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private ReportQueryParam getRptParam() {
        DynamicObject[] acctArray;
        int rowIndex = this.getModel().getEntryCurrentRowIndex(REPORT_LIST_AP);
        ReportList control = (ReportList)this.getControl(REPORT_LIST_AP);
        DynamicObject rowData = control.getReportModel().getRowData(rowIndex);
        if (rowData == null) {
            return null;
        }
        ReportTree reportTree = (ReportTree)this.getControl("reporttreeap");
        if (reportTree == null) {
            return null;
        }
        ReportQueryParam param = this.getQueryParam();
        FilterInfo info = param.getFilter();
        FilterInfo filter = new FilterInfo();
        filter.addFilterItem("booktype", (Object)info.getLong("booktype"));
        filter.addFilterItem("orgview", (Object)info.getLong("orgview"));
        filter.addFilterItem("startperiod", (Object)info.getLong("startperiod"));
        filter.addFilterItem("endperiod", (Object)info.getLong("endperiod"));
        filter.addFilterItem("periodtype", (Object)info.getLong("periodtype"));
        filter.addFilterItem(BOOKEDDATE, (Object)info.getDate(BOOKEDDATE));
        filter.addFilterItem(EXPIREDATE, (Object)info.getDate(EXPIREDATE));
        filter.addFilterItem("accounttable", (Object)info.getLong("accounttable"));
        filter.addFilterItem("accountlevel", (Object)info.getString("accountlevel"));
        filter.addFilterItem(SHOWBYEXPIREDATE, (Object)info.getBoolean(SHOWBYEXPIREDATE));
        filter.addFilterItem(SHOWBYAMOUNT, (Object)info.getBoolean(SHOWBYAMOUNT));
        Boolean isShowOrg = info.getBoolean("showorg");
        filter.addFilterItem("showorg", (Object)isShowOrg);
        Long parentOrg = this.getParentOrg();
        long rowOrgId = rowData.getLong("orgname.id");
        if (isShowOrg.booleanValue() && rowOrgId != 0L) {
            filter.addFilterItem(AGINGDETAILORG, (Object)rowData.getLong("orgname.id"));
        }
        filter.addFilterItem("org", (Object)parentOrg);
        filter.addFilterItem("orgs", (Object)info.getDynamicObjectCollection("orgs"));
        DynamicObject selectNode = (DynamicObject)param.getCustomParam().get("curSelectNode");
        if (Objects.isNull(selectNode)) {
            return null;
        }
        Long curNodeId = selectNode.getLong("masterid");
        Set masterIdAll = ReciprocalUtils.getAllLeafAccount((Long)curNodeId, (long)info.getLong("accounttable"));
        masterIdAll.add(curNodeId);
        DynamicObjectCollection acctCol = (DynamicObjectCollection)info.getFilterItem("account").getValue();
        if (Objects.nonNull(acctCol)) {
            Set acctMasterIdSet = acctCol.stream().map(v -> v.getLong("masterid")).collect(Collectors.toSet());
            masterIdAll.retainAll(acctMasterIdSet);
        }
        if (Objects.nonNull(acctArray = GLUtil.getAccIdsByMasterIds((long)parentOrg, (Set)masterIdAll, (Date)info.getDate(BOOKEDDATE)))) {
            masterIdAll = Arrays.stream(acctArray).map(v -> v.getLong("id")).collect(Collectors.toSet());
        }
        filter.addFilterItem("account", (Object)masterIdAll);
        String currencyFilter = info.getString("currency");
        Long currencyId = 0L;
        if ("basecurrency".equals(currencyFilter)) {
            filter.addFilterItem("currency", (Object)currencyFilter);
            Set childOrgSet = new HashSet();
            String str = this.getPageCache().get("_childOrgSet");
            if (str != null) {
                childOrgSet = (Set)GLUtil.fromSerializedString((String)str);
            }
            List bookInfoList = AccSysUtil.getBookFromAccSys(childOrgSet, (long)info.getLong("booktype"));
            currencyId = ((AccountBookInfo)bookInfoList.get(0)).getBaseCurrencyId();
        } else {
            filter.addFilterItem("currency", (Object)rowData.getLong("currencyid.id"));
            currencyId = rowData.getLong("currencyid.id");
        }
        List items = param.getFilter().getFlexFilterItems();
        LinkedHashSet flexFieldSet = new LinkedHashSet(items.size());
        items.forEach(v -> flexFieldSet.add(v.getPropName()));
        ArrayList<FilterItemInfo> flexItems = new ArrayList<FilterItemInfo>(flexFieldSet.size());
        for (String flexField : flexFieldSet) {
            HashSet<Long> vals = new HashSet<Long>();
            String propertyName = flexField + ".id";
            if (!rowData.containsProperty(flexField)) continue;
            Long val = rowData.getLong(propertyName);
            if (val == 0L) {
                if (rowData.getString("rowtype").equals("2")) {
                    DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
                    for (DynamicObject row : entryentity) {
                        DynamicObject fieldname = row.getDynamicObject("fieldname");
                        if (fieldname == null || !flexField.equals(fieldname.get("flexfield"))) continue;
                        DynamicObjectCollection valNameColl = row.getDynamicObjectCollection("value");
                        if (valNameColl.size() > 0) {
                            for (DynamicObject valDyn : valNameColl) {
                                Long id = valDyn.getLong("fbasedataid_id");
                                vals.add(id);
                            }
                            continue;
                        }
                        vals.add(val);
                    }
                } else {
                    vals.add(val);
                }
            } else {
                vals.add(val);
            }
            if (vals.isEmpty()) continue;
            FilterItemInfo itemInfo = new FilterItemInfo(flexField, vals, "in");
            flexItems.add(itemInfo);
        }
        filter.setFlexFilterItems(flexItems);
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filter);
        return queryParam;
    }

    private void addCustomParams(ReportShowParameter parameter, HyperLinkClickEvent evt) {
        Pattern p;
        Matcher matcher;
        String name = evt.getFieldName();
        HashMap<Boolean, ArrayList<Tuple<Integer, Integer>>> rangeMap = new HashMap<Boolean, ArrayList<Tuple<Integer, Integer>>>();
        DynamicObjectCollection agingEntity = this.getModel().getEntryEntity(AGINGENTITY);
        if (name.endsWith("total")) {
            ArrayList<Tuple<Integer, Integer>> undueRange = new ArrayList<Tuple<Integer, Integer>>();
            ArrayList<Tuple<Integer, Integer>> overdueRange = new ArrayList<Tuple<Integer, Integer>>();
            for (DynamicObject row : agingEntity) {
                String undueAge = row.getString(UNDUE_AGE);
                String overdueAge = row.getString(OVERDUE_AGE);
                this.convertToRange(undueAge, undueRange);
                this.convertToRange(overdueAge, overdueRange);
            }
            switch (name) {
                case "baltotal": {
                    rangeMap.put(Boolean.TRUE, overdueRange);
                    rangeMap.put(Boolean.FALSE, undueRange);
                    break;
                }
                case "unduetotal": {
                    rangeMap.put(Boolean.FALSE, undueRange);
                    break;
                }
                case "overduetotal": {
                    rangeMap.put(Boolean.TRUE, overdueRange);
                    break;
                }
            }
        } else if (name.startsWith(COLKEY_OVERDUE)) {
            Pattern p2 = Pattern.compile("\\d+");
            Matcher matcher2 = p2.matcher(name);
            if (matcher2.find()) {
                Integer index = Integer.valueOf(matcher2.group());
                String overdueAge = (String)this.getModel().getValue(OVERDUE_AGE, index.intValue());
                ArrayList<Tuple<Integer, Integer>> range = new ArrayList<Tuple<Integer, Integer>>();
                this.convertToRange(overdueAge, range);
                rangeMap.put(Boolean.TRUE, range);
            }
        } else if (name.startsWith(COLKEY_UNDUE) && (matcher = (p = Pattern.compile("\\d+")).matcher(name)).find()) {
            Integer index = Integer.valueOf(matcher.group());
            String undueAge = (String)this.getModel().getValue(UNDUE_AGE, index.intValue());
            ArrayList<Tuple<Integer, Integer>> range = new ArrayList<Tuple<Integer, Integer>>();
            this.convertToRange(undueAge, range);
            rangeMap.put(Boolean.FALSE, range);
        }
        parameter.setCustomParam("agingrange", rangeMap);
        if (parameter.getReportQueryParam().getFilter().containProp(AGINGDETAILORG)) {
            parameter.setCustomParam(AGINGDETAILORG, (Object)parameter.getReportQueryParam().getFilter().getLong(AGINGDETAILORG));
        }
    }

    private void convertToRange(String strAge, List<Tuple<Integer, Integer>> range) {
        String[] arr;
        if (!StringUtils.isEmpty((String)strAge) && (arr = strAge.split(" - ")).length == 2) {
            int minDay = Integer.parseInt(arr[0]);
            String maxDay = arr[1].trim();
            if (!NumberUtils.isNumber((String)maxDay)) {
                range.add((Tuple<Integer, Integer>)new Tuple((Object)minDay, (Object)0));
            } else {
                range.add((Tuple<Integer, Integer>)new Tuple((Object)minDay, (Object)Integer.valueOf(maxDay)));
            }
        }
    }

    private void updateAgingDay(String fieldKey, String updateFieldKey, Object oldVal, Object newVal) {
        IDataModel model = this.getModel();
        int idx = model.getEntryCurrentRowIndex(AGINGENTITY);
        DynamicObjectCollection entity = this.getModel().getEntryEntity(AGINGENTITY);
        int rowCount = entity.size();
        if (idx < 0 || idx >= rowCount) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u884c\u7684\u8303\u56f4\u8d85\u51fa\u5355\u636e\u4f53\u5927\u5c0f\u3002", (String)"AgingScheduleReportPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            this.rollbackValue(fieldKey, oldVal, idx);
            return;
        }
        String tagField = fieldKey.equals(OVERDUE_DAY) ? "" : "-";
        int rangeDay = Integer.parseInt(newVal.toString());
        if (rangeDay < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5929\u6570\u4e0d\u80fd\u4e3a\u8d1f\u6570\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"AgingScheduleReportPlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            this.rollbackValue(fieldKey, oldVal, idx);
            return;
        }
        if (rangeDay == 0) {
            model.setValue(updateFieldKey, (Object)"", idx);
            return;
        }
        if (idx > 0) {
            Integer preRowDay = (Integer)this.getModel().getValue(fieldKey, idx - 1);
            Integer nextRowDay = (Integer)this.getModel().getValue(fieldKey, idx + 1);
            if (preRowDay.compareTo(rangeDay) >= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u884c\u8bbe\u7f6e\u7684\u5929\u6570\u5e94\u5927\u4e8e\u4e0a\u4e00\u884c\u8bbe\u7f6e\u7684\u5929\u6570\u3002", (String)"AgingScheduleReportPlugin_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                this.rollbackValue(fieldKey, oldVal, idx);
                return;
            }
            if (nextRowDay != null && nextRowDay != 0 && nextRowDay.compareTo(rangeDay) <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u884c\u8bbe\u7f6e\u7684\u5929\u6570\u5e94\u5c0f\u4e8e\u4e0b\u4e00\u884c\u8bbe\u7f6e\u7684\u5929\u6570\u3002", (String)"AgingScheduleReportPlugin_10", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                this.rollbackValue(fieldKey, oldVal, idx);
                return;
            }
        }
        int curDays = fieldKey.equals(OVERDUE_DAY) ? 0 : -1;
        for (int i = 0; i < rowCount; ++i) {
            if (i == idx) {
                if (curDays + 1 == 0) {
                    model.setValue(updateFieldKey, (Object)String.format(RANGE3 + tagField + "%s", rangeDay), idx);
                } else {
                    model.setValue(updateFieldKey, (Object)String.format(tagField + RANGE4 + tagField + "%s", curDays + 1, rangeDay), idx);
                }
                int nextIdx = ++i;
                if (nextIdx >= rowCount) {
                    nextIdx = model.createNewEntryRow(AGINGENTITY);
                    model.setValue(updateFieldKey, (Object)ResManager.loadKDString((String)"%1$s%2$s - \u4e0d\u8bbe\u7f6e", (String)"AgingScheduleReportPlugin_13", (String)"fi-gl-formplugin", (Object[])new Object[]{tagField, rangeDay + 1}), nextIdx);
                    this.setAgingEntityEnable();
                    break;
                }
                DynamicObject nextRow = (DynamicObject)entity.get(nextIdx);
                int nextDays = nextRow.getInt(fieldKey);
                if (nextIdx <= rowCount - 2) {
                    model.setValue(updateFieldKey, (Object)String.format(tagField + RANGE4 + tagField + "%s", rangeDay + 1, nextDays), nextIdx);
                    break;
                }
                model.setValue(updateFieldKey, (Object)ResManager.loadKDString((String)"%1$s%2$s - \u4e0d\u8bbe\u7f6e", (String)"AgingScheduleReportPlugin_13", (String)"fi-gl-formplugin", (Object[])new Object[]{tagField, rangeDay + 1}), nextIdx);
                break;
            }
            DynamicObject row = (DynamicObject)entity.get(i);
            curDays = row.getInt(fieldKey);
        }
    }

    private void rollbackValue(String fieldKey, Object oldVal, int idx) {
        this.isPropertyChanged = false;
        if (oldVal == null) {
            oldVal = 0;
        }
        this.getModel().setValue(fieldKey, oldVal, idx);
        this.isPropertyChanged = true;
    }

    private void setAgingEntityEnable() {
        int rowCount = this.getModel().getEntryRowCount(AGINGENTITY);
        for (int i = 0; i < rowCount; ++i) {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{OVERDUE_AGE, UNDUE_AGE});
        }
    }

    @Override
    public void afterSetModelValue(DynamicObject scheme) {
        super.afterSetModelValue(scheme);
        this.getModel().setValue(BOOKEDDATE, scheme.get(BOOKEDDATE));
        this.getModel().setValue(EXPIREDATE, scheme.get(EXPIREDATE));
        this.setAgingEntityEnable();
    }

    private void setDefaultDate() {
        IDataModel model = this.getModel();
        DynamicObject period = (DynamicObject)model.getValue("startperiod");
        Date dtNow = TimeServiceHelper.now();
        model.setValue(EXPIREDATE, (Object)dtNow);
        if (period != null) {
            Date enddate = (Date)period.get("enddate");
            if (enddate.before(dtNow)) {
                model.setValue(BOOKEDDATE, (Object)enddate);
            } else {
                model.setValue(BOOKEDDATE, (Object)dtNow);
            }
        }
    }

    private void orgChangeEvent() {
        this.setDefaultDate();
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        boolean isSingleOrgManageMode = SingleOrgContextHelper.isSingleOrgManageMode();
        if (isSingleOrgManageMode) {
            return;
        }
        FilterInfo filterInfo = evt.getFilter();
        DynamicObjectCollection orgs = filterInfo.getDynamicObjectCollection("orgs");
        if (orgs == null || orgs.size() < 2) {
            return;
        }
        Long parentOrg = this.getParentOrg();
        String name = "";
        if (parentOrg != null && parentOrg != 0L) {
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)parentOrg, (String)"bos_org", (String)"name");
            name = org.getString("name");
        }
        evt.setFormatedFilterString(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7%1$s%2$s; %3$s", (String)"SubLedgerFormRpt_100", (String)"fi-gl-formplugin", (Object[])new Object[0]), "\uff1a", name, evt.getFormatedFilterString()));
    }

    @Override
    protected BasedataEdit getOrgEdit() {
        return (BasedataEdit)this.getControl("orgs");
    }

    @Override
    protected List<Long> getOrgValue() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
        return orgs.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    @Override
    protected void setDefaultOrg(Long orgId) {
        if (orgId == null || orgId == 0L) {
            this.getModel().setValue("orgs", null);
        } else {
            this.getModel().setValue("orgs", (Object)new Long[]{orgId});
        }
    }

    @Override
    protected List<Long> getFilterOrg(FilterInfo filterInfo) {
        List value;
        ArrayList<Long> result = new ArrayList<Long>();
        FilterItemInfo itemInfo = filterInfo.getFilterItem("orgs");
        if (itemInfo != null && (value = (List)itemInfo.getValue()) != null) {
            for (DynamicObject dyn : value) {
                result.add(dyn.getLong("id"));
            }
        }
        return result;
    }

    private void fillRangeToList(String ageVal, Integer dayVal, List<Integer> range) {
        String[] arr;
        if (dayVal != 0 && !StringUtils.isEmpty((String)ageVal) && (arr = ageVal.split(" - ")).length == 2) {
            String maxDay = arr[1];
            try {
                int day = Integer.parseInt(maxDay);
                range.add(Math.abs(day));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void exportAllToExcel() {
        TreeModel treeModel;
        List nodes;
        ReportQueryParam queryParam = this.getQueryParam();
        this.setQueryType(queryParam, 1);
        ReportList list = (ReportList)this.getControl(REPORT_LIST_AP);
        ReportTree reportTree = (ReportTree)this.getView().getControl("reporttreeap");
        DynamicObject[] accounts = new DynamicObject[]{};
        if (reportTree != null && !CollectionUtils.isEmpty((Collection)(nodes = (treeModel = reportTree.getReportModel().getTreeModel()).getNodes()))) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (TreeNode node : nodes) {
                if (!Objects.equals("0", node.getParentid())) continue;
                ids.add(Long.parseLong(node.getId()));
            }
            try {
                accounts = BusinessDataServiceHelper.load((Object[])ids.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (accounts.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u79d1\u76ee\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5bfc\u51fa\u6240\u6709\u3002", (String)"AgingScheduleReportPlugin_11", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        List columns = list.getReportModel().getColumns();
        ((ReportColumn)columns.get(1)).setHide(false);
        this.setHiddenColumn(columns, "accountid");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("gl_reportexportall");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("entitynumber", this.getView().getEntityId());
        showParameter.getCustomParams().put("entityname", this.getView().getFormShowParameter().getFormConfig().getCaption().toString());
        showParameter.getCustomParams().put("queryparam", SerializationUtils.serializeToBase64((Object)queryParam));
        showParameter.getCustomParams().put("selectobj", SerializationUtils.serializeToBase64((Object)accounts));
        this.getView().showForm(showParameter);
    }

    private void setQueryType(ReportQueryParam queryParam, int type) {
        FilterItemInfo queryType = queryParam.getFilter().getFilterItem(QUERY_TYPE);
        if (queryType == null) {
            queryParam.getFilter().addFilterItem(QUERY_TYPE, (Object)type);
        } else {
            queryType.setValue((Object)type);
        }
    }

    private void setHiddenColumn(List<AbstractReportColumn> columns, String ... columnKeys) {
        for (String columnKey : columnKeys) {
            for (AbstractReportColumn column : columns) {
                if (!(column instanceof ReportColumn) || !columnKey.equals(((ReportColumn)column).getFieldKey())) continue;
                ((ReportColumn)column).setHide(Boolean.TRUE.booleanValue());
            }
        }
    }
}

