/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.util.Tuple2;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.BeforeLoadDataEvent;
import kd.bos.print.core.plugin.event.BeforeOutputGridEvent;
import kd.bos.print.core.plugin.event.BeforeOutputWidgetEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.print.core.plugin.event.bo.PWGridCellBo;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.gl.report.ReportPrintHelper;

public class AssistActBalanceRptPrintNew
extends AbstractPrintPlugin {
    private static final String[] rowDataStringFieldKeys = new String[]{"fseq", "asstypename", "assvalnumber", "assvalname", "periodyear", "periodnumber", "currencyid.name", "accountid", "accountnumber", "measureunit.name"};
    private static final String[] rowDataAmountForFieldKeys = new String[]{"yearbeginfor", "periodbeginfor", "debitfor", "creditfor", "yeardebitfor", "yearcreditfor", "endfor"};
    private static final String[] rowDataAmountLocalFieldKeys = new String[]{"yearbegindebitlocal", "yearbegincreditlocal", "debitbeginlocal", "creditbeginlocal", "debitlocal", "creditlocal", "yeardebitlocal", "yearcreditlocal", "debitendlocal", "creditendlocal"};
    private static final String[] rowDataQtyFieldKeys = new String[]{"yearbeginqty", "periodbeginqty", "debitqty", "creditqty", "yeardebitqty", "yearcreditqty", "endqty"};
    private static final String[] headBaseDataFieldKeys = new String[]{"org", "orgview", "booktype", "periodtype", "startperiod", "endperiod", "accounttable", "currencyrpt"};
    private static final String[] headMulBaseDataFieldKeys = new String[]{"measureunits"};
    private static final String CURRENCY_HEAD = "currency";
    private static final String CURRENCY_LOCAL = "currencylocalid";
    private static final String CURRENCY_FOR = "currencyid";
    private static final String MEASUREUNITFIELD = "measureunit";
    private FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
    private static final String ACCOUNTBALANCE_PRINT_PAGEID_CACHE = "assistActBalanceRptPrintPageIdCache";
    private boolean showcomassist = false;
    private List<String> comAssistColFields;

    public void loadCustomData(CustomDataLoadEvent evt) {
        CustomDataSource dataSource = evt.getDataSource();
        String pageId = dataSource.getPageId();
        ReportListModel modelList = this.getListModel(pageId);
        if (modelList == null) {
            return;
        }
        ReportQueryParam param = modelList.getReportQueryParam();
        FilterInfo filterInfo = param.getFilter();
        if ("reporthead".equals(dataSource.getDsName())) {
            DynamicObjectType customDT = new DynamicObjectType();
            List field = dataSource.getQueryField();
            String[] headBaseDataFields = ReportPrintHelper.getExistFileds(field, headBaseDataFieldKeys);
            String[] headMulBaseDataFields = ReportPrintHelper.getExistFileds(field, headMulBaseDataFieldKeys);
            ReportPrintHelper.registerStringProperty(customDT, new String[][]{headBaseDataFields, headMulBaseDataFields});
            ReportPrintHelper.registerStringProperty(customDT, CURRENCY_HEAD);
            DataRowSet printRow = new DataRowSet();
            ReportPrintHelper.handleBaseDataFilterInfo(filterInfo, printRow, headBaseDataFields);
            ReportPrintHelper.handleMulBaseDataFilterInfo(filterInfo, printRow, headMulBaseDataFields);
            ReportPrintHelper.handleCurrencyNameById(filterInfo, printRow, CURRENCY_HEAD);
            List customDataRows = evt.getCustomDataRows();
            customDataRows.add(printRow);
        } else {
            int count = modelList.getRowCount();
            DynamicObjectCollection ds = modelList.getRowData(0, count);
            if (ds == null || ds.isEmpty()) {
                return;
            }
            List field = dataSource.getQueryField();
            if (Objects.nonNull(this.comAssistColFields)) {
                field.addAll(this.comAssistColFields);
            }
            DynamicObjectType customDt = new DynamicObjectType("reportlist");
            String[] rowDataStringFields = ReportPrintHelper.getExistFileds(field, rowDataStringFieldKeys);
            String[] rowDataAmountForFields = ReportPrintHelper.getExistFileds(field, rowDataAmountForFieldKeys);
            String[] rowDataAmountLocalFields = ReportPrintHelper.getExistFileds(field, rowDataAmountLocalFieldKeys);
            String[] rowDataQtyFields = ReportPrintHelper.getExistFileds(field, rowDataQtyFieldKeys);
            ReportPrintHelper.registerStringProperty(customDt, new String[][]{rowDataStringFields, rowDataAmountLocalFields, rowDataAmountForFields, rowDataQtyFields});
            boolean showqty = param.getFilter().getBoolean("showqty");
            String basecurrency = param.getFilter().getString(CURRENCY_HEAD);
            boolean noForAmount = "basecurrency".equals(basecurrency);
            List customDataRows = evt.getCustomDataRows();
            HashMap<String, Tuple2<String, String>> comAssistProp = new HashMap<String, Tuple2<String, String>>(2);
            for (DynamicObject rowData : ds) {
                DataRowSet printRow = new DataRowSet();
                ReportPrintHelper.handleStringFields(rowData, printRow, rowDataStringFields);
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_LOCAL, (boolean)Boolean.FALSE, rowDataAmountLocalFields);
                if (noForAmount) {
                    if (field.contains("currencyid.name")) {
                        printRow.add("currencyid.name", (Field)new TextField(""));
                    }
                } else {
                    ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_FOR, (boolean)Boolean.FALSE, rowDataAmountForFields);
                }
                if (showqty) {
                    ReportPrintHelper.handleQtyFields(rowData, printRow, (boolean)Boolean.FALSE, MEASUREUNITFIELD, this.fobj, rowDataQtyFields);
                }
                this.comAssistFieldHandler(printRow, rowData, comAssistProp);
                customDataRows.add(printRow);
            }
        }
    }

    public void beforeOutputWidget(BeforeOutputWidgetEvent e) {
        super.beforeOutputWidget(e);
        if (e.getWidgetKey().equals("DataGrid")) {
            String pageId = (String)ThreadCache.get((Object)ACCOUNTBALANCE_PRINT_PAGEID_CACHE);
            if (this.showcomassist) {
                this.createComAssistColumns((BeforeOutputGridEvent)e, pageId);
            }
        }
    }

    private void createComAssistColumns(BeforeOutputGridEvent e, String pageId) {
        ReportListModel model = this.getListModel(pageId);
        if (model == null) {
            return;
        }
        int rowCount = model.getRowCount();
        DynamicObjectCollection rows = model.getRowData(0, rowCount);
        this.addComAssistFieldPropertys(rows);
        List columns = model.getColumns();
        HashMap<String, String> colFieldAndNameMap = new HashMap<String, String>(1);
        ArrayList<String> assgrpFields = new ArrayList<String>(2);
        for (AbstractReportColumn column : columns) {
            ReportColumn reportColumn;
            if (!(column instanceof ReportColumn) || !(reportColumn = (ReportColumn)column).getFieldKey().startsWith("comassist") || !"basedata".equals(reportColumn.getFieldType())) continue;
            assgrpFields.add(reportColumn.getFieldKey());
            colFieldAndNameMap.put(reportColumn.getFieldKey(), reportColumn.getCaption().getLocaleValue());
        }
        int curColIndex = 10;
        int totalWidth = e.getRightSpace();
        int width = totalWidth / assgrpFields.size();
        for (String assgrpField : assgrpFields) {
            String itemName = (String)colFieldAndNameMap.get(assgrpField);
            this.createDynamicColumn(e, curColIndex, assgrpField, itemName, width);
            ++curColIndex;
        }
    }

    private void addComAssistFieldPropertys(DynamicObjectCollection ds) {
        this.comAssistColFields = new ArrayList<String>(2);
        DataEntityPropertyCollection propertyCollection = ds.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : propertyCollection) {
            String fieldKey = property.getName();
            if (!fieldKey.startsWith("comassist") || !(property instanceof BasedataProp)) continue;
            this.comAssistColFields.add(fieldKey);
        }
    }

    private void createDynamicColumn(BeforeOutputGridEvent e, int colIndex, String assgrpField, String colTitle, int width) {
        List pwGridCellBos = e.insertColumn(colIndex, width);
        int i = 0;
        for (PWGridCellBo po : pwGridCellBos) {
            if (i == 0) {
                po.setCellValue(colTitle);
            }
            if (i == 2) {
                po.setCellValue("reportlist", assgrpField);
            }
            ++i;
        }
        MergeBlock mb = MergeBlock.create((int)colIndex, (int)colIndex, (int)0, (int)1);
        e.addMerge(mb);
    }

    private void comAssistFieldHandler(DataRowSet printRow, DynamicObject row, Map<String, Tuple2<String, String>> flexProp) {
        if (this.comAssistColFields != null) {
            for (String field : this.comAssistColFields) {
                DynamicObject assgrp = row.getDynamicObject(field);
                if (assgrp == null) continue;
                Tuple2 tuple2 = flexProp.get(field);
                if (tuple2 == null) {
                    BasedataEntityType entityType = (BasedataEntityType)assgrp.getDataEntityType();
                    String name = entityType.getNameProperty();
                    String number = entityType.getNumberProperty();
                    tuple2 = new Tuple2((Object)name, (Object)number);
                    flexProp.put(field, (Tuple2<String, String>)tuple2);
                }
                printRow.add(field, (Field)new TextField(assgrp.getString((String)tuple2.t1)));
            }
        }
    }

    public void beforeLoadData(BeforeLoadDataEvent evt) {
        super.beforeLoadData(evt);
        PrtDataSource dataSource = evt.getDataSource();
        if (dataSource instanceof MainDataSource) {
            String pageId = ((MainDataSource)dataSource).getPageId();
            ReportListModel listModel = this.getListModel(pageId);
            if (listModel == null) {
                return;
            }
            ThreadCache.put((Object)ACCOUNTBALANCE_PRINT_PAGEID_CACHE, (Object)pageId);
            FilterInfo filterInfo = listModel.getReportQueryParam().getFilter();
            this.showcomassist = filterInfo.getBoolean("showcomassist");
        }
    }

    private ReportListModel getListModel(String pageId) {
        ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            return null;
        }
        ReportList list = view.getReportList();
        ReportListModel listModel = (ReportListModel)list.getReportModel();
        return listModel;
    }
}

