/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.gl.report.ReportPrintHelper;

public class AssistBalanceRptAssgrpPagingPrint
extends AbstractPrintPlugin {
    private static final String CURRENCYLOCALID = "currencylocalid";
    private static final String CURRENCYID = "currencyid";
    private static final String MEASUREUNIT = "measureunit";
    private static final String NAME = "name";
    private FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
    private static final String[] headBaseDataFieldKeys = new String[]{"orgview", "booktype", "periodtype", "startperiod", "endperiod", "accounttable", "currencyrpt"};
    private static final String[] headMulBaseDataFieldKeys = new String[]{"measureunits"};
    private static final String CURRENCY_HEAD = "currency";
    private static final String PARENT_ORG = "parentorg";
    private static final String pageHeadCacheKey = "AssistBalanceRptPrintPageHeadCacheKey";
    private static final String rowDataCacheKey = "AssistBalanceRptPrintRowDatas";
    private static final String[] headFieldKeys = new String[]{"id", "assist"};

    public void loadCustomData(CustomDataLoadEvent evt) {
        super.loadCustomData(evt);
        CustomDataSource dataSource = evt.getDataSource();
        String pageId = dataSource.getPageId();
        ReportListModel listModel = this.getListModel(pageId);
        if (listModel == null) {
            return;
        }
        ReportQueryParam param = listModel.getReportQueryParam();
        if ("reporthead".equals(dataSource.getDsName())) {
            FilterInfo filterInfo = param.getFilter();
            List queryField = dataSource.getQueryField();
            List printRows = evt.getCustomDataRows();
            DataRowSet printRow = new DataRowSet();
            Map pageHeadAccAndAss = (Map)ThreadCache.get((Object)pageHeadCacheKey);
            String assist = ResManager.loadKDString((String)"\u5f85\u5206\u7c7b", (String)"AssistBalanceRptAssgrpPagingPrint_0", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            String pkId = dataSource.getPkId().toString();
            if (pkId != null && pkId.trim().length() > 0) {
                assist = (String)pageHeadAccAndAss.get(Integer.parseInt(pkId));
            }
            printRow.add(headFieldKeys[1], (Field)new TextField(assist));
            String[] headBaseDataFields = ReportPrintHelper.getExistFileds(queryField, headBaseDataFieldKeys);
            String[] headMulBaseDataFields = ReportPrintHelper.getExistFileds(queryField, headMulBaseDataFieldKeys);
            ReportPrintHelper.handleBaseDataFilterInfo(filterInfo, printRow, headBaseDataFields);
            ReportPrintHelper.handleMulBaseDataFilterInfo(filterInfo, printRow, headMulBaseDataFields);
            ReportPrintHelper.handleCurrencyNameById(filterInfo, printRow, CURRENCY_HEAD);
            ReportPrintHelper.handleMulCur(filterInfo, printRow, queryField);
            this.getParentOrgName(filterInfo, printRow, PARENT_ORG);
            printRows.add(printRow);
        } else if ("reportlistap".equals(dataSource.getDsName())) {
            DynamicObject curDyn;
            int length;
            String dataIndexs;
            String[] indexStr;
            int startIndex;
            DynamicObjectCollection ds;
            Map rowDatasMap = (Map)ThreadCache.get((Object)rowDataCacheKey);
            if (rowDatasMap == null || rowDatasMap.isEmpty()) {
                return;
            }
            String pkId = dataSource.getPkId().toString();
            int index = 1;
            if (pkId != null && pkId.trim().length() > 0) {
                index = Integer.parseInt(pkId);
            }
            if ((ds = listModel.getRowData(startIndex = Integer.parseInt((indexStr = (dataIndexs = (String)rowDatasMap.get(index)).split("-"))[0]), length = Integer.parseInt(indexStr[1]) - startIndex)) == null || ds.isEmpty()) {
                return;
            }
            DynamicObjectType customDt = new DynamicObjectType("reportlist");
            List<String> commonColFields = this.getCommonFields(customDt);
            boolean showqty = param.getFilter().getBoolean("showqty");
            List<String> amountTypes = this.getAmountTypes(ds.getDynamicObjectType().getProperties());
            List<String> amountColFields = this.getAmountFields(amountTypes, customDt, showqty);
            Map<String, String> typeAndCurrencyField = this.getCurrencyField();
            List queryField = dataSource.getQueryField();
            String curStr = param.getFilter().getString(CURRENCY_HEAD);
            String curFor = "";
            if (!"allcurrency".equals(curStr) && !"basecurrency".equals(curStr) && (curDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(curStr), (String)"bd_currency")) != null) {
                curFor = curDyn.getString(NAME);
            }
            List customDataRows = evt.getCustomDataRows();
            int seq = 1;
            for (DynamicObject row : ds) {
                DataRowSet printRow = new DataRowSet();
                this.commonFieldHandler(printRow, row, commonColFields, seq++);
                this.currencyHandler(printRow, row, param, curFor);
                this.amountFieldHandler(printRow, row, amountColFields, amountTypes, typeAndCurrencyField, param);
                if (showqty) {
                    this.qtyFieldHandler(printRow, row, amountColFields);
                }
                customDataRows.add(printRow);
            }
        }
    }

    public void afterLoadData(AfterLoadDataEvent evt) {
        super.afterLoadData(evt);
        PrtDataSource dataSource = evt.getDataSource();
        if (dataSource instanceof MainDataSource) {
            String pageId = ((MainDataSource)dataSource).getPageId();
            ReportListModel listModel = this.getListModel(pageId);
            if (listModel == null) {
                return;
            }
            Map<String, String> keyToCaption = this.getKeyToCaption(listModel);
            DynamicObjectCollection rowDatas = listModel.getRowData(0, listModel.getRowCount());
            if (rowDatas == null || rowDatas.isEmpty()) {
                return;
            }
            HashMap<Integer, String> rowIndexsByPage = new HashMap<Integer, String>(1);
            HashMap<Integer, String> pageToaccAndass = new HashMap<Integer, String>(1);
            String tempStr = "";
            int key = 1;
            ArrayList<DataRowSet> dataRows = new ArrayList<DataRowSet>(1);
            for (DynamicObject rowData : rowDatas) {
                String assistVal = this.getAssistVal(keyToCaption, rowData);
                if (StringUtils.isBlank((CharSequence)assistVal)) continue;
                int rowNo = rowData.getInt("fseq");
                if (assistVal.equalsIgnoreCase(tempStr)) continue;
                if (rowIndexsByPage.get(key) == null && key != rowNo) {
                    rowIndexsByPage.put(key, key - 1 + "-" + (rowNo - 1));
                }
                DataRowSet dsRow = new DataRowSet();
                tempStr = assistVal;
                key = rowNo;
                pageToaccAndass.put(key, assistVal);
                dsRow.add(headFieldKeys[0], (Field)new TextField(rowNo + ""));
                dataRows.add(dsRow);
            }
            evt.setDataRowSets(dataRows);
            if (rowDatas.size() > 0) {
                rowIndexsByPage.put(key, key - 1 + "-" + (rowDatas.size() - 1));
            }
            ThreadCache.put((Object)rowDataCacheKey, rowIndexsByPage);
            ThreadCache.put((Object)pageHeadCacheKey, pageToaccAndass);
        }
    }

    private Map<String, String> getKeyToCaption(ReportListModel listModel) {
        List listColumns = listModel.getColumns();
        HashMap<String, String> keyToCaption = new HashMap<String, String>(listColumns.size());
        for (AbstractReportColumn listColumn : listColumns) {
            ReportColumn column;
            String key;
            if (!(listColumn instanceof ReportColumn) || !(key = (column = (ReportColumn)listColumn).getFieldKey()).startsWith("assval")) continue;
            if (key.contains(NAME)) {
                key = key.replace(NAME, "");
            }
            String caption = column.getCaption().getLocaleValue();
            keyToCaption.put(key, caption);
        }
        return keyToCaption;
    }

    private String getAssistVal(Map<String, String> keyToCaption, DynamicObject rowData) {
        ArrayList<String> allAssistVal = new ArrayList<String>(keyToCaption.size());
        for (Map.Entry<String, String> entry : keyToCaption.entrySet()) {
            StringBuilder sb = new StringBuilder(entry.getValue()).append("\uff1a");
            Object assistObj = rowData.get(entry.getKey());
            if (null != assistObj && assistObj instanceof DynamicObject) {
                DynamicObject assistDyn = (DynamicObject)assistObj;
                Set fullIndexFields = assistDyn.getDataEntityType().getFullIndexFields();
                for (String field : fullIndexFields) {
                    sb.append(assistDyn.getString(field)).append(" ");
                }
                allAssistVal.add(sb.toString());
                continue;
            }
            if (null == assistObj || !StringUtils.isNotEmpty((CharSequence)rowData.getString("number"))) continue;
            sb.append(assistObj.toString());
            allAssistVal.add(sb.toString());
        }
        return String.join((CharSequence)"\uff1b", allAssistVal);
    }

    private void getParentOrgName(FilterInfo filterInfo, DataRowSet printRow, String parentOrg) {
        Object parentOrgId = filterInfo.getCommFilter("parentOrg").getValue();
        String orgName = (String)ThreadCache.get((Object)("AccBalanceRptPrint-getParentOrg-" + parentOrgId), () -> {
            QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(parentOrgId.toString()));
            DynamicObject orgDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)NAME, (QFilter[])idFilter.toArray());
            if (orgDyn != null) {
                return orgDyn.getString(NAME);
            }
            return "";
        });
        printRow.add(parentOrg, (Field)new TextField(orgName));
    }

    public void currencyHandler(DataRowSet printRow, DynamicObject row, ReportQueryParam param, String currencyFor) {
        String curStr = param.getFilter().getString(CURRENCY_HEAD);
        String curName = "";
        if ("allcurrency".equals(curStr)) {
            DynamicObject curDyn = row.getDynamicObject(CURRENCYID);
            if (curDyn != null) {
                curName = curDyn.getString(NAME);
            }
        } else if ("basecurrency".equals(curStr)) {
            DynamicObject curDyn = row.getDynamicObject(CURRENCYLOCALID);
            if (curDyn != null) {
                curName = curDyn.getString(NAME);
            }
        } else {
            curName = currencyFor;
        }
        printRow.add(CURRENCYID, (Field)new TextField(curName));
    }

    private void commonFieldHandler(DataRowSet printRow, DynamicObject row, List<String> commonColFields, int seq) {
        for (String field : commonColFields) {
            if ("fseq".equals(field)) {
                printRow.add(field, (Field)new TextField(seq + ""));
                continue;
            }
            printRow.add(field, (Field)new TextField(row.getString(field)));
        }
    }

    private void amountFieldHandler(DataRowSet printRow, DynamicObject row, List<String> amountColFields, List<String> amountTypes, Map<String, String> typeAndCurrencyField, ReportQueryParam param) {
        for (String amountType : amountTypes) {
            String curField = typeAndCurrencyField.get(amountType);
            DynamicObject curDyn = row.getDynamicObject(curField);
            if (curDyn == null) continue;
            int amtprecision = curDyn.getInt("amtprecision");
            String signStr = curDyn.getString("sign") == null ? "" : curDyn.getString("sign");
            this.fobj.getCurrencyFormat().setCurrencySymbols(signStr);
            this.fobj.getCurrencyFormat().setMinimumFractionDigits(amtprecision);
            Format format = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(this.fobj);
            for (String field : amountColFields) {
                BigDecimal amount = row.getBigDecimal(field + amountType);
                if (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                printRow.add(field + amountType, (Field)new TextField(format.format(amount)));
            }
        }
    }

    private void qtyFieldHandler(DataRowSet printRow, DynamicObject row, List<String> amountColFields) {
        DynamicObject measureunit = row.getDynamicObject(MEASUREUNIT);
        int precision = 0;
        if (measureunit != null) {
            printRow.add(MEASUREUNIT, (Field)new TextField(measureunit.getString(NAME)));
            precision = measureunit.getInt("precision");
        }
        for (String field : amountColFields) {
            BigDecimal qtyBigDecimal = row.getBigDecimal(field + "qty");
            if ((qtyBigDecimal = qtyBigDecimal.setScale(precision)).compareTo(BigDecimal.ZERO) == 0) continue;
            printRow.add(field + "qty", (Field)new TextField(qtyBigDecimal + ""));
        }
    }

    private List<String> getCommonFields(DynamicObjectType customDt) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("fseq");
        fields.add("number");
        fields.add(NAME);
        for (String field : fields) {
            customDt.registerProperty(field, String.class, (Object)"", false);
        }
        return fields;
    }

    private Map<String, String> getCurrencyField() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("for", "curfor");
        map.put("rpt", "currencyrptid");
        map.put("local", CURRENCYLOCALID);
        return map;
    }

    private List<String> getAmountFields(List<String> amountTypes, DynamicObjectType customDt, boolean showqty) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("begindebit");
        fields.add("begincredit");
        fields.add("debit");
        fields.add("credit");
        fields.add("yeardebit");
        fields.add("yearcredit");
        fields.add("enddebit");
        fields.add("endcredit");
        customDt.registerProperty(CURRENCYID, String.class, (Object)"", false);
        for (String field : fields) {
            for (String amountType : amountTypes) {
                customDt.registerProperty(field + amountType, String.class, (Object)"", false);
            }
            if (!showqty) continue;
            customDt.registerProperty(field + "qty", String.class, (Object)"", false);
        }
        if (showqty) {
            customDt.registerProperty(MEASUREUNIT, String.class, (Object)"", false);
        }
        return fields;
    }

    private List<String> getAmountTypes(DataEntityPropertyCollection propertys) {
        ArrayList<String> fields = new ArrayList<String>();
        if (propertys.containsKey((Object)"begindebitlocal")) {
            fields.add("local");
        }
        if (propertys.containsKey((Object)"begindebitfor")) {
            fields.add("for");
        }
        if (propertys.containsKey((Object)"begindebitrpt")) {
            fields.add("rpt");
        }
        return fields;
    }

    private ReportListModel getListModel(String pageId) {
        ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            return null;
        }
        ReportList list = view.getReportList();
        ReportListModel listModel = (ReportListModel)list.getReportModel();
        return listModel;
    }
}

