/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.enums.AssistShowType;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.report.AssistTxtFilterPlugin;
import kd.fi.gl.vo.AssistTreeStyleVO;

public class AssistLevelFilterPlugin
extends AssistTxtFilterPlugin {
    private static final String CACHE_KEY = "AssistRptTxtFilterPlugin_param";
    private static Log logger = LogFactory.getLog(AssistLevelFilterPlugin.class);
    private static final List<String> specialEntity = new ArrayList<String>(2);

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"asstlevel"});
    }

    public void setTreeReportList(TreeReportListEvent event) {
        if ("gl_rpt_assistbalance".equals(this.getView().getFormShowParameter().getFormId())) {
            super.setTreeReportList(event);
        }
    }

    @Override
    protected void setVisibleAssistEntry() {
        super.setVisibleAssistEntry();
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        int size = model.getEntryRowCount("entryentity");
        boolean isMulTree = false;
        boolean isLevel = false;
        for (int i = 0; i < size; ++i) {
            DynamicObject valueSource;
            String sourceNumber;
            DynamicObject fieldNameDyn = (DynamicObject)model.getValue("fieldname", i);
            if (fieldNameDyn == null) {
                view.setEnable(Boolean.valueOf(false), i, new String[]{"groupstandard", "asstlevel"});
                continue;
            }
            boolean isBase = "1".equals(fieldNameDyn.getString("valuetype"));
            if (isBase && grpEntity.contains(sourceNumber = (valueSource = fieldNameDyn.getDynamicObject("valuesource")).getString("number"))) {
                isMulTree = true;
                view.setEnable(Boolean.valueOf(true), i, new String[]{"groupstandard"});
            }
            if ("3".equals(model.getValue("showtype", i))) {
                isLevel = true;
                view.setEnable(Boolean.valueOf(true), i, new String[]{"asstlevel"});
                continue;
            }
            model.setValue("asstlevel", (Object)0, i);
            view.setEnable(Boolean.valueOf(false), i, new String[]{"asstlevel"});
        }
        view.setVisible(Boolean.valueOf(isMulTree), new String[]{"groupstandard"});
        view.setVisible(Boolean.valueOf(isLevel), new String[]{"asstlevel"});
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        ChangeData data = e.getChangeSet()[0];
        String propertyName = e.getProperty().getName();
        Object newValue = data.getNewValue();
        int seq = data.getRowIndex();
        switch (propertyName) {
            case "fieldname": {
                model.setValue("value", null, seq);
                model.setValue("textinput", null, seq);
                if (newValue == null) {
                    model.setValue("groupstandard", null, seq);
                    model.setValue("showtype", (Object)"1", seq);
                    model.setValue("asstlevel", (Object)0, seq);
                    view.setEnable(Boolean.valueOf(false), new String[]{"asstlevel", "textinput", "showtype"});
                    return;
                }
                model.setValue("groupstandard", null, seq);
                String entityId = this.getEntityId(seq);
                view.setEnable(Boolean.valueOf(entityId == null), seq, new String[]{"textinput"});
                if (this.isGroupOrTreeEntity(entityId)) {
                    view.setEnable(Boolean.valueOf(true), seq, new String[]{"showtype"});
                } else {
                    model.setValue("showtype", (Object)"1", seq);
                    view.setEnable(Boolean.valueOf(false), seq, new String[]{"showtype"});
                }
                this.setVisibleAssistEntry();
                break;
            }
            case "showtype": {
                if ("2".equals(newValue) || "3".equals(newValue)) {
                    this.clearAsstLevel(seq);
                }
                this.setVisibleAssistEntry();
                break;
            }
        }
    }

    private void clearAsstLevel(int indexRow) {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount("entryentity");
        for (int i = 0; i < count; ++i) {
            if (indexRow == i) continue;
            model.setValue("showtype", (Object)"1", i);
        }
    }

    private boolean isGroupOrTreeEntity(String entityId) {
        if (entityId == null) {
            return false;
        }
        if (grpEntity.contains(entityId)) {
            return true;
        }
        if (specialEntity.contains(entityId)) {
            return true;
        }
        return this.isTreeEntity(entityId);
    }

    private boolean isTreeEntity(String entityId) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        DynamicProperty parent = mainEntityType.getProperty("parent");
        DynamicProperty isleaf = mainEntityType.getProperty("isleaf");
        DynamicProperty level = mainEntityType.getProperty("level");
        return this.isExist(parent) && this.isExist(isleaf) && this.isExist(level);
    }

    private boolean isExist(DynamicProperty property) {
        return property != null && !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)property.getAlias());
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        DynamicObject valuesource;
        String entityNumber;
        MainEntityType type;
        super.getEntityType(e);
        try {
            type = e.getNewEntityType() == null ? (MainEntityType)e.getOriginalEntityType().clone() : e.getNewEntityType();
        }
        catch (CloneNotSupportedException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new KDBizException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
        EntryProp entry = (EntryProp)type.getProperty("entryentity");
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("entryentity");
        DynamicObject fieldNameDyn = (DynamicObject)model.getValue("fieldname", rowIndex);
        if (fieldNameDyn == null) {
            return;
        }
        String valuetype = fieldNameDyn.getString("valuetype");
        if ("1".equals(valuetype) && grpEntity.contains(entityNumber = (valuesource = fieldNameDyn.getDynamicObject("valuesource")).getString("id"))) {
            String formId = entityNumber + "groupstandard";
            BasedataProp prop = (BasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty("groupstandard");
            prop.setBaseEntityId(formId);
            prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)formId));
        }
        e.setNewEntityType(type);
    }

    private String getEntityId(int index) {
        MainEntityType type = this.getModel().getDataEntityType();
        EntryProp entry = (EntryProp)type.getProperty("entryentity");
        IDataModel model = this.getModel();
        DynamicObject fieldNameDyn = (DynamicObject)model.getValue("fieldname", index);
        if (fieldNameDyn == null) {
            return null;
        }
        String valuetype = fieldNameDyn.getString("valuetype");
        String entityNumber = null;
        if (AssistValueType.isBaseData((String)valuetype)) {
            DynamicObject valuesource = fieldNameDyn.getDynamicObject("valuesource");
            entityNumber = valuesource.getString("id");
            if (grpEntity.contains(entityNumber)) {
                String formId = entityNumber + "groupstandard";
                BasedataProp prop = (BasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty("groupstandard");
                prop.setBaseEntityId(formId);
                prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)formId));
                QFilter fispreset = new QFilter("ispreset", "=", (Object)Character.valueOf('1'));
                QFilter fstatus = new QFilter("status", "=", (Object)Character.valueOf('C'));
                DynamicObject defaultSet = QueryServiceHelper.queryOne((String)formId, (String)"id", (QFilter[])new QFilter[]{fispreset, fstatus});
                long defaultId = defaultSet == null ? 0L : defaultSet.getLong("id");
                model.setValue("groupstandard", (Object)defaultId, index);
            }
        } else if (AssistValueType.isAssistData((String)valuetype)) {
            entityNumber = "bos_assistantdata_detail";
        }
        return entityNumber;
    }

    @Override
    protected String[] getFields() {
        return new String[]{"groupstandard", "showtype", "asstlevel", "textinput"};
    }

    @Override
    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        Optional<AssistTreeStyleVO> styleVO = this.getAssistTreeStyleInfo();
        Map customParam = queryParam.getCustomParam();
        customParam.put(CACHE_KEY, styleVO.isPresent() ? SerializationUtils.toJsonString((Object)styleVO.get()) : "");
    }

    public Optional<AssistTreeStyleVO> getAssistTreeStyleInfo() {
        IDataModel model = this.getModel();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        for (int idx = 0; idx < selectRows.length; ++idx) {
            String entityId;
            DynamicObject valuesource;
            DynamicObject assisType;
            boolean isShowUp;
            int i = selectRows[idx];
            AssistShowType showType = AssistShowType.valueOf((int)Integer.parseInt((String)model.getValue("showtype", i)));
            int assistLevel = (Integer)model.getValue("asstlevel", i);
            boolean bl = isShowUp = showType == AssistShowType.FollowLevel || showType == AssistShowType.SpecificLevel && assistLevel != 0;
            if (!isShowUp || (assisType = (DynamicObject)model.getValue("fieldname", i)) == null) continue;
            String valuetype = assisType.getString("valuetype");
            if (AssistValueType.isBaseData((String)valuetype)) {
                valuesource = assisType.getDynamicObject("valuesource");
                if (valuesource == null) continue;
                entityId = valuesource.getString("id");
            } else {
                if (!AssistValueType.isAssistData((String)valuetype) || (valuesource = assisType.getDynamicObject("assistanttype")) == null) continue;
                entityId = "bos_assistantdata_detail";
            }
            AssistTreeStyleVO styleVO = new AssistTreeStyleVO();
            if (grpEntity.contains(entityId)) {
                Long value = (Long)model.getValue("groupstandard_id", i);
                if (value == 0L) continue;
                styleVO.setCategory(value);
            }
            styleVO.setShowType(showType.getValue());
            styleVO.setEntityId(entityId);
            styleVO.setAssistProp(assisType.getString("flexfield"));
            styleVO.setSpecificLevel(assistLevel);
            return Optional.of(styleVO);
        }
        return Optional.empty();
    }

    @Override
    public void loadOtherEntryFilter(DynamicObject scheme) {
        IDataModel model = this.getModel();
        MainEntityType type = model.getDataEntityType();
        EntryProp entryProp = (EntryProp)type.getProperty("entryentity");
        ReportQueryParam queryParam = ((ReportShowParameter)this.getView().getFormShowParameter()).getReportQueryParam();
        String firstHyperQuery = this.getPageCache().get("firstHyperQuery");
        if (queryParam != null && !Objects.equals(firstHyperQuery, "true")) {
            FilterInfo filter = queryParam.getFilter();
            List flexFilterItems = filter.getFlexFilterItems();
            HashSet<String> flexFields = new HashSet<String>(flexFilterItems.size());
            for (FilterItemInfo item : flexFilterItems) {
                String flex = item.getPropName();
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)flex)) continue;
                flexFields.add(flex);
            }
            Map asstTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (QFilter[])new QFilter[]{new QFilter("flexfield", "in", flexFields)});
            HashMap<String, DynamicObject> flexFieldAndAssMap = new HashMap<String, DynamicObject>(asstTypeMap.size());
            for (DynamicObject assType : asstTypeMap.values()) {
                flexFieldAndAssMap.put(assType.getString("flexfield"), assType);
            }
            model.deleteEntryData("entryentity");
            for (FilterItemInfo item : flexFilterItems) {
                DynamicObject asstType;
                String flex = item.getPropName();
                if (StringUtils.isEmpty((String)flex) || (asstType = (DynamicObject)flexFieldAndAssMap.get(flex)) == null) continue;
                String entityNumber = null;
                String valueType = asstType.getString("valuetype");
                if (AssistValueType.isAssistData((String)valueType)) {
                    entityNumber = "bos_assistantdata_detail";
                } else if (AssistValueType.isBaseData((String)valueType)) {
                    DynamicObject valueSource = asstType.getDynamicObject("valuesource");
                    if (valueSource == null) continue;
                    entityNumber = valueSource.getString("id");
                }
                int rowIndex = model.createNewEntryRow("entryentity");
                model.setValue("fieldname", asstType.getPkValue(), rowIndex);
                if (entityNumber != null) {
                    MulBasedataProp prop = (MulBasedataProp)entryProp.getDynamicCollectionItemPropertyType().getProperty("value");
                    prop.setBaseEntityId(entityNumber);
                    BasedataProp baseProp = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
                    baseProp.setBaseEntityId(entityNumber);
                    baseProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber));
                    if (!(item.getValue() instanceof Set)) continue;
                    Set pkSet = (Set)item.getValue();
                    model.setValue("value", (Object)pkSet.toArray(new Object[0]), rowIndex);
                    continue;
                }
                model.setValue("textinput", item.getValue(), rowIndex);
            }
            this.getPageCache().put("firstHyperQuery", "true");
        } else {
            DynamicObjectCollection entryEntity = scheme.getDynamicObjectCollection("entryentity");
            int count = model.getEntryRowCount("entryentity");
            String[] fields = this.getFields();
            for (int i = 0; i < entryEntity.size(); ++i) {
                if (i >= count) {
                    model.createNewEntryRow("entryentity");
                }
                DynamicObject dyn = (DynamicObject)entryEntity.get(i);
                for (String field : fields) {
                    if (field.equals("groupstandard")) {
                        DynamicObject valuesource;
                        DynamicObject fieldNameDyn = (DynamicObject)model.getValue("fieldname", i);
                        if (fieldNameDyn != null && (valuesource = fieldNameDyn.getDynamicObject("valuesource")) != null && grpEntity.contains(valuesource.getString("id"))) {
                            String formId = valuesource.getString("id") + "groupstandard";
                            BasedataProp prop = (BasedataProp)entryProp.getDynamicCollectionItemPropertyType().getProperty("groupstandard");
                            prop.setBaseEntityId(formId);
                            prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)formId));
                            Object val = dyn.get(field + "_id");
                            model.setValue("groupstandard", val, i);
                            continue;
                        }
                        model.setValue("groupstandard", null, i);
                        continue;
                    }
                    Object val = dyn.get(field);
                    model.setValue(field, val, i);
                }
            }
        }
        int count = model.getEntryRowCount("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] rows = IntStream.range(0, count).toArray();
        entryGrid.selectRows(rows, 0);
    }

    static {
        specialEntity.add("bos_org");
        specialEntity.add("bos_adminorg");
    }
}

