/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.report.AssistRptFilterPlugin;

public class AssistTxtFilterPlugin
extends AssistRptFilterPlugin {
    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"value", "textinput"});
        this.setVisibleAssistEntry();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "removebtn": {
                this.setVisibleAssistEntry();
            }
        }
    }

    @Override
    protected String[] getAssistValueType() {
        return new String[]{"1", "2", "3"};
    }

    @Override
    protected void setAssistTxtValue(IDataModel model, int i, FilterItemInfo item) {
        String value = (String)model.getValue("textinput", i);
        if (StringUtils.isEmpty((CharSequence)value.trim())) {
            item.setValue(new HashSet(0));
            return;
        }
        HashSet<String> idList = new HashSet<String>();
        idList.add(value.trim());
        item.setValue(idList);
    }

    protected void setVisibleAssistEntry() {
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        int size = model.getEntryRowCount("entryentity");
        boolean hasMal = false;
        for (int i = 0; i < size; ++i) {
            DynamicObject fieldNameDyn = (DynamicObject)model.getValue("fieldname", i);
            if (fieldNameDyn == null) continue;
            boolean isMal = "3".equals(fieldNameDyn.getString("valuetype"));
            if (isMal) {
                hasMal = true;
            }
            view.setEnable(Boolean.valueOf(isMal), i, new String[]{"textinput"});
            view.setEnable(Boolean.valueOf(!isMal), i, new String[]{"value"});
        }
        view.setVisible(Boolean.valueOf(hasMal), new String[]{"textinput"});
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        switch (propertyName = e.getProperty().getName()) {
            case "fieldname": {
                model.setValue("textinput", null, e.getChangeSet()[0].getRowIndex());
                this.setVisibleAssistEntry();
            }
        }
    }

    protected String[] getFields() {
        return new String[]{"textinput"};
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        HashMap<String, List> others = new HashMap<String, List>();
        IDataModel model = this.getModel();
        String[] str = this.getFields();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        for (DynamicObject dyn : entryEntity) {
            for (String field : str) {
                Object val = dyn.get(field);
                others.computeIfAbsent(field, k -> new ArrayList()).add(val);
            }
        }
        filterInfo.setOtherEntryFilter(others);
    }

    @Override
    public void loadOtherEntryFilter(DynamicObject scheme) {
        IDataModel model = this.getModel();
        MainEntityType type = model.getDataEntityType();
        EntryProp entryProp = (EntryProp)type.getProperty("entryentity");
        ReportQueryParam queryParam = ((ReportShowParameter)this.getView().getFormShowParameter()).getReportQueryParam();
        String firstHyperQuery = this.getPageCache().get("firstHyperQuery");
        if (queryParam != null && !Objects.equals(firstHyperQuery, "true")) {
            FilterInfo filter = queryParam.getFilter();
            List flexFilterItems = filter.getFlexFilterItems();
            HashSet<String> flexFields = new HashSet<String>(flexFilterItems.size());
            for (FilterItemInfo item : flexFilterItems) {
                String flex = item.getPropName();
                if (StringUtils.isEmpty((CharSequence)flex)) continue;
                flexFields.add(flex);
            }
            Map asstTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (QFilter[])new QFilter[]{new QFilter("flexfield", "in", flexFields)});
            HashMap<String, DynamicObject> flexFieldAndAssMap = new HashMap<String, DynamicObject>(asstTypeMap.size());
            for (DynamicObject assType : asstTypeMap.values()) {
                flexFieldAndAssMap.put(assType.getString("flexfield"), assType);
            }
            model.deleteEntryData("entryentity");
            for (FilterItemInfo item : flexFilterItems) {
                DynamicObject asstType;
                String flex = item.getPropName();
                if (kd.bos.util.StringUtils.isEmpty((String)flex) || (asstType = (DynamicObject)flexFieldAndAssMap.get(flex)) == null) continue;
                String entityNumber = null;
                String valueType = asstType.getString("valuetype");
                if ("2".equals(valueType)) {
                    entityNumber = "bos_assistantdata_detail";
                } else if ("1".equals(valueType)) {
                    DynamicObject valueSource = asstType.getDynamicObject("valuesource");
                    if (valueSource == null) continue;
                    entityNumber = valueSource.getString("id");
                }
                int rowIndex = model.createNewEntryRow("entryentity");
                model.setValue("fieldname", asstType.getPkValue(), rowIndex);
                if (entityNumber != null) {
                    MulBasedataProp prop = (MulBasedataProp)entryProp.getDynamicCollectionItemPropertyType().getProperty("value");
                    prop.setBaseEntityId(entityNumber);
                    BasedataProp baseProp = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
                    baseProp.setBaseEntityId(entityNumber);
                    baseProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber));
                    if (!(item.getValue() instanceof Set)) continue;
                    Set pkSet = (Set)item.getValue();
                    model.setValue("value", (Object)pkSet.toArray(new Object[0]), rowIndex);
                    continue;
                }
                model.setValue("textinput", item.getValue(), rowIndex);
            }
            this.getPageCache().put("firstHyperQuery", "true");
        }
        int count = model.getEntryRowCount("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] rows = IntStream.range(0, count).toArray();
        entryGrid.selectRows(rows, 0);
    }
}

