/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportBatchQueryInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.report.BaseAuxSubLedgerFormRpt;
import kd.fi.gl.report.CurType;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.util.ReportFieldSettingUtil;
import kd.fi.gl.util.VoucherUtil;
import kd.fi.gl.vo.ReportFieldSettingVo;

public class AuxSubLedgerFormRpt
extends BaseAuxSubLedgerFormRpt {
    private static final Log LOGGER = LogFactory.getLog(AuxSubLedgerFormRpt.class);

    @Override
    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
    }

    @Override
    protected boolean isBasecurrency(FilterInfo filter) {
        String str = CacheHelper.getDistributeCache((CacheModule)CacheModule.report).get("AuxSubLedgerQueryRpt-qpRpt");
        CurType curType = (CurType)SerializationUtils.fromJsonString((String)str, CurType.class);
        return curType == CurType.BASE || curType == CurType.NATIVE;
    }

    @Override
    protected Map<String, String> getColWidth(boolean showCurrencyCol, boolean exportExcel, boolean isBaseCurrency, boolean showQty, boolean showPrice, DynamicObject account, boolean isShowAccount) {
        return super.getColWidth(showCurrencyCol, exportExcel, isBaseCurrency, showQty, showPrice, account, true);
    }

    @Override
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap", "exportcuracc"});
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener(evt -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("reportlistap");
            DynamicObject rowData = list.getReportModel().getRowData(rowIndex);
            switch (evt.getFieldName()) {
                case "voucherno": {
                    long voucherId = rowData.getLong("voucherid");
                    long orgId = rowData.getLong("org_id");
                    if (voucherId == 0L) break;
                    VoucherUtil.hyperVoucher(orgId, voucherId, (IFormView)this.getView());
                }
            }
        });
        BasedataEdit acc = (BasedataEdit)this.getControl("account");
        acc.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            filterParam.getQFilters().add(new QFilter("isassist", "=", (Object)"1"));
        });
    }

    @Override
    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        queryParam.getCustomParam().put("pageId", this.getView().getPageId());
        Object openType = this.getView().getFormShowParameter().getCustomParam("openType");
        FilterItemInfo openTypeFilter = queryParam.getFilter().getFilterItem("openType");
        if (Objects.nonNull(openType)) {
            queryParam.getFilter().addFilterItem("openType", openType);
        } else if (Objects.nonNull(openTypeFilter)) {
            openTypeFilter.setValue((Object)"");
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        this.getView().getFormShowParameter().setCustomParam("openType", null);
        this.getView().cacheFormShowParameter();
    }

    @Override
    public void processRowData(String gridId, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        ReportBatchQueryInfo reportBatchQueryInfo = (ReportBatchQueryInfo)queryParam.byBatchInfo();
        if (!reportBatchQueryInfo.isLargeData()) {
            super.processRowData(gridId, rowData, queryParam);
        } else {
            List displayFields = ReportFieldSettingUtil.getDisplayFieldConfigList((String)this.getView().getEntityId());
            Map vchMap = ReportUtils.getVoucherInfo((List)displayFields, (DynamicObjectCollection)rowData);
            for (DynamicObject row : rowData) {
                DynamicObject dynamicObject;
                Long fentryid = row.getLong("fentryid");
                if (fentryid == 0L || displayFields == null || displayFields.isEmpty() || Objects.isNull(dynamicObject = (DynamicObject)vchMap.get(fentryid))) continue;
                for (ReportFieldSettingVo vo : displayFields) {
                    row.set(vo.getField(), dynamicObject.get(vo.getFieldMark()));
                }
            }
        }
        List flexFilterItems = queryParam.getFilter().getFlexFilterItems();
        List<Tuple2<String, String>> tupleList = this.getAssistCols(flexFilterItems);
        int no = 0;
        ArrayList assistBaseCols = new ArrayList(10);
        for (Tuple2 tuple2 : tupleList) {
            Iterator name;
            Iterator iterator = name = no == 0 ? "assval" : "assval" + no;
            if (!"nonbase".equals(tuple2.t1)) {
                assistBaseCols.add(name);
            }
            ++no;
        }
        HashMap<Long, Map> assistDataMasterIdToId = new HashMap<Long, Map>(10);
        HashMap<String, Set> hashMap = new HashMap<String, Set>(64);
        for (DynamicObject dyn : rowData) {
            DynamicObject orgObj = dyn.getDynamicObject("org");
            if (orgObj == null) continue;
            long orgid = orgObj.getLong("id");
            for (String string : assistBaseCols) {
                DynamicObject dynamicObject = dyn.getDynamicObject(string);
                if (dynamicObject == null || !dynamicObject.containsProperty("masterid")) continue;
                long l = dynamicObject.getLong("masterid");
                long id = dynamicObject.getLong("id");
                String assistTypeName = dynamicObject.getDynamicObjectType().getName();
                assistDataMasterIdToId.computeIfAbsent(orgid, k -> new HashMap()).computeIfAbsent(assistTypeName, k -> new HashMap(10)).put(l, id);
                hashMap.computeIfAbsent(assistTypeName, k -> new HashSet(64)).add(dynamicObject.getLong("id"));
            }
        }
        for (Map.Entry assistDataEntry : assistDataMasterIdToId.entrySet()) {
            Long orgId = (Long)assistDataEntry.getKey();
            Map assistNumberValues = (Map)assistDataEntry.getValue();
            for (Map.Entry assistNumberValuesEntry : assistNumberValues.entrySet()) {
                String string = (String)assistNumberValuesEntry.getKey();
                Map map = (Map)assistNumberValuesEntry.getValue();
                Set set = map.keySet();
                QFilter filter = new QFilter("masterid", "in", set);
                DynamicObjectCollection assistObjs = BaseDataServiceHelper.queryBaseData((String)string, (Long)orgId, (QFilter)filter, (String)"id,masterid");
                for (DynamicObject assistObj : assistObjs) {
                    map.computeIfPresent(assistObj.getLong("masterid"), (k, v) -> assistObj.getLong("id"));
                    hashMap.computeIfAbsent(string, k -> new HashSet(64)).add(assistObj.getLong("id"));
                }
            }
        }
        HashMap<String, Map> assistDynMap = new HashMap<String, Map>(10);
        for (Map.Entry assistTypeIdEntry : hashMap.entrySet()) {
            String assistTypeName = (String)assistTypeIdEntry.getKey();
            Set idSet = (Set)assistTypeIdEntry.getValue();
            if (!CollectionUtils.isNotEmpty((Collection)idSet)) continue;
            Map assistObjsMap = BusinessDataServiceHelper.loadFromCache((Object[])idSet.toArray(), (String)assistTypeName);
            for (Map.Entry entry : assistObjsMap.entrySet()) {
                assistDynMap.computeIfAbsent(assistTypeName, k -> new HashMap(10)).put((Long)entry.getKey(), entry.getValue());
            }
        }
        for (DynamicObject dyn : rowData) {
            long orgid;
            Map map;
            DynamicObject orgObj = dyn.getDynamicObject("org");
            if (orgObj == null || (map = (Map)assistDataMasterIdToId.get(orgid = orgObj.getLong("id"))) == null || map.isEmpty()) continue;
            for (String string : assistBaseCols) {
                String assistTypeName;
                DynamicObject assistObj = dyn.getDynamicObject(string);
                if (assistObj == null || !map.containsKey(assistTypeName = assistObj.getDynamicObjectType().getName())) continue;
                Map masterIdToId = (Map)map.get(assistTypeName);
                Long id = (Long)masterIdToId.get(assistObj.getLong("masterid"));
                if (Objects.isNull(assistDynMap.get(assistTypeName))) continue;
                dyn.set(string, ((Map)assistDynMap.get(assistTypeName)).get(id));
                dyn.set(string + "_id", (Object)id);
            }
        }
        if (DebugTrace.enable()) {
            LOGGER.info("AuxSubledger process data:" + rowData);
        }
    }

    private List<Tuple2<String, String>> getAssistCols(List<FilterItemInfo> flexFilterItems) {
        List flexList = flexFilterItems.stream().map(FilterItemInfo::getPropName).collect(Collectors.toList());
        QFilter qFilter = new QFilter("flexfield", "in", flexList);
        DynamicObjectCollection queryOne = QueryServiceHelper.query((String)"bd_asstacttype", (String)"flexfield,valuetype", (QFilter[])new QFilter[]{qFilter});
        HashMap<String, String> map = new HashMap<String, String>();
        for (DynamicObject dyn : queryOne) {
            String valType = dyn.getString("valuetype");
            String flexField = dyn.getString("flexfield");
            if (!AssistValueType.isBaseData((String)valType)) {
                map.put(flexField, "nonbase");
                continue;
            }
            map.put(flexField, "base");
        }
        ArrayList<Tuple2<String, String>> result = new ArrayList<Tuple2<String, String>>(flexList.size());
        for (String s : flexList) {
            String type = (String)map.get(s);
            result.add((Tuple2<String, String>)new Tuple2((Object)type, (Object)s));
        }
        return result;
    }
}

