/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;

public class DailyChartRpt
extends AbstractFormPlugin {
    private static final String BAR_WIDTH = "30%";
    private static final String AXIS_COLOR = "#666666";
    private static final String DEBIT_COLOR = "#B775FF";
    private static final String CREDIT_COLOR = "#7775FF";

    public void afterCreateNewData(EventObject e) {
        DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.report);
        String str = cache.get("dailyQuery-chartMap");
        if (str == null) {
            return;
        }
        Map barChartData = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        this.setBarData(barChartData);
    }

    private void setBarData(Map<String, List<?>> barChartData) {
        Chart chart = (Chart)this.getControl("barchartap");
        chart.clearData();
        if (barChartData == null) {
            return;
        }
        List<?> axisList = barChartData.get("axisList");
        List<?> dataList = barChartData.get("dataList");
        if (axisList == null || dataList == null) {
            return;
        }
        String[] xLabel = axisList.toArray(new String[0]);
        BigDecimal[] data = dataList.toArray(new BigDecimal[0]);
        ArrayList<BigDecimal> debitlocal = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> creditlocal = new ArrayList<BigDecimal>();
        for (int i = 0; i < data.length; ++i) {
            if (i % 2 == 0) {
                debitlocal.add(data[i]);
                continue;
            }
            creditlocal.add(data[i]);
        }
        BarSeries barSeries = chart.createBarSeries(ResManager.loadKDString((String)"\u672c\u65e5\u501f\u65b9\u53d1\u751f\u989d", (String)"DailyChartRpt_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        barSeries.setData(this.getItemValue(debitlocal, DEBIT_COLOR));
        barSeries.setType(ChartType.bar);
        barSeries.setColor(DEBIT_COLOR);
        barSeries.setBarWidth(BAR_WIDTH);
        barSeries.setLabel(null);
        BarSeries barSeries2 = chart.createBarSeries(ResManager.loadKDString((String)"\u672c\u65e5\u8d37\u65b9\u53d1\u751f\u989d", (String)"DailyChartRpt_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        barSeries2.setData(this.getItemValue(creditlocal, CREDIT_COLOR));
        barSeries2.setColor(CREDIT_COLOR);
        barSeries2.setType(ChartType.bar);
        barSeries2.setBarWidth(BAR_WIDTH);
        barSeries2.setLabel(null);
        Axis xaxis = chart.createXAxis(ResManager.loadKDString((String)"\u65e5\u671f", (String)"DailyChartRpt_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), AxisType.category);
        xaxis.setCategorys(Arrays.asList(xLabel));
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.valueOf(false));
        xaxis.setPropValue("axisTick", axisTick);
        this.setLineColor(xaxis, AXIS_COLOR);
        Axis yaxis = chart.createYAxis(ResManager.loadKDString((String)"\u5143", (String)"DailyChartRpt_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), AxisType.value);
        yaxis.setPropValue("axisTick", axisTick);
        this.setLineColor(yaxis, AXIS_COLOR);
        chart.setShowTooltip(true);
        chart.setShowLegend(true);
        chart.bindData(null);
    }

    private ItemValue[] getItemValue(List<BigDecimal> data, String color) {
        ItemValue[] values = new ItemValue[data.size()];
        int size = data.size();
        for (int i = 0; i < size; ++i) {
            ItemValue value;
            values[i] = value = new ItemValue((Number)data.get(i).doubleValue(), color);
        }
        return values;
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }
}

