/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.text.Format;
import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.gl.report.FlexPrintFormatter;
import kd.fi.gl.report.ReportPrintHelper;

public class DailyFormRptPrint
extends AbstractPrintServicePlugin {
    private static final String[] rowDataStringFieldKeys = new String[]{"fseq", "number.number", "number.name", "currencylocalid.name", "curfor.name", "currencyrptid.name", "measureunit.name", "debitcount", "creditcount"};
    private static final String[] rowDataFlexFieldKeys = new String[]{"assgrp"};
    private static final String[] rowDataAmountLocalFieldKeys = new String[]{"predebitlocal", "precreditlocal", "debitlocal", "creditlocal", "todebitlocal", "tocreditlocal"};
    private static final String[] rowDataAmountForFieldKeys = new String[]{"predebitfor", "precreditfor", "debitfor", "creditfor", "todebitfor", "tocreditfor"};
    private static final String[] rowDataAmountRptFieldKeys = new String[]{"predebitrpt", "precreditrpt", "debitrpt", "creditrpt", "todebitrpt", "tocreditrpt"};
    private static final String[] rowDataQtyFieldKeys = new String[]{"predebitqty", "precreditqty", "debitqty", "creditqty", "todebitqty", "tocreditqty"};
    private static final String[] headBaseDataFieldKeys = new String[]{"org", "orgview", "booktype", "periodtype", "accounttable", "currencyrpt"};
    private static final String[] headDateFieldKeys = new String[]{"datebegin", "dateend"};
    private static final String CURRENCY_HEAD = "currency";
    private static final String CURRENCY_LOCAL = "currencylocalid";
    private static final String CURRENCY_FOR = "curfor";
    private static final String CURRENCY_RPT = "currencyrptid";
    private static final String MEASUREUNITFIELD = "measureunit";
    private FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
    private Format timeFormat = FormatFactory.get((FormatTypes)FormatTypes.Date).getFormat(this.fobj);
    private FlexPrintFormatter flexPrintFormatter = null;
    private final Boolean enableBOSFormatter = Boolean.parseBoolean(System.getProperty("fi.gl.report.print.enablebosflexformatter", Boolean.TRUE.toString()));

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        super.customPrintDataEntities(e);
        ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>();
        String pageId = e.getPageId();
        ReportListModel listModel = ReportPrintHelper.getListModel(pageId);
        if (listModel == null) {
            return;
        }
        ReportQueryParam param = listModel.getReportQueryParam();
        FilterInfo filterInfo = param.getFilter();
        if (e.isMainDs()) {
            DynamicObjectType customDT = new DynamicObjectType();
            customDT.registerProperty("id", String.class, (Object)"", false);
            DynamicObject printDyn = new DynamicObject(customDT);
            printDyn.set("id", (Object)"1");
            dyns.add(printDyn);
            e.setDataEntities(dyns);
        } else if ("reporthead".equals(e.getDataSourceName())) {
            DynamicObjectType customDT = new DynamicObjectType();
            String[] headBaseDataFields = ReportPrintHelper.getExistFileds(e, headBaseDataFieldKeys);
            String[] headDateFields = ReportPrintHelper.getExistFileds(e, headDateFieldKeys);
            ReportPrintHelper.registerStringProperty(customDT, new String[][]{headBaseDataFields, headDateFields});
            ReportPrintHelper.registerStringProperty(customDT, CURRENCY_HEAD);
            DynamicObject printDyn = new DynamicObject(customDT);
            ReportPrintHelper.handleBaseDataFilterInfo(filterInfo, printDyn, headBaseDataFields);
            ReportPrintHelper.handleDateFilterInfo(filterInfo, printDyn, this.timeFormat, headDateFields);
            ReportPrintHelper.handleCurrencyNameById(filterInfo, printDyn, CURRENCY_HEAD);
            dyns.add(printDyn);
            e.setDataEntities(dyns);
        } else {
            int count = listModel.getRowCount();
            DynamicObjectCollection ds = listModel.getRowData(0, count);
            if (ds == null || ds.isEmpty()) {
                return;
            }
            if (this.enableBOSFormatter.booleanValue()) {
                this.flexPrintFormatter = new FlexPrintFormatter(listModel, ds);
            }
            DynamicObjectType customDt = new DynamicObjectType("reportlist");
            String[] rowDataStringFields = ReportPrintHelper.getExistFileds(e, rowDataStringFieldKeys);
            String[] rowDataFlexFields = ReportPrintHelper.getExistFileds(e, rowDataFlexFieldKeys);
            String[] rowDataAmountForFields = ReportPrintHelper.getExistFileds(e, rowDataAmountForFieldKeys);
            String[] rowDataAmountLocalFields = ReportPrintHelper.getExistFileds(e, rowDataAmountLocalFieldKeys);
            String[] rowDataAmountRptFields = ReportPrintHelper.getExistFileds(e, rowDataAmountRptFieldKeys);
            String[] rowDataQtyFields = ReportPrintHelper.getExistFileds(e, rowDataQtyFieldKeys);
            ReportPrintHelper.registerStringProperty(customDt, new String[][]{rowDataAmountLocalFields, rowDataAmountForFields, rowDataAmountRptFields, rowDataStringFields, rowDataFlexFields, rowDataQtyFields});
            boolean isShowAssgrp = filterInfo.getBoolean("showassist");
            boolean showrpt = filterInfo.getBoolean("showrpt");
            boolean showqty = filterInfo.getBoolean("showqty");
            HashSet<String> hgValueSet = new HashSet<String>(ds.size());
            for (DynamicObject rowData : ds) {
                DynamicObject printRow = new DynamicObject(customDt);
                ReportPrintHelper.handleStringFields(rowData, printRow, rowDataStringFields);
                if (rowData.getInt("fseq") == count) {
                    printRow.set("number.name", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"DailyFormRptPrint_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                }
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_LOCAL, (boolean)Boolean.FALSE, rowDataAmountLocalFields);
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_FOR, (boolean)Boolean.FALSE, rowDataAmountForFields);
                if (showrpt) {
                    ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_RPT, (boolean)Boolean.FALSE, rowDataAmountRptFields);
                }
                if (showqty) {
                    ReportPrintHelper.handleQtyFields(rowData, printRow, (boolean)Boolean.FALSE, MEASUREUNITFIELD, this.fobj, rowDataQtyFields);
                }
                if (isShowAssgrp) {
                    if (!this.enableBOSFormatter.booleanValue()) {
                        ReportPrintHelper.handleFlexFields(rowData, printRow, hgValueSet, rowDataFlexFields);
                    } else if (this.flexPrintFormatter != null && customDt.getProperty("assgrp") != null) {
                        printRow.set("assgrp", (Object)this.flexPrintFormatter.getFlexString(rowData));
                    }
                }
                dyns.add(printRow);
            }
            if (!this.enableBOSFormatter.booleanValue() && isShowAssgrp) {
                ReportPrintHelper.handleFlexIntoToStr(dyns, hgValueSet, rowDataFlexFields);
            }
            e.setDataEntities(dyns);
        }
    }
}

