/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.report.ReportList;
import kd.fi.gl.report.GLRptTemplatePlugin;
import kd.fi.gl.report.NavToSubLedgerRpt;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.ShowByAccountDCParam;

public class GeneralLedgerFormRpt
extends GLRptTemplatePlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList control = (ReportList)this.getControl("reportlistap");
        control.addHyperClickListener(evt -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("reportlistap");
            DynamicObject rowData = control.getReportModel().getRowData(rowIndex);
            if (Objects.nonNull(rowData)) {
                String name = evt.getFieldName();
                if ("accountnumber".equals(name)) {
                    Long accId = rowData.getLong("acct_id");
                    Long orgId = this.getQueryParam().getFilter().getLong("org");
                    new NavToSubLedgerRpt.SLBuilder(this.getQueryParam(), (IFormView)this.getView()).accountId(accId).orgId(orgId).build().apply();
                } else if ("currencyname".equals(name)) {
                    Long accId = rowData.getLong("acct_id");
                    Long curId = rowData.getLong("currencyid_id");
                    Long orgId = this.getQueryParam().getFilter().getLong("org");
                    new NavToSubLedgerRpt.SLBuilder(this.getQueryParam(), (IFormView)this.getView()).accountId(accId).currencyId(curId).orgId(orgId).build().apply();
                }
            }
        });
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        Long defaultOrg = this.getParentOrg();
        List<String> amountTypes = this.getAmountType(rowData.getDynamicObjectType().getProperties());
        ShowByAccountDCParam param = new ShowByAccountDCParam(defaultOrg, Long.valueOf(queryParam.getFilter().getLong("accounttable")));
        param.setMergeDebitAndCreditCol(Boolean.TRUE);
        param.setAmountTypes(amountTypes);
        param.addBalAndDCField("end", "direction");
        ReportUtils.showRowDataByActDC((ShowByAccountDCParam)param, (DynamicObjectCollection)rowData);
    }

    private List<String> getAmountType(DataEntityPropertyCollection props) {
        ArrayList<String> amountTypes = new ArrayList<String>();
        amountTypes.add("local");
        if (props.containsKey((Object)"endfor")) {
            amountTypes.add("for");
        }
        if (props.containsKey((Object)"endqty")) {
            amountTypes.add("qty");
        }
        return amountTypes;
    }
}

