/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.gl.report.ReportPrintHelper;

public class GeneralLedgerRptActPrintNew
extends AbstractPrintPlugin {
    private static final String[] rowDataStringFieldKeys = new String[]{"currencylocalid.name", "period.name", "measureunit.name", "description", "currencyid.name", "direction"};
    private static final String[] rowDataQtyFieldKeys = new String[]{"debitqty", "creditqty", "endqty"};
    private static final String[] rowDataAmountLocalFieldKeys = new String[]{"debitlocal", "creditlocal", "endlocal"};
    private static final String[] rowDataAmountForFieldKeys = new String[]{"debitfor", "creditfor", "endfor"};
    private static final String[] headBaseDataFieldKeys = new String[]{"org", "orgview", "booktype", "periodtype", "startperiod", "endperiod", "accounttable", "currencyrpt"};
    private static final String CURRENCY_HEAD = "currency";
    private static final String CURRENCY_LOCAL = "currencylocalid";
    private static final String CURRENCY_FOR = "currencyid";
    private static final String MEASUREUNITFIELD = "measureunit";
    private FormatObject fobj;
    private static final String rowDataCacheKey = "GeneralLedgerRptActPrintNew_RowDatas";
    private static final String pageHeadCacheKey = "GeneralLedgerRptActPrintNew_pageHead";

    public void loadCustomData(CustomDataLoadEvent evt) {
        CustomDataSource dataSource = evt.getDataSource();
        String pageId = dataSource.getPageId();
        ReportListModel model = this.getListModel(pageId);
        if (model == null) {
            return;
        }
        String pkId = dataSource.getPkId().toString();
        if (StringUtils.isEmpty((CharSequence)pkId)) {
            return;
        }
        if ("reporthead".equals(dataSource.getDsName())) {
            ReportQueryParam param = model.getReportQueryParam();
            FilterInfo filter = param.getFilter();
            List queryField = dataSource.getQueryField();
            List customDataRows = evt.getCustomDataRows();
            DataRowSet dsRow = new DataRowSet();
            Map pageHeadAcct = (Map)ThreadCache.get((Object)pageHeadCacheKey);
            String[] acct = (String[])pageHeadAcct.get(Integer.parseInt(pkId));
            dsRow.add("account", (Field)new TextField(acct[0] + acct[1]));
            String[] headBaseDataFields = ReportPrintHelper.getExistFileds(queryField, headBaseDataFieldKeys);
            ReportPrintHelper.handleBaseDataFilterInfo(filter, dsRow, headBaseDataFields);
            ReportPrintHelper.handleCurrencyNameById(filter, dsRow, CURRENCY_HEAD);
            customDataRows.add(dsRow);
        } else if ("reportlistap".equals(dataSource.getDsName())) {
            List fields = evt.getDataSource().getQueryField();
            String[] rowDataStringFields = ReportPrintHelper.getExistFileds(fields, rowDataStringFieldKeys);
            String[] rowDataAmountForFields = ReportPrintHelper.getExistFileds(fields, rowDataAmountForFieldKeys);
            String[] rowDataAmountLocalFields = ReportPrintHelper.getExistFileds(fields, rowDataAmountLocalFieldKeys);
            String[] rowDataQtyFields = ReportPrintHelper.getExistFileds(fields, rowDataQtyFieldKeys);
            this.fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
            Map pageHeadAcct = (Map)ThreadCache.get((Object)pageHeadCacheKey);
            Map rowDatasMap = (Map)ThreadCache.get((Object)rowDataCacheKey);
            int index = Integer.parseInt(pkId);
            String dataIndexs = (String)rowDatasMap.get(index);
            String[] indexStr = dataIndexs.split("-");
            int startIndex = Integer.parseInt(indexStr[0]);
            int length = Integer.parseInt(indexStr[1]) - startIndex;
            DynamicObjectCollection ds = model.getRowData(startIndex, length);
            int temp = 1;
            String[] acct = (String[])pageHeadAcct.get(index);
            List customDataRows = evt.getCustomDataRows();
            for (DynamicObject rowData : ds) {
                DataRowSet printRow = new DataRowSet();
                printRow.add("fseq", (Field)new TextField(String.valueOf(temp)));
                ++temp;
                printRow.add("accountname", (Field)new TextField(acct[0]));
                printRow.add("accountnumber", (Field)new TextField(acct[1]));
                ReportPrintHelper.handleStringFields(rowData, printRow, rowDataStringFields);
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_LOCAL, (boolean)Boolean.FALSE, rowDataAmountLocalFields);
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_FOR, (boolean)Boolean.FALSE, rowDataAmountForFields);
                ReportPrintHelper.handleQtyFields(rowData, printRow, (boolean)Boolean.FALSE, MEASUREUNITFIELD, this.fobj, rowDataQtyFields);
                customDataRows.add(printRow);
            }
        }
    }

    private ReportListModel getListModel(String pageId) {
        ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            return null;
        }
        ReportList list = view.getReportList();
        ReportListModel listModel = (ReportListModel)list.getReportModel();
        return listModel;
    }

    public void afterLoadData(AfterLoadDataEvent e) {
        super.afterLoadData(e);
        PrtDataSource dataSource = e.getDataSource();
        if (dataSource instanceof MainDataSource) {
            Object param;
            String pageId = ((MainDataSource)dataSource).getPageId();
            ReportListModel model = this.getListModel(pageId);
            if (model == null) {
                return;
            }
            Map extParam = this.getExtParam();
            if (!extParam.isEmpty() && (param = this.getExtParam().get("pageID")) != null) {
                String pageIDForPrint = param.toString();
                model.setReportTaskResult(model.getReportCache().getReportTaskResult(pageIDForPrint, "reportlistap"));
            }
            DynamicObjectCollection rowDatas = model.getRowData(0, model.getRowCount());
            HashMap<Integer, String> rowIndexsByPage = new HashMap<Integer, String>(1);
            HashMap<Integer, String[]> pageToaccAndass = new HashMap<Integer, String[]>(1);
            String tempStr = "";
            int key = 1;
            ArrayList<DataRowSet> dataRows = new ArrayList<DataRowSet>(1);
            for (DynamicObject rowData : rowDatas) {
                String acctName = rowData.getString("accountname");
                String acctNumber = rowData.getString("accountnumber");
                String str = String.join((CharSequence)"", acctNumber, acctName);
                if (StringUtils.isBlank((CharSequence)str)) continue;
                int rowNo = rowData.getInt("fseq");
                if (str.equalsIgnoreCase(tempStr)) continue;
                if (rowIndexsByPage.get(key) == null && key != rowNo) {
                    rowIndexsByPage.put(key, key - 1 + "-" + (rowNo - 1));
                }
                DataRowSet dsRow = new DataRowSet();
                tempStr = str;
                key = rowNo;
                pageToaccAndass.put(key, new String[]{acctNumber, acctName});
                dsRow.add("id", (Field)new TextField(rowNo + ""));
                dataRows.add(dsRow);
            }
            e.setDataRowSets(dataRows);
            if (rowDatas.size() > 0) {
                rowIndexsByPage.put(key, key - 1 + "-" + rowDatas.size());
            }
            ThreadCache.put((Object)rowDataCacheKey, rowIndexsByPage);
            ThreadCache.put((Object)pageHeadCacheKey, pageToaccAndass);
        }
    }
}

