/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.gl.report.ReportPrintHelper;

public class GeneralLedgerRptPrintNew
extends AbstractPrintPlugin {
    private static final String[] rowDataStringFieldKeys = new String[]{"fseq", "accountnumber", "accountname", "currencylocalid.name", "period.name", "measureunit.name", "description", "currencyid.name", "direction"};
    private static final String[] rowDataQtyFieldKeys = new String[]{"debitqty", "creditqty", "endqty"};
    private static final String[] rowDataAmountLocalFieldKeys = new String[]{"debitlocal", "creditlocal", "endlocal"};
    private static final String[] rowDataAmountForFieldKeys = new String[]{"debitfor", "creditfor", "endfor"};
    private static final String[] headBaseDataFieldKeys = new String[]{"org", "orgview", "booktype", "periodtype", "startperiod", "endperiod", "accounttable", "currencyrpt"};
    private static final String CURRENCY_HEAD = "currency";
    private static final String CURRENCY_LOCAL = "currencylocalid";
    private static final String CURRENCY_FOR = "currencyid";
    private static final String MEASUREUNITFIELD = "measureunit";
    private FormatObject fobj;

    public void loadCustomData(CustomDataLoadEvent evt) {
        CustomDataSource dataSource = evt.getDataSource();
        String pageId = dataSource.getPageId();
        ReportListModel model = this.getListModel(pageId);
        if (model == null) {
            return;
        }
        if ("reporthead".equals(dataSource.getDsName())) {
            ReportQueryParam param = model.getReportQueryParam();
            FilterInfo filter = param.getFilter();
            List queryField = dataSource.getQueryField();
            List customDataRows = evt.getCustomDataRows();
            DataRowSet dsRow = new DataRowSet();
            String[] headBaseDataFields = ReportPrintHelper.getExistFileds(queryField, headBaseDataFieldKeys);
            ReportPrintHelper.handleBaseDataFilterInfo(filter, dsRow, headBaseDataFields);
            ReportPrintHelper.handleCurrencyNameById(filter, dsRow, CURRENCY_HEAD);
            customDataRows.add(dsRow);
        } else if ("reportlistap".equals(dataSource.getDsName())) {
            int count = model.getRowCount();
            List fields = evt.getDataSource().getQueryField();
            String[] rowDataStringFields = ReportPrintHelper.getExistFileds(fields, rowDataStringFieldKeys);
            String[] rowDataAmountForFields = ReportPrintHelper.getExistFileds(fields, rowDataAmountForFieldKeys);
            String[] rowDataAmountLocalFields = ReportPrintHelper.getExistFileds(fields, rowDataAmountLocalFieldKeys);
            String[] rowDataQtyFields = ReportPrintHelper.getExistFileds(fields, rowDataQtyFieldKeys);
            this.fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
            DynamicObjectCollection ds = model.getRowData(0, count);
            List customDataRows = evt.getCustomDataRows();
            for (DynamicObject rowData : ds) {
                DataRowSet printRow = new DataRowSet();
                ReportPrintHelper.handleStringFields(rowData, printRow, rowDataStringFields);
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_LOCAL, (boolean)Boolean.FALSE, rowDataAmountLocalFields);
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_FOR, (boolean)Boolean.FALSE, rowDataAmountForFields);
                ReportPrintHelper.handleQtyFields(rowData, printRow, (boolean)Boolean.FALSE, MEASUREUNITFIELD, this.fobj, rowDataQtyFields);
                customDataRows.add(printRow);
            }
        }
    }

    private ReportListModel getListModel(String pageId) {
        ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            return null;
        }
        ReportList list = view.getReportList();
        ReportListModel listModel = (ReportListModel)list.getReportModel();
        return listModel;
    }
}

