/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.VoucherUtil;

public class MultColAcctRptFormPlugin
extends AbstractReportFormPlugin {
    private static final String SCHEME = "scheme";
    private static final String SCHEME_CALL_BACK = "schemeCallBack";
    private static final String COLKEY_DEBITFIELD = "fd_";
    private static final String COLKEY_CREDITFIELD = "fc_";
    private static final String SUBTOTALENDSWITH = "_subtotal";
    private List<String> debitColumns;
    private List<String> creditColumns;
    public static final String PREAMOUNTBAL = "preAmountBal";

    public void beforeQuery(ReportQueryParam queryParam) {
        this.getPageCache().put(PREAMOUNTBAL, "");
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        Long startPeriod = filter.getLong("startperiod");
        Long endPeriod = filter.getLong("endperiod");
        Long periodType = filter.getLong("periodtype");
        HashMap<Long, Date> periodAndDateMap = new HashMap<Long, Date>();
        QFilter periodTypeF = new QFilter("periodtype", "=", (Object)periodType);
        QFilter startFilter = new QFilter("id", ">=", (Object)startPeriod);
        QFilter endFilter = new QFilter("id", "<=", (Object)endPeriod);
        try (DataSet rs = QueryServiceHelper.queryDataSet((String)"GLUtil.getPeriodIds", (String)"bd_period", (String)"id,enddate", (QFilter[])new QFilter[]{periodTypeF, startFilter, endFilter}, null);){
            for (Row row : rs) {
                periodAndDateMap.put(row.getLong("id"), row.getDate("enddate"));
            }
        }
        BigDecimal amountBal = BigDecimal.ZERO;
        if (StringUtils.isNotEmpty((String)this.getPageCache().get(PREAMOUNTBAL))) {
            amountBal = new BigDecimal(this.getPageCache().get(PREAMOUNTBAL));
        }
        String dc = "0";
        for (Row row : rowData) {
            String dataType;
            switch (dataType = row.getString("datatype")) {
                case "0": {
                    this.updateDebitAndCreditAmount((DynamicObject)row, dataType);
                    dc = row.getString("dc");
                    amountBal = row.getBigDecimal("amountBal").multiply(new BigDecimal(dc));
                    row.set("period", null);
                    break;
                }
                case "1": {
                    this.updateDebitAndCreditAmount((DynamicObject)row, dataType);
                    BigDecimal debit = row.getBigDecimal("debit");
                    BigDecimal credit = row.getBigDecimal("credit");
                    amountBal = amountBal.add(debit).subtract(credit);
                    dc = amountBal.compareTo(BigDecimal.ZERO) > 0 ? "1" : (amountBal.compareTo(BigDecimal.ZERO) < 0 ? "-1" : "0");
                    row.set("dc", (Object)dc);
                    row.set("amountBal", (Object)amountBal.abs());
                    break;
                }
                case "2": 
                case "3": {
                    this.updateDebitAndCreditAmount((DynamicObject)row, dataType);
                    row.set("dc", (Object)dc);
                    row.set("amountBal", (Object)amountBal.abs());
                    Long periodId = row.getLong("period.id");
                    Date date = (Date)periodAndDateMap.get(periodId);
                    if (date == null) break;
                    row.set("bookeddate", (Object)date);
                    break;
                }
            }
        }
        this.getPageCache().put(PREAMOUNTBAL, amountBal.toPlainString());
        boolean bIsShowByAccountDC = this.isShowByAccDc(filter.getLong("org"));
        if (bIsShowByAccountDC) {
            this.showBalByAccountDC(filter, rowData);
        }
    }

    private void updateDebitAndCreditAmount(DynamicObject row, String rowType) {
        BigDecimal debitTotal = BigDecimal.ZERO;
        BigDecimal creditTotal = BigDecimal.ZERO;
        this.initMultColumns(row);
        DataEntityPropertyCollection propertys = row.getDataEntityType().getProperties();
        for (String colName : this.debitColumns) {
            debitTotal = debitTotal.add(row.getBigDecimal(colName));
        }
        for (String colName : this.creditColumns) {
            creditTotal = creditTotal.add(row.getBigDecimal(colName));
        }
        if (propertys.containsKey((Object)"debittotal")) {
            row.set("debittotal", (Object)debitTotal);
        }
        if (propertys.containsKey((Object)"credittotal")) {
            row.set("credittotal", (Object)creditTotal);
        }
        if ("1".equals(rowType) || "2".equals(rowType) || "3".equals(rowType)) {
            row.set("debit", (Object)debitTotal);
            row.set("credit", (Object)creditTotal);
        }
    }

    private void initMultColumns(DynamicObject row) {
        if (this.debitColumns != null && this.creditColumns != null) {
            return;
        }
        this.debitColumns = new ArrayList<String>();
        this.creditColumns = new ArrayList<String>();
        DataEntityPropertyCollection propertys = row.getDataEntityType().getProperties();
        for (IDataEntityProperty property : propertys) {
            String colName = property.getName();
            if (colName.endsWith(SUBTOTALENDSWITH)) continue;
            if (colName.startsWith(COLKEY_DEBITFIELD)) {
                this.debitColumns.add(colName);
            }
            if (!colName.startsWith(COLKEY_CREDITFIELD)) continue;
            this.creditColumns.add(colName);
        }
    }

    private void showBalByAccountDC(FilterInfo filter, DynamicObjectCollection rowData) {
        DynamicObject scheme = filter.getDynamicObject(SCHEME);
        String accountDC = "1";
        if (scheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u65b9\u6848\u5931\u8d25", (String)"MultColAcctRptFormPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        Long accountId = scheme.getLong("account.id");
        DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"dc", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)accountId)});
        if (account != null) {
            accountDC = account.getInt("dc") == 1 ? "1" : "-1";
        }
        for (DynamicObject row : rowData) {
            String balDC = row.getString("dc");
            BigDecimal amtBal = row.getBigDecimal("amountBal");
            row.set("dc", (Object)this.getDCBySysParam(accountDC, amtBal));
            row.set("amountBal", (Object)this.getAmountBalBySysParam(balDC, accountDC, amtBal));
        }
    }

    private String getDCBySysParam(String accountDC, BigDecimal amountBal) {
        if (amountBal.compareTo(BigDecimal.ZERO) == 0) {
            return "0";
        }
        return accountDC;
    }

    private BigDecimal getAmountBalBySysParam(String balDC, String accountDC, BigDecimal amountBal) {
        return amountBal.multiply(new BigDecimal(accountDC)).multiply(new BigDecimal(balDC));
    }

    private boolean isShowByAccDc(Long org) {
        Boolean bIsShowByAccountDC = (Boolean)GLUtil.getSystemParam((String)"showbyaccountdc", (Long)org);
        if (bIsShowByAccountDC == null) {
            bIsShowByAccountDC = Boolean.FALSE;
        }
        return bIsShowByAccountDC;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit schemEdit = (BasedataEdit)this.getControl(SCHEME);
        schemEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            Long orgId = (Long)this.getModel().getValue("org_id");
            if (orgId.equals(0L)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"MultColAcctRptFormPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long bookTypeId = (Long)this.getModel().getValue("booktype_id");
            param.setCustomParam("org", (Object)orgId);
            param.setCustomParam("booktype", (Object)bookTypeId);
            Long acctTblId = (Long)this.getModel().getValue("accounttable_id");
            param.setCustomParam("accounttable", (Object)acctTblId);
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("org", "=", (Object)orgId));
            filters.add(new QFilter("booktype", "=", (Object)bookTypeId));
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SCHEME_CALL_BACK));
            param.getListFilterParameter().setQFilters(filters);
        });
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener(evt -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("reportlistap");
            DynamicObject rowData = list.getReportModel().getRowData(rowIndex);
            switch (evt.getFieldName()) {
                case "billno": {
                    long voucherId = rowData.getLong("voucherid");
                    if (voucherId == 0L) break;
                    this.viewVoucher(voucherId);
                }
            }
        });
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object result = closedCallBackEvent.getReturnData();
        if (result == null) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "schemeCallBack": {
                ListSelectedRowCollection rows = (ListSelectedRowCollection)result;
                if (rows.isEmpty()) {
                    return;
                }
                Object pkId = rows.get(0).getPrimaryKeyValue();
                this.getModel().setValue(SCHEME, null);
                this.getModel().setValue(SCHEME, pkId);
                break;
            }
        }
    }

    private void viewVoucher(Long id) {
        long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        VoucherUtil.hyperVoucher(orgId, id, (IFormView)this.getView());
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        if (scheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u591a\u680f\u8d26\u65b9\u6848\u3002", (String)"MultColAcctRptFormPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long schemeId = scheme.getLong("id");
        Boolean isExist = QueryServiceHelper.exists((String)"gl_multcol_scheme", (Object)schemeId);
        if (!isExist.booleanValue()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u591a\u680f\u8d26\u65b9\u6848[%s]\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u76f8\u5173\u62a5\u8868\u65b9\u6848\u4e2d\u7684\u591a\u680f\u8d26\u65b9\u6848\u3002", (String)"MultColAcctRptFormPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), scheme.get("name")));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object value = e.getChangeSet()[0].getNewValue();
        if (value == null) {
            return;
        }
        switch (propertyName) {
            case "org": 
            case "booktype": {
                this.getModel().setValue(SCHEME, null);
                break;
            }
            case "scheme": {
                DynamicObject scheme = (DynamicObject)value;
                if (scheme == null) break;
                HashSet<Long> accountIds = new HashSet<Long>();
                if ("0".equals(scheme.getString("type"))) {
                    DynamicObjectCollection entrysCollection = scheme.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : entrysCollection) {
                        accountIds.add(entry.getLong("accountnum.id"));
                    }
                } else {
                    accountIds.add(scheme.getLong("account.id"));
                }
                this.getModel().setValue("account", (Object)accountIds.toArray(new Long[0]));
            }
        }
    }

    public void afterSetModelValue(DynamicObject scheme) {
        super.afterSetModelValue(scheme);
        this.getModel().setValue(SCHEME, (Object)scheme.getDynamicObject(SCHEME));
    }
}

