/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.report.AssistTxtFilterPlugin;
import kd.fi.gl.util.GlFormUtil;

public class MultColAssistFilterPlugin
extends AssistTxtFilterPlugin {
    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        if (queryParam == null || queryParam.getFilter() == null) {
            return false;
        }
        GlFormUtil.setSelectedFlexItems(this.getModel(), (EntryGrid)this.getControl("entryentity"), queryParam.getFilter());
        this.beforeQuerySetParam(queryParam);
        return true;
    }

    @Override
    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        IDataModel model = this.getModel();
        MainEntityType type = model.getDataEntityType();
        EntryProp entryProp = (EntryProp)type.getProperty("entryentity");
        ReportQueryParam queryParam = ((ReportShowParameter)this.getView().getFormShowParameter()).getReportQueryParam();
        if (queryParam != null) {
            FilterInfo filter = queryParam.getFilter();
            List flexFilterItems = filter.getFlexFilterItems();
            HashSet<String> flexFields = new HashSet<String>(flexFilterItems.size());
            for (FilterItemInfo item : flexFilterItems) {
                String flex = item.getPropName();
                if (StringUtils.isEmpty((CharSequence)flex)) continue;
                flexFields.add(flex);
            }
            Map asstTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (QFilter[])new QFilter[]{new QFilter("flexfield", "in", flexFields)});
            HashMap<String, DynamicObject> flexFieldAndAssMap = new HashMap<String, DynamicObject>(asstTypeMap.size());
            for (DynamicObject assType : asstTypeMap.values()) {
                flexFieldAndAssMap.put(assType.getString("flexfield"), assType);
            }
            model.deleteEntryData("entryentity");
            for (FilterItemInfo item : flexFilterItems) {
                DynamicObject asstType;
                String flex = item.getPropName();
                if (kd.bos.util.StringUtils.isEmpty((String)flex) || (asstType = (DynamicObject)flexFieldAndAssMap.get(flex)) == null) continue;
                String entityNumber = null;
                String valueType = asstType.getString("valuetype");
                if ("2".equals(valueType)) {
                    entityNumber = "bos_assistantdata_detail";
                } else if ("1".equals(valueType)) {
                    DynamicObject valueSource = asstType.getDynamicObject("valuesource");
                    if (valueSource == null) continue;
                    entityNumber = valueSource.getString("id");
                }
                int rowIndex = model.createNewEntryRow("entryentity");
                model.setValue("fieldname", asstType.getPkValue(), rowIndex);
                if (entityNumber != null) {
                    MulBasedataProp prop = (MulBasedataProp)entryProp.getDynamicCollectionItemPropertyType().getProperty("value");
                    prop.setBaseEntityId(entityNumber);
                    BasedataProp baseProp = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
                    baseProp.setBaseEntityId(entityNumber);
                    baseProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber));
                    if (!(item.getValue() instanceof Set)) continue;
                    Set pkSet = (Set)item.getValue();
                    model.setValue("value", (Object)pkSet.toArray(new Object[0]), rowIndex);
                    continue;
                }
                model.setValue("textinput", item.getValue(), rowIndex);
            }
        } else {
            DynamicObjectCollection entryEntity = scheme.getDynamicObjectCollection("entryentity");
            int count = model.getEntryRowCount("entryentity");
            String[] fields = this.getFields();
            for (int i = 0; i < entryEntity.size(); ++i) {
                if (i >= count) {
                    model.createNewEntryRow("entryentity");
                }
                DynamicObject dyn = (DynamicObject)entryEntity.get(i);
                for (String field : fields) {
                    Object val = dyn.get(field);
                    model.setValue(field, val, i);
                }
            }
        }
        int count = model.getEntryRowCount("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] rows = IntStream.range(0, count).toArray();
        entryGrid.selectRows(rows, 0);
    }
}

