/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.VoucherUtil;

public class ReciprocalLogRptFilterPlugin
extends AbstractReportFormPlugin {
    public void initialize() {
        super.initialize();
        FilterGrid filterGrid = (FilterGrid)this.getControl("voucherfiltergridap");
        filterGrid.setEntityNumber("gl_voucher");
        this.setVoucherFilterFields(filterGrid);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit account = (BasedataEdit)this.getControl("account");
        account.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            QFilter qf = new QFilter("isleaf", "=", (Object)true).and(new QFilter("accheck", "=", (Object)true));
            param.getListFilterParameter().getQFilters().add(qf);
        });
        BasedataEdit assgrp = (BasedataEdit)this.getControl("fieldname");
        assgrp.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            DynamicObjectCollection accts = (DynamicObjectCollection)this.getModel().getValue("account");
            ArrayList<Object> assgrpIds = new ArrayList<Object>();
            for (DynamicObject dyo : accts) {
                DynamicObject acct = dyo.getDynamicObject("fbasedataid");
                DynamicObjectCollection entry = acct.getDynamicObjectCollection("checkitementry");
                for (DynamicObject item : entry) {
                    boolean isAccheck = item.getBoolean("enaccheck");
                    if (!isAccheck) continue;
                    DynamicObject asstactitem = item.getDynamicObject("asstactitem");
                    assgrpIds.add(asstactitem.getPkValue());
                }
            }
            if (!assgrpIds.isEmpty()) {
                QFilter qf = new QFilter("id", "in", assgrpIds);
                param.getListFilterParameter().getQFilters().add(qf);
                param.getListFilterParameter().getQFilters();
            }
        });
        ReportList control = (ReportList)this.getControl("reportlistap");
        control.addHyperClickListener(evt -> {
            long vid;
            int rowIndex = this.getModel().getEntryCurrentRowIndex("reportlistap");
            DynamicObject rowData = control.getReportModel().getRowData(rowIndex);
            String name = evt.getFieldName();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if ("reciprocalvoucherno".equals(name)) {
                long vid2 = rowData.getLong("buyervoucherid");
                if (vid2 != 0L) {
                    VoucherUtil.hyperVoucher(org.getLong("id"), vid2, (IFormView)this.getView());
                }
            } else if ("writeoffvoucherno".equals(name) && (vid = rowData.getLong("writeoffvoucherid")) != 0L) {
                VoucherUtil.hyperVoucher(org.getLong("id"), vid, (IFormView)this.getView());
            }
        });
        BasedataEdit speriod = (BasedataEdit)this.getControl("startperiod");
        speriod.addBeforeF7SelectListener(evt -> {
            IDataModel model = this.getModel();
            DynamicObject org = (DynamicObject)model.getValue("org");
            DynamicObject booktype = (DynamicObject)model.getValue("booktype");
            long mpid = this.getMinInitPeriod(org, booktype);
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            if (mpid != 0L) {
                QFilter qf = new QFilter("id", ">=", (Object)mpid);
                param.getListFilterParameter().getQFilters().add(qf);
            } else {
                QFilter qf = new QFilter("id", "<", (Object)0);
                param.getListFilterParameter().getQFilters().add(qf);
            }
        });
        BasedataEdit eperiod = (BasedataEdit)this.getControl("endperiod");
        eperiod.addBeforeF7SelectListener(evt -> {
            IDataModel model = this.getModel();
            DynamicObject org = (DynamicObject)model.getValue("org");
            DynamicObject booktype = (DynamicObject)model.getValue("booktype");
            long mpid = this.getMinInitPeriod(org, booktype);
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            if (mpid != 0L) {
                QFilter qf = new QFilter("id", ">=", (Object)mpid);
                param.getListFilterParameter().getQFilters().add(qf);
            } else {
                QFilter qf = new QFilter("id", "<", (Object)0);
                param.getListFilterParameter().getQFilters().add(qf);
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "org": 
            case "booktype": {
                this.initPeriod();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initCurrency();
        this.initPeriod();
    }

    private void initCurrency() {
        ComboEdit currency = (ComboEdit)this.getControl("currency");
        currency.setComboItems(ReportUtils.getCurrencyItems((boolean)false, (boolean)true));
    }

    private static LocaleString getAllCurrency() {
        return new LocaleString(ResManager.loadKDString((String)"\u6240\u6709\u5e01\u79cd", (String)"ReciprocalLogRptFilterPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
    }

    private void initPeriod() {
        DynamicObject booktype;
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        long mpid = this.getMinInitPeriod(org, booktype = (DynamicObject)model.getValue("booktype"));
        if (mpid != 0L) {
            model.setValue("startperiod", (Object)mpid);
            model.setValue("endperiod", (Object)mpid);
            this.getPageCache().put(String.format("%s+%s+init", String.valueOf(org.getPkValue()), String.valueOf(booktype.getPkValue())), String.valueOf(mpid));
        } else {
            model.setValue("startperiod", null);
            model.setValue("endperiod", null);
        }
    }

    private long getMinInitPeriod(DynamicObject org, DynamicObject booktype) {
        if (org != null && booktype != null) {
            String sql = String.format("select min(fendinitperiod) mpid from t_gl_reci_init_state where forgid = %s and fbooktypeid = %s and fisendinit='1'", String.valueOf(org.getPkValue()), String.valueOf(booktype.getPkValue()));
            try (DataSet initState = DB.queryDataSet((String)"fi.gl.ReciprocalAcctQueryRpt.initstate", (DBRoute)DBRoute.of((String)"gl"), (String)sql);){
                if (initState.hasNext()) {
                    long mpid;
                    Row row = initState.next();
                    if (row.get("mpid") == null) {
                        long l = 0L;
                        return l;
                    }
                    long l = mpid = row.getLong("mpid").longValue();
                    return l;
                }
            }
        }
        return 0L;
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        ArrayList<Long> buyervoucherids = new ArrayList<Long>(rowData.size());
        ArrayList<Long> writeoffvoucherids = new ArrayList<Long>(rowData.size());
        ArrayList<Long> acctIds = new ArrayList<Long>(rowData.size());
        long acccurrent = 0L;
        int i = 0;
        BigDecimal reciprocalfor = BigDecimal.ZERO;
        BigDecimal reciprocallocal = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : rowData) {
            BigDecimal ballocal;
            buyervoucherids.add(dynamicObject.getLong("buyervoucherid"));
            writeoffvoucherids.add(dynamicObject.getLong("writeoffvoucherid"));
            acctIds.add(dynamicObject.getLong("accountid_id"));
            BigDecimal reciprocalForTemp = dynamicObject.getBigDecimal("reciprocalfor");
            BigDecimal reciprocalLocalTemp = dynamicObject.getBigDecimal("reciprocallocal");
            int reciprocalLocalSign = ReciprocalUtils.getAmountSignType((BigDecimal)reciprocalLocalTemp);
            int reciprocalForSign = ReciprocalUtils.getAmountSignType((BigDecimal)reciprocalForTemp);
            BigDecimal writeoffForTemp = dynamicObject.getBigDecimal("writeofffor");
            BigDecimal writeoffLocalTemp = dynamicObject.getBigDecimal("writeofflocal");
            BigDecimal balfor = reciprocalForSign == 1 ? reciprocalForTemp.subtract(writeoffForTemp) : reciprocalForTemp.add(writeoffForTemp);
            BigDecimal bigDecimal = ballocal = reciprocalLocalSign == 1 ? reciprocalLocalTemp.subtract(writeoffLocalTemp) : reciprocalLocalTemp.add(writeoffLocalTemp);
            if (i == 0) {
                acccurrent = dynamicObject.getLong("id");
                dynamicObject.set("balfor", (Object)balfor);
                dynamicObject.set("ballocal", (Object)ballocal);
                reciprocalfor = balfor;
                reciprocallocal = ballocal;
                ++i;
                continue;
            }
            if (acccurrent != dynamicObject.getLong("id")) {
                acccurrent = dynamicObject.getLong("id");
                dynamicObject.set("balfor", (Object)balfor);
                dynamicObject.set("ballocal", (Object)ballocal);
                reciprocalfor = balfor;
                reciprocallocal = ballocal;
                continue;
            }
            dynamicObject.set("reciprocalfor", (Object)reciprocalfor);
            dynamicObject.set("reciprocallocal", (Object)reciprocallocal);
            balfor = reciprocalForSign == 1 ? reciprocalfor.subtract(writeoffForTemp) : reciprocalfor.add(writeoffForTemp);
            ballocal = reciprocalLocalSign == 1 ? reciprocallocal.subtract(writeoffLocalTemp) : reciprocallocal.add(writeoffLocalTemp);
            dynamicObject.set("balfor", (Object)balfor);
            dynamicObject.set("ballocal", (Object)ballocal);
            reciprocalfor = balfor;
            reciprocallocal = ballocal;
        }
        DynamicObject[] buyervoucherData = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"id,billno,bizdate,bookeddate,entries.edescription edescription,entries.businessnum businessnum,creator", (QFilter[])new QFilter[]{new QFilter("id", "in", buyervoucherids)});
        DynamicObject[] writeoffvoucherData = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"id,billno,bookeddate,creator", (QFilter[])new QFilter[]{new QFilter("id", "in", writeoffvoucherids)});
        HashMap<Long, DynamicObject> buyerMap = new HashMap<Long, DynamicObject>(buyervoucherData.length);
        HashMap<Long, DynamicObject> writeoffMap = new HashMap<Long, DynamicObject>(writeoffvoucherData.length);
        for (DynamicObject dyn : buyervoucherData) {
            buyerMap.put(dyn.getLong("id"), dyn);
        }
        for (DynamicObject dyn : writeoffvoucherData) {
            writeoffMap.put(dyn.getLong("id"), dyn);
        }
        HashMap<Long, DynamicObject> acctMap = new HashMap<Long, DynamicObject>(acctIds.size());
        DynamicObject[] acctDyns = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", acctIds)});
        for (DynamicObject dyn : acctDyns) {
            acctMap.put(dyn.getLong("id"), dyn);
        }
        for (DynamicObject dynamicObject : rowData) {
            long acctId;
            DynamicObject writeoffvoucher;
            if (buyerMap != null) {
                DynamicObject buyerDynamicObject = (DynamicObject)buyerMap.get(dynamicObject.getLong("buyervoucherid"));
                if (dynamicObject != null && buyerDynamicObject != null) {
                    dynamicObject.set("reciprocalvoucherno", (Object)buyerDynamicObject.getString("billno"));
                    Object creator = buyerDynamicObject.get("creator");
                    if (creator != null) {
                        dynamicObject.set("reciprocalvoucheruser", creator);
                    }
                }
            }
            if (writeoffMap != null && (writeoffvoucher = (DynamicObject)writeoffMap.get(dynamicObject.getLong("writeoffvoucherid"))) != null) {
                String writeoffvoucherno = writeoffvoucher.getString("billno");
                if (dynamicObject != null && writeoffvoucherno != null) {
                    dynamicObject.set("writeoffvoucherno", (Object)writeoffvoucherno);
                    Object creator = writeoffvoucher.get("creator");
                    if (creator != null) {
                        dynamicObject.set("writeoffvoucheruser", creator);
                    }
                }
            }
            if (!Objects.nonNull(acctMap.get(acctId = dynamicObject.getLong("accountid_id")))) continue;
            DynamicObject acctDyn = (DynamicObject)acctMap.get(acctId);
            dynamicObject.set("accountnumber", (Object)acctDyn.getString("number"));
            dynamicObject.set("accountname", (Object)acctDyn.getString(GLUtil.getAcctNameBySysParam((Long)dynamicObject.getLong("org"))));
        }
    }

    private void setVoucherFilterFields(FilterGrid filterGrid) {
        ArrayList<String> filterFileds = new ArrayList<String>(19);
        filterFileds.add("billno");
        filterFileds.add("edescription");
        filterFileds.add("vouchertype.number");
        filterFileds.add("bizdate");
        filterFileds.add("bookeddate");
        filterFileds.add("description");
        filterFileds.add("billstatus");
        filterFileds.add("ispost");
        filterFileds.add("creator.number");
        filterFileds.add("auditor.number");
        filterFileds.add("cashier.number");
        filterFileds.add("poster.number");
        filterFileds.add("debitori");
        filterFileds.add("creditori");
        filterFileds.add("debitlocal");
        filterFileds.add("creditlocal");
        filterFileds.add("debitrpt");
        filterFileds.add("creditrpt");
        filterFileds.add("businessnum");
        filterGrid.setFilterFieldKeys(filterFileds);
    }
}

