/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.IFrameMessage;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.IFrame;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.report.GLRptTemplatePlugin;
import kd.fi.gl.report.ReportUtils;

public class ReciprocalQingFormRpt
extends GLRptTemplatePlugin {
    private static final String CACHE_RECIPROCAL_QUERY_PARAM = "reciprocalqueryparam";
    private static final String QINGANALYSIS = "qinganalysisap";

    public void initialize() {
        super.initialize();
        FilterGrid filterGrid = (FilterGrid)this.getControl("voucherfiltergridap");
        filterGrid.setEntityNumber("gl_voucher");
        this.setVoucherFilterFields(filterGrid);
    }

    @Override
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit account = (BasedataEdit)this.getControl("account");
        account.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            IDataModel model = this.getModel();
            List qFilters = param.getListFilterParameter().getQFilters();
            Long orgId = (Long)model.getValue("org_id");
            Long bookTypeId = (Long)model.getValue("booktype_id");
            qFilters.add(ReciprocalUtils.queryEndInitActFilter(Collections.singleton(orgId), (Long)bookTypeId));
            QFilter qf = new QFilter("isleaf", "=", (Object)true).and(new QFilter("accheck", "=", (Object)true));
            qFilters.add(qf);
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{QINGANALYSIS});
    }

    @Override
    protected List<ComboItem> getCurrencyItems() {
        return ReportUtils.getCurrencyItems((boolean)false, (boolean)true);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{QINGANALYSIS});
        this.getPageCache().put(CACHE_RECIPROCAL_QUERY_PARAM, SerializationUtils.serializeToBase64((Object)queryParam));
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        this.refetchQingData();
    }

    private void refetchQingData() {
        IFrameMessage message = new IFrameMessage();
        message.setType("reExtractData");
        IFrame frame = (IFrame)this.getView().getControl(QINGANALYSIS);
        frame.postMessage(message);
    }

    private void setVoucherFilterFields(FilterGrid filterGrid) {
        ArrayList<String> filterFileds = new ArrayList<String>(19);
        filterFileds.add("billno");
        filterFileds.add("edescription");
        filterFileds.add("vouchertype.number");
        filterFileds.add("bizdate");
        filterFileds.add("bookeddate");
        filterFileds.add("description");
        filterFileds.add("billstatus");
        filterFileds.add("ispost");
        filterFileds.add("creator.number");
        filterFileds.add("auditor.number");
        filterFileds.add("cashier.number");
        filterFileds.add("poster.number");
        filterFileds.add("debitori");
        filterFileds.add("creditori");
        filterFileds.add("debitlocal");
        filterFileds.add("creditlocal");
        filterFileds.add("debitrpt");
        filterFileds.add("creditrpt");
        filterFileds.add("businessnum");
        filterGrid.setFilterFieldKeys(filterFileds);
    }
}

