/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.TreeModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.SingleOrgContextHelper;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.ReportTree;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.model.Context;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.business.service.PeriodService;
import kd.fi.gl.enums.SubLedgerSortFieldEnum;
import kd.fi.gl.enums.report.RptSearchType;
import kd.fi.gl.model.schema.JobExecuteFormSchema;
import kd.fi.gl.model.schema.report.SubLedgerSchema;
import kd.fi.gl.report.GLRptTemplatePlugin;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.SLTreeNode;
import kd.fi.gl.report.ShowByAccountDCParam;
import kd.fi.gl.report.exportall.multiorg.FormJobExecutor;
import kd.fi.gl.report.exportall.multiorg.JobExecuteEdit;
import kd.fi.gl.report.exportall.multiorg.info.SubLedgerMultiOrgExportJobInfo;
import kd.fi.gl.report.exportall.multiorg.joblistener.MultiOrgExportJobListener;
import kd.fi.gl.report.exportall.multiorg.task.MultipleOrgReportExportTask;
import kd.fi.gl.util.AccountUtils;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.ReportFieldSettingUtil;
import kd.fi.gl.util.VoucherUtil;
import kd.fi.gl.vo.ReportFieldSettingVo;

public class SubLedgerFormRpt
extends GLRptTemplatePlugin
implements ProgresssListener,
TreeNodeClickListener {
    private static final Log LOGGER = LogFactory.getLog(SubLedgerFormRpt.class);
    private static final String ACCOUNT = "accountcolumn";
    private static final String ACCOUNT_NAME = "accountname";
    private static final String BK_DATE = "datefield";
    private static final String BIZ_DATE = "bizdate";
    protected static final String VCH_NUM = "voucherno";
    private static final String DESC = "desc";
    private static final String UNIT = "measureunit";
    private static final String CURRNECY = "currencycolumn";
    private static final String ASSGRP = "assgrp";
    private static final String DEBIT_QTY = "debitqty";
    private static final String CREDIT_QTY = "creditqty";
    private static final String END_QTY = "endqty";
    private static final String DEBIT_PRICE = "debitprice";
    private static final String CREDIT_PRICE = "creditprice";
    private static final String END_PRICE = "endprice";
    private static final String END_RPT = "endrpt";
    private static final String DEBIT_FOR = "debitfor";
    private static final String CREDIT_FOR = "creditfor";
    private static final String END_FOR = "endfor";
    private static final String DEBIT_LOCAL = "debitlocal";
    private static final String CREDIT_LOCAL = "creditlocal";
    private static final String END_LOCAL = "endlocal";
    private static final String DC = "dc";
    private static final String ZERO = "0";
    private static final String EXPORT_EXCEL = "exportexcel";
    protected static final String REPORT_LIST_AP = "reportlistap";
    private static final String SORTCOMBO = "sortcombo";
    private static final String FIELDCOMBO = "fieldcombo";
    private static final String CUSTOMSORTENTRY = "customsortentry";
    private static final String SEARCHTYPE = "searchtype";
    private MulOrgQPRpt mulOrgQPRpt = null;
    private static final String PERIOD_MAP_KEY = "SubLedgerFormRpt_perioddatemap";

    private static LocaleString getTxtAmount() {
        return new LocaleString(ResManager.loadKDString((String)"\u91d1\u989d", (String)"SubLedgerFormRpt_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
    }

    public void initialize() {
        super.initialize();
        ((ReportTree)this.getControl("reporttreeap")).addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                List children;
                super.treeNodeClick(evt);
                ReportTree tree = (ReportTree)evt.getSource();
                String id = evt.getNodeId().toString();
                if (SLTreeNode.isAccountNode(id) && CollectionUtils.isNotEmpty((Collection)(children = tree.getTreeNode(id).getChildren()))) {
                    tree.setLeafNodeQuery(false);
                }
                SubLedgerFormRpt.this.getView().getPageCache().put("foucusid", id);
            }
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getControl("voucherfiltergridap");
        filterGrid.setEntityNumber("gl_voucher");
        this.setVoucherFilterFields(filterGrid);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        if (SLTreeNode.isAccountNode((String)evt.getNodeId()) && ReportUtils.checkIfDetailOutOfLimit((ReportQueryParam)this.getView().getQueryParam()).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u8303\u56f4\u7684\u51ed\u8bc1\u6570\u636e\u91cf\u8d85\u51fa\u9650\u5236\uff0c\u8d85\u51fa\u9650\u5236\u7684\u671f\u95f4\u5c06\u4e0d\u518d\u5c55\u793a\uff0c\u5982\u9700\u663e\u793a\u5168\u90e8\u6570\u636e\uff0c\u8bf7\u4f7f\u7528\u5bfc\u51fa\u529f\u80fd\u3002", (String)"SubLedgerFormRpt_100", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
        }
    }

    private void setVoucherFilterFields(FilterGrid filterGrid) {
        List filterFileds = ReportFieldSettingUtil.getFilterFieldConfigs((String)"gl_rpt_subledger");
        filterGrid.setFilterFieldKeys(filterFileds);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "exportcuracc"});
        ReportList list = (ReportList)this.getControl(REPORT_LIST_AP);
        list.addHyperClickListener(evt -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(REPORT_LIST_AP);
            IReportListModel reportModel = list.getReportModel();
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            Long orgID = rowData.getLong("orgname.id");
            switch (evt.getFieldName()) {
                case "voucherno": {
                    long voucherId = rowData.getLong("voucherid");
                    if (voucherId == 0L) break;
                    this.viewVoucher(voucherId, orgID, reportModel);
                    break;
                }
                case "assgrp": {
                    DynamicObject assgrp = rowData.getDynamicObject(ASSGRP);
                    String val = assgrp.getString("value");
                    if (StringUtils.isEmpty((String)val)) break;
                    Map valueMap = (Map)SerializationUtils.fromJsonString((String)val, Map.class);
                    ReportTree tree = (ReportTree)this.getControl("reporttreeap");
                    String focusNodeId = tree.getTreeState().getFocusNodeId();
                    if (focusNodeId == null) {
                        focusNodeId = this.getPageCache().get("foucusid");
                    }
                    if (!SLTreeNode.isAccountNode(focusNodeId)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de6\u8fb9\u79d1\u76ee\u6811\u7ed3\u6784\u8bf7\u9009\u62e9\u79d1\u76ee\u8282\u70b9\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SubLedgerFormRpt_13", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                        return;
                    }
                    this.viewAsstledger(Collections.singletonList(orgID), valueMap, Long.valueOf(focusNodeId));
                    break;
                }
                case "opassgrp": {
                    Long opAccountId = rowData.getLong("opaccount_id");
                    DynamicObject opAssgrp = rowData.getDynamicObject("opassgrp");
                    String opVal = opAssgrp.getString("value");
                    if (StringUtils.isEmpty((String)opVal)) break;
                    Map valueMap = (Map)SerializationUtils.fromJsonString((String)opVal, Map.class);
                    this.viewAsstledger(Collections.singletonList(orgID), valueMap, opAccountId);
                    break;
                }
                case "opacctname": {
                    Long opAccId = rowData.getLong("opaccount_id");
                    this.viewSubLedger(orgID, opAccId);
                    break;
                }
            }
        });
        MulBasedataEdit orgs4Export = (MulBasedataEdit)this.getControl("orgs4export");
        orgs4Export.addBeforeF7SelectListener(evt -> evt.addCustomQFilter(AccSysUtil.getAcctOrgFilter((String)SubLedgerSchema.INSTANCE.entity, (boolean)false, (PermissonType)PermissonType.EXPORT)));
        ProgressBar exportBar = (ProgressBar)this.getControl(SubLedgerSchema.INSTANCE.multiOrgsExportBar.toString());
        exportBar.addProgressListener((ProgresssListener)this);
    }

    @Override
    protected BasedataEdit getOrgEdit() {
        return (BasedataEdit)this.getControl("orgs");
    }

    @Override
    protected List<Long> getOrgValue() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
        return orgs.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    @Override
    protected void setDefaultOrg(Long orgId) {
        if (orgId == null || orgId == 0L) {
            this.getModel().setValue("orgs", null);
        } else {
            this.getModel().setValue("orgs", (Object)new Long[]{orgId});
        }
    }

    @Override
    protected List<Long> getFilterOrg(FilterInfo filterInfo) {
        List value;
        ArrayList<Long> result = new ArrayList<Long>();
        FilterItemInfo itemInfo = filterInfo.getFilterItem("orgs");
        if (itemInfo != null && (value = (List)itemInfo.getValue()) != null) {
            for (DynamicObject dyn : value) {
                result.add(dyn.getLong("id"));
            }
        }
        return result;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        DynamicObject periodType = (DynamicObject)model.getValue("periodtype");
        if (periodType != null) {
            long typeid = periodType.getLong("id");
            switch (e.getProperty().getName()) {
                case "dateend": {
                    Date newDate = (Date)e.getChangeSet()[0].getNewValue();
                    long pid = this.getPeriodIdByDate(newDate, typeid);
                    model.setValue("endperiod", (Object)pid);
                    view.updateView("endperiod");
                    break;
                }
                case "datebegin": {
                    Date newDate = (Date)e.getChangeSet()[0].getNewValue();
                    long pid = this.getPeriodIdByDate(newDate, typeid);
                    model.setValue("startperiod", (Object)pid);
                    view.updateView("startperiod");
                    break;
                }
                case "fieldcombo": {
                    if (DC.equals(e.getChangeSet()[0].getNewValue())) {
                        view.setEnable(Boolean.valueOf(false), e.getChangeSet()[0].getRowIndex(), new String[]{SORTCOMBO});
                        break;
                    }
                    view.setEnable(Boolean.valueOf(true), e.getChangeSet()[0].getRowIndex(), new String[]{SORTCOMBO});
                    break;
                }
                case "org": 
                case "searchtype": 
                case "booktype": 
                case "periodtype": {
                    this.replaceSetPeriod(model, typeid, (IFormView)view);
                    break;
                }
                case "orgs4export": {
                    this.multipleOrgExport();
                    break;
                }
            }
        }
        if (SEARCHTYPE.equals(e.getProperty().getName())) {
            this.hideNoZeroBalanceButton();
        }
    }

    private void hideNoZeroBalanceButton() {
        int searchType = Integer.parseInt((String)this.getModel().getValue(SEARCHTYPE));
        if (2 == searchType) {
            this.getView().getModel().setValue("balancezero", (Object)Boolean.FALSE);
            this.getView().setVisible(Boolean.FALSE, new String[]{"balancezero"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"balancezero"});
        }
    }

    private void multipleOrgExport() {
        List orgs = ((DynamicObjectCollection)this.getModel().getValue("orgs4export")).stream().map(orgDyo -> orgDyo.getLong("fbasedataid_id")).collect(Collectors.toList());
        Context context = new Context().registerContext(SubLedgerSchema.INSTANCE.orgs4Export, orgs).registerContext(JobExecuteFormSchema.INSTANCE.Param_ParentPageID, (Object)this.getView().getPageId());
        FormJobExecutor.execute(SubLedgerMultiOrgExportJobInfo.class, Collections.singletonList(MultiOrgExportJobListener.class.getTypeName()), context, (IFormView)this.getView());
    }

    private void replaceSetPeriod(IDataModel model, long typeid, IFormView view) {
        int searchType;
        if ("gl_rpt_subledger".equals(this.getView().getEntityId()) && 2 == (searchType = Integer.parseInt((String)this.getModel().getValue(SEARCHTYPE)))) {
            Date dateBegin = (Date)model.getValue("datebegin");
            long pid = this.getPeriodIdByDate(dateBegin, typeid);
            model.setValue("startperiod", (Object)pid);
            view.updateView("startperiod");
            Date dateEnd = (Date)model.getValue("dateend");
            pid = this.getPeriodIdByDate(dateEnd, typeid);
            model.setValue("endperiod", (Object)pid);
            view.updateView("endperiod");
        }
    }

    private Long getPeriodIdByDate(Date date, long typeid) {
        QFilter qtype = new QFilter("periodtype", "=", (Object)typeid);
        QFilter qbegin = new QFilter("begindate", "<=", (Object)date);
        QFilter qend = new QFilter("enddate", ">=", (Object)date);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])new QFilter[]{qtype, qbegin, qend}, (String)"id desc", (int)-1);
        if (ids.isEmpty()) {
            return 0L;
        }
        return (Long)ids.get(0);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("syncexportall".equals(key)) {
            String entityID;
            if (this.isNoAccountNode()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5bfc\u51fa\u3002", (String)"SubLedgerFormRpt_101", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                return;
            }
            List orgIdList = this.getMulOrgQPRpt().getAllEntityOrgs();
            if (!GLUtil.hasPermission((String)"0YH1MN9OTQ4J", (List)orgIdList, (String)(entityID = "gl_rpt_subledger"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5206\u914d\u5bfc\u51fa\u6743\u9650\u3002", (String)"SubsiDiaryTreeFormRpt_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            ReportQueryParam queryParam = this.getView().getQueryParam();
            HashMap<String, Object> selectObj = new HashMap<String, Object>(8);
            selectObj.put("filefilter", "1");
            selectObj.put("orderfilter", "1");
            selectObj.put("sheetlimit", 0);
            selectObj.put("orgIdList", orgIdList);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("gl_reportexportall_subsi");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.getCustomParams().put("entitynumber", this.getView().getEntityId());
            showParameter.getCustomParams().put("entityid", entityID);
            showParameter.getCustomParams().put("entityname", this.getView().getFormShowParameter().getFormConfig().getCaption().toString());
            showParameter.getCustomParams().put("selectobj", SerializationUtils.serializeToBase64(selectObj));
            showParameter.getCustomParams().put("queryparam", SerializationUtils.serializeToBase64((Object)queryParam));
            this.getView().showForm(showParameter);
            return;
        }
        if ("syncexportall_old".equals(key)) {
            try {
                this.syncexportall();
            }
            catch (Throwable e) {
                ReportQueryParam queryParam = this.getQueryParam();
                queryParam.getFilter().getFilterItems().removeIf(filterItemInfo -> EXPORT_EXCEL.equals(filterItemInfo.getPropName()));
                queryParam.getFilter().getFilterItems(EXPORT_EXCEL).clear();
                queryParam.getFilter().addFilterItem(EXPORT_EXCEL, (Object)false);
                ReportCacheManager.getInstance().getCache().setReportQueryParam(this.getView().getPageId(), queryParam);
                throw e;
            }
            return;
        }
        if ("multipleorgexportall".equals(key)) {
            MulBasedataEdit orgs4Export = (MulBasedataEdit)this.getControl("orgs4export");
            orgs4Export.setF7Click(true);
            orgs4Export.click();
        }
        if ("barsubsidiarydetail".equals(key)) {
            AccountBookInfo book;
            List<Long> orgIDs = this.getOrgIdsFromFilter();
            FilterInfo subLedgerFilterInfo = this.getQueryParam().getFilter();
            long bookType = subLedgerFilterInfo.getLong("booktype");
            String linkedFormId = "t_rpt_aux_subledger";
            if (orgIDs.size() == 1 && (book = AccSysUtil.getBookFromAccSys((long)orgIDs.get(0), (long)bookType)) != null && book.isIsbizunit()) {
                linkedFormId = "gl_rpt_subsidiaryledger";
            }
            if (!GLUtil.hasPermission((String)PermissonType.VIEW.getPermId(), orgIDs, (String)linkedFormId)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u201c%s\u201d\u67e5\u8be2\u6743\u9650\u3002", (String)"SubLedgerFormRpt_10", (String)"fi-gl-formplugin", (Object[])new Object[0]), EntityMetadataCache.getDataEntityType((String)linkedFormId).getDisplayName().getLocaleValue()));
                return;
            }
            this.querySubsidiarydetail();
        }
        if ("setfield".equals(key)) {
            if (!AccSysUtil.isPerm((String)this.getView().getEntityId(), (String)"3+T3DWZJF6/L")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8bbe\u7f6e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SubLedgerFormRpt_14", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("gl_report_field_seting");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("form_id", (Object)"gl_rpt_subledger");
            this.getView().showForm(parameter);
        }
    }

    private void syncexportall() {
        ReportQueryParam queryParam = this.getQueryParam();
        DynamicObjectCollection accountColl = (DynamicObjectCollection)queryParam.getFilter().getValue("account");
        if (accountColl != null && accountColl.isEmpty()) {
            accountColl = null;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("gl_reportexportall");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("entitynumber", this.getView().getEntityId());
        showParameter.getCustomParams().put("entityname", this.getView().getFormShowParameter().getFormConfig().getCaption().toString());
        FilterInfo filter = queryParam.getFilter();
        if (filter.getFilterItems().size() > 0) {
            filter.getFilterItem(EXPORT_EXCEL).setValue((Object)true);
        }
        showParameter.getCustomParams().put("queryparam", SerializationUtils.serializeToBase64((Object)queryParam));
        this.getView().showForm(showParameter);
    }

    private void viewSubLedger(Long orgID, Long opAccId) {
        ReportShowParameter report = new ReportShowParameter();
        report.setFormId("gl_rpt_subledger");
        report.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        FilterInfo filter = new FilterInfo();
        List<String> ignoreFilterItem = Arrays.asList("orgs", "org", "showrpt", "account");
        for (FilterItemInfo item : this.getQueryParam().getFilter().getFilterItems()) {
            String propName = item.getPropName();
            if (ignoreFilterItem.contains(propName)) continue;
            filter.addFilterItem(propName, item.getValue(), item.getCompareType());
        }
        DynamicObjectType orgType = this.getQueryParam().getFilter().getDynamicObjectCollection("orgs").getDynamicObjectType();
        DynamicObjectCollection orgDyos = new DynamicObjectCollection(orgType, null, Collections.singletonList(BusinessDataServiceHelper.load((Object[])new Object[]{orgID}, (DynamicObjectType)orgType)[0]));
        filter.addFilterItem("orgs", (Object)orgDyos);
        filter.addFilterItem("account", (Object)opAccId);
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filter);
        report.setQueryParam(queryParam);
        this.getView().showForm((FormShowParameter)report);
    }

    private void viewAsstledger(List<Long> orgIDs, Map<String, Object> flexValue, Long accountId) {
        String mulCurType;
        AccountBookInfo book;
        FilterInfo subLedgerFilterInfo = this.getQueryParam().getFilter();
        long bookType = subLedgerFilterInfo.getLong("booktype");
        String linkedFormId = "t_rpt_aux_subledger";
        if (orgIDs.size() == 1 && (book = AccSysUtil.getBookFromAccSys((long)orgIDs.get(0), (long)bookType)) != null && book.isIsbizunit()) {
            linkedFormId = "gl_rpt_subsidiaryledger";
        }
        if ("t_rpt_aux_subledger".equals(linkedFormId) && (mulCurType = subLedgerFilterInfo.getString("mulcur")) != null && !"LocalCurrency".equals(mulCurType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u591a\u672c\u4f4d\u5e01\u8054\u67e5\u591a\u7ec4\u7ec7\u8f85\u52a9\u660e\u7ec6\u8d26\u3002", (String)"SubLedgerFormRpt_16", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            return;
        }
        ReportShowParameter report = new ReportShowParameter();
        report.setFormId(linkedFormId);
        report.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        FilterInfo filter = new FilterInfo();
        List<String> ignoreFilterItem = Arrays.asList("showrpt", "account", "issupvir");
        long periodType = subLedgerFilterInfo.getLong("periodtype");
        boolean searchByDate = "2".equals(subLedgerFilterInfo.getString(SEARCHTYPE));
        for (Object item : subLedgerFilterInfo.getFilterItems()) {
            String string = item.getPropName();
            if (!ignoreFilterItem.contains(string)) {
                filter.addFilterItem(string, item.getValue(), item.getCompareType());
            }
            if ("nodisplayforzeroamount".equals(string)) {
                filter.addFilterItem("nozeroperiod", item.getValue(), item.getCompareType());
            }
            if (!searchByDate || !"startperiod".equals(string) && !"endperiod".equals(string)) continue;
            Date date = subLedgerFilterInfo.getDate("startperiod".equals(string) ? "datebegin" : "dateend");
            filter.getFilterItem(string).setValue((Object)this.getPeriodIdByDate(date, periodType));
        }
        filter.addFilterItem("org", (Object)orgIDs.get(0));
        List flexFilter = filter.getFlexFilterItems();
        for (Map.Entry entry : flexValue.entrySet()) {
            HashSet val = new HashSet();
            Object value = entry.getValue();
            if (value != null) {
                val.add(value);
            }
            flexFilter.add(new FilterItemInfo((String)entry.getKey(), val, "in"));
        }
        long acctTableId = subLedgerFilterInfo.getLong("accounttable");
        if (linkedFormId.equals("gl_rpt_subsidiaryledger")) {
            DataSet accountDataSet;
            String number = BusinessDataServiceHelper.loadSingleFromCache((Object)accountId, (String)"bd_accountview", (String)"number").getString("number");
            Long orgId = orgIDs.get(0);
            Date endDate = PeriodService.getEndDate((long)filter.getLong("endperiod"));
            if (endDate != null && (accountDataSet = AccountUtils.getAccountDataSet((long)orgId, (long)acctTableId, (Date)endDate, (boolean)false, (QFilter)new QFilter("number", "=", (Object)number), (String[])new String[]{"id"})).hasNext()) {
                accountId = accountDataSet.next().getLong("id");
            }
        }
        filter.addFilterItem("account", (Object)accountId);
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filter);
        report.setQueryParam(queryParam);
        report.setCustomParam("accounttable", (Object)String.valueOf(acctTableId));
        this.getView().showForm((FormShowParameter)report);
    }

    protected void viewVoucher(Long id, Long orgId, IReportListModel reportModel) {
        VoucherUtil.hyperVoucher((long)orgId, (long)id, (IFormView)this.getView(), VoucherUtil.getVoucherIdList(reportModel, "voucherid", this.getModel().getEntryCurrentRowIndex(REPORT_LIST_AP)));
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterGrid filterGrid = (FilterGrid)this.getControl("voucherfiltergridap");
        FilterCondition cond = filterGrid.getFilterGridState().getFilterCondition();
        ITimeService timeService = (ITimeService)this.getView().getService(ITimeService.class);
        IUserService userService = (IUserService)this.getView().getService(IUserService.class);
        FilterInfo filter = queryParam.getFilter();
        filter.addCommFilter("gl_voucher", cond, timeService, userService);
        filter.addFilterItem(EXPORT_EXCEL, (Object)false);
        queryParam.getCustomParam().put("flexorgidfield", "flexorgid");
        if (DebugTrace.enable()) {
            String isvId = ISVService.getISVInfo().getId();
            LOGGER.info("SubLedgerFormRpt_isvId:" + isvId);
        }
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection sortEntry;
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo.getLong("orgview") == 0L) {
            Set mainViewIds;
            DynamicObject defaultView = null;
            DynamicObjectCollection orgs = filterInfo.getDynamicObjectCollection("orgs");
            if (!CollectionUtils.isEmpty((Collection)orgs) && (mainViewIds = AccSysUtil.getViewByOrg((Long)((DynamicObject)orgs.get(0)).getLong("id"))).size() > 0) {
                defaultView = BusinessDataServiceHelper.loadSingle(mainViewIds.iterator().next(), (String)"bd_accountingsysviewsch");
            }
            if (!filterInfo.containProp("orgview")) {
                filterInfo.addFilterItem("orgview", defaultView);
            } else {
                filterInfo.getFilterItem("orgview").setValue(defaultView);
            }
        }
        if (!super.verifyQuery(queryParam)) {
            return false;
        }
        if (this.getModel().getDataEntityType().getProperties().get((Object)CUSTOMSORTENTRY) != null && Objects.nonNull(sortEntry = this.getModel().getEntryEntity(CUSTOMSORTENTRY))) {
            Set voucherFields = SubLedgerSortFieldEnum.getAllSortFieldNumbers();
            voucherFields.addAll(MetadataServiceHelper.getDataEntityType((String)"gl_voucher").getAllFields().keySet());
            HashSet<String> fieldSet = new HashSet<String>(10);
            for (DynamicObject sortRow : sortEntry) {
                String fieldName = sortRow.getString(FIELDCOMBO);
                if (!fieldSet.add(fieldName)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6392\u5e8f\u5b57\u6bb5\u4e0d\u80fd\u91cd\u590d\u3002", (String)"SubsiDiaryTreeFormRpt_11", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (fieldName.startsWith("entries")) {
                    fieldName = fieldName.substring(8);
                }
                if (voucherFields.contains(fieldName)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u51ed\u8bc1\u65e0\u6b64\u5b57\u6bb5\uff0c\u8bf7\u4fee\u6539\u81ea\u5b9a\u4e49\u6392\u5e8f\u5b57\u6bb5\u3002", (String)"SubsiDiaryTreeFormRpt_15", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return false;
            }
            this.setOtherEntryFilter(filterInfo);
        }
        return true;
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        DynamicObjectCollection sortEntry;
        super.setOtherEntryFilter(filterInfo);
        if (this.getModel().getDataEntityType().getProperties().get((Object)CUSTOMSORTENTRY) != null && Objects.nonNull(sortEntry = this.getModel().getEntryEntity(CUSTOMSORTENTRY))) {
            HashMap otherEntryFilter = new HashMap();
            ArrayList<DynamicObject> saveEntrys = new ArrayList<DynamicObject>();
            for (DynamicObject sortRow : sortEntry) {
                saveEntrys.add(sortRow);
            }
            otherEntryFilter.put(CUSTOMSORTENTRY, saveEntrys);
            filterInfo.setOtherEntryFilter(otherEntryFilter);
        }
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        DynamicObjectCollection sortEntry;
        super.loadOtherEntryFilter(scheme);
        if (scheme.getDataEntityType().getProperties().get((Object)CUSTOMSORTENTRY) != null && (sortEntry = scheme.getDynamicObjectCollection(CUSTOMSORTENTRY)) != null && !sortEntry.isEmpty()) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.deleteEntryData(CUSTOMSORTENTRY);
            model.batchCreateNewEntryRow(CUSTOMSORTENTRY, sortEntry.size());
            for (int i = 0; i < sortEntry.size(); ++i) {
                DynamicObject sortRow = (DynamicObject)sortEntry.get(i);
                model.setValue(FIELDCOMBO, (Object)sortRow.getString(FIELDCOMBO), i);
                model.setValue(SORTCOMBO, (Object)sortRow.getString(SORTCOMBO), i);
            }
            model.endInit();
            this.getView().updateView(CUSTOMSORTENTRY);
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        this.collapseTreePanel();
        FilterInfo filter = event.getQueryParam().getFilter();
        String currencyId = filter.getString("currency");
        boolean exportexcel = filter.getBoolean(EXPORT_EXCEL) || this.isExportExcel();
        boolean isBaseCurrency = this.isBasecurrency(filter);
        DynamicObject account = null;
        if (event.getSelectedObj() instanceof DynamicObject) {
            account = (DynamicObject)event.getSelectedObj();
        }
        boolean showCurrencyCol = currencyId == null || currencyId.equals("allcurrency");
        boolean showQty = filter.getBoolean("showqty") || filter.getBoolean("showsumqty");
        boolean showPrice = this.isShowPrice(showQty, this.getParentOrg());
        HashSet<String> vchMcFields = new HashSet<String>();
        for (LocalCurrencyConfigVO configVO : LocalCurrencyConfigService.queryEnableCurrencies()) {
            configVO.getVoucherFields(new MCT[]{MCT.CREDIT, MCT.DEBIT}).forEach(metaField -> vchMcFields.add(metaField.getMetaId()));
        }
        Map<String, String> colWidth = this.getColWidth(showCurrencyCol, exportexcel, isBaseCurrency, showQty, showPrice, account, false);
        this.setColumnStyle(event.getColumns(), colWidth, isBaseCurrency, vchMcFields);
    }

    private MulOrgQPRpt getMulOrgQPRpt() {
        if (this.mulOrgQPRpt == null) {
            this.mulOrgQPRpt = new MulOrgQPRpt(this.getView().getQueryParam().getFilter(), "gl_rpt_subledger");
        }
        return this.mulOrgQPRpt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isBasecurrency(FilterInfo filter) {
        String curType = filter.getString("mulcur");
        MulOrgQPRpt mulOrgQPRpt = this.getMulOrgQPRpt();
        List allEntityOrgs = mulOrgQPRpt.getAllEntityOrgs();
        String currencyId = filter.getString("currency");
        if (Objects.isNull(curType) || "LocalCurrency".equals(curType)) {
            Stream<String> baseCurrencyStream = AccSysUtil.getBookFromAccSys(new HashSet(allEntityOrgs), (long)filter.getLong("booktype")).stream().map(AccountBookInfo::getBaseCurrencyId).map(Object::toString);
            if (currencyId == null) return false;
            if (currencyId.equals("basecurrency")) return true;
            if (!baseCurrencyStream.allMatch(currencyId::equals)) return false;
            return true;
        }
        long localeCur = LocalCurrencyConfigService.getCurrencyConfig((String)curType).getCurrencyId(((Long)allEntityOrgs.get(0)).longValue(), mulOrgQPRpt.getBookType());
        if (currencyId == null) return false;
        if (currencyId.equals("basecurrency")) return true;
        if (!(localeCur + "").equals(currencyId)) return false;
        return true;
    }

    private void collapseTreePanel() {
        TreeModel reportTreeModel = ReportCacheManager.getInstance().getCache().getReportTreeModel(this.getView().getPageId());
        if (reportTreeModel != null) {
            List collect = reportTreeModel.getNodes().stream().filter(treeNode -> treeNode.getText().split(" ").length > 1).collect(Collectors.toList());
            SplitContainer splitContainer = (SplitContainer)this.getView().getControl("splitcontainerap");
            splitContainer.setCollapse("treesplitpanel", collect.size() == 1);
        }
    }

    private void setColumnStyle(List<AbstractReportColumn> columns, Map<String, String> colWidth, boolean isBaseCurrency, Set<String> vchMcFields) {
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                ReportColumn col = (ReportColumn)column;
                String key = col.getFieldKey();
                String width = colWidth.get(key);
                if (ZERO.equals(width)) {
                    col.setHide(true);
                } else {
                    col.setWidth(new LocaleString(width));
                    if (key.endsWith("local") && isBaseCurrency && !vchMcFields.contains(key)) {
                        col.setCaption(SubLedgerFormRpt.getTxtAmount());
                    }
                }
                if (!isBaseCurrency || !"localrate".equals(key)) continue;
                col.setHide(true);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            ReportColumnGroup colGroup = (ReportColumnGroup)column;
            this.setColumnStyle(colGroup.getChildren(), colWidth, isBaseCurrency, vchMcFields);
        }
    }

    protected Map<String, String> getColWidth(boolean showCurrencyCol, boolean exportExcel, boolean isBaseCurrency, boolean showQty, boolean showPrice, DynamicObject account, boolean isShowAccount) {
        boolean showAssGrp = false;
        if (account != null) {
            MulOrgQPRpt mulOrgQPRpt = this.getMulOrgQPRpt();
            List entityOrgs = mulOrgQPRpt.getAllEntityOrgs();
            DataSet accountDataSet = AccountUtils.getAccountDataSet((List)entityOrgs, (long)mulOrgQPRpt.getAccountTable(), (Date)mulOrgQPRpt.getFilterInfo().getDynamicObject("endperiod").getDate("enddate"), (boolean)false, (QFilter)new QFilter("number", "=", (Object)account.getString("number")), (String[])new String[]{"isassist"});
            for (Row row : accountDataSet) {
                if (!row.getBoolean("isassist").booleanValue()) continue;
                showAssGrp = true;
                accountDataSet.close();
                break;
            }
        }
        HashMap<String, String> colWidth = new HashMap<String, String>(22);
        boolean min = isBaseCurrency && !showQty;
        boolean max = !isBaseCurrency || showQty;
        String forWidth = this.getAmountColWidth(min, max);
        colWidth.put(ACCOUNT, exportExcel || isShowAccount ? "8%" : ZERO);
        colWidth.put(ACCOUNT_NAME, exportExcel || isShowAccount ? "10%" : ZERO);
        colWidth.put(BK_DATE, min ? "8%" : "6%");
        colWidth.put(BIZ_DATE, min ? "8%" : "6%");
        colWidth.put(VCH_NUM, min && !showAssGrp ? "15%" : "10%");
        colWidth.put(DESC, min && !showAssGrp ? "15%" : "10%");
        colWidth.put(UNIT, showQty ? "5%" : ZERO);
        colWidth.put(CURRNECY, showCurrencyCol ? "6%" : ZERO);
        colWidth.put(ASSGRP, showAssGrp ? "15%" : ZERO);
        colWidth.put(DEBIT_QTY, showQty ? "9%" : ZERO);
        colWidth.put(DEBIT_PRICE, showPrice ? "9%" : ZERO);
        colWidth.put(DEBIT_FOR, isBaseCurrency ? ZERO : "9%");
        colWidth.put(DEBIT_LOCAL, forWidth);
        colWidth.put(CREDIT_QTY, showQty ? "9%" : ZERO);
        colWidth.put(CREDIT_PRICE, showPrice ? "9%" : ZERO);
        colWidth.put(CREDIT_FOR, isBaseCurrency ? ZERO : "9%");
        colWidth.put(CREDIT_LOCAL, forWidth);
        colWidth.put(DC, "4%");
        colWidth.put(END_QTY, showQty ? "9%" : ZERO);
        colWidth.put(END_PRICE, showPrice ? "9%" : ZERO);
        colWidth.put(END_FOR, isBaseCurrency ? ZERO : "9%");
        colWidth.put(END_LOCAL, forWidth);
        return colWidth;
    }

    private String getAmountColWidth(boolean min, boolean max) {
        if (min) {
            return "15%";
        }
        return max ? "9%" : "12%";
    }

    private boolean isExportExcel() {
        StackTraceElement[] stackTrace;
        boolean isExportExcel = false;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            String methodName = element.getMethodName();
            if (!methodName.equals("exportExcel")) continue;
            isExportExcel = true;
            break;
        }
        return isExportExcel;
    }

    public void processRowData(String gridId, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        Date dateEnd = filter.getDate("dateend");
        Long defaultOrg = this.getParentOrg();
        boolean isBaseCur = this.isBasecurrency(filter);
        boolean showPrice = this.isShowPrice(filter.getBoolean("showqty") || filter.getBoolean("showsumqty"), defaultOrg);
        int searchType = filter.getInt(SEARCHTYPE);
        String s1 = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"SubLedgerFormRpt_1", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        String s3 = ResManager.loadKDString((String)"\u672c\u65e5\u5408\u8ba1", (String)"SubLedgerFormRpt_2", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        String s4 = ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"SubLedgerFormRpt_3", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        String s5 = ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"SubLedgerFormRpt_4", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        Map<Long, Date> periodDateMap = this.getPeriodDateMap();
        String accountNameField = GLUtil.getAcctNameBySysParam((Long)defaultOrg);
        HashMap<Long, DynamicObjectCollection> org2RowDatas = new HashMap<Long, DynamicObjectCollection>();
        List displayFields = ReportFieldSettingUtil.getDisplayFieldConfigList((String)this.getView().getEntityId());
        Map vchMap = ReportUtils.getVoucherInfo((List)displayFields, (DynamicObjectCollection)rowData);
        for (DynamicObject row2 : rowData) {
            DynamicObject voucherObj;
            Long fentryid;
            DynamicObject opAcct;
            String rowType;
            long orgID = row2.getLong("orgname_id");
            DynamicObjectCollection sameOrgRows2 = org2RowDatas.getOrDefault(orgID, new DynamicObjectCollection(rowData.getDynamicObjectType(), rowData.getParent()));
            sameOrgRows2.add((Object)row2);
            org2RowDatas.putIfAbsent(orgID, sameOrgRows2);
            Date bookedDate = null;
            long period = row2.getLong("period_id");
            if (Objects.nonNull(periodDateMap.get(period))) {
                bookedDate = searchType == 2 && dateEnd.before(periodDateMap.get(period)) ? dateEnd : periodDateMap.get(period);
            }
            if ("1".equals(rowType = row2.getString("rowtype"))) {
                row2.set(DESC, (Object)s1);
            } else if ("3".equals(rowType)) {
                row2.set(DESC, (Object)s3);
            } else if ("4".equals(rowType)) {
                row2.set(DESC, (Object)s4);
                row2.set("bookeddate", (Object)bookedDate);
            } else if ("5".equals(rowType)) {
                row2.set(DESC, (Object)s5);
                row2.set("bookeddate", (Object)bookedDate);
            }
            DynamicObject account = row2.getDynamicObject(ACCOUNT);
            if (account == null) continue;
            row2.set(ACCOUNT_NAME, (Object)account.getString(accountNameField));
            BigDecimal endLocal = row2.getBigDecimal(END_LOCAL);
            if (endLocal == null || GLUtil.isZero((BigDecimal)endLocal)) {
                row2.set(DC, (Object)ZERO);
                row2.set(END_PRICE, (Object)BigDecimal.ZERO);
            } else {
                String dc = account.getString(DC);
                row2.set(DC, (Object)dc);
                if (dc.equals("-1")) {
                    row2.set(END_FOR, (Object)row2.getBigDecimal(END_FOR).negate());
                    row2.set(END_LOCAL, (Object)row2.getBigDecimal(END_LOCAL).negate());
                    if (filter.getBoolean("showqty") || filter.getBoolean("showsumqty")) {
                        row2.set(END_QTY, (Object)row2.getBigDecimal(END_QTY).negate());
                    }
                    if (filter.getBoolean("showrpt")) {
                        row2.set(END_RPT, (Object)row2.getBigDecimal(END_RPT).negate());
                    }
                }
            }
            if (filter.getBoolean("showopaccount") && Objects.nonNull(opAcct = row2.getDynamicObject("opaccount"))) {
                row2.set("opacctname", (Object)(opAcct.getString("number") + " " + opAcct.getString(accountNameField)));
            }
            if ((fentryid = Long.valueOf(row2.getLong("fentryid"))) == 0L || displayFields == null || displayFields.isEmpty() || Objects.isNull(voucherObj = (DynamicObject)vchMap.get(fentryid))) continue;
            for (ReportFieldSettingVo vo : displayFields) {
                row2.set(vo.getField(), voucherObj.get(vo.getFieldMark()));
            }
        }
        org2RowDatas.forEach((org, sameOrgRows) -> {
            List<String> amountTypes = this.getAmountTypesNew(sameOrgRows.getDynamicObjectType().getProperties());
            ShowByAccountDCParam param = new ShowByAccountDCParam(org, Long.valueOf(queryParam.getFilter().getLong("accounttable")));
            param.setMergeDebitAndCreditCol(Boolean.TRUE);
            param.setAmountTypes(amountTypes);
            param.addBalAndDCField("end", DC);
            param.setQtyField(END_QTY);
            ReportUtils.showRowDataByActDC((ShowByAccountDCParam)param, (DynamicObjectCollection)sameOrgRows, (boolean)true);
        });
        rowData.forEach(row -> this.dealPrice(isBaseCur, showPrice, (DynamicObject)row, row.getString("rowtype")));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String key = source.getOperateKey();
        if (EXPORT_EXCEL.equals(key) && this.isNoAccountNode()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5bfc\u51fa\u3002", (String)"SubLedgerFormRpt_101", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        switch (key) {
            case "printpreview": 
            case "exportexcel": {
                List ids;
                TreeView reportTree = (TreeView)this.getView().getControl("reporttreeap");
                if (reportTree == null || (ids = reportTree.getTreeState().getSelectedNodeId()).isEmpty() || SLTreeNode.isAccountNode((String)ids.get(0))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de6\u8fb9\u79d1\u76ee\u6811\u7ed3\u6784\u8bf7\u9009\u62e9\u79d1\u76ee\u8282\u70b9\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SubLedgerFormRpt_13", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    TreeModel getTreeModel() {
        return ReportCacheManager.getInstance().getCache().getReportTreeModel(this.getView().getPageId());
    }

    boolean isNoAccountNode() {
        return this.getTreeModel().getNodes().size() <= 1;
    }

    private void dealPrice(boolean isBaseCur, boolean showPrice, DynamicObject row, String rowtype) {
        if (showPrice) {
            BigDecimal qty;
            String endBal = END_LOCAL;
            String suffix = "local";
            if (!isBaseCur) {
                endBal = END_FOR;
                suffix = "for";
            }
            if ((qty = row.getBigDecimal(END_QTY)).compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal end = row.getBigDecimal(endBal);
                row.set(END_PRICE, (Object)end.divide(qty, 10, 4).abs());
            } else {
                row.set(END_PRICE, (Object)BigDecimal.ZERO);
            }
            switch (rowtype) {
                case "3": 
                case "4": 
                case "5": {
                    String s = "debit#,credit#";
                    for (String field : s.split(",")) {
                        String qtyS = field.replace("#", "qty");
                        BigDecimal qtyB = row.getBigDecimal(qtyS);
                        String localS = field.replace("#", suffix);
                        String priceS = field.replace("#", "price");
                        if (qtyB.compareTo(BigDecimal.ZERO) != 0) {
                            BigDecimal priceB = row.getBigDecimal(localS).divide(qtyB, 10, 4).abs();
                            row.set(priceS, (Object)priceB);
                            continue;
                        }
                        row.set(priceS, (Object)BigDecimal.ZERO);
                    }
                    break;
                }
            }
        }
    }

    private List<String> getAmountTypesNew(DataEntityPropertyCollection props) {
        ArrayList<String> amountTypes = new ArrayList<String>();
        amountTypes.add("for");
        amountTypes.add("local");
        amountTypes.add("rpt");
        return amountTypes;
    }

    private boolean isShowPrice(boolean showQty, Long org) {
        Boolean showPrice = (Boolean)GLUtil.getSystemParam((String)"p_showprice", (Long)org);
        if (showPrice == null) {
            return false;
        }
        return showQty && showPrice != false;
    }

    private Map<Long, Date> getPeriodDateMap() {
        return (Map)ThreadCache.get((Object)PERIOD_MAP_KEY, () -> {
            HashMap<Long, Date> result = new HashMap<Long, Date>();
            ReportQueryParam queryParam = this.getQueryParam();
            FilterInfo filter = queryParam.getFilter();
            long startperiod = filter.getLong("startperiod");
            long endperiod = filter.getLong("endperiod");
            QFilter periodTypeF = new QFilter("periodtype", "=", (Object)(endperiod / GLUtil.TYPE_PERIOD_L));
            QFilter beginFilter = new QFilter("id", ">=", (Object)startperiod);
            QFilter endFilter = new QFilter("id", "<=", (Object)endperiod);
            try (DataSet rs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".getPeriodIds"), (String)"bd_period", (String)"id,enddate", (QFilter[])new QFilter[]{periodTypeF, beginFilter, endFilter}, null);){
                for (Row r : rs) {
                    result.put(r.getLong(0), r.getDate(1));
                }
            }
            return result;
        });
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        boolean isSingleOrgManageMode;
        String formatedFilterString = evt.getFormatedFilterString();
        FilterInfo filter = evt.getFilter();
        if (Objects.equals(this.getPageCache().get("enableMulCur"), "true")) {
            formatedFilterString = GlFormUtil.getMulCurFormatedFilterString(filter.getString("mulcur"), formatedFilterString);
            evt.setFormatedFilterString(formatedFilterString);
        }
        if (isSingleOrgManageMode = SingleOrgContextHelper.isSingleOrgManageMode()) {
            return;
        }
        Long parentOrg = this.getParentOrg();
        String name = "";
        if (parentOrg != null && parentOrg != 0L) {
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)parentOrg, (String)"bos_org", (String)"name");
            name = org.getString("name");
        }
        evt.setFormatedFilterString(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7%1$s%2$s; %3$s", (String)"SubLedgerFormRpt_100", (String)"fi-gl-formplugin", (Object[])new Object[0]), "\uff1a", name, evt.getFormatedFilterString()));
        if (this.getModel().getValue(SEARCHTYPE) == null) {
            return;
        }
        int searchtype = Integer.parseInt((String)this.getModel().getValue(SEARCHTYPE));
        if (searchtype == 1) {
            return;
        }
        if (evt.getFilter().getDate("datebegin") == null) {
            return;
        }
        String dateformatStr = InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId());
        SimpleDateFormat format = new SimpleDateFormat(dateformatStr);
        String dateStr = String.format(ResManager.loadKDString((String)"\u65e5\u671f\uff1a%1$s ~ %2$s", (String)"SubLedgerFormRpt_9", (String)"fi-gl-formplugin", (Object[])new Object[0]), format.format(evt.getFilter().getDate("datebegin")), format.format(evt.getFilter().getDate("dateend")));
        String formatStr = evt.getFormatedFilterString();
        String[] split = formatStr.split("; ");
        StringBuilder result = new StringBuilder();
        if (split.length > 0) {
            result.append(split[0]);
            result.append(';');
            result.append(dateStr);
            result.append(';');
            result.append(split[split.length - 1]);
            evt.setFormatedFilterString(result.toString());
        }
    }

    private void querySubsidiarydetail() {
        TreeView reportTree = (TreeView)this.getView().getControl("reporttreeap");
        if (reportTree == null) {
            return;
        }
        if (this.isNoAccountNode()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u8054\u67e5\u3002", (String)"SubLedgerFormRpt_102", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            return;
        }
        String selId = null;
        List selectedNodeId = reportTree.getTreeState().getSelectedNodeId();
        if (CollectionUtils.isEmpty((Collection)selectedNodeId)) {
            selId = this.getPageCache().get("foucusid");
        } else if (SLTreeNode.isAccountNode((String)selectedNodeId.get(0))) {
            selId = (String)selectedNodeId.get(0);
        }
        if (selId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u8fb9\u660e\u7ec6\u8282\u70b9\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SubLedgerFormRpt_13", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            return;
        }
        Long accountId = Long.valueOf(selId);
        Long accountMid = BusinessDataServiceHelper.loadSingle((Object)accountId, (String)"bd_accountview", (String)"id, masterid").getLong("masterid");
        DynamicObject period = this.getQueryParam().getFilter().getDynamicObject("endperiod");
        Date endDate = period.getDate("enddate");
        QFilter fstartDate = new QFilter("startdate", "<=", (Object)endDate);
        QFilter fendDate = new QFilter("enddate", ">=", (Object)endDate);
        QFilter fmasterId = new QFilter("masterid", "=", (Object)accountMid);
        QFilter fids = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)this.getParentOrg());
        DynamicObject[] acctDyo = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"id,checkitementry.asstactitem", (QFilter[])new QFilter[]{fids, fstartDate, fendDate, fmasterId});
        DynamicObjectCollection acctEntry = null;
        if (acctDyo.length == 0) {
            DynamicObject acct = BusinessDataServiceHelper.loadSingle((Object)accountId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
            acctEntry = acct.getDynamicObjectCollection("checkitementry");
        } else {
            acctEntry = acctDyo[0].getDynamicObjectCollection("checkitementry");
        }
        if (acctEntry.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u6ca1\u6709\u6838\u7b97\u7ef4\u5ea6\uff0c\u4e0d\u80fd\u8054\u67e5\u3002", (String)"AccBalanceFormRpt_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> listmap = new HashMap<String, Object>();
        for (DynamicObject assgrp : acctEntry) {
            DynamicObject assit = assgrp.getDynamicObject("asstactitem");
            listmap.put(assit.getString("flexfield"), null);
        }
        this.viewAsstledger(this.getOrgIdsFromFilter(), listmap, accountId);
    }

    private List<Long> getOrgIdsFromFilter() {
        ReportQueryParam queryParam = this.getQueryParam();
        ArrayList<Long> orgs = new ArrayList<Long>(4);
        DynamicObjectCollection doc = queryParam.getFilter().getDynamicObjectCollection("orgs");
        if (CollectionUtils.isNotEmpty((Collection)doc)) {
            doc.forEach(x -> orgs.add(x.getLong("id")));
        }
        return orgs;
    }

    public void onProgress(ProgressEvent evt) {
        TaskInfo taskInfo;
        String taskID = this.getPageCache().get(JobExecuteFormSchema.INSTANCE.Param_TaskID.toTypeName());
        if (this.exportJobStatus() == JobExecuteEdit.JobStatus.backgrounded) {
            Optional.ofNullable(MultipleOrgReportExportTask.UrlManager.consume(taskID)).ifPresent(url -> {
                this.getView().download(url);
                this.getView().sendFormAction((IFormView)this.getView());
            });
        }
        if ((taskInfo = ScheduleServiceHelper.queryTask((String)taskID)) == null || taskInfo.isTaskEnd()) {
            JobExecuteEdit.JobStatus.changeJobStatus(this.getPageCache(), JobExecuteEdit.JobStatus.ended);
            evt.setProgress(100);
        }
    }

    private JobExecuteEdit.JobStatus exportJobStatus() {
        return JobExecuteEdit.JobStatus.jobStatus(this.getPageCache());
    }

    public void setExcelName(List<String> list) {
        super.setExcelName(list);
        if (SubLedgerSchema.INSTANCE.entity.equals(this.getView().getEntityId())) {
            String formName = MetadataServiceHelper.getDataEntityType((String)this.getView().getEntityId()).getDisplayName().getLocaleValue();
            FilterInfo filter = this.getQueryParam().getFilter();
            String orgName = this.getView().getPageCache().get("searchCondition").split(";  ")[0].split("\uff1a")[1];
            String bookName = filter.getDynamicObject("booktype").getLocaleString("name").getLocaleValue();
            String startPeriodName = filter.getDynamicObject("startperiod").getLocaleString("name").getLocaleValue();
            String endPeriodName = filter.getDynamicObject("endperiod").getLocaleString("name").getLocaleValue();
            String periodDesc = String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s", (String)"SubLedgerFormRpt_12", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), startPeriodName, endPeriodName);
            list.add(String.join((CharSequence)"-", formName, orgName, bookName, periodDesc));
        }
    }

    @Override
    public void afterSetModelValue(DynamicObject scheme) {
        super.afterSetModelValue(scheme);
        this.getView().setVisible(Boolean.valueOf(RptSearchType.of((String)scheme.getString(SEARCHTYPE)) == RptSearchType.byPeriod), new String[]{"balancezero"});
    }
}

