/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.constant.PrintFieldTypeEnum;
import kd.fi.gl.report.FlexPrintFormatter;
import kd.fi.gl.report.ReportPrintHelper;
import kd.fi.gl.report.SubsiDiaryRptPrint;
import kd.fi.gl.report.subledger.print.SLPrintPageKey;
import kd.fi.gl.util.ReportFieldSettingUtil;

public class SubLedgerRptPrintNew
extends AbstractPrintPlugin {
    private static final Log log = LogFactory.getLog(SubsiDiaryRptPrint.class);
    private static final String dataCacheKey = "SubLedgerRptPrint";
    private static final String rowDataCacheKey = "SubLedgerRptPrint_RowDatas";
    private static final String pageHeadCacheKey = "SubLedgerRptPrint_PageHead";
    private String[] rowDataStringFieldKeys = new String[]{"voucherno", "desc", "measureunit.name", "currencycolumn.name", "currencyrptid.name", "basecurrency.name"};
    private static final String[] rowDataFlexFieldKeys = new String[]{"assgrp", "opassgrp"};
    private static final String[] opAccountStringJointFields = new String[]{"opaccount.number", "opaccount.name"};
    private static final String[] rowDataDateFieldKeys = new String[]{"bizdate", "bookeddate"};
    private static final String[] rowDataAmountLocalFieldKeys = new String[]{"debitlocal", "creditlocal", "endlocal"};
    private static final String[] rowDataAmountForFieldKeys = new String[]{"debitfor", "creditfor", "endfor", "debitprice", "creditprice", "endprice"};
    private static final String[] rowDataAmountRptFieldKeys = new String[]{"debitrpt", "creditrpt", "endrpt"};
    private static final String[] rowDataQtyFieldKeys = new String[]{"debitqty", "creditqty", "endqty"};
    private static final String[] rowDataDecimalFieldKeys = new String[]{"localrate"};
    private static final String[] headFieldKeys = new String[]{"org", "orgview", "booktype", "periodtype", "startperiod", "endperiod", "accounttable", "currencyrpt"};
    private static final String[] headDateFieldKeys = new String[]{"datebegin", "dateend"};
    private static final String DC = "dc";
    private static final String SEQ = "fseq";
    private static final String CURRENCY_LOCAL = "basecurrency";
    private static final String CURRENCY_FOR = "currencycolumn";
    private static final String CURRENCY_RPT = "currencyrptid";
    private FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
    private Format timeFormat = FormatFactory.get((FormatTypes)FormatTypes.Date).getFormat(this.fobj);
    private FlexPrintFormatter flexPrintFormatter = null;
    private final Boolean enableBOSFormatter = Boolean.parseBoolean(System.getProperty("fi.gl.report.print.enablebosflexformatter", Boolean.TRUE.toString()));

    public void afterLoadData(AfterLoadDataEvent e) {
        super.afterLoadData(e);
        PrtDataSource dataSource = e.getDataSource();
        if (dataSource instanceof MainDataSource) {
            ReportListModel listModel = this.getListModel(((MainDataSource)dataSource).getPageId());
            if (listModel == null) {
                return;
            }
            String tempPageKey = "";
            DynamicObjectCollection ds = listModel.getRowData(0, listModel.getRowCount());
            if (this.enableBOSFormatter.booleanValue()) {
                this.flexPrintFormatter = new FlexPrintFormatter(listModel, ds);
            }
            HashMap rowDatas = new HashMap(1);
            HashMap<Integer, String> pageHeadAccount = new HashMap<Integer, String>(1);
            int key = 1;
            FilterInfo filter = listModel.getReportQueryParam().getFilter();
            ComAssistTable comAssistService = ComAssistTable.get((Long)filter.getLong("accounttable"));
            ArrayList<String> keys = new ArrayList<String>(Arrays.asList(this.rowDataStringFieldKeys));
            comAssistService.getCommonAssists().forEach(commonAssist -> keys.add(commonAssist.key + "id.name"));
            this.rowDataStringFieldKeys = keys.toArray(new String[0]);
            List commonAssists = comAssistService.getComAssistForGroup(filter.getBoolean("showsumcomassist"));
            ArrayList<DataRowSet> dataRows = new ArrayList<DataRowSet>(1);
            for (DynamicObject dyo : ds) {
                DataRowSet printRow = new DataRowSet();
                Optional<SLPrintPageKey> optionalPageKey = SLPrintPageKey.createPK(dyo, commonAssists);
                if (!optionalPageKey.isPresent()) continue;
                SLPrintPageKey printPageKey = optionalPageKey.get();
                String pageKey = printPageKey.toString();
                int rowNo = dyo.getInt(SEQ);
                if (!pageKey.equals(tempPageKey)) {
                    tempPageKey = pageKey;
                    key = rowNo;
                    printRow.add("id", (Field)new TextField(rowNo + ""));
                    pageHeadAccount.put(key, pageKey);
                    dataRows.add(printRow);
                }
                if (rowDatas.get(key) == null) {
                    ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>(1);
                    datas.add(dyo);
                    rowDatas.put(key, datas);
                    continue;
                }
                ((List)rowDatas.get(key)).add(dyo);
            }
            e.setDataRowSets(dataRows);
            ThreadCache.put((Object)rowDataCacheKey, rowDatas);
            ThreadCache.put((Object)pageHeadCacheKey, pageHeadAccount);
        }
    }

    public void loadCustomData(CustomDataLoadEvent evt) {
        super.loadCustomData(evt);
        CustomDataSource dataSource = evt.getDataSource();
        String pageId = dataSource.getPageId();
        ReportListModel model = this.getListModel(pageId);
        if (model == null) {
            return;
        }
        ReportQueryParam param = model.getReportQueryParam();
        FilterInfo filter = param.getFilter();
        if ("reporthead".equals(dataSource.getDsName())) {
            Map pageHeadAccounts = (Map)ThreadCache.get((Object)pageHeadCacheKey);
            List customDataRows = evt.getCustomDataRows();
            DataRowSet dsRow = new DataRowSet();
            SLPrintPageKey.fromStr((String)pageHeadAccounts.get(Integer.parseInt(dataSource.getPkId().toString()))).addPageField((key, value) -> dsRow.add(key, (Field)new TextField(value)));
            List field = dataSource.getQueryField();
            String[] headFields = ReportPrintHelper.getExistFileds(field, headFieldKeys);
            String[] headDateFields = ReportPrintHelper.getExistFileds(field, headDateFieldKeys);
            ReportPrintHelper.handleBaseDataFilterInfo(filter, dsRow, headFields);
            ReportPrintHelper.handleMulCur(filter, dsRow, field);
            ReportPrintHelper.handleDateFilterInfo(filter, dsRow, this.timeFormat, headDateFields);
            ReportPrintHelper.handleCurrencyNameById(filter, dsRow, "currency");
            customDataRows.add(dsRow);
        } else if ("reportlist".equals(dataSource.getDsName())) {
            Map rowDatas = (Map)ThreadCache.get((Object)rowDataCacheKey);
            int index = Integer.parseInt(dataSource.getPkId().toString());
            List datas = (List)rowDatas.get(index);
            List field = dataSource.getQueryField();
            String[] rowDataStringFields = ReportPrintHelper.getExistFileds(field, this.getFieldByTpye(PrintFieldTypeEnum.STRING.getValue()).toArray(this.rowDataStringFieldKeys));
            String[] rowDataFlexFields = ReportPrintHelper.getExistFileds(field, rowDataFlexFieldKeys);
            String[] rowDataAmountForFields = ReportPrintHelper.getExistFileds(field, this.getFieldByTpye(PrintFieldTypeEnum.AMOUNT.getValue()).toArray(rowDataAmountForFieldKeys));
            String[] rowDataAmountLocalFields = ReportPrintHelper.getExistFileds(field, rowDataAmountLocalFieldKeys);
            String[] rowDataAmountRptFields = ReportPrintHelper.getExistFileds(field, rowDataAmountRptFieldKeys);
            String[] rowDataQtyFields = ReportPrintHelper.getExistFileds(field, rowDataQtyFieldKeys);
            String[] rowDataDateFields = ReportPrintHelper.getExistFileds(field, this.getFieldByTpye(PrintFieldTypeEnum.DATE.getValue()).toArray(rowDataDateFieldKeys));
            String[] rowDataDecimalFields = ReportPrintHelper.getExistFileds(field, rowDataDecimalFieldKeys);
            boolean showrpt = filter.getBoolean("showrpt");
            boolean showqty = filter.getBoolean("showqty") || filter.getBoolean("showsumqty");
            boolean showopaccount = filter.getBoolean("showopaccount");
            DynamicObjectType customDT = new DynamicObjectType();
            ReportPrintHelper.registerStringProperty(customDT, new String[][]{rowDataStringFields, rowDataFlexFields, rowDataAmountForFields, rowDataAmountLocalFields, rowDataAmountRptFields, rowDataQtyFields, rowDataDateFields, rowDataDecimalFields});
            List customDataRows = evt.getCustomDataRows();
            HashBasedTable orgBookedDateAssgrp = HashBasedTable.create();
            int tempSeq = 1;
            for (DynamicObject rowData : datas) {
                DataRowSet printRow = new DataRowSet();
                printRow.add(SEQ, (Field)new TextField(tempSeq++ + ""));
                ReportPrintHelper.handleStringFields(rowData, printRow, rowDataStringFields);
                ReportPrintHelper.handleComboFields(rowData, printRow, rowDataStringFields);
                ReportPrintHelper.handleDateFields(rowData, printRow, this.timeFormat, rowDataDateFields);
                ReportPrintHelper.handleDateFlexFields(rowData, printRow, (Table<Long, Date, Set<String>>)orgBookedDateAssgrp, rowDataFlexFields);
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_LOCAL, (boolean)Boolean.FALSE, rowDataAmountLocalFields);
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_FOR, (boolean)Boolean.FALSE, rowDataAmountForFields);
                ReportPrintHelper.handleDecimalFields(rowData, printRow, this.fobj, (boolean)Boolean.FALSE, rowDataDecimalFields);
                ReportPrintHelper.handleDcFields(rowData, printRow, DC);
                if (showopaccount) {
                    ReportPrintHelper.handleStringJointField(rowData, printRow, "opaccount", " ", opAccountStringJointFields);
                }
                if (showrpt) {
                    ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_RPT, (boolean)Boolean.FALSE, rowDataAmountRptFields);
                }
                if (showqty) {
                    ReportPrintHelper.handleQtyFields(rowData, printRow, (boolean)Boolean.FALSE, "measureunit", this.fobj, rowDataQtyFields);
                }
                if (this.flexPrintFormatter != null) {
                    printRow.put("assgrp", (Field)new TextField(this.flexPrintFormatter.getFlexString(rowData)));
                }
                printRow.add("org", (Field)new TextField(String.valueOf(rowData.getLong("orgname_id"))));
                customDataRows.add(printRow);
            }
            if (!this.enableBOSFormatter.booleanValue()) {
                ReportPrintHelper.handleDateFlexIntoToStr(customDataRows, this.timeFormat, (Table<Long, Date, Set<String>>)orgBookedDateAssgrp, rowDataFlexFields);
            }
        }
    }

    private ReportListModel getListModel(String pageId) {
        ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            return null;
        }
        ReportList list = view.getReportList();
        ReportListModel listModel = (ReportListModel)list.getReportModel();
        Object param = this.getExtParam().get("pageIDForPrint");
        if (param != null) {
            String pageIDForPrint = param.toString();
            listModel.setReportTaskResult(listModel.getReportCache().getReportTaskResult(pageIDForPrint, "reportlistap"));
            listModel.setPageId(pageIDForPrint);
        }
        return listModel;
    }

    private List<String> getFieldByTpye(String type) {
        String[] arr = PrintFieldTypeEnum.DATE.getValue().equals(type) ? rowDataDateFieldKeys : (PrintFieldTypeEnum.AMOUNT.getValue().equals(type) ? rowDataAmountForFieldKeys : this.rowDataStringFieldKeys);
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(arr));
        List fieldConfigs = ReportFieldSettingUtil.getDisplayFieldConfigs((String)"gl_rpt_subledger");
        ArrayList dateList = new ArrayList();
        ArrayList amountList = new ArrayList();
        ArrayList stringList = new ArrayList();
        MainEntityType voucherEntity = EntityMetadataCache.getDataEntityType((String)"gl_voucher");
        for (String field : fieldConfigs) {
            voucherEntity.getAllFields().entrySet().forEach(stringIDataEntityPropertyEntry -> {
                if (field.equals(stringIDataEntityPropertyEntry.getKey())) {
                    if (stringIDataEntityPropertyEntry.getValue() instanceof DateTimeProp) {
                        dateList.add(field);
                    } else if (stringIDataEntityPropertyEntry.getValue() instanceof AmountProp) {
                        amountList.add(field);
                    } else {
                        stringList.add(field);
                    }
                }
            });
        }
        if (PrintFieldTypeEnum.DATE.getValue().equals(type)) {
            list.addAll(dateList);
        } else if (PrintFieldTypeEnum.AMOUNT.getValue().equals(type)) {
            list.addAll(amountList);
        } else {
            list.addAll(stringList);
        }
        return list;
    }
}

