/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterOutputWidgetEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.print.core.plugin.event.EndExportEvent;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.report.ReportPrintHelper;

public class SubsiDiaryCataloguePlugin
extends AbstractPrintPlugin {
    private static final Log LOGGER = LogFactory.getLog(SubsiDiaryCataloguePlugin.class);
    private Map<String, Integer> startPageMap = new LinkedHashMap<String, Integer>(6);
    private static final String ACCOUNT = "Text10";
    private static final String ASSIST = "Text12";
    private static final String[] headBaseDataFieldKeys = new String[]{"org", "booktype"};
    private static final String EMPTY = "";
    private String account = "";
    private String assist = "";
    private String org = "";
    private String booktype = "";

    public void loadCustomData(CustomDataLoadEvent evt) {
        CustomDataSource dataSource = evt.getDataSource();
        String pageId = dataSource.getPageId();
        ReportListModel model = ReportPrintHelper.getListModel(pageId);
        if (model == null) {
            return;
        }
        if ("reporthead".equals(dataSource.getDsName())) {
            List field = dataSource.getQueryField();
            String[] headBaseDataFields = ReportPrintHelper.getExistFileds(field, headBaseDataFieldKeys);
            DataRowSet dsRow = new DataRowSet();
            ReportQueryParam param = model.getReportQueryParam();
            FilterInfo filter = param.getFilter();
            ReportPrintHelper.handleAccountBaseDataFilterInfo(filter, dsRow, headBaseDataFields);
            this.org = String.valueOf(dsRow.getField("org"));
            this.booktype = String.valueOf(dsRow.getField("booktype"));
        }
    }

    public void afterOutputWidget(AfterOutputWidgetEvent evt) {
        String widgetKey = evt.getWidgetKey();
        int pageIndex = evt.getPageIndex();
        if (ACCOUNT.equals(widgetKey)) {
            TextField outputValue = (TextField)evt.getOutputValue();
            this.account = (String)outputValue.getValue();
        }
        boolean assistValue = false;
        if (ASSIST.equals(widgetKey)) {
            TextField outputValue = (TextField)evt.getOutputValue();
            this.assist = (String)outputValue.getValue();
            assistValue = true;
        }
        if (!this.account.equals(EMPTY) && assistValue) {
            StringBuilder accountAssist = new StringBuilder();
            accountAssist.append(this.account).append(";").append(this.assist);
            if (!this.startPageMap.containsKey(String.valueOf(accountAssist))) {
                this.startPageMap.put(String.valueOf(accountAssist), pageIndex + 1);
            }
        }
    }

    public void endExport(EndExportEvent evt) {
        String entity = evt.getPrtAttach().getFormId();
        String cacheKey = entity + "_" + this.org + "_" + this.booktype;
        DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.report);
        cache.put(cacheKey, SerializationUtils.toJsonString(this.startPageMap));
        LOGGER.info("This is SubsiDiaryCataloguePlugin cacheValue:" + SerializationUtils.toJsonString(this.startPageMap));
    }
}

