/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.io.Serializable;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportTaskResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.gl.configuration.ReportConfiguration;
import kd.fi.gl.report.ReportPrintHelper;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.ReportFieldSettingUtil;

public class SubsiDiaryRptPrint
extends AbstractPrintServicePlugin
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SubsiDiaryRptPrint.class);
    private static final String rowDataCacheKey = "SubsiDiaryRptPrint_RowDatas";
    private static final String[] headFieldKeys = new String[]{"id", "account", "showassist"};
    private static final String[] rowDataStringFieldKeys = new String[]{"accountnumber", "accountname", "vouchernumber", "desc", "measureunit.name", "currencycolumn.name", "bookcolumn.name", "basecurrency.name"};
    private static final String[] rowDataDateFieldKeys = new String[]{"datefield", "bizdate"};
    private static final String[] rowDataQtyFieldKeys = new String[]{"debitqty", "creditqty", "endqty"};
    private static final String[] rowDataDcFieldKeys = new String[]{"accountdc", "dc"};
    private static final String[] rowDataAmountLocalFieldKeys = new String[]{"debitlocal", "creditlocal", "endlocal"};
    private static final String[] rowDataAmountForFieldKeys = new String[]{"debitprice", "debitfor", "creditprice", "creditfor", "endprice", "endfor"};
    private static final String[] rowDataDecimalFieldKeys = new String[]{"localrate"};
    private static final String SEQ = "fseq";
    private static final String[] headBaseDataFieldKeys = new String[]{"org", "orgview", "booktype", "periodtype", "startperiod", "endperiod", "accounttable", "currencyrpt"};
    private static final String[] headMulBaseDataFieldKeys = new String[]{"measureunits"};
    private static final String CURRENCY_HEAD = "currency";
    private static final String CURRENCY_LOCAL = "basecurrency";
    private static final String CURRENCY_FOR = "currencycolumn";
    private static final String MEASUREUNITFIELD = "measureunit";
    private FormatObject fobj;
    private Format timeFormat;

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        try {
            ReportListModel listModel = this.getListModel(e.getPageId());
            if (listModel == null) {
                return;
            }
            ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>();
            int count = listModel.getRowCount();
            ReportQueryParam param = listModel.getReportQueryParam();
            FilterInfo filterInfo = param.getFilter();
            if (e.isMainDs()) {
                DynamicObjectType dt = new DynamicObjectType("head");
                ReportPrintHelper.registerStringProperty(dt, headFieldKeys);
                Map<String, String> keyToCaption = this.getKeyToCaption(listModel);
                DynamicObjectCollection rowDatas = listModel.getRowData(0, ReportConfiguration.SUBSIDIARY_PRINT_LIMIT.getInt());
                HashMap<Integer, String> rowIndexsByPage = new HashMap<Integer, String>();
                String tempStr = "";
                int key = 1;
                for (DynamicObject rowData : rowDatas) {
                    String assistVal;
                    String acctName = rowData.getString("accountname");
                    String acctNumber = rowData.getString("accountnumber");
                    String str = String.join((CharSequence)"", acctNumber, acctName, assistVal = this.getAssistVal(keyToCaption, rowData));
                    if (StringUtils.isBlank((CharSequence)str) || str.equalsIgnoreCase(tempStr)) continue;
                    int rowNo = rowData.getInt(SEQ);
                    if (rowIndexsByPage.get(key) == null && key != rowNo) {
                        rowIndexsByPage.put(key, key - 1 + "-" + (rowNo - 1));
                    }
                    tempStr = str;
                    key = rowNo;
                    DynamicObject head = new DynamicObject(dt);
                    head.set(headFieldKeys[0], (Object)rowNo);
                    head.set(headFieldKeys[1], (Object)(acctNumber + acctName));
                    head.set(headFieldKeys[2], (Object)assistVal);
                    dyns.add(head);
                }
                if (!rowDatas.isEmpty()) {
                    rowIndexsByPage.put(key, key - 1 + "-" + rowDatas.size());
                }
                ThreadCache.put((Object)rowDataCacheKey, rowIndexsByPage);
            } else if ("reporthead".equals(e.getDataSourceName())) {
                DynamicObjectType customDT = new DynamicObjectType();
                String[] headBaseDataFields = ReportPrintHelper.getExistFileds(e, headBaseDataFieldKeys);
                String[] headMulBaseDataFields = ReportPrintHelper.getExistFileds(e, headMulBaseDataFieldKeys);
                ReportPrintHelper.registerStringProperty(customDT, new String[][]{headBaseDataFields, headMulBaseDataFields});
                ReportPrintHelper.registerStringProperty(customDT, CURRENCY_HEAD);
                DynamicObject printDyn = new DynamicObject(customDT);
                ReportPrintHelper.handleBaseDataFilterInfo(filterInfo, printDyn, headBaseDataFields);
                ReportPrintHelper.handleMulBaseDataFilterInfo(filterInfo, printDyn, headMulBaseDataFields);
                ReportPrintHelper.handleCurrencyNameById(filterInfo, printDyn, CURRENCY_HEAD);
                dyns.add(printDyn);
                e.setDataEntities(dyns);
            } else {
                Map rowDatasMap = (Map)ThreadCache.get((Object)rowDataCacheKey);
                int index = Integer.parseInt(e.getFilter().getValue().toString());
                String dataIndexs = (String)rowDatasMap.get(index);
                String[] indexStr = dataIndexs.split("-");
                int startIndex = Integer.parseInt(indexStr[0]);
                int length = Integer.parseInt(indexStr[1]) - startIndex;
                DynamicObjectCollection datas = listModel.getRowData(startIndex, length);
                DynamicObjectType dt = new DynamicObjectType();
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(rowDataStringFieldKeys));
                list.addAll(ReportFieldSettingUtil.getDisplayFieldConfigs((String)"gl_rpt_subsidiaryledger"));
                String[] rowDataStringFields = ReportPrintHelper.getExistFileds(e, list.toArray(rowDataStringFieldKeys));
                String[] rowDataAmountForFields = ReportPrintHelper.getExistFileds(e, rowDataAmountForFieldKeys);
                String[] rowDataAmountLocalFields = ReportPrintHelper.getExistFileds(e, rowDataAmountLocalFieldKeys);
                String[] rowDataQtyFields = ReportPrintHelper.getExistFileds(e, rowDataQtyFieldKeys);
                String[] rowDataDcFields = ReportPrintHelper.getExistFileds(e, rowDataDcFieldKeys);
                String[] rowDataDateFields = ReportPrintHelper.getExistFileds(e, rowDataDateFieldKeys);
                String[] rowDataDecimalFields = ReportPrintHelper.getExistFileds(e, rowDataDecimalFieldKeys);
                ReportPrintHelper.registerStringProperty(dt, new String[][]{rowDataStringFields, rowDataDateFields, rowDataAmountLocalFields, rowDataAmountForFields, rowDataDcFields, rowDataQtyFields, rowDataDecimalFields});
                ReportPrintHelper.registerStringProperty(dt, SEQ);
                this.fobj = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
                this.timeFormat = FormatFactory.get((FormatTypes)FormatTypes.Date).getFormat(this.fobj);
                boolean showqty = filterInfo.getBoolean("showqty");
                String basecurrency = filterInfo.getString(CURRENCY_HEAD);
                boolean noForAmount = CURRENCY_LOCAL.equals(basecurrency);
                int temp = 1;
                for (DynamicObject rowData : datas) {
                    DynamicObject printRow = new DynamicObject(dt);
                    printRow.set(SEQ, (Object)temp++);
                    ReportPrintHelper.handleStringFields(rowData, printRow, rowDataStringFields);
                    ReportPrintHelper.handleDateFields(rowData, printRow, this.timeFormat, rowDataDateFields);
                    ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_LOCAL, (boolean)Boolean.FALSE, rowDataAmountLocalFields);
                    if (noForAmount) {
                        if (e.getCustomFields().contains("currencycolumn.name")) {
                            printRow.set("currencycolumn.name", (Object)"");
                        }
                    } else {
                        ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_FOR, (boolean)Boolean.FALSE, rowDataAmountForFields);
                    }
                    ReportPrintHelper.handleDecimalFields(rowData, printRow, this.fobj, (boolean)Boolean.FALSE, rowDataDecimalFields);
                    ReportPrintHelper.handleDcFields(rowData, printRow, rowDataDcFields);
                    if (showqty) {
                        ReportPrintHelper.handleQtyFields(rowData, printRow, (boolean)Boolean.FALSE, MEASUREUNITFIELD, this.fobj, rowDataQtyFields);
                    }
                    dyns.add(printRow);
                }
            }
            e.setDataEntities(dyns);
        }
        catch (Exception exp) {
            log.error(GLUtil.printError((Throwable)exp));
        }
    }

    private String getAssistVal(Map<String, String> keyToCaption, DynamicObject rowData) {
        ArrayList<String> allAssistVal = new ArrayList<String>();
        for (Map.Entry<String, String> entry : keyToCaption.entrySet()) {
            StringBuilder sb = new StringBuilder(entry.getValue()).append("\uff1a");
            Object assistObj = rowData.get(entry.getKey());
            if (assistObj instanceof DynamicObject) {
                DynamicObject assistDyn = (DynamicObject)assistObj;
                sb.append(assistDyn.getString("name"));
                allAssistVal.add(sb.toString());
                continue;
            }
            if (null == assistObj || StringUtils.isEmpty((CharSequence)assistObj.toString())) continue;
            sb.append(assistObj);
            allAssistVal.add(sb.toString());
        }
        return String.join((CharSequence)"\uff1b", allAssistVal);
    }

    private Map<String, String> getKeyToCaption(ReportListModel listModel) {
        ReportColumn column;
        String key;
        HashMap<String, String> keyToCaption = new HashMap<String, String>();
        List listColumns = listModel.getColumns();
        for (int i = 1; i < listColumns.size() && !"accountnumber".equals(key = (column = (ReportColumn)listColumns.get(i)).getFieldKey()); ++i) {
            String caption = column.getCaption().getLocaleValue();
            keyToCaption.put(key, caption);
        }
        return keyToCaption.entrySet().stream().sorted((o1, o2) -> ((String)o2.getKey()).compareTo((String)o1.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> newValue, LinkedHashMap::new));
    }

    private ReportListModel getListModel(String pageId) {
        Map map;
        String printPageId;
        ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u89c6\u56fe\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\u3002", (String)"SubsiDiaryRptPrintNew_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        ReportQueryParam queryParam = view.getQueryParam();
        ReportList list = view.getReportList();
        ReportListModel listModel = (ReportListModel)list.getReportModel();
        IReportCache reportCache = ReportCacheManager.getInstance().getCache();
        ReportTaskResult reportTaskResult = reportCache.getReportTaskResult(printPageId = (String)(map = queryParam.getCustomParam()).computeIfAbsent("printPageId", k -> Uuid16.create().toString()), "reportlistap");
        if (reportTaskResult == null) {
            Object selectObj = map.get("selectObj");
            if (Objects.nonNull(selectObj)) {
                selectObj = SerializationUtils.deSerializeFromBase64((String)((String)selectObj));
            }
            String exportFlag = map.getOrDefault("exportFlag", "all");
            FilterInfo filter = queryParam.getFilter();
            List filterItems = filter.getFilterItems("exportexcel");
            if (Objects.isNull(filterItems)) {
                filter.addFilterItem("exportexcel", (Object)exportFlag, "=");
            } else {
                filterItems.clear();
                queryParam.getFilter().getFilterItems().removeIf(filterItemInfo -> "exportexcel".equals(filterItemInfo.getPropName()));
                filter.addFilterItem("exportexcel", (Object)exportFlag, "=");
            }
            reportCache.setReportQueryParam(printPageId, queryParam);
            AbstractReportListModel reportModel = (AbstractReportListModel)list.getReportModel();
            reportModel.setPageId(printPageId);
            list.setAsynQuery(true);
            list.submitTask(queryParam, selectObj);
        } else {
            listModel.setPageId(printPageId);
            listModel.setReportTaskResult(reportTaskResult);
        }
        return listModel;
    }
}

