/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.report.GLRptTemplatePlugin;
import kd.fi.gl.report.NavToSubLedgerRpt;
import kd.fi.gl.util.GLApp;
import org.apache.commons.lang3.StringUtils;

public class VoucherSummaryFormRpt
extends AbstractReportFormPlugin
implements ProgresssListener {
    private String tempFilter;

    public void initialize() {
        FilterGrid filterGrid = (FilterGrid)this.getControl("voucherfiltergridap");
        filterGrid.setEntityNumber("gl_voucher");
        this.setVoucherFilterFields(filterGrid);
    }

    private void setVoucherFilterFields(FilterGrid filterGrid) {
        ArrayList<String> filterFileds = new ArrayList<String>();
        filterFileds.add("billno");
        filterFileds.add("vouchertype.number");
        filterGrid.setFilterFieldKeys(filterFileds);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterGrid filterGrid = (FilterGrid)this.getControl("voucherfiltergridap");
        FilterCondition cond = filterGrid.getFilterGridState().getFilterCondition();
        ITimeService timeService = (ITimeService)this.getView().getService(ITimeService.class);
        IUserService userService = (IUserService)this.getView().getService(IUserService.class);
        queryParam.getFilter().addCommFilter("gl_voucher", cond, timeService, userService);
        this.setDisplayVoucherNum(true);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.start();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        Map filtermap = this.getQueryParam().getFilter().getCommFilter();
        QFilter temp = (QFilter)filtermap.get("gl_voucher");
        this.tempFilter = "";
        if (temp != null) {
            this.tempFilter = temp.toSerializedString();
        }
        ReportList control = (ReportList)this.getControl("reportlistap");
        control.addHyperClickListener(evt -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("reportlistap");
            DynamicObject rowData = control.getReportModel().getRowData(rowIndex);
            String name = evt.getFieldName();
            if ("number".equals(name)) {
                Long accId = rowData.getLong("number_id");
                Long orgId = this.getQueryParam().getFilter().getLong("org");
                new NavToSubLedgerRpt.SLBuilder(this.getQueryParam(), (IFormView)this.getView()).accountId(accId).orgId(orgId).build().apply();
            } else if ("currencyid".equals(name)) {
                Long accId = rowData.getLong("number_id");
                Long curId = rowData.getLong("currencyid_id");
                Long orgId = this.getQueryParam().getFilter().getLong("org");
                new NavToSubLedgerRpt.SLBuilder(this.getQueryParam(), (IFormView)this.getView()).accountId(accId).currencyId(curId).orgId(orgId).build().apply();
            } else if ("debit".equals(name) || "debitlocal".equals(name)) {
                Long accId = rowData.getLong("number_id");
                String number = rowData.getString("number.number");
                Long orgId = this.getQueryParam().getFilter().getLong("org");
                if (StringUtils.isNotEmpty((CharSequence)number)) {
                    new NavToSubLedgerRpt.SLBuilder(this.getQueryParam(), (IFormView)this.getView()).accountId(accId).orgId(orgId).isDebit(true).number(number).filterList(this.tempFilter).build().openVoucher();
                }
            } else if ("credit".equals(name) || "creditlocal".equals(name)) {
                Long accId = rowData.getLong("number_id");
                Long orgId = this.getQueryParam().getFilter().getLong("org");
                String number = rowData.getString("number.number");
                if (StringUtils.isNotEmpty((CharSequence)number)) {
                    new NavToSubLedgerRpt.SLBuilder(this.getQueryParam(), (IFormView)this.getView()).accountId(accId).orgId(orgId).isDebit(false).number(number).filterList(this.tempFilter).build().openVoucher();
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        long orgid = (Long)this.getModel().getValue("org_id");
        this.setBookTypeView(orgid);
        this.setDisplayVoucherNum(false);
    }

    public void setBookTypeView(long org) {
        List bookIdList = AccSysUtil.getAllBookFromAccSys((long)org);
        if (bookIdList.size() == 1) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"booktype"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"booktype"});
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        GLRptTemplatePlugin.processData(Maps.newHashMap(), rowData, queryParam, null);
    }

    private void setDisplayVoucherNum(boolean isDisplay) {
        this.getView().setVisible(Boolean.valueOf(isDisplay), new String[]{"voucherpanelap"});
    }

    public void preProcessExportData(List<AbstractReportColumn> exportColumns, DynamicObjectCollection data, NumberFormatProvider numberFormatProvider) {
        if (!data.isEmpty()) {
            String vounum = ResManager.loadKDString((String)"\u51ed\u8bc1\u6570\uff1a", (String)"VoucherSummaryFormRpt_0", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            String attnum = ResManager.loadKDString((String)"\u9644\u4ef6\u6570\uff1a", (String)"VoucherSummaryFormRpt_1", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            String showBill = ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7\uff1a", (String)"VoucherSummaryFormRpt_2", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            String id = RequestContext.get().getUserId();
            String vouchernum = new DistributeCache(CacheModule.report).get(String.format("%s_%s", "VoucherSummaryQueryRpt_count", id));
            String attachnum = new DistributeCache(CacheModule.report).get(String.format("%s_%s", "VoucherSummaryQueryRpt_attachNum", id));
            String showBillno = new DistributeCache(CacheModule.report).get(String.format("%s_%s", "VoucherSummaryQueryRpt_showBillno", id));
            DynamicObject row1 = new DynamicObject(data.getDynamicObjectType());
            DynamicObject row2 = new DynamicObject(data.getDynamicObjectType());
            DynamicObject row3 = new DynamicObject(data.getDynamicObjectType());
            row1.set("name", (Object)(vounum + vouchernum));
            row2.set("name", (Object)(attnum + attachnum));
            row3.set("name", (Object)(showBill + showBillno));
            data.add((Object)row1);
            data.add((Object)row2);
            data.add((Object)row3);
        }
    }

    private void doProgress() {
        Long id = RequestContext.get().getCurrUserId();
        String attachnum = new DistributeCache(CacheModule.report).get(String.format("%s_%s", "VoucherSummaryQueryRpt_attachNum", id));
        if (kd.bos.util.StringUtils.isNotEmpty((String)attachnum)) {
            Label voucherNum = (Label)this.getControl("vouchernum");
            String vouchernum = new DistributeCache(CacheModule.report).get(String.format("%s_%s", "VoucherSummaryQueryRpt_count", id));
            voucherNum.setText(vouchernum);
            Label attachNum = (Label)this.getControl("attachnum");
            attachNum.setText(attachnum);
            String showBillno = new DistributeCache(CacheModule.report).get(String.format("%s_%s", "VoucherSummaryQueryRpt_showBillno", id));
            Label billnoCon = (Label)this.getControl("showbillno");
            billnoCon.setText(String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7\uff1a%s", (String)"VoucherSummaryFormRpt_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), showBillno));
            if ("~".equals(showBillno.trim())) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"showbillno"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"showbillno"});
            }
            ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
            bar.stop();
        }
    }

    public void onProgress(ProgressEvent arg0) {
        this.doProgress();
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        String colKey = ((ReportColumn)e.getSource()).getFieldKey();
        if (("debit".equalsIgnoreCase(colKey) || "credit".equalsIgnoreCase(colKey) || "debitlocal".equalsIgnoreCase(colKey) || "creditlocal".equalsIgnoreCase(colKey)) && e.getFormatValue() != null && e.getRowData().get("number") == null && ResManager.loadKDString((String)"\u5408\u8ba1", (String)"VoucherSummaryFormRpt_4", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]).equalsIgnoreCase(e.getRowData().getString("name"))) {
            e.setFormatValue((Object)("<nolink>" + e.getFormatValue()));
        }
    }
}

