/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.exportall.multiorg.joblistener;

import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.fi.bd.model.JsonObjectAdapter;
import kd.fi.gl.model.schema.JobExecuteFormSchema;
import kd.fi.gl.report.exportall.multiorg.JobExecuteEdit;
import kd.fi.gl.report.exportall.multiorg.joblistener.BaseJobExecuteListener;
import kd.fi.gl.report.exportall.multiorg.joblistener.ExecuteProgressEvent;
import kd.fi.gl.report.exportall.multiorg.joblistener.JobExecuteEvent;
import kd.fi.gl.util.GLApp;

public class DefaultJobExecuteListener
extends BaseJobExecuteListener {
    private static final JobExecuteFormSchema schema = JobExecuteFormSchema.INSTANCE;

    @Override
    public void beforeExecuted(JobExecuteEvent e) {
        super.beforeExecuted(e);
        JobExecuteEdit edit = (JobExecuteEdit)((Object)e.getSource());
        ((Label)edit.getControl(JobExecuteFormSchema.INSTANCE.title.toString())).setText(edit.jobMetaData().title(ScheduleServiceHelper.queryTask((String)edit.getTaskId())));
        if (edit.jobExecuteInfo().haveSubTask()) {
            ((Label)edit.getControl(JobExecuteFormSchema.INSTANCE.onGoingUnit.toString())).setText(edit.jobMetaData().unit());
            ((Label)edit.getControl(JobExecuteFormSchema.INSTANCE.totalUnit.toString())).setText(edit.jobMetaData().unit());
        }
        edit.getView().setVisible(Boolean.valueOf(false), new String[]{JobExecuteFormSchema.INSTANCE.subTaskPanel.toString()});
        ((ProgressBar)edit.getControl(DefaultJobExecuteListener.schema.progressBar.toString())).start();
    }

    @Override
    public void onExecuteProgress(ExecuteProgressEvent e) {
        super.onExecuteProgress(e);
        this.showJobProcessDetail(e);
    }

    private void showJobProcessDetail(ExecuteProgressEvent e) {
        TaskInfo taskInfo = e.getTaskInfo();
        JobExecuteEdit edit = (JobExecuteEdit)((Object)e.getSource());
        if (e.getTaskInfo().getData() == null) {
            return;
        }
        JsonObjectAdapter returnData = JsonObjectAdapter.fromJson((String)taskInfo.getData());
        String title = edit.jobMetaData().title(taskInfo);
        String taskStatus = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8d44\u6e90", (String)"JobExecuteEdit_6", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]);
        if (e.getTaskInfo().getProgress() > 0) {
            title = title + "\uff1a" + taskInfo.getDesc();
            taskStatus = ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u4e2d", (String)"JobExecuteEdit_7", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]);
        }
        ((Label)edit.getControl(JobExecuteFormSchema.INSTANCE.title.toString())).setText(title);
        if (edit.jobExecuteInfo().haveSubTask()) {
            edit.getView().setVisible(Boolean.valueOf(true), new String[]{JobExecuteFormSchema.INSTANCE.subTaskPanel.toString()});
            ((Label)edit.getControl(JobExecuteFormSchema.INSTANCE.taskStatus.toString())).setText(taskStatus);
            ((Label)edit.getControl(JobExecuteFormSchema.INSTANCE.totalNum.toString())).setText(returnData.query(JobExecuteFormSchema.INSTANCE.totalNum).toString());
            ((Label)edit.getControl(JobExecuteFormSchema.INSTANCE.onGoingNum.toString())).setText(returnData.query(JobExecuteFormSchema.INSTANCE.onGoingNum).toString());
        }
    }

    @Override
    public void beforeSuspended(JobExecuteEvent e) {
        super.beforeSuspended(e);
        JobExecuteEdit edit = (JobExecuteEdit)((Object)e.getSource());
        String msg = String.format(ResManager.loadKDString((String)"%s\u7ec8\u6b62\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"JobExecuteEdit_1", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), edit.jobMetaData().jobName());
        edit.getView().showLoading(new LocaleString(msg));
        edit.getView().setVisible(Boolean.FALSE, new String[]{"exportpanel"});
        edit.getView().sendFormAction(edit.getView());
    }

    @Override
    public void afterSuspended(JobExecuteEvent e) {
        super.afterSuspended(e);
        JobExecuteEdit edit = (JobExecuteEdit)((Object)e.getSource());
        String stoppedTips = String.format(ResManager.loadKDString((String)"%s\u5df2\u4e2d\u6b62\u3002", (String)"JobExecuteEdit_4", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), edit.jobMetaData().jobName());
        ((Label)edit.getView().getControl(JobExecuteFormSchema.INSTANCE.title.toString())).setText(stoppedTips);
        ((ProgressBar)edit.getControl(JobExecuteFormSchema.INSTANCE.progressBar.toString())).stop();
        edit.getView().setEnable(Boolean.valueOf(false), new String[]{DefaultJobExecuteListener.schema.Button_ToBackGround.toString()});
    }

    @Override
    public void afterCompleted(JobExecuteEvent e) {
        super.afterCompleted(e);
        JobExecuteEdit edit = (JobExecuteEdit)((Object)e.getSource());
        ((ProgressBar)edit.getControl(JobExecuteFormSchema.INSTANCE.progressBar.toString())).stop();
    }

    @Override
    public void afterFailed(JobExecuteEvent e) {
        super.afterFailed(e);
        JobExecuteEdit edit = (JobExecuteEdit)((Object)e.getSource());
        String errMsg = String.format(ResManager.loadKDString((String)"%s\u6267\u884c\u5931\u8d25\uff1a", (String)"JobExecuteEdit_3", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), edit.jobMetaData().jobName());
        edit.getView().showErrorNotification(errMsg + e.getTaskInfo().getFailureReason());
        edit.getView().setEnable(Boolean.valueOf(false), new String[]{DefaultJobExecuteListener.schema.Button_ToBackGround.toString()});
    }

    @Override
    public void afterSuccess(JobExecuteEvent e) {
        super.afterSuccess(e);
        JobExecuteEdit edit = (JobExecuteEdit)((Object)e.getSource());
        IFormView parentView = edit.getView().getParentView();
        parentView.showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u5df2\u5b8c\u6210\u3002", (String)"JobExecuteEdit_2", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), edit.jobMetaData().jobName()));
        edit.getView().sendFormAction(parentView);
        edit.getView().close();
    }
}

