/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.exportall.multiorg.task;

import com.alibaba.fastjson.JSONArray;
import java.util.Arrays;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.FieldEdit;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.export.ExportProgress;
import kd.bos.mvc.export.ExportProgressImpl;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.ReportList;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.model.JsonObjectAdapter;
import kd.fi.bd.model.schema.basedata.OrgSchema;
import kd.fi.bd.model.schema.property.Prop;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.model.schema.JobExecuteFormSchema;
import kd.fi.gl.model.schema.report.SubLedgerSchema;

public class MultipleOrgReportExportTask
extends AbstractTask {
    private ExportProgress exportProgress;
    private String originalSearchCondition = null;
    private String searchConditionWithoutOrgField = "";
    private Long originalOrgID = 0L;
    private static final String searchConditionSplitBy = ";  ";

    public ExportProgress getExportProgress() {
        if (this.exportProgress == null) {
            this.exportProgress = new ExportProgressImpl(this.taskId);
        }
        return this.exportProgress;
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) {
        JsonObjectAdapter jsonObject = JsonObjectAdapter.fromMap(map);
        String reportPageID = jsonObject.query(JobExecuteFormSchema.INSTANCE.Param_ParentPageID).toString();
        JSONArray orgs4Export = (JSONArray)jsonObject.query(SubLedgerSchema.INSTANCE.orgs4Export);
        ReportView reportView = (ReportView)SessionManager.getCurrent().getView(reportPageID);
        reportView.setExportProgress(this.getExportProgress());
        reportView.getReportList().setAsynQuery(true);
        ((ReportListModel)reportView.getReportList().getReportModel()).setAsynQuery(false);
        reportView.getReportList().getReportModel().getReportQueryParam().getFilter().getFilterItem(SubLedgerSchema.INSTANCE.Filter_ExportExcel.toString()).setValue((Object)true);
        this.cacheOriginalCondition(reportView);
        for (Object orgID : orgs4Export) {
            this.feedbackOrgProgress(orgs4Export, orgID);
            String url = this.exportSingle(reportView.getReportList(), Long.parseLong(orgID.toString()));
            this.publishUrl(this.taskId, url);
        }
        this.restoreCondition(reportView);
    }

    private void restoreCondition(ReportView reportView) {
        reportView.getPageCache().put("searchCondition", this.originalSearchCondition);
        this.replaceFilterWithNewOrg(reportView.getReportList(), this.originalOrgID);
        reportView.getQueryParam().getFilter().getFilterItem(SubLedgerSchema.INSTANCE.Filter_ExportExcel.toString()).setValue((Object)false);
        reportView.refresh();
    }

    private void feedbackOrgProgress(JSONArray orgsForExport, Object orgID) {
        OrgSchema orgSchema = new OrgSchema();
        DynamicObject orgDyn = BusinessDataServiceHelper.loadSingle((Object)orgID, (String)orgSchema.entity, (String)Prop.toSelectFieldStr((Prop[])new Prop[]{orgSchema.name}));
        this.getExportProgress().feedbackProgress(0, 0);
        this.getExportProgress().feedbackCustData((Map)JsonObjectAdapter.getEmpty().registerContext(JobExecuteFormSchema.INSTANCE.totalNum, (Object)orgsForExport.size()).registerContext(JobExecuteFormSchema.INSTANCE.onGoingNum, (Object)orgsForExport.indexOf(orgID)).registerContext(JobExecuteFormSchema.INSTANCE.Param_SubTaskName, (Object)orgDyn.getLocaleString(orgSchema.name.toFullName()).getLocaleValue()).getSource());
    }

    protected Object getSelectObject(ReportList reportList) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String exportSingle(ReportList reportList, Long orgID) {
        ReportListModel reportModel = (ReportListModel)reportList.getReportModel();
        ReportQueryParam queryParam = reportModel.getReportQueryParam();
        this.redirectToTempPageID(reportList);
        this.replaceFilterWithNewOrg(reportList, orgID);
        String url = "";
        try {
            reportList.submitTask(queryParam, this.getSelectObject(reportList));
            int total = reportList.getTotalRecords();
            this.getExportProgress().feedbackProgress(total, 0);
            url = reportList.exportExcel();
            this.getExportProgress().feedbackProgress(total, total);
        }
        finally {
            reportModel.close();
        }
        return url;
    }

    private void redirectToTempPageID(ReportList reportList) {
        ReportListModel reportModel = (ReportListModel)reportList.getReportModel();
        ReportQueryParam queryParam = reportModel.getReportQueryParam();
        String tempPageID = Uuid16.create().toString();
        reportModel.getReportCache().setReportQueryParam(tempPageID, queryParam);
        reportModel.setReportTaskResult(null);
        reportModel.setPageId(tempPageID);
    }

    private void cacheOriginalCondition(ReportView reportView) {
        this.originalSearchCondition = reportView.getPageCache().get("searchCondition");
        String[] split = this.originalSearchCondition.split(searchConditionSplitBy);
        this.searchConditionWithoutOrgField = String.join((CharSequence)searchConditionSplitBy, Arrays.copyOfRange(split, 1, split.length));
        this.originalOrgID = ((DynamicObject)reportView.getQueryParam().getFilter().getFilterItem(SubLedgerSchema.INSTANCE.org.toString()).getValue()).getLong("id");
    }

    private void replaceFilterWithNewOrg(ReportList reportList, Long orgID) {
        OrgSchema orgSchema = new OrgSchema();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgID, (String)orgSchema.entity, (String)Prop.toSelectFieldStr((Prop[])new Prop[]{orgSchema.masterID, orgSchema.number, orgSchema.name}));
        reportList.getReportModel().getReportQueryParam().getFilter().getFilterItem(SubLedgerSchema.INSTANCE.org.toString()).setValue((Object)org);
        StringBuilder newSearchCondition = new StringBuilder();
        FieldEdit orgEdit = (FieldEdit)reportList.getView().getControl(SubLedgerSchema.INSTANCE.org.toString());
        String orgEditName = orgEdit.getProperty().getDisplayName().toString();
        newSearchCondition.append(orgEditName).append("\uff1a").append(org.getLocaleString(orgSchema.name.toFullName())).append(searchConditionSplitBy).append(this.searchConditionWithoutOrgField);
        reportList.getView().getPageCache().put("searchCondition", newSearchCondition.toString());
    }

    private void publishUrl(String pageID, String url) {
        UrlManager.publish(pageID, url);
    }

    public static class UrlManager {
        private static DistributeCache getUrlCache() {
            return CacheHelper.getDistributeCache((CacheModule)CacheModule.report);
        }

        public static String consume(String taskID) {
            String url = UrlManager.getUrlCache().get(taskID);
            UrlManager.getUrlCache().remove(taskID);
            return url;
        }

        public static void publish(String taskID, String url) {
            UrlManager.spinWhenBlocked(taskID);
            UrlManager.getUrlCache().put(taskID, url);
        }

        public static boolean tryTouch(String taskID) {
            return UrlManager.getUrlCache().get(taskID) != null;
        }

        private static void spinWhenBlocked(String taskID) {
            while (Boolean.parseBoolean(System.getProperty("fi.gl.export.sleep", "true"))) {
                try {
                    if (!UrlManager.tryTouch(taskID)) {
                        return;
                    }
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

