/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.init;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportRowSet;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterContainerFilterValues;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bd.assign.OpLogHelper;
import kd.fi.bd.business.vo.CashFlowItemVO;
import kd.fi.bd.helper.CashFlowItemHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.cashflow.CashFlowInitExecutor;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistService;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.constant.InitCashFlow;
import kd.fi.gl.report.CashFlowFormRpt;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.FormExportUtil;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.PermissonType;

public class InitCashFlowItemFormRpt
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
BeforeFilterF7SelectListener {
    private static final int INIT_CAPACITY = 32;
    private static final String entityName = "gl_initcashflow";
    private static final String PC_BOOKTYPE = "pc_booktype";
    private static final String PC_ORG = "pc_orglist";
    private static final String ENTITY_BD_ACCOUNTBOOKSTYPE = "bd_accountbookstype";
    private static final String KEY_NEW = "new";
    private static final String KEY_EDIT = "edit";
    private static final String KEY_DELETE = "delete";
    private static final String KEY_EXPORT_EXCEL_BY_TEMPLATE = "exportexcelbytemplate";
    private static final String KEY_BATCH_INIT = "batchinit";
    private static final String KEY_BATCH_RESERVE_INIT = "batchreserveinit";
    private static final String DELETEALL = "deleteall";
    private static final String comassist_cahe = "comassist_cahe";
    public static final String COUNT = "count";
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.report);
    public static final Log logger = LogFactory.getLog(InitCashFlowItemFormRpt.class);

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        this.init(contInitEvent.getCommonFilterColumns());
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (!fieldName.isEmpty() && fieldName.startsWith("org.")) {
            List orgPkList = AccSysUtil.getAcctOrgPkList((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.VIEW);
            args.addCustomQFilter(new QFilter("id", "in", (Object)orgPkList));
        } else if (fieldName.startsWith("comassist")) {
            String comassistKey = fieldName.substring(0, "comassist".length() + 1);
            int index = Integer.parseInt(comassistKey.replace("comassist", ""));
            String source = this.getComassist().get(index - 1);
            args.setRefEntityId(source);
            List<QFilter> comAssistPermF = this.getComAssistPermF(this.getValFromPageCache(PC_ORG), comassistKey);
            comAssistPermF.addAll(args.getQfilters());
            args.setQfilters(comAssistPermF);
        }
    }

    private void init(List<FilterColumn> filters) {
        this.getPageCache().remove(comassist_cahe);
        Long customFilterOrgId = this.getCustomFilterId("org.id");
        Long customFilterBookTypeId = this.getCustomFilterId("booktype.id");
        int i = 0;
        ArrayList comassistList = new ArrayList(2);
        Iterator<FilterColumn> iterator = filters.iterator();
        while (iterator.hasNext()) {
            CommonFilterColumn commFilter = (CommonFilterColumn)iterator.next();
            String fieldName = commFilter.getFieldName();
            commFilter.setMulti(false);
            if ("org".equals(fieldName)) {
                List comboList = AccSysUtil.getAcctOrgComboItem((String)"gl_initcashflowitem", (boolean)false, (PermissonType)PermissonType.VIEW);
                commFilter.setComboItems(comboList);
                if (customFilterOrgId == null) {
                    long defaultOrgId;
                    Set orgSet = AccSysUtil.getAllOrgIdByComboItems((Collection)comboList);
                    customFilterOrgId = orgSet.contains(defaultOrgId = AccSysUtil.getDefaultOrgId((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.VIEW)) ? Long.valueOf(defaultOrgId) : GlFormUtil.getDefaultAcctOrg(new ArrayList<Long>(orgSet));
                    FormShowParameter showParameter = this.getView().getFormShowParameter();
                    String orgId = (String)showParameter.getCustomParam("imicdimension_bos_org");
                    if (StringUtils.isNotEmpty((CharSequence)orgId)) {
                        customFilterOrgId = Long.parseLong(orgId);
                    }
                    if (customFilterOrgId != null) {
                        commFilter.setDefaultValue(customFilterOrgId.toString());
                    }
                }
                this.cacheCustomFilterValue(PC_ORG, customFilterOrgId != null ? customFilterOrgId : 0L);
                continue;
            }
            if ("booktype".equals(fieldName)) {
                List bookTypeCombos = AccSysUtil.getBookTypeComboByOrg((long)(customFilterOrgId == null ? 0L : customFilterOrgId));
                commFilter.setComboItems(bookTypeCombos);
                long bookTypeId = 0L;
                if (bookTypeCombos.size() > 0) {
                    bookTypeId = Long.parseLong(((ComboItem)bookTypeCombos.get(0)).getValue());
                    commFilter.setDefaultValue(String.valueOf(bookTypeId));
                }
                List bkIds = bookTypeCombos.stream().map(x -> Long.valueOf(x.getValue())).collect(Collectors.toList());
                this.cacheCustomFilterValue(PC_BOOKTYPE, customFilterBookTypeId != null && bkIds.contains(customFilterBookTypeId) ? customFilterBookTypeId : bookTypeId);
                continue;
            }
            if (!fieldName.startsWith("comassist")) continue;
            if (CollectionUtils.isEmpty(comassistList) && this.getPageCache().get(PC_BOOKTYPE) != null && customFilterOrgId != null) {
                ComAssistTable.get((Long)customFilterOrgId, (Long)Long.parseLong(this.getPageCache().get(PC_BOOKTYPE))).ifPresent(commonAssistTable -> commonAssistTable.getCommonAssists().forEach(commonAssist -> {
                    if (commonAssist.isBalanced) {
                        comassistList.add(commonAssist);
                    }
                }));
            }
            if (comassistList.size() < i + 1) {
                iterator.remove();
                continue;
            }
            CommonAssist commonAssist = (CommonAssist)comassistList.get(i);
            if (DebugTrace.enable()) {
                logger.info("InitCashFlowItemFormRpt init comassistList : " + ((Object)comassistList).toString());
            }
            String entity = commonAssist.getValueSource();
            commFilter.setEntityType(MetadataServiceHelper.getDataEntityType((String)entity));
            commFilter.setEntityField(true);
            commFilter.setEntryEntity(entity);
            QFilter filter = new QFilter("1", "=", (Object)"1", true);
            List<QFilter> comAssistPermF = this.getComAssistPermF(customFilterOrgId != null ? customFilterOrgId : 0L, commonAssist.key);
            comAssistPermF.forEach(e -> filter.and(e));
            if ("2".equals(commonAssist.valueSourceType)) {
                filter.and(new QFilter("group", "=", (Object)commonAssist.getAssistType()));
            }
            if (DebugTrace.enable()) {
                logger.info("InitCashFlowItemFormRpt init comassist filter : " + filter.toString());
            }
            DynamicObjectCollection basedata = QueryServiceHelper.query((String)entity, (String)"id,name,number", (QFilter[])filter.toArray(), null);
            List items = basedata.parallelStream().map(x -> new ComboItem(new LocaleString(x.getString("name")), x.getString("id"))).collect(Collectors.toList());
            commFilter.setComboItems(items);
            commFilter.setCaption(new LocaleString(CommonAssistUtil.getComAssistEntityName((long)(customFilterOrgId != null ? customFilterOrgId : 0L), (long)Long.parseLong(this.getPageCache().get(PC_BOOKTYPE)), (String)entity)));
            ++i;
        }
        List comAssistValSource = CommonAssistUtil.getComAssistValSource((long)(customFilterOrgId != null ? customFilterOrgId : 0L), (long)Long.parseLong(this.getPageCache().get(PC_BOOKTYPE)));
        if (!CollectionUtils.isEmpty((Collection)comAssistValSource)) {
            this.getPageCache().put(comassist_cahe, StringUtils.join((Object[])comAssistValSource.toArray(), (String)","));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        FilterInfo filter;
        FilterItemInfo filterItem;
        SearchClickEvent searchClickEvent = args.getSearchClickEvent();
        Map filterValues = searchClickEvent.getFilterValues();
        List customFils = (List)filterValues.get("customfilter");
        if (customFils == null) {
            return;
        }
        long bkId = 0L;
        for (Map map : customFils) {
            String fieldName = (String)((List)map.get("FieldName")).get(0);
            if (!"booktype.id".equals(fieldName)) continue;
            List val = (List)map.get("Value");
            val.clear();
            bkId = this.getValFromPageCache(PC_BOOKTYPE);
            val.add(bkId == 0L ? "" : String.valueOf(bkId));
            break;
        }
        if (Objects.nonNull(filterItem = (filter = this.getQueryParam().getFilter()).getFilterItem("booktype.id"))) {
            filterItem.setValue((Object)bkId);
        }
    }

    private void cacheCustomFilterValue(String key, long value) {
        this.getPageCache().put(key, String.valueOf(value));
    }

    private long getValFromPageCache(String key) {
        switch (key) {
            case "pc_booktype": {
                String booksTypeStr = this.getPageCache().get(PC_BOOKTYPE);
                return booksTypeStr == null ? 0L : Long.parseLong(booksTypeStr);
            }
            case "pc_orglist": {
                String orgIdsJson = this.getPageCache().get(PC_ORG);
                return orgIdsJson == null ? 0L : Long.parseLong(orgIdsJson);
            }
        }
        return 0L;
    }

    private Long getCustomFilterId(String fieldName) {
        Long result = null;
        FilterContainerFilterValues filterValues = this.getFilterValue();
        if (filterValues == null) {
            return result;
        }
        FilterKeyValueCollections otherFilterValues = filterValues.getOtherFilterValues();
        if (otherFilterValues != null && otherFilterValues.getFilterKey().equalsIgnoreCase("customfilter")) {
            List filterValuesList = otherFilterValues.createFilterValuesList();
            for (Map map : filterValuesList) {
                List name = (List)map.get("FieldName");
                if (!name.get(0).equals(fieldName)) continue;
                List list = (List)map.get("Value");
                if (list == null || list.size() == 0) {
                    return null;
                }
                Object value = list.get(0);
                if (StringUtils.isBlank(value)) {
                    return null;
                }
                result = Long.valueOf((String)value);
            }
        }
        return result;
    }

    private FilterContainerFilterValues getFilterValue() {
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        return filterContainer.getCachedFilterValues();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit endinitperiod = (BasedataEdit)this.getControl("endinitperiod");
        endinitperiod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        FilterContainer container = (FilterContainer)this.getControl("filtercontainerap");
        container.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "template": {
                this.template();
                break;
            }
            case "import": {
                this.importData();
                break;
            }
            case "endinit": {
                this.endinit();
                break;
            }
            case "reverseinit": {
                this.reverseinit();
                break;
            }
            case "new": {
                this.newAssgrp();
                break;
            }
            case "edit": {
                this.editAssgrp();
                break;
            }
            case "delete": {
                ReportList report = (ReportList)this.getView().getControl("reportlistap");
                int[] selectedRows = report.getEntryState().getSelectedRows();
                if (selectedRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"InitCashFlowItemFormRpt_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!this.validateDelete(evt.getItemKey())) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u6838\u7b97\u7ef4\u5ea6\u548c\u672c\u5e74\u7d2f\u8ba1\u3002", (String)"InitCashFlowItemFormRpt_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(KEY_DELETE, (IFormPlugin)this));
                break;
            }
            case "exportexcelbytemplate": {
                this.export();
                break;
            }
            case "batchinit": {
                this.showForm(Boolean.TRUE);
                break;
            }
            case "batchreserveinit": {
                this.showForm(Boolean.FALSE);
                break;
            }
            case "deleteall": {
                this.getView().showConfirm(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5168\u90e8\u5220\u9664\uff1a\u4f1a\u5220\u9664\u6240\u6709\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0b\u6240\u6709\u6838\u7b97\u7ef4\u5ea6\u7684\u503c\uff0c\u662f\u5426\u786e\u8ba4\u5168\u90e8\u5220\u9664\u3002", (String)"InitCashFlowItemFormRpt_33", (String)"fi-gl-formplugin", (Object[])new Object[0]), (String)"InitCashFlowItemFormRpt_33", (String)"fi-gl-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETEALL, (IFormPlugin)this));
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        FilterItemInfo orgItem = filterInfo.getFilterItem("org.id");
        FilterItemInfo bookTypeItem = filterInfo.getFilterItem("booktype.id");
        if (orgItem == null || bookTypeItem == null) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u8868\u5934\u8fc7\u6ee4\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8fc7\u6ee4\u8bbe\u7f6e\u3002", (String)"InitCashFlowItemFormRpt_45", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            return;
        }
        switch (itemKey = evt.getItemKey()) {
            case "export": {
                this.cache.put(this.getView().getPageId() + COUNT, "0");
            }
            case "exportexcelbytemplate": {
                if (GLUtil.hasPermission((String)"4730fc9f000004ae", (Long)orgItem.getLong(), (String)this.getView().getEntityId())) break;
                evt.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u201d\u7684\u64cd\u4f5c\u201c\u5bfc\u51fa\u201d\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InitCashFlowItemFormRpt_46", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (evt.getResult() == MessageBoxResult.Yes && (KEY_DELETE.equals(callBackId) || DELETEALL.equals(callBackId))) {
            this.deleteAssgrp(callBackId);
        }
    }

    private void reverseinit() {
        this.initOp("anticloseinitcashflow");
    }

    private void endinit() {
        this.initOp("closeinitcashflow");
    }

    private void initOp(String opKey) {
        DynamicObject bookOp;
        OperationResult result;
        String permissionId;
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        FilterItemInfo orgItem = filterInfo.getFilterItem("org.id");
        if (orgItem == null) {
            return;
        }
        String string = permissionId = "closeinitcashflow".equals(opKey) ? "4730fc9f000005ae" : "4730fc9f000006ae";
        if (!GLUtil.hasPermission((String)permissionId, (Long)orgItem.getLong(), (String)this.getView().getEntityId())) {
            if ("closeinitcashflow".equals(opKey)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u7ed3\u675f\u521d\u59cb\u5316\u201d\u7684\u529f\u80fd\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u201c\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316>\u7ed3\u675f\u521d\u59cb\u5316\u201d\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InitCashFlowItemFormRpt_35", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u53cd\u521d\u59cb\u5316\u201d\u7684\u529f\u80fd\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u201c\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316>\u53cd\u521d\u59cb\u5316\u201d\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InitCashFlowItemFormRpt_36", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        DynamicObject book = this.getBookInfo();
        if (book == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u8d26\u7c3f\u4fe1\u606f\u3002", (String)"InitCashFlowItemFormRpt_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        OperateOption operateOption = OperateOption.create();
        if ("closeinitcashflow".equals(opKey)) {
            ArrayList<Integer> rowNumbers = new ArrayList<Integer>(2);
            ReportList control = (ReportList)this.getControl("reportlistap");
            IReportListModel reportModel = control.getReportModel();
            int rowCount = reportModel.getRowCount();
            ReportRowSet rowSet = ((AbstractReportListModel)reportModel).getReportTaskResult().getData(0, rowCount);
            int rowNum = 1;
            while (rowSet.next()) {
                String name = (String)rowSet.getObject("name");
                if (StringUtils.isNotBlank((CharSequence)name) && name.contains(ResManager.loadKDString((String)"\u73b0\u91d1\u53ca\u73b0\u91d1\u7b49\u4ef7\u7269\u51c0\u589e\u52a0\u989d", (String)"InitCashFlowItemFormRpt_4", (String)"fi-gl-formplugin", (Object[])new Object[0]))) {
                    rowNumbers.add(rowNum);
                }
                ++rowNum;
            }
            operateOption.setVariableValue("indexs", StringUtils.join((Object[])rowNumbers.toArray(), (String)"_"));
        }
        if ((result = OperationServiceHelper.executeOperate((String)opKey, (String)"gl_endinit", (DynamicObject[])new DynamicObject[]{bookOp = BusinessDataServiceHelper.loadSingle((Object)book.getLong("id"), (String)"gl_endinit")}, (OperateOption)operateOption)).isSuccess()) {
            if (opKey.equals("anticloseinitcashflow")) {
                if (PeriodUtil.getPeriodNumber((long)book.getLong(GLField.id_((String)"cashinitperiod"))) == 1L) {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"endinit"});
                } else {
                    this.setBtnEnable(true);
                }
            } else {
                this.setBtnEnable(false);
            }
            String info = "anticloseinitcashflow".equals(opKey) ? ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"InitCashFlowItemFormRpt_6", (String)"fi-gl-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"InitCashFlowItemFormRpt_7", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(info);
        } else {
            this.getView().showOperationResult(result);
        }
    }

    private DynamicObject getBookInfo() {
        Object booktype;
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        FilterItemInfo orgItem = filterInfo.getFilterItem("org.id");
        FilterItemInfo filterItem = filterInfo.getFilterItem("booktype.id");
        if (filterItem == null) {
            AccountBookInfo defaultBookFromAccSys = AccSysUtil.getDefaultBookFromAccSys((Long)orgItem.getLong());
            booktype = defaultBookFromAccSys.getBookTypeId();
        } else {
            booktype = filterItem.getValue();
        }
        return AccSysUtil.loadSingleBook((Object)orgItem.getValue(), (Object)booktype, (String)"id,basecurrency,bookstype,cashinitperiod");
    }

    private void template() {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("bos_importtemplate");
        parameter.setCustomParam("bindEntityId", (Object)entityName);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void importData() {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        FilterItemInfo orgItem = filterInfo.getFilterItem("org.id");
        if (orgItem == null) {
            return;
        }
        String permissionId = "4730fc9f000003ae";
        if (!GLUtil.hasPermission((String)permissionId, (Long)orgItem.getLong(), (String)this.getView().getEntityId())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u201d\u7684\u64cd\u4f5c\u201c\u5bfc\u5165\u201d\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InitCashFlowItemFormRpt_34", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_importstart");
        showParameter.setCustomParam("BillFormId", (Object)entityName);
        showParameter.setCustomParam("ListName", (Object)this.getView().getFormShowParameter().getFormName());
        showParameter.setCustomParam("RealPermissionEntityId", (Object)this.getView().getEntityId());
        showParameter.setCustomParam("ImportPlugin", (Object)"kd.fi.gl.formplugin.cashflow.CashFlowComAssistImportPlugin");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeimport"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection rows;
        String actionId = closedCallBackEvent.getActionId();
        if ("closeimport".equals(actionId) || "editassgrp".equals(actionId)) {
            this.getView().refresh();
            return;
        }
        if (("closeinitcashflow".equals(actionId) || "anticloseinitcashflow".equals(actionId)) && null != (rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData())) {
            String orgs = StringUtils.join((Object[])rows.getPrimaryKeyValues(), (String)",");
            HashMap result = CashFlowInitExecutor.batchInit((String)actionId, (String)orgs, (long)this.getBookInfo().getLong("bookstype.id"));
            String errorMsg = result.get("errormsg").toString();
            int successcount = (Integer)result.get("successcount");
            int faultcount = (Integer)result.get("faultcount");
            if (errorMsg.length() != 0) {
                this.showMsg(successcount, faultcount, errorMsg);
                this.getView().refresh();
                return;
            }
            if (errorMsg.length() == 0) {
                String info = "anticloseinitcashflow".equals(actionId) ? ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"InitCashFlowItemFormRpt_6", (String)"fi-gl-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"InitCashFlowItemFormRpt_7", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(info);
                this.getView().refresh();
            } else {
                if (successcount > 0) {
                    this.getView().refresh();
                }
                this.showMsg(successcount, faultcount, errorMsg);
            }
        }
    }

    private void setBookInfo(DynamicObject book) {
        Long endinitperiod = null;
        if (book.getLong("cashinitperiod") != 0L) {
            endinitperiod = book.getLong("cashinitperiod");
        }
        this.getModel().setValue("endinitperiod", (Object)endinitperiod);
        if (endinitperiod == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u7c3f\u672a\u8bbe\u7f6e\u201c\u73b0\u91d1\u6d41\u91cf\u542f\u7528\u671f\u95f4\u201d\uff0c\u8bf7\u5148\u5230\u4f1a\u8ba1\u8d26\u7c3f\u4e0a\u8bbe\u7f6e\u201c\u73b0\u91d1\u6d41\u91cf\u542f\u7528\u671f\u95f4\u201d\u540e\u518d\u8fdb\u884c\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u3002", (String)"InitCashFlowItemFormRpt_43", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        long initPeriodId = book.getLong("cashinitperiod");
        DynamicObject dynPeriod = null;
        if (endinitperiod != null) {
            dynPeriod = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("endinitperiod_id"), (String)"bd_period");
            if (book.getBoolean("isendinitcashflow")) {
                this.setBtnEnable(false);
            } else if (1 == dynPeriod.getInt("periodnumber")) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"import", KEY_NEW, KEY_EDIT, KEY_DELETE, DELETEALL});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"endinit"});
            } else {
                this.setBtnEnable(true);
            }
        }
        if (Objects.isNull(dynPeriod)) {
            this.setBtnEnable(false);
        }
        this.getPageCache().put("periodtypeId", String.valueOf(book.getLong("periodtype")));
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        QFilter[] qFilters = new QFilter[2];
        List filter = queryParam.getFilter().getFilterItems();
        HashMap<String, Object> comassists = new HashMap<String, Object>(2);
        for (FilterItemInfo item : filter) {
            String propName;
            switch (propName = item.getPropName()) {
                case "booktype.id": 
                case "booktype.name": {
                    qFilters[0] = new QFilter(item.getPropName().replace("booktype", "bookstype"), item.getCompareType(), item.getValue());
                    break;
                }
                case "org.id": 
                case "org.name": {
                    qFilters[1] = new QFilter(item.getPropName(), item.getCompareType(), item.getValue());
                }
            }
            if (!propName.startsWith("comassist")) continue;
            int index = propName.indexOf(".");
            if (index > 0) {
                comassists.put(propName.substring(0, index), item.getValue());
                continue;
            }
            comassists.put(propName, item.getValue());
        }
        String select = "cashinitperiod,curperiod,curperiod.periodnumber periodnumber,periodtype,org,bookstype,isendinitcashflow";
        DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)select, (QFilter[])qFilters);
        if (book == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u548c\u8d26\u7c3f\u7c7b\u578b\u5bf9\u5e94\u7684\u8d26\u7c3f\u627e\u4e0d\u5230\u3002", (String)"InitCashFlowItemFormRpt_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        FilterItemInfo orgInfo = new FilterItemInfo("org.id", (Object)book.getLong("org"), "=");
        FilterItemInfo btInfo = new FilterItemInfo("booktype.id", (Object)book.getLong("bookstype"), "=");
        filter.clear();
        filter.add(orgInfo);
        filter.add(btInfo);
        this.setBookInfo(book);
        if (CollectionUtils.isEmpty(comassists)) {
            List<String> comassist = this.getComassist();
            for (int i = 1; i <= comassist.size(); ++i) {
                FilterItemInfo comassistInfo = new FilterItemInfo("comassist" + i, (Object)0L, "=");
                filter.add(comassistInfo);
            }
        } else {
            for (Map.Entry entry : comassists.entrySet()) {
                FilterItemInfo comassistInfo = new FilterItemInfo((String)entry.getKey(), entry.getValue(), "=");
                filter.add(comassistInfo);
            }
        }
        this.cache.put(this.getView().getPageId() + COUNT, "0");
        return true;
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        queryParam.getCustomParam().put("pageId", this.getView().getPageId());
        queryParam.getCustomParam().put("orgId", this.getFilter("org.id"));
        queryParam.getCustomParam().put("endPeriodId", this.getModel().getValue("endinitperiod_id"));
        new CashFlowFormRpt().processRowData(gridPK, rowData, queryParam);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        Object source = arg0.getSource();
        Control sourceCtl = (Control)source;
        String key = sourceCtl.getKey();
        if ("endinitperiod".equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            ListFilterParameter filterParam = showParameter.getListFilterParameter();
            String periodtypeid = this.getPageCache().get("periodtypeId");
            filterParam.getQFilters().add(new QFilter("periodtype", "=", (Object)periodtypeid));
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent arg0) {
        List ids;
        String fieldName = arg0.getFieldName();
        if (fieldName.startsWith("booktype") && null != (ids = AccSysUtil.getBookTypeDataPermission(null))) {
            arg0.addCustomQFilter(new QFilter("id", "in", (Object)ids));
        }
    }

    private void newAssgrp() {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long orgId = this.getCustomFilterId("org.id");
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        HasPermOrgResult hasPermOrg = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"10", (String)appId, (String)"gl_initcashflowitem", (String)"47156aff000000ac");
        if (null == hasPermOrg || !hasPermOrg.hasAllOrgPerm() && !hasPermOrg.getHasPermOrgs().contains(orgId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InitCashFlowItemFormRpt_9", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.checkSelectedRow()) {
            return;
        }
        this.showForm(KEY_NEW);
    }

    private boolean checkSelectedRow() {
        DynamicObject cashFlowItem;
        Optional cashFlowItemVO;
        ReportList report = (ReportList)this.getView().getControl("reportlistap");
        int rowIndex = report.getEntryState().getFocusRow();
        DynamicObject selectedRow = report.getReportModel().getRowData(rowIndex);
        if (selectedRow == null) {
            return true;
        }
        Long cashFlowItemId = selectedRow.getLong("cfitemid.id");
        if (cashFlowItemId == null) {
            logger.info("\u73b0\u91d1\u6d41\u91cf\u9879\u76eenumber is blank!");
            return true;
        }
        if (this.getModel().getValue("endinitperiod_id") != null && (cashFlowItemVO = CashFlowItemHelper.loadSingleForVersion((Long)cashFlowItemId, (Long)this.getCustomFilterId("org.id"), (Long)((Long)this.getModel().getValue("endinitperiod_id")))).isPresent()) {
            cashFlowItemId = ((CashFlowItemVO)cashFlowItemVO.get()).getId();
        }
        if ((cashFlowItem = QueryServiceHelper.queryOne((String)"gl_cashflowitem", null, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)cashFlowItemId)})) == null) {
            logger.info(String.format("\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u67e5\u8be2\u4e3anull!id=%s", cashFlowItemId));
            return true;
        }
        if (!cashFlowItem.getBoolean("isleaf")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u660e\u7ec6\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u652f\u6301\u5f55\u5165\u521d\u59cb\u5316\u6570\u636e\u3002", (String)"InitCashFlowItemFormRpt_10", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (cashFlowItem.getBoolean("isprefit")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u51c0\u5229\u6da6\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u652f\u6301\u5f55\u5165\u521d\u59cb\u5316\u6570\u636e\u3002", (String)"InitCashFlowItemFormRpt_11", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!"3".equals(cashFlowItem.getString("type")) && "b".equals(cashFlowItem.getString("direction"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u5411\u4e3a\u6d41\u5165\u6d41\u51fa\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u652f\u6301\u5f55\u5165\u521d\u59cb\u5316\u6570\u636e\u3002", (String)"InitCashFlowItemFormRpt_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void editAssgrp() {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        HasPermOrgResult hasPermOrg = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"10", (String)appId, (String)"gl_initcashflowitem", (String)"0A3J+YT5CUD4");
        if (null == hasPermOrg || !hasPermOrg.hasAllOrgPerm() && hasPermOrg.getHasPermOrgs().size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff01\u60a8\u6ca1\u6709[\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u5217\u8868]\u7684\u64cd\u4f5c[\u8c03\u6574]\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InitCashFlowItemFormRpt_14", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        ReportList report = (ReportList)this.getView().getControl("reportlistap");
        int rowIndex = report.getEntryState().getFocusRow();
        DynamicObject selectedRow = report.getReportModel().getRowData(rowIndex);
        if (selectedRow == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u8c03\u6574\u3002", (String)"InitCashFlowItemFormRpt_39", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.checkSelectedRow()) {
            return;
        }
        this.showForm(KEY_EDIT);
    }

    private void showForm(String opKey) {
        String permissionId;
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        FilterItemInfo orgItem = filterInfo.getFilterItem("org.id");
        if (orgItem == null) {
            return;
        }
        String string = permissionId = "closeinitcashflow".equals(opKey) ? "4730fc9f000005ae" : "4730fc9f000006ae";
        if (!GLUtil.hasPermission((String)permissionId, (Long)orgItem.getLong(), (String)this.getView().getEntityId())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"InitCashFlowItemFormRpt_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formParams = new FormShowParameter();
        formParams.setFormId("gl_initcashflowassgrp");
        formParams.setParentPageId(this.getView().getPageId());
        formParams.getOpenStyle().setShowType(ShowType.Modal);
        formParams.setCustomParam("opkey", (Object)opKey);
        formParams.setCustomParam("org", this.getFilter("org.id"));
        formParams.setCustomParam("booktype", this.getFilter("booktype.id"));
        DynamicObject bookInfo = this.getBookInfo();
        formParams.setCustomParam("currency", (Object)bookInfo.getLong("basecurrency_id"));
        DynamicObject rowData = this.getRptSelectRow();
        if (rowData != null) {
            Optional cashFlowItemVO;
            String cashFlowItemNumber;
            DynamicObject cashFlowItem;
            DynamicObject cfItem = rowData.getDynamicObject("cfitemid");
            if (cfItem == null || !((Boolean)cfItem.get("isleaf")).booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u975e\u660e\u7ec6\u8282\u70b9\u4e0d\u80fd\u7f16\u8f91\u3002", (String)"InitCashFlowItemFormRpt_15", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            if (KEY_EDIT.equals(opKey) && cfItem.getInt("level") < 3 && (cashFlowItem = QueryServiceHelper.queryOne((String)"gl_cashflowitem", null, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)(cashFlowItemNumber = rowData.getString("number")))})) == null) {
                logger.warn(String.format("\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u67e5\u8be2\u4e3anull!id=%s", cashFlowItemNumber));
                return;
            }
            formParams.setCustomParam("cfitem", (Object)cfItem.getLong("id"));
            if (KEY_NEW.equals(opKey) && this.getModel().getValue("endinitperiod_id") != null && (cashFlowItemVO = CashFlowItemHelper.loadSingleForVersion((Long)cfItem.getLong("id"), (Long)this.getCustomFilterId("org.id"), (Long)((Long)this.getModel().getValue("endinitperiod_id")))).isPresent()) {
                formParams.setCustomParam("cfitem", (Object)((CashFlowItemVO)cashFlowItemVO.get()).getId());
            }
            if (KEY_EDIT.equals(opKey)) {
                HashMap<String, Object> mapData = new HashMap<String, Object>();
                mapData.put("assgrp", rowData.getString("assgrp.id"));
                mapData.put("yearamount", rowData.getBigDecimal("yearamount"));
                formParams.setCustomParam("rowData", (Object)SerializationUtils.toJsonString(mapData));
            }
            List<String> comassistList = this.getComassist();
            for (int i = 1; i <= comassistList.size(); ++i) {
                String comassist = "comassist" + i;
                Object value = KEY_NEW.equals(opKey) ? this.getFilter(InitCashFlow.id((String)comassist)) : Long.valueOf(rowData.getLong(InitCashFlow.id((String)comassist)));
                formParams.setCustomParam(comassist, value);
            }
        }
        formParams.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "editassgrp"));
        this.getView().showForm(formParams);
    }

    private Object getFilter(String filterFiled) {
        FilterInfo filter = this.getQueryParam().getFilter();
        FilterItemInfo filterItem = filter.getFilterItem(filterFiled);
        return Optional.ofNullable(filterItem).orElseGet(FilterItemInfo::new).getValue();
    }

    private void deleteAssgrp(String callBackId) {
        if (!GLUtil.hasPermission((String)"4715e1f1000000ac", (Long)((Long)this.getFilter("org.id")), (String)"gl_initcashflowitem")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff01\u60a8\u6ca1\u6709[\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316]\u7684\u64cd\u4f5c[\u5220\u9664]\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InitCashFlowItemFormRpt_19", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qfOrg = new QFilter("org", "=", this.getFilter("org.id"));
        QFilter qfbooktype = new QFilter("booktype", "=", this.getFilter("booktype.id"));
        Map<String, List<Long>> cfitem_Assgrp = this.getCfitemAndAssgrp(callBackId);
        QFilter qfcfitem = null;
        for (Map.Entry<String, List<Long>> entry : cfitem_Assgrp.entrySet()) {
            String key = entry.getKey();
            String[] cfitem2comassist = key.split("_");
            QFilter qFilter2 = new QFilter("cfitem.masterid", "=", (Object)Long.parseLong(cfitem2comassist[0]));
            for (int i = 1; i < cfitem2comassist.length; ++i) {
                if (!StringUtils.isNotEmpty((CharSequence)cfitem2comassist[i]) || "0".equals(cfitem2comassist[i])) continue;
                qFilter2.and(new QFilter("comassist" + i, "=", (Object)Long.parseLong(cfitem2comassist[i])));
            }
            int size = entry.getValue().size();
            if (size > 0) {
                qFilter2.and(new QFilter("assgrp", "in", entry.getValue()));
            }
            if (null == qfcfitem) {
                qfcfitem = qFilter2;
                continue;
            }
            qfcfitem.or(qFilter2);
        }
        DynamicObject[] initCashFlow = BusinessDataServiceHelper.load((String)entityName, (String)"id", (QFilter[])new QFilter[]{qfOrg, qfbooktype, qfcfitem});
        if (initCashFlow.length == 0) {
            this.getView().refresh();
            return;
        }
        StringBuilder sql = new StringBuilder(" update t_gl_initcashflow set ftabdelete = '1' where  fid in (");
        for (int i = 0; i < initCashFlow.length; ++i) {
            DynamicObject init = initCashFlow[i];
            if (i == 0) {
                sql.append(init.getLong("id"));
                continue;
            }
            sql.append(",").append(init.getLong("id"));
        }
        sql.append(")");
        if (sql.length() > 0) {
            DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)sql.toString());
        }
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316", "InitCashFlowAssgrpInfo_7", "fi-gl-formplugin");
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u5220\u9664\u6210\u529f\u3002", "InitCashFlowItemFormRpt_40", "fi-gl-formplugin");
        String[] descParams = new String[]{};
        new OpLogHelper().addOperateLog((IFormView)this.getView(), Long.parseLong(this.getPageCache().get(PC_ORG)), "", "delInitCashFlow", opNameBridge, opDescBridge, descParams);
        this.getView().refresh();
    }

    private boolean validateDelete(String callBackId) {
        Map<String, List<Long>> cfitem_Assgrp = this.getCfitemAndAssgrp(callBackId);
        for (Map.Entry<String, List<Long>> entry : cfitem_Assgrp.entrySet()) {
            List<Long> assgrp = entry.getValue();
            for (Long assgrpid : assgrp) {
                if (assgrpid != 0L) continue;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u4e2d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u70b9\u51fb\u5220\u9664\uff0c\u4f1a\u5220\u9664\u8be5\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0b\u6240\u6709\u6838\u7b97\u7ef4\u5ea6\u7684\u503c\uff0c\u662f\u5426\u5220\u9664\uff1f", (String)"InitCashFlowItemFormRpt_20", (String)"fi-gl-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(KEY_DELETE, (IFormPlugin)this));
                return false;
            }
        }
        return true;
    }

    private Map<String, List<Long>> getCfitemAndAssgrp(String callBackId) {
        HashMap<String, List<Long>> cfitem_Assgrp = new HashMap<String, List<Long>>();
        if (DELETEALL.equals(callBackId)) {
            return cfitem_Assgrp;
        }
        List<String> comassist = this.getComassist();
        ReportList report = (ReportList)this.getView().getControl("reportlistap");
        int[] selectedRows = report.getEntryState().getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            DynamicObject rowData = report.getReportModel().getRowData(selectedRows[i]);
            DynamicObject cfitem = rowData.getDynamicObject("cfitemid");
            if (cfitem == null) continue;
            long cfitemid = cfitem.getLong("masterid");
            long assgrp_id = rowData.getLong("assgrp_id");
            ArrayList<String> cfitem2comassist = new ArrayList<String>(3);
            cfitem2comassist.add(cfitemid + "");
            for (int j = 1; j <= comassist.size(); ++j) {
                cfitem2comassist.add(rowData.getString(InitCashFlow.id_((String)("comassist" + j))));
            }
            String key = StringUtils.join((Object[])cfitem2comassist.toArray(), (String)"_");
            if (cfitem_Assgrp.containsKey(key)) {
                ((List)cfitem_Assgrp.get(key)).add(assgrp_id);
                continue;
            }
            cfitem_Assgrp.put(key, Lists.newArrayList((Object[])new Long[]{assgrp_id}));
        }
        return cfitem_Assgrp;
    }

    private void setBtnEnable(boolean isEnable) {
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"import", "endinit", KEY_NEW, KEY_EDIT, KEY_DELETE, DELETEALL});
    }

    private DynamicObject getRptSelectRow() {
        ReportList report = (ReportList)this.getView().getControl("reportlistap");
        int rowIndex = report.getEntryState().getFocusRow();
        return report.getReportModel().getRowData(rowIndex);
    }

    private void export() {
        ReportQueryParam queryParam = this.getQueryParam();
        FilterItemInfo orgFilterItem = queryParam.getFilter().getFilterItem("org.id");
        FilterItemInfo booktypeFilterItem = queryParam.getFilter().getFilterItem("booktype.id");
        QFilter orgFilter = new QFilter("org", "=", orgFilterItem.getValue());
        QFilter bookTypeFilter = new QFilter("booktype", "=", booktypeFilterItem.getValue());
        QFilter deleteFilter = new QFilter("tabdelete", "=", (Object)"0");
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)entityName, (String)StringUtils.join((Object[])EntityMetadataCache.getDataEntityType((String)entityName).getAllFields().keySet().toArray(), (String)","), (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, deleteFilter});
        this.exportExcelByTemplate(datas);
    }

    private void exportExcelByTemplate(DynamicObject[] data) {
        if (data != null && ((DynamicObject[])data).length > 0) {
            DynamicObject accountBookDyn;
            ArrayList<String> header = new ArrayList<String>(32);
            ArrayList<String> fieldHeader = new ArrayList<String>(32);
            fieldHeader.add("org.number");
            fieldHeader.add("booktype.number");
            fieldHeader.add("cfitem.number");
            header.add(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7.\u7f16\u7801", (String)"InitCashFlowItemFormRpt_21", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            header.add(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b.\u7f16\u7801", (String)"InitCashFlowItemFormRpt_22", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            header.add(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u9879\u76ee.\u7f16\u7801", (String)"InitCashFlowItemFormRpt_23", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            List<String> comassist = this.getComassist();
            for (int i = 1; i <= comassist.size(); ++i) {
                header.add(String.format(ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6%1$s\u7f16\u7801", (String)"InitCashFlowItemFormRpt_37", (String)"fi-gl-formplugin", (Object[])new Object[0]), i));
                fieldHeader.add("comassist" + i + ".number");
            }
            int count = 8;
            for (int i = 0; i < count; ++i) {
                header.add(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6", (String)"InitCashFlowItemFormRpt_24", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                header.add(ResManager.loadKDString((String)"\u7f16\u7801", (String)"InitCashFlowItemFormRpt_25", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                header.add(ResManager.loadKDString((String)"\u540d\u79f0", (String)"InitCashFlowItemFormRpt_26", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                fieldHeader.add("assgrp");
                fieldHeader.add("assgrp.number");
                fieldHeader.add("assgrp.name");
            }
            header.add(ResManager.loadKDString((String)"\u91d1\u989d", (String)"InitCashFlowItemFormRpt_27", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            fieldHeader.add("yearamount");
            ArrayList<List<String>> rowDatas = new ArrayList<List<String>>(32);
            ReportQueryParam queryParam = this.getQueryParam();
            FilterItemInfo orgFilterItem = queryParam.getFilter().getFilterItem("org.id");
            FilterItemInfo booktypeFilterItem = queryParam.getFilter().getFilterItem("booktype.id");
            DynamicObject bookType = null;
            DynamicObject org = null;
            ORM orm = ORM.create();
            if (null != booktypeFilterItem) {
                bookType = orm.queryOne(ENTITY_BD_ACCOUNTBOOKSTYPE, "id, number", new QFilter[]{new QFilter("id", "=", (Object)booktypeFilterItem.getLong())});
            }
            if (null != orgFilterItem) {
                org = orm.queryOne("bos_org", "id, number", new QFilter[]{new QFilter("id", "=", (Object)orgFilterItem.getLong())});
            }
            int scale = 4;
            if (null != org && null != bookType && (accountBookDyn = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"basecurrency.amtprecision amtprecision", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)org.getLong("id")), new QFilter("bookstype", "=", (Object)bookType.getLong("id"))})) != null) {
                scale = accountBookDyn.getInt("amtprecision");
            }
            for (DynamicObject datum : data) {
                count = 8;
                ArrayList<String> rowData = new ArrayList<String>(32);
                if (null != org) {
                    rowData.add(org.getString("number"));
                } else {
                    rowData.add("");
                }
                if (null != bookType) {
                    rowData.add(bookType.getString("number"));
                } else {
                    rowData.add("");
                }
                DynamicObject cfitem = (DynamicObject)datum.get("cfitem");
                if (null != cfitem) {
                    rowData.add(cfitem.getString("number"));
                } else {
                    rowData.add("");
                }
                for (int i = 0; i < comassist.size(); ++i) {
                    DynamicObject dyn = QueryServiceHelper.queryOne((String)comassist.get(i), (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", datum.get("comassist" + (i + 1) + "_id"))});
                    rowData.add(dyn != null ? dyn.getString("number") : "");
                }
                DynamicObject assgrp = (DynamicObject)datum.get("assgrp");
                if (null != assgrp) {
                    String value = assgrp.getString("value");
                    JSONObject jsonObject = JSONObject.parseObject((String)value);
                    Set entries = jsonObject.entrySet();
                    HashSet flexFields = new HashSet(entries.size());
                    for (Map.Entry entry : entries) {
                        flexFields.add(entry.getKey());
                    }
                    DynamicObjectCollection propertys = QueryServiceHelper.query((String)"bos_flex_property", (String)"id, name, number, flexfield, valuesource, valuetype", (QFilter[])new QFilter[]{new QFilter("flexfield", "in", flexFields)});
                    HashMap<String, DynamicObject> assgrpMap = new HashMap<String, DynamicObject>();
                    for (DynamicObject ass : propertys) {
                        assgrpMap.put(ass.getString("flexfield"), ass);
                    }
                    for (Map.Entry entry : entries) {
                        --count;
                        DynamicObject basFlexProperty = (DynamicObject)assgrpMap.get(entry.getKey());
                        if (null == basFlexProperty) continue;
                        rowData.add(basFlexProperty.getString("name"));
                        String valuetype = basFlexProperty.getString("valuetype");
                        if ("3".equals(valuetype)) {
                            rowData.add("");
                            rowData.add(entry.getValue().toString());
                            continue;
                        }
                        String valuesource = basFlexProperty.getString("valuesource");
                        if (StringUtils.isNotBlank((CharSequence)valuesource)) {
                            DynamicObject valueDynamicObject = this.queryValueSourceData(orm, entry, valuesource);
                            if (null != valueDynamicObject) {
                                rowData.add(valueDynamicObject.getString("number"));
                                rowData.add(valueDynamicObject.getString("name"));
                                continue;
                            }
                            rowData.add("");
                            rowData.add("");
                            continue;
                        }
                        rowData.add("");
                        rowData.add("");
                    }
                }
                for (int i = 0; i < count; ++i) {
                    rowData.add("");
                    rowData.add("");
                    rowData.add("");
                }
                BigDecimal yearamount = (BigDecimal)datum.get("yearamount");
                if (null != yearamount) {
                    rowData.add(String.valueOf(yearamount.setScale(scale, RoundingMode.HALF_EVEN)));
                } else {
                    rowData.add("");
                }
                rowDatas.add(rowData);
            }
            FormExportUtil formExportUtil = new FormExportUtil();
            IReportView view = this.getView();
            String url = formExportUtil.export(header, fieldHeader, rowDatas, view.getFormShowParameter().getCaption(), comassist);
            formExportUtil.openUrl(url, (IFormView)view);
            if (null != orgFilterItem) {
                MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u6309\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa", "InitCashFlowItemFormRpt_41", "fi-gl-formplugin");
                MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u6309\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa\u6210\u529f\u3002", "InitCashFlowItemFormRpt_42", "fi-gl-formplugin");
                String[] descParams = new String[]{};
                new OpLogHelper().addOperateLog((IFormView)this.getView(), orgFilterItem.getLong(), "", "exportInitCashFlow", opNameBridge, opDescBridge, descParams);
            }
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u4efb\u4f55\u6570\u636e\u53ef\u5bfc\u51fa\u3002", (String)"InitCashFlowItemFormRpt_28", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject queryValueSourceData(ORM orm, Map.Entry<String, Object> entry, String valuesource) {
        DynamicObject valueDynamicObject = orm.queryOne(valuesource, "id, name, number", new QFilter[]{new QFilter("id", "=", entry.getValue())});
        return valueDynamicObject;
    }

    private void showForm(boolean isForEndInit) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        List pkSet = AccSysUtil.getAcctOrgPkList((String)this.getView().getEntityId(), (boolean)Boolean.TRUE, (PermissonType)PermissonType.VIEW);
        QFilter qfbookstype = new QFilter("bookstype", "=", (Object)this.getValFromPageCache(PC_BOOKTYPE));
        QFilter isbizunit = new QFilter("isbizunit", "=", (Object)"1");
        DynamicObjectCollection dynBookTypeColl = QueryServiceHelper.query((String)"gl_accountbook", (String)"org.id", (QFilter[])new QFilter[]{qfbookstype, isbizunit});
        Set ids = dynBookTypeColl.stream().map(v -> v.getLong("org.id")).collect(Collectors.toSet());
        pkSet.retainAll(ids);
        if (isForEndInit) {
            qfbookstype.and(new QFilter("isendinitcashflow", "=", (Object)false));
            qfbookstype.and(new QFilter("cashinitperiod", "!=", (Object)0));
        } else {
            qfbookstype.and(new QFilter("isendinitcashflow", "=", (Object)true));
            qfbookstype.and(QFilter.of((String)"cashinitperiod = curperiod", (Object[])new Object[0]));
        }
        DynamicObjectCollection dynColl = QueryServiceHelper.query((String)"gl_accountbook", (String)"org.id", (QFilter[])new QFilter[]{qfbookstype});
        Set collectIds = dynColl.stream().map(v -> v.getLong("org.id")).collect(Collectors.toSet());
        pkSet.retainAll(collectIds);
        qFilters.add(new QFilter("id", "in", (Object)pkSet));
        ListShowParameter para = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)true, (int)0);
        para.setCustomParam("islockfunc", (Object)true);
        para.setCustomParam("orgFuncId", (Object)"10");
        para.getListFilterParameter().setQFilters(qFilters);
        para.setCustomParam("range", ids);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, isForEndInit ? "closeinitcashflow" : "anticloseinitcashflow"));
        this.getView().showForm((FormShowParameter)para);
    }

    private void showMsg(int success, int error, String errorMsg) {
        this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6210\u529f\uff1a%1$s\u6761\uff0c\u5931\u8d25\uff1a%2$s\u6761\u3002", (String)"InitCashFlowItemFormRpt_30", (String)"fi-gl-formplugin", (Object[])new Object[0]), success, error), errorMsg, MessageTypes.Default);
    }

    private List<String> getComassist() {
        String s = this.getPageCache().get(comassist_cahe);
        return StringUtils.isEmpty((CharSequence)s) ? new ArrayList() : Arrays.asList(s.split(","));
    }

    private List<QFilter> getComAssistPermF(long orgId, String commonAssistKey) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        ComAssistTable.get((Long)orgId, (Long)Long.parseLong(this.getPageCache().get(PC_BOOKTYPE))).ifPresent(commonAssistTable -> commonAssistTable.getCommonAssists().stream().filter(commonAssist -> commonAssistKey.equals(commonAssist.key)).forEach(commonAssist -> qFilters.addAll(ComAssistService.generateQFilterWithDataPerm((CommonAssist)commonAssist, Collections.singletonList(orgId)))));
        return qFilters;
    }
}

