/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.cache.CachedDataSetBuilder;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportTaskResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.model.JsonObjectAdapter;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.common.ShowBosPrintingProgress;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.model.schema.report.SubLedgerSchema;
import kd.fi.gl.report.ReportPrintHelper;
import kd.fi.gl.report.SLTreeNode;
import kd.fi.gl.util.GLApp;

public class SubLedgerPrintFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String EXPORT_EXCEL = "exportexcel";
    protected static final String REPORT_LIST_AP = "reportlistap";
    private final IReportCache reportCache = ReportCacheManager.getInstance().getCache();
    private Map<Long, Tuple<String, Integer>> org2CacheID;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.getProgressBar().addProgressListener((ProgresssListener)this);
    }

    private ProgressBar getProgressBar() {
        return (ProgressBar)this.getControl("multiorgsprint_bar");
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("printbar".equals(key) || "printview".equals(key)) {
            if ("printview".equals(key) && !this.isAccountNodeSelected(this.getView())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de6\u8fb9\u79d1\u76ee\u6811\u7ed3\u6784\u8bf7\u9009\u62e9\u79d1\u76ee\u8282\u70b9\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SubLedgerFormRpt_13", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                return;
            }
            this.doMultiOrgPrint("printbar".equals(key));
        }
    }

    private boolean isAccountNodeSelected(IFormView view) {
        TreeView reportTree = (TreeView)view.getControl("reporttreeap");
        if (reportTree == null) {
            return true;
        }
        String selId = (String)reportTree.getTreeState().getSelectedNodeId().get(0);
        return SLTreeNode.isAccountNode(selId);
    }

    private void doMultiOrgPrint(Boolean isPrintAll) {
        String formId;
        Object defaultTemplateId;
        if (this.isPrintJobWorking().booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6253\u5370\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e", (String)"SubLedgerFormRpt_15", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        HasPermOrgResult allPermOrgs = AccSysUtil.getAllPermOrgs((String)"gl_rpt_subledger", (String)"4730fc9e000000ac");
        if (!allPermOrgs.hasAllOrgPerm()) {
            HashSet permOrgs = new HashSet(allPermOrgs.getHasPermOrgs());
            HashSet<Long> selectOrgs = new HashSet<Long>(this.getOrgValue());
            selectOrgs.removeAll(permOrgs);
            if (selectOrgs.size() > 0) {
                String orgNameStr = QueryServiceHelper.query((String)"bos_org", (String)"name", (QFilter[])new QFilter("id", "in", selectOrgs).toArray()).stream().map(dyo -> dyo.getString("name")).collect(Collectors.joining(", "));
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u7ec4\u7ec7\u3010%s\u3011\u660e\u7ec6\u5206\u7c7b\u8d26\u201d\u7684\u201c\u6253\u5370\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SubLedgerPrintFormPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), orgNameStr));
                return;
            }
        }
        if (ObjectUtils.isEmpty((Object)(defaultTemplateId = ReportPrintHelper.getDefaultTemplateId(formId = "gl_rpt_subledger")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u6a21\u677f\u3002", (String)"SubLedgerFormRpt_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getReportPageCache().put("isprintall", isPrintAll.toString());
        this.changePrintStatus(PrintStatus.CREATE);
        this.getProgressBar().start();
    }

    protected List<Long> getOrgValue() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
        return orgs.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    public void onProgress(ProgressEvent progressEvent) {
        switch (this.printStatus()) {
            case CREATE: {
                this.showOrgProgress(this.getView().getPageId(), -1, -1, null);
                this.changePrintStatus(PrintStatus.WAITING_INIT);
                break;
            }
            case WAITING_INIT: {
                this.initAllSingleOrgDS();
                this.changePrintStatus(PrintStatus.DONE_INIT);
                break;
            }
            case DONE_INIT: 
            case SINGLE_DONE: {
                this.moveToNextOrg();
                break;
            }
            case PRINTING: {
                break;
            }
            case ALL_DONE: {
                this.getProgressBar().stop();
            }
        }
    }

    private void showOrgProgress(String printPageID, int totalNum, int doneNum, String orgName) {
        Integer duration = 5000;
        IFormView printView = this.getView().getView(printPageID);
        if (totalNum != -1) {
            printView.showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6253\u5370%1$s\u7ec4\u7ec7\u7684\u660e\u7ec6\u5206\u7c7b\u8d26\uff08\u7b2c%2$s\u5bb6/\u5171%3$s\u5bb6\uff09", (String)"SubLedgerPrintFormPlugin_0", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), orgName, doneNum + 1, totalNum), duration);
        }
        this.getView().sendFormAction(printView);
    }

    private Map<Long, Tuple<String, Integer>> getAllSingleOrgDS() {
        if (this.org2CacheID == null) {
            this.org2CacheID = (Map)SerializationUtils.deSerializeFromBase64((String)this.getReportPageCache().get("org2dataset"));
        }
        return this.org2CacheID;
    }

    private Map<Long, Tuple<String, Integer>> initAllSingleOrgDS() {
        this.org2CacheID = this.doSingleOrgResultInit();
        this.getReportPageCache().put("org2dataset", SerializationUtils.serializeToBase64(this.org2CacheID));
        return this.org2CacheID;
    }

    private Map<Long, Tuple<String, Integer>> doSingleOrgResultInit() {
        ReportList reportList = (ReportList)this.getView().getControl(REPORT_LIST_AP);
        ReportListModel reportModel = (ReportListModel)reportList.getReportModel();
        if (Boolean.parseBoolean(this.getReportPageCache().get("isprintall"))) {
            reportModel = this.getExportAllReportModel(reportList);
        } else {
            List ids;
            TreeView reportTree = (TreeView)this.getView().getControl("reporttreeap");
            if (reportTree != null && !(ids = reportTree.getTreeState().getSelectedNodeId()).isEmpty() && ((String)ids.get(0)).equals("0")) {
                this.changePrintStatus(PrintStatus.ALL_DONE);
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u6253\u5370\u6570\u636e\u3002", (String)"SubLedgerPrintFormPlugin_2", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            }
        }
        ReportTaskResult multiOrgResult = this.reportCache.getReportTaskResult(reportModel.getPageId(), reportModel.getCtrlId());
        return this.splitToSingleOrgDS(multiOrgResult);
    }

    private Map<Long, Tuple<String, Integer>> splitToSingleOrgDS(ReportTaskResult multiOrgResult) {
        DataSet multiOrgDS;
        if (multiOrgResult != null && (multiOrgDS = Algo.getCacheDataSet((String)multiOrgResult.getResultId()).toDataSet(Algo.create((String)(((Object)((Object)this)).getClass().getSimpleName() + "#getMultiOrgResult")), false)).hasNext()) {
            HashMap<Long, Tuple<String, Integer>> res = new HashMap<Long, Tuple<String, Integer>>();
            Long curOrg = -1L;
            int count = 0;
            CachedDataSetBuilder builder = new CachedDataSetBuilder(multiOrgDS.getRowMeta(), CacheHint.getDefault());
            for (Row row : multiOrgDS) {
                Long nextOrg = row.getLong("org");
                if (curOrg == -1L) {
                    curOrg = nextOrg;
                }
                if (!curOrg.equals(nextOrg)) {
                    res.put(curOrg, (Tuple<String, Integer>)new Tuple((Object)builder.build().getCacheId(), (Object)count));
                    builder = new CachedDataSetBuilder(multiOrgDS.getRowMeta(), CacheHint.getDefault());
                    curOrg = nextOrg;
                    count = 0;
                }
                builder.append((Row)((AbstractRow)row).persist());
                ++count;
            }
            res.put(curOrg, new Tuple((Object)builder.build().getCacheId(), (Object)count));
            return res;
        }
        this.changePrintStatus(PrintStatus.ALL_DONE);
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u6253\u5370\u6570\u636e\u3002", (String)"SubLedgerPrintFormPlugin_2", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
    }

    private ReportListModel getExportAllReportModel(ReportList reportList1) {
        ReportQueryParam queryParam = reportList1.getReportModel().getReportQueryParam();
        queryParam.getFilter().getFilterItem(EXPORT_EXCEL).setValue((Object)true);
        ReportList list = (ReportList)this.getControl(REPORT_LIST_AP);
        DynamicObjectCollection accountColl = (DynamicObjectCollection)queryParam.getFilter().getValue("account");
        if (accountColl != null && accountColl.isEmpty()) {
            accountColl = null;
        }
        String tempPageId = Uuid16.create().toString();
        this.reportCache.setReportQueryParam(tempPageId, queryParam);
        ReportListModel reportModel = (ReportListModel)list.getReportModel();
        reportModel.setPageId(tempPageId);
        list.setAsynQuery(true);
        list.submitTask(queryParam, (Object)accountColl);
        return reportModel;
    }

    private IPageCache getReportPageCache() {
        return this.getPageCache();
    }

    private Queue<Long> getOrgQueue() {
        LinkedList<Long> orgQueue;
        String org2CacheIDStr = this.getReportPageCache().get("orgsReadyForPrint");
        if (this.printStatus() == PrintStatus.DONE_INIT) {
            orgQueue = new LinkedList<Long>(this.doSingleOrgResultInit().keySet());
            this.getReportPageCache().put("orgsReadyForPrint", SerializationUtils.serializeToBase64(orgQueue));
        } else {
            orgQueue = (LinkedList<Long>)SerializationUtils.deSerializeFromBase64((String)org2CacheIDStr);
        }
        return orgQueue;
    }

    private void cacheOrgQueue(Queue<Long> queue) {
        this.getReportPageCache().put("orgsReadyForPrint", SerializationUtils.serializeToBase64(queue));
    }

    private void moveToNextOrg() {
        Queue<Long> orgQueue = this.getOrgQueue();
        Map<Long, Tuple<String, Integer>> allSingleOrgDS = this.getAllSingleOrgDS();
        if (allSingleOrgDS.isEmpty() || orgQueue.isEmpty()) {
            this.changePrintStatus(PrintStatus.ALL_DONE);
            return;
        }
        Long nextOrg = orgQueue.poll();
        this.cacheOrgQueue(orgQueue);
        DynamicObject orgDyo = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id, number, name", (QFilter[])new QFilter("id", "=", (Object)nextOrg).toArray());
        String orgName = orgDyo.getLocaleString("name").getLocaleValue();
        String printPageID = this.executePrint(orgDyo);
        this.showOrgProgress(printPageID, allSingleOrgDS.size(), allSingleOrgDS.size() - orgQueue.size() - 1, orgName);
        this.changePrintStatus(PrintStatus.PRINTING);
    }

    private String executePrint(DynamicObject orgDyo) {
        int rowCount = (Integer)this.getAllSingleOrgDS().get((Object)Long.valueOf((long)orgDyo.getLong((String)"id"))).item2;
        String formId = SubLedgerSchema.INSTANCE.entity;
        Object defaultTemplateId = ReportPrintHelper.getDefaultTemplateId(formId);
        ReportView reportView = (ReportView)this.getView();
        String reportPageID = reportView.getPageId();
        IReportCache cache = ReportCacheManager.getInstance().getCache();
        String tmpModelPageID = Uuid16.create().toString();
        ReportQueryParam tmpParam = reportView.getQueryParam();
        tmpParam.getFilter().getFilterItem(SubLedgerSchema.INSTANCE.org.toString()).setValue((Object)orgDyo);
        tmpParam.getFilter().getFilterItem(EXPORT_EXCEL).setValue((Object)Boolean.parseBoolean(this.getReportPageCache().get("isprintall")));
        cache.setReportQueryParam(tmpModelPageID, tmpParam);
        String cacheID = (String)this.getAllSingleOrgDS().get((Object)Long.valueOf((long)orgDyo.getLong((String)"id"))).item1;
        List exportColumns = cache.getReportTaskResult(reportPageID, REPORT_LIST_AP).getReportColumns();
        cache.setReportTaskResult(tmpModelPageID, REPORT_LIST_AP, new ReportTaskResult(cacheID, exportColumns));
        JSONObject extParam = JsonObjectAdapter.getEmpty().registerContext("pageIDForPrint", (Object)tmpModelPageID).registerContext("printAll", (Object)true).getSource();
        this.getReportPageCache().put("extParam", extParam.toJSONString());
        return ShowBosPrintingProgress.showProgressFormV2(rowCount, formId, reportPageID, defaultTemplateId, "", (IFormView)reportView, extParam, (IFormPlugin)this);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("printFormClose".equals(e.getActionId())) {
            this.changePrintStatus(PrintStatus.SINGLE_DONE);
            ReportQueryParam queryParam = ((ReportView)this.getView()).getQueryParam();
            queryParam.getFilter().getFilterItems().removeIf(filterItemInfo -> EXPORT_EXCEL.equals(filterItemInfo.getPropName()));
            Optional.ofNullable(queryParam.getFilter().getFilterItems(EXPORT_EXCEL)).ifPresent(List::clear);
            queryParam.getFilter().addFilterItem(EXPORT_EXCEL, (Object)false);
            ReportCacheManager.getInstance().getCache().setReportQueryParam(this.getView().getPageId(), queryParam);
        }
    }

    private void changePrintStatus(PrintStatus status) {
        this.getReportPageCache().put("printstatus", status.name());
    }

    private PrintStatus printStatus() {
        return PrintStatus.valueOf(this.getReportPageCache().get("printstatus"));
    }

    private Boolean isPrintJobWorking() {
        return this.getReportPageCache().get("printstatus") != null && this.printStatus() != PrintStatus.ALL_DONE;
    }

    private static enum PrintStatus {
        CREATE,
        WAITING_INIT,
        DONE_INIT,
        PRINTING,
        SINGLE_DONE,
        ALL_DONE;

    }
}

