/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.exception.BOSException;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FormExportUtil {
    public void openUrl(String url, IFormView formView) {
        ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction("openUrl", (Object)url);
    }

    public String export(List<String> headInfos, DynamicObjectCollection dataRows, Map<String, List<String>> fieldMap, IFormView view, DynamicObject currency, String permissionItemId) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("sheet1");
        this.initFormat(currency);
        this.setTableByGroups(wb, sheet, headInfos, dataRows, fieldMap);
        try {
            FormShowParameter showParameter = view.getFormShowParameter();
            String caption = showParameter.getCaption();
            if (caption == null) {
                caption = ResManager.loadKDString((String)"\u7a0e\u52a1\u62a5\u8868-\u73b0\u91d1\u6d41\u91cf\u8868", (String)"FormExportUtil_0", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            }
            String url = this.writeFile(wb, caption);
            DistributeSessionlessCache distributeCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
            HashMap<String, String> refEntiryMap = new HashMap<String, String>(2);
            String tempFileId = url.split("id=")[1];
            refEntiryMap.put("entityNum", showParameter.getFormId());
            refEntiryMap.put("appId", showParameter.getServiceAppId());
            refEntiryMap.put("permissionItemId", permissionItemId);
            distributeCache.put("ReportTempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntiryMap), 7200);
            return url;
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public String export(List<String> header, List<String> fieldHeader, List<List<String>> rowDatas, String sheetName, List<String> comassist) {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet();
        XSSFCellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        int index = 0;
        index = this.createTemplateRow(sheet, index, comassist);
        index = this.setHeader(fieldHeader, sheet, index, style);
        index = this.setHeader(header, sheet, index, style);
        index = this.setRowData(rowDatas, sheet, index, style);
        if (sheetName == null) {
            sheetName = ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e_\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u6807\u51c6\u5bfc\u5165\u6a21\u677f", (String)"FormExportUtil_1", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        }
        Object inStream = null;
        try {
            return this.writeFile(wb, sheetName, ".xlsx");
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public String export(List<String> headInfos, DynamicObjectCollection dataRows, List<String> fieldList, IFormView view, DynamicObject currency, String permissionItemId) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("sheet1");
        this.initFormat(currency);
        this.setTable(wb, sheet, headInfos, dataRows, fieldList);
        try {
            FormShowParameter showParameter = view.getFormShowParameter();
            String caption = showParameter.getCaption();
            if (caption == null) {
                caption = ResManager.loadKDString((String)"\u7a0e\u52a1\u62a5\u8868-\u73b0\u91d1\u6d41\u91cf\u8868", (String)"FormExportUtil_0", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            }
            String url = this.writeFile(wb, caption);
            DistributeSessionlessCache distributeCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
            HashMap<String, String> refEntiryMap = new HashMap<String, String>(2);
            String tempFileId = url.split("id=")[1];
            refEntiryMap.put("entityNum", showParameter.getFormId());
            refEntiryMap.put("appId", showParameter.getServiceAppId());
            refEntiryMap.put("permissionItemId", permissionItemId);
            distributeCache.put("ReportTempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntiryMap), 7200);
            return url;
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void initFormat(DynamicObject currency) {
        int amt = 2;
        String sign = "";
        if (currency != null) {
            amt = currency.getInt("amtprecision");
            sign = currency.getString("sign");
        }
        FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
        fobj.getCurrencyFormat().setCurrencySymbols(sign);
        fobj.getCurrencyFormat().setMinimumFractionDigits(amt);
    }

    public void setTableByGroups(HSSFWorkbook wb, HSSFSheet sheet, List<String> headInfos, DynamicObjectCollection dataRows, Map<String, List<String>> fieldMap) {
        ArrayList<Map<String, String>> typeList = new ArrayList<Map<String, String>>();
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        int rowIndex = 0;
        int columnsSize = 0;
        for (List<String> fieldList : fieldMap.values()) {
            if (fieldList != null && !fieldList.isEmpty()) {
                columnsSize += fieldList.size();
                continue;
            }
            ++columnsSize;
        }
        rowIndex = FormExportUtil.createTitleCell(sheet, headInfos, columnsSize, style, rowIndex);
        rowIndex = this.createHeadCellByGroups(sheet, dataRows, fieldMap, typeList, style, rowIndex);
        this.createDetailRowCell(sheet, dataRows, typeList, style, rowIndex);
    }

    public void setTable(HSSFWorkbook wb, HSSFSheet sheet, List<String> headInfos, DynamicObjectCollection dataRows, List<String> fieldList) {
        ArrayList<Map<String, String>> typeList = new ArrayList<Map<String, String>>();
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        int rowIndex = 0;
        rowIndex = FormExportUtil.createTitleCell(sheet, headInfos, fieldList.size(), style, rowIndex);
        rowIndex = this.createHeadCell(sheet, dataRows, fieldList, typeList, style, rowIndex);
        this.createDetailRowCell(sheet, dataRows, typeList, style, rowIndex);
    }

    private void createDetailRowCell(HSSFSheet sheet, DynamicObjectCollection dataRows, List<Map<String, String>> typeList, HSSFCellStyle style, int rowIndex) {
        for (int h = 0; h < dataRows.size(); ++h) {
            HSSFRow createRow = sheet.createRow(h + rowIndex);
            DynamicObject dyn = (DynamicObject)dataRows.get(h);
            for (int i = 0; i < typeList.size(); ++i) {
                String number = typeList.get(i).get("number");
                String type = typeList.get(i).get("type");
                String value = "";
                HSSFCell cell = createRow.createCell(i);
                if (type.equals("FieldProp")) {
                    value = dyn.getString(number);
                } else if (type.equals("BasedataProp")) {
                    DynamicObject dynamicObject = dyn.getDynamicObject(number);
                    value = dynamicObject == null ? "" : dynamicObject.getString("name");
                } else if (type.equals("AmountProp")) {
                    double v = dyn.getBigDecimal(number).doubleValue();
                    if (v != 0.0) {
                        cell.setCellValue(dyn.getBigDecimal(number).doubleValue());
                    }
                    cell.setCellStyle(style);
                    continue;
                }
                cell.setCellValue(value);
                cell.setCellStyle(style);
            }
        }
    }

    private int createHeadCellByGroups(HSSFSheet sheet, DynamicObjectCollection dataRows, Map<String, List<String>> fieldMap, List<Map<String, String>> typeList, HSSFCellStyle style, int rowIndex) {
        HSSFRow row = sheet.createRow(rowIndex);
        HSSFRow childRow = sheet.createRow(rowIndex + 1);
        DataEntityPropertyCollection propetyCol = dataRows.getDynamicObjectType().getProperties();
        int colIndex = 0;
        for (Map.Entry<String, List<String>> entry : fieldMap.entrySet()) {
            CellRangeAddress region;
            List<String> fieldList = entry.getValue();
            if (fieldList == null || fieldList.isEmpty()) {
                String columnGroupKey = entry.getKey();
                FormExportUtil.createSingleCell(typeList, style, row, propetyCol, colIndex, columnGroupKey);
                region = new CellRangeAddress(rowIndex, rowIndex + 1, colIndex, colIndex);
                sheet.addMergedRegion(region);
                ++colIndex;
                continue;
            }
            HSSFCell cell = row.createCell(colIndex);
            cell.setCellValue(entry.getKey());
            cell.setCellStyle(style);
            region = new CellRangeAddress(rowIndex, rowIndex, colIndex, colIndex + fieldList.size() - 1);
            sheet.addMergedRegion(region);
            for (int i = 0; i < fieldList.size(); ++i) {
                String number = fieldList.get(i);
                FormExportUtil.createSingleCell(typeList, style, childRow, propetyCol, colIndex + i, number);
            }
            colIndex += fieldList.size();
        }
        return rowIndex += 2;
    }

    public static void createSingleCell(List<Map<String, String>> typeList, HSSFCellStyle style, HSSFRow row, DataEntityPropertyCollection propetyCol, int i, String number) {
        DynamicProperty property = (DynamicProperty)propetyCol.get((Object)number);
        HashMap<String, String> typeMap = new HashMap<String, String>();
        if (property instanceof AmountProp) {
            typeMap.put("type", "AmountProp");
        } else if (property instanceof FieldProp) {
            typeMap.put("type", "FieldProp");
        } else if (property instanceof BasedataProp) {
            typeMap.put("type", "BasedataProp");
        }
        typeMap.put("number", number);
        typeList.add(typeMap);
        LocaleString name = property.getDisplayName();
        HSSFCell cell = row.createCell(i);
        cell.setCellValue(name.getLocaleValue());
        cell.setCellStyle(style);
    }

    private int createHeadCell(HSSFSheet sheet, DynamicObjectCollection dataRows, List<String> fieldList, List<Map<String, String>> typeList, HSSFCellStyle style, int rowIndex) {
        HSSFRow row = sheet.createRow(rowIndex);
        DataEntityPropertyCollection propetyCol = dataRows.getDynamicObjectType().getProperties();
        for (int i = 0; i < fieldList.size(); ++i) {
            String number = fieldList.get(i);
            FormExportUtil.createSingleCell(typeList, style, row, propetyCol, i, number);
        }
        return ++rowIndex;
    }

    public static int createTitleCell(HSSFSheet sheet, List<String> headInfos, int combineSize, HSSFCellStyle style, int rowIndex) {
        if (headInfos != null && headInfos.size() > 0) {
            HSSFRow titleRow = sheet.createRow(rowIndex);
            HSSFCell titleCell = titleRow.createCell(0);
            titleCell.setCellValue(headInfos.get(0));
            titleCell.setCellStyle(style);
            CellRangeAddress region = new CellRangeAddress(0, 0, 0, combineSize - 1);
            sheet.addMergedRegion(region);
            ++rowIndex;
            if (headInfos.size() > 1) {
                HSSFRow headRow = sheet.createRow(rowIndex);
                for (int colIdx = 1; colIdx < headInfos.size(); ++colIdx) {
                    HSSFCell cell = headRow.createCell(colIdx - 1);
                    cell.setCellValue(headInfos.get(colIdx));
                    cell.setCellStyle(style);
                }
                ++rowIndex;
            }
        }
        return rowIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeFile(HSSFWorkbook wb, String formName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheHelper.getTempFileCache().saveAsUrl(this.getTempFilename(formName), (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeFile(XSSFWorkbook wb, String formName, String fileType) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheHelper.getTempFileCache().saveAsUrl(this.getTempFilename(formName, fileType), (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    protected String getTempFilename(String formName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmssSSS");
        String currDateTime = dateFormat.format(new Date());
        String userName = RequestContext.get().getUserName();
        return formName + "-" + currDateTime + "-" + userName + ".xls";
    }

    public HSSFCellStyle getCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle numberStyle = wb.createCellStyle();
        numberStyle.setBorderLeft(BorderStyle.THIN);
        numberStyle.setBorderTop(BorderStyle.THIN);
        numberStyle.setBorderRight(BorderStyle.THIN);
        numberStyle.setBorderBottom(BorderStyle.THIN);
        numberStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        numberStyle.setHidden(false);
        return numberStyle;
    }

    public HSSFCellStyle getHeadColumnStyle(HSSFWorkbook wb) {
        HSSFCellStyle headColumnStyle = wb.createCellStyle();
        if (headColumnStyle == null) {
            headColumnStyle = wb.createCellStyle();
            headColumnStyle.setBorderBottom(BorderStyle.THIN);
            headColumnStyle.setBorderTop(BorderStyle.THIN);
            headColumnStyle.setBorderLeft(BorderStyle.THIN);
            headColumnStyle.setBorderRight(BorderStyle.THIN);
            headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
            headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            headColumnStyle.setHidden(false);
        }
        return headColumnStyle;
    }

    private int setHeader(List<String> header, XSSFSheet sheet, int index, XSSFCellStyle style) {
        XSSFRow headerRow = sheet.createRow(index);
        for (int i = 0; i < header.size(); ++i) {
            XSSFCell cell = headerRow.createCell(i);
            cell.setCellValue(header.get(i));
            cell.setCellStyle((CellStyle)style);
        }
        return ++index;
    }

    private int setRowData(List<List<String>> rowDatas, XSSFSheet sheet, int index, XSSFCellStyle style) {
        for (List<String> rowData : rowDatas) {
            XSSFRow row = sheet.createRow(index);
            for (int i = 0; i < rowData.size(); ++i) {
                XSSFCell cell = row.createCell(i);
                cell.setCellValue(rowData.get(i));
                cell.setCellStyle((CellStyle)style);
            }
            ++index;
        }
        return index;
    }

    private int createTemplateRow(XSSFSheet sheet, int index, List<String> comassist) {
        sheet.createRow(index).createCell(0).setCellValue(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316 # gl_initcashflow", (String)"FormExportUtil_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        sheet.createRow(++index).createCell(0).setCellValue(ResManager.loadKDString((String)"\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002", (String)"FormExportUtil_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        for (int i = 1; i <= comassist.size(); ++i) {
            sheet.getRow(index).createCell(2 + i).setCellValue(String.format(ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6%1$s\u5bf9\u5e94\u79d1\u76ee\u8868\u7684\u516c\u5171\u7ef4\u5ea6\u7b2c%2$s\u884c", (String)"FormExportUtil_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), i, i));
        }
        return ++index;
    }

    protected String getTempFilename(String formName, String fileType) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMdd");
        String currDateTime = dateFormat.format(new Date());
        return formName + "_" + currDateTime + fileType;
    }
}

