/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.autotrans.FinalProcessAssgrp;
import kd.fi.gl.formplugin.FPFormUtil;

public class GlFormUtil {
    public static final String FI_GL_FORMPLUGIN = "fi-gl-formplugin";

    public static void goChronologicalPageVoucher(IFormView view) {
        GlFormUtil.goChronologicalPage(view, "gl_voucher", null);
    }

    public static void goChronologicalPageVoucher(IFormView view, String filterParameter) {
        GlFormUtil.goChronologicalPage(view, "gl_voucher", filterParameter);
    }

    public static void goChronologicalPage(IFormView view, String pageKey, String filterParameter) {
        GlFormUtil.goChronologicalPage(view, pageKey, filterParameter, null);
    }

    public static void goChronologicalPage(IFormView view, String pageKey, String filterParameter, List<SqlParameter> sqlParameters) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(pageKey);
        showParameter.setFormId("bos_list");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("tabap");
        if (null != filterParameter) {
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            if (StringUtils.isNotEmpty((String)filterParameter)) {
                listFilterParameter.setFilter(QFilter.fromSerializedString((String)filterParameter));
            }
            showParameter.setListFilterParameter(listFilterParameter);
        }
        showParameter.setCustomParam("source", (Object)"GLUtil");
        view.showForm((FormShowParameter)showParameter);
    }

    public static DynamicObject getCurYearMaxPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", ">=", currPeriod.get("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filterType, pfilter}, (String)"periodnumber desc");
        if (cols.size() > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cols.get(0)).getLong("id"), (DynamicObjectType)type);
        }
        return null;
    }

    public static DynamicObject getCurYearMinPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", "<=", currPeriod.get("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filterType, pfilter}, (String)"periodnumber");
        if (cols.size() > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cols.get(0)).getLong("id"), (DynamicObjectType)type);
        }
        return null;
    }

    public static BigDecimal setScale(BigDecimal val, int scale) {
        if (val == null) {
            return val;
        }
        return val.setScale(scale, 4);
    }

    public static DynamicObject getSamePeriodOfYear(long curperiodID, int beforeValue) {
        QFilter filterNum2;
        QFilter filterYear2;
        DynamicObject result = null;
        String entityName = "bd_period";
        String selector = "id,name,periodtype,periodyear,periodnumber,begindate,enddate";
        DynamicObject[] taskObjs = BusinessDataServiceHelper.load((String)entityName, (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)curperiodID)});
        if (taskObjs == null || taskObjs.length == 0) {
            return result;
        }
        DynamicObject curPeriod = taskObjs[0];
        QFilter filterType2 = new QFilter("periodtype", "=", curPeriod.get("periodtype_id"));
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"gl.glutil.samePeriodOfYear", (String)entityName, (String)selector, (QFilter[])new QFilter[]{filterType2, filterYear2 = new QFilter("periodyear", "=", (Object)(curPeriod.getInt("periodyear") - beforeValue)), filterNum2 = new QFilter("periodnumber", "=", (Object)curPeriod.getInt("periodnumber"))}, null);
        if (cols.size() > 0) {
            result = (DynamicObject)cols.get(0);
        }
        return result;
    }

    public static Long getDefaultAcctOrg(List<Long> orgPkList) {
        Long curLoginOrg = RequestContext.get().getOrgId();
        if (orgPkList.contains(curLoginOrg)) {
            return curLoginOrg;
        }
        if (!orgPkList.isEmpty()) {
            return orgPkList.get(0);
        }
        return null;
    }

    public static <K, V> void putMap(Map<K, Set<V>> map, K key, V value) {
        if (map.containsKey(key)) {
            Set<V> accSet = map.get(key);
            accSet.add(value);
            map.put(key, accSet);
        } else {
            HashSet<V> accSet = new HashSet<V>();
            accSet.add(value);
            map.put(key, accSet);
        }
    }

    public static void setF7ClickFilter(BasedataEdit edit, QFilter qFilter) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        if (qFilter != null) {
            list.add(qFilter);
        }
        edit.setQFilters(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> queryVoucherId(List<Long> srcentityIDs) {
        QFilter filter = new QFilter("srcentity", "in", srcentityIDs);
        ArrayList<Long> voucherId = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"gl_adjratevoucherref.getVoucherID", (String)"gl_voucherrelation", (String)"targentity", (QFilter[])new QFilter[]{filter}, null);){
            for (Row row : dataSet) {
                voucherId.add(row.getLong("targentity"));
            }
        }
        return voucherId;
    }

    public static Map<String, Object> getDptNameByUserId(Long creatorId) {
        HashMap<String, Object> userDpt = new HashMap<String, Object>();
        userDpt.put("dpt", 0L);
        userDpt.put("dptName", null);
        String selectField = "id,entryentity.dpt,entryentity.ispartjob,entryentity.dpt.name,name";
        QFilter idFilter = new QFilter("id", "=", (Object)creatorId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"gl.TransPLProgramEditPlugin.getDptNameByUserId", (String)"bos_user", (String)selectField, (QFilter[])new QFilter[]{idFilter}, (String)"");
        if (collection.isEmpty()) {
            return userDpt;
        }
        for (DynamicObject userObj : collection) {
            boolean ispartjob = userObj.getBoolean("entryentity.ispartjob");
            if (ispartjob) continue;
            userDpt.put("dpt", userObj.get("entryentity.dpt"));
            userDpt.put("dptName", userObj.getString("entryentity.dpt.name"));
            return userDpt;
        }
        return userDpt;
    }

    public static String toDynamicObjectJson(DynamicObject obj) {
        DynamicObjectType type = obj.getDynamicObjectType();
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        jser.setSerializeComplexProperty(true);
        binder.setOnlyDbProperty(false);
        return jser.serializeToString((Object)obj, null);
    }

    public static DynamicObject fromDynamicString(String value, MainEntityType entityType) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)entityType);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        jser.setSerializeComplexProperty(true);
        binder.setOnlyDbProperty(false);
        return (DynamicObject)jser.deserializeFromString(value, null);
    }

    public static Optional<Set<Long>> getAssgrpsByRowid(String rowid, IPageCache cache) {
        String assgrpDynStr = cache.get(rowid);
        DynamicObject assgrpDyn = null;
        if (Objects.nonNull(assgrpDynStr)) {
            assgrpDyn = GlFormUtil.fromDynamicString(assgrpDynStr, EntityMetadataCache.getDataEntityType((String)"gl_finalprocess_assgrp"));
        } else {
            assgrpDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_finalprocess_assgrp", (QFilter[])new QFilter("assgrprow", "=", (Object)rowid).toArray());
            if (assgrpDyn == null) {
                return Optional.empty();
            }
            cache.put(rowid, FPFormUtil.toDynamicObjectJson(assgrpDyn));
        }
        Set assgrpIds = FinalProcessAssgrp.create((DynamicObjectCollection)assgrpDyn.getDynamicObjectCollection("entryentity")).getHgIds();
        return assgrpIds.isEmpty() ? Optional.empty() : Optional.of(assgrpIds);
    }

    public static void setSelectedFlexItems(IDataModel model, EntryGrid entryGrid, FilterInfo filterInfo) {
        if (GlFormUtil.isRefresh()) {
            return;
        }
        int[] selectRows = entryGrid.getSelectRows();
        Set selectRowSet = Arrays.stream(selectRows).boxed().collect(Collectors.toSet());
        List flexFilterItems = filterInfo.getFlexFilterItems();
        ArrayList<FilterItemInfo> newFlexFilterItems = new ArrayList<FilterItemInfo>(flexFilterItems.size());
        for (Integer idx : selectRowSet) {
            DynamicObject assisType = (DynamicObject)model.getValue("fieldname", idx.intValue());
            if (assisType == null) continue;
            for (FilterItemInfo filterItemInfo : flexFilterItems) {
                if (!Objects.equals(filterItemInfo.getPropName(), assisType.getString("flexfield"))) continue;
                newFlexFilterItems.add(filterItemInfo);
            }
        }
        filterInfo.setFlexFilterItems(newFlexFilterItems);
    }

    public static boolean isRefresh() {
        String queryString = RequestContext.get().getQueryString();
        boolean refresh = false;
        if (queryString != null && queryString.contains("refresh")) {
            refresh = true;
        }
        return refresh;
    }

    public static String getVerifyResultSummaryTxt() {
        return ResManager.loadKDString((String)"\u6240\u9009\u8d26\u7c3f\u7684%s\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u4e0d\u652f\u6301\u67e5\u8be2\u3002", (String)"GLRptTemplatePlugin_24", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]);
    }

    public static String getDownloadDetailTxt() {
        return ResManager.loadKDString((String)"\u4e0b\u8f7d\u660e\u7ec6", (String)"GLRptTemplatePlugin_25", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]);
    }

    public static String getCancelTxt() {
        return ResManager.loadKDString((String)"\u53d6\u6d88", (String)"GLRptTemplatePlugin_26", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]);
    }

    public static String getLocalCurTxt() {
        return ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u4e3a", (String)"GLRptTemplatePlugin_27", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]);
    }

    public static String getSecLocalCurTxt() {
        return ResManager.loadKDString((String)"\u7b2c\u4e8c\u672c\u4f4d\u5e01\u4e3a", (String)"GLRptTemplatePlugin_28", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]);
    }

    public static String getTrdLocalCurTxt() {
        return ResManager.loadKDString((String)"\u7b2c\u4e09\u672c\u4f4d\u5e01\u4e3a", (String)"GLRptTemplatePlugin_29", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]);
    }

    public static String getGrpLocalCurTxt() {
        return ResManager.loadKDString((String)"\u96c6\u56e2\u672c\u4f4d\u5e01\u4e3a", (String)"GLRptTemplatePlugin_30", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]);
    }

    public static String getMulCurVerifyFileNameTxt() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u5217\u8868_\u4f1a\u8ba1\u8d26\u7c3f\u672c\u4f4d\u5e01\u7c7b\u578b", (String)"GLRptTemplatePlugin_31", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]);
    }

    public static String getMulCurFormatedFilterString(String mulCur, String formatedFilterString) {
        if (StringUtils.isNotEmpty((String)mulCur)) {
            return String.format(ResManager.loadKDString((String)"%1$s; \u672c\u4f4d\u5e01\uff1a%2$s", (String)"AccBalanceFormRpt_7", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]), formatedFilterString, GlFormUtil.getMulCurText(mulCur));
        }
        return formatedFilterString;
    }

    public static String getMulCurText(String mulCur) {
        String mulCurText = "";
        if (Objects.equals("LocalCurrency", mulCur)) {
            mulCurText = ResManager.loadKDString((String)"\u672c\u4f4d\u5e01", (String)"ReportPrintHelper_5", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]);
        } else if (Objects.equals("SecLocalCurrency", mulCur)) {
            mulCurText = ResManager.loadKDString((String)"\u7b2c\u4e8c\u672c\u4f4d\u5e01", (String)"ReportPrintHelper_6", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]);
        } else if (Objects.equals("TrdLocalCurrency", mulCur)) {
            mulCurText = ResManager.loadKDString((String)"\u7b2c\u4e09\u672c\u4f4d\u5e01", (String)"ReportPrintHelper_7", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]);
        } else if (Objects.equals("GrpLocalCurrency", mulCur)) {
            mulCurText = ResManager.loadKDString((String)"\u96c6\u56e2\u672c\u4f4d\u5e01", (String)"ReportPrintHelper_8", (String)FI_GL_FORMPLUGIN, (Object[])new Object[0]);
        }
        return mulCurText;
    }
}

