/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.closeperiod.breakpoint.BreakPointCommonUtil;
import kd.fi.gl.closeperiod.breakpoint.OrgBooktypePeriod;
import kd.fi.gl.formplugin.finalprocess.breakpoint.VchBreakPointList;
import kd.fi.gl.formplugin.voucher.VoucherList;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.GLBreakPointUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.voucher.VoucherNumberUtils;

public class VoucherNumCheckUtil {
    private final AbstractFormPlugin p;
    private String validateMsg;

    public VoucherNumCheckUtil(AbstractFormPlugin p) {
        if (p == null) {
            throw new IllegalArgumentException("VoucherNumCheckUtil's Constructor has an IllegalArgumentException in line 17");
        }
        this.p = p;
        this.validateMsg = "";
    }

    public static String getCreateNewDatFlag(String pageId) {
        return "afterCreateNewData_flag" + pageId;
    }

    public static String getVoucherListIsCustom(String pageId) {
        return "VoucherList_isCustom_" + pageId;
    }

    public boolean beforeCheckBreakPoint() {
        ArrayList<String> orgIds = new ArrayList<String>();
        IPageCache pageCache = this.p.getPageCache();
        if (this.p instanceof VoucherList) {
            List customFilter = CommonAssistUtil.getCustomFilter((IFormView)this.p.getView(), (String)"org", (String)"bos_org");
            if (!this.checkQueryPermission(customFilter, false)) {
                return false;
            }
            orgIds.addAll(customFilter.stream().map(String::valueOf).collect(Collectors.toList()));
        }
        if (this.p instanceof VchBreakPointList) {
            IListView view = (IListView)this.p.getView();
            IDataModel model = view.getModel();
            ControlFilters filters = view.getControlFilters();
            for (Object obj : filters.getFilter("org.id")) {
                orgIds.add((String)obj);
            }
            String bookTypeId = ((DynamicObject)model.getValue("bookstype")).getString("id");
            Long currentPeriod = Long.valueOf(((DynamicObject)model.getValue("period")).getString("id"));
            this.showBrokenNumber(this.checkVoucherNumber(orgIds, bookTypeId, String.valueOf(currentPeriod)));
            return true;
        }
        boolean validRule = this.checkCodeRule(orgIds);
        if (!validRule) {
            return false;
        }
        this.cacheOrgBookTypePeriodList(this.buildOrgBookTypePeriodList(orgIds), pageCache);
        return true;
    }

    private List<String> getCanQueryOrg() {
        HasPermOrgResult all = AccSysUtil.getAllPermOrgs((String)"gl_voucherbreakpoint", (String)PermissonType.VIEW.getPermId());
        return all.hasAllOrgPerm() ? AccSysUtil.getAcctOrgPkList((String)"gl_voucherbreakpoint", (boolean)false, (PermissonType)PermissonType.VIEW).stream().map(x -> x + "").collect(Collectors.toList()) : all.getHasPermOrgs().stream().map(x -> x + "").collect(Collectors.toList());
    }

    private List<OrgBooktypePeriod> buildOrgBookTypePeriodList(List<String> orgIds) {
        ArrayList<OrgBooktypePeriod> orgBookTypePeriodList = new ArrayList<OrgBooktypePeriod>(orgIds.size());
        for (String org : orgIds) {
            OrgBooktypePeriod orgBooktypePeriod = new OrgBooktypePeriod(Long.valueOf(org), Long.valueOf(0L), Long.valueOf(0L));
            orgBookTypePeriodList.add(orgBooktypePeriod);
            orgBooktypePeriod.setChecked(true);
            orgBooktypePeriod.setBookName("");
        }
        return orgBookTypePeriodList;
    }

    private void showBrokenNumber(Object[] result) {
        IListView view = (IListView)this.p.getView();
        String breakFlag = (String)result[0];
        List tipList = null;
        if (result[1] instanceof ArrayList) {
            tipList = (List)result[1];
        }
        ConfirmCallBackListener submit = new ConfirmCallBackListener("submit", (IFormPlugin)this.p);
        if (!"0".equals(breakFlag)) {
            if (tipList != null && "2".equals(breakFlag)) {
                view.showConfirm(String.format(ResManager.loadKDString((String)"%s\uff0c\u65e0\u6cd5\u8c03\u6574\u3002", (String)"VoucherNumCheckUtil_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), tipList.get(tipList.size() - 1)), "", MessageBoxOptions.Toast, ConfirmTypes.Wait, submit);
            } else {
                view.setReturnData((Object)"1");
                view.showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u6761\u4ef6\u4e0d\u5b58\u5728\u65ad\u53f7,\u65e0\u9700\u8c03\u6574", (String)"VoucherNumCheckUtil_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.Toast, ConfirmTypes.Default, submit);
            }
        } else {
            view.showConfirm(String.format(ResManager.loadKDString((String)"\u6240\u9009\u6838\u7b97\u7ec4\u7ec7+\u671f\u95f4\u5b58\u5728\u65ad\u53f7\uff1a%s", (String)"VoucherNumCheckUtil_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), result[2].toString()), MessageBoxOptions.OK);
        }
    }

    private boolean checkCodeRule(List<String> orgIds) {
        Iterator<String> iterator = orgIds.iterator();
        HashSet<String> noCodeRuleOrgIds = new HashSet<String>();
        while (iterator.hasNext()) {
            String org = iterator.next();
            CodeRuleInfo codeRule = VoucherNumberUtils.getCodeRuleInfo((Long)Long.parseLong(org), (String)"B");
            if (codeRule != null) continue;
            noCodeRuleOrgIds.add(org);
            iterator.remove();
        }
        if (orgIds.size() == 0) {
            this.p.getView().showMessage(ResManager.loadKDString((String)"\u51ed\u8bc1\u7f16\u7801\u89c4\u5219\u672a\u8bbe\u7f6e", (String)"VoucherNumCheckUtil_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u63d0\u4ea4\u51ed\u8bc1\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u524d\u5f80\u914d\u7f6e\u5de5\u5177-\u7f16\u7801\u89c4\u5219\u8bbe\u7f6e\u3002", (String)"VoucherNumCheckUtil_5", (String)"fi-gl-formplugin", (Object[])new Object[0]), MessageTypes.Default);
            return false;
        }
        if (noCodeRuleOrgIds.size() != 0) {
            String joined = String.join((CharSequence)";", this.getOrgName(noCodeRuleOrgIds.stream().map(Long::parseLong).collect(Collectors.toList())));
            this.p.getView().showMessage(ResManager.loadKDString((String)"\u65ad\u53f7\u8c03\u6574\u6821\u9a8c", (String)"VoucherNumCheckUtil_9", (String)"fi-gl-formplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7%1$s\uff0c\u672a\u8bbe\u7f6e\u63d0\u4ea4\u51ed\u8bc1\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u524d\u5f80\u914d\u7f6e\u5de5\u5177-\u7f16\u7801\u89c4\u5219\u8bbe\u7f6e\u3002%2$s", (String)"VoucherNumCheckUtil_6", (String)"fi-gl-formplugin", (Object[])new Object[0]), joined, this.validateMsg), MessageTypes.Default);
            return true;
        }
        return true;
    }

    private List<String> getAllOrg() {
        List orgIds = AccSysUtil.getAcctOrgPkList((String)"gl_voucher", (boolean)false, (PermissonType)PermissonType.NEW);
        return orgIds.stream().map(String::valueOf).collect(Collectors.toList());
    }

    public Object[] checkVoucherNumber(List<String> orgIds, String booksTypeId, String period) {
        Object[] result = new Object[4];
        ArrayList<String> tipList = new ArrayList<String>();
        ArrayList<String> breakDetail = new ArrayList<String>();
        for (String orgId : orgIds) {
            DynamicObject book;
            CodeRuleInfo codeRule = BreakPointCommonUtil.getCodeRuleInfo((String)orgId);
            DynamicObjectCollection ruleEntry = GLBreakPointUtil.getCodeRuleEntry((CodeRuleInfo)codeRule);
            QFilter qOrg = new QFilter("org", "=", (Object)Long.valueOf(orgId));
            if (booksTypeId != null && !"0".equals(booksTypeId)) {
                qOrg.and(new QFilter("bookstype", "=", (Object)Long.valueOf(booksTypeId)));
            }
            if ((book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"curperiod,curperiod.name,bookstype", (QFilter[])qOrg.toArray())) == null || booksTypeId == null) continue;
            booksTypeId = book.getString("bookstype");
            List codeRuleEntryAttributes = GLBreakPointUtil.getAttributeFromCodeRuleEntry((DynamicObjectCollection)ruleEntry);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("orgId", orgId);
            paramMap.put("booktype", booksTypeId);
            paramMap.put("period", Long.parseLong(period));
            paramMap.put("orgName", QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(orgId))}).get("name"));
            paramMap.put("condition", VoucherNumberUtils.isOnlyForSubmit((CodeRuleInfo)codeRule));
            String[] consistent = GLBreakPointUtil.checkConsistent((String)codeRule.getId(), (List)codeRuleEntryAttributes, paramMap, (int)0, (boolean)codeRule.getIsNonBreak());
            String isconsistent = consistent[0];
            if ("0".equals(isconsistent)) {
                tipList.add(consistent[1]);
                result[0] = "0";
                breakDetail.add(consistent[2]);
            }
            if (!"2".equals(isconsistent)) continue;
            result[0] = "2";
            tipList.add(consistent[1]);
        }
        if (tipList.size() != 0) {
            result[1] = tipList;
        }
        if (breakDetail.size() != 0) {
            result[2] = breakDetail;
        }
        return result;
    }

    private void cacheOrgBookTypePeriodList(List<OrgBooktypePeriod> orgBookTypePeriodList, IPageCache pageCache) {
        if (!orgBookTypePeriodList.isEmpty()) {
            String orgAndBooksMapStr = pageCache.get("orgAndBooksForPointList");
            if (!StringUtils.isEmpty((CharSequence)orgAndBooksMapStr)) {
                Map orgAndBooksMap = (Map)JSON.parseObject((String)orgAndBooksMapStr, HashMap.class);
                List<Map> allBooks = orgAndBooksMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                HashMap bookTypeMap = new HashMap(8);
                allBooks.forEach(e -> {
                    String cfr_ignored_0 = (String)bookTypeMap.putIfAbsent(e.get("masterId"), e.get("bookNm"));
                });
                orgBookTypePeriodList.forEach(e -> {
                    String bookName = (String)bookTypeMap.get(String.valueOf(e.getBooktypeId()));
                    e.setBookName(bookName);
                });
            }
            pageCache.put("orgBookTypePeriodList", JSON.toJSONString(orgBookTypePeriodList));
        }
    }

    public boolean checkQueryPermission(List<Long> orgIds, boolean show) {
        HasPermOrgResult allPermOrg = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"15", (String)"gl", (String)"gl_voucherbreakpoint", (String)PermissonType.VIEW.getPermId());
        if (allPermOrg.hasAllOrgPerm()) {
            return true;
        }
        List hasPermOrg = allPermOrg.getHasPermOrgs();
        List<Long> resOrg = orgIds.stream().filter(hasPermOrg::contains).collect(Collectors.toList());
        List<Long> noPermOrg = orgIds.stream().filter(ele -> !hasPermOrg.contains(ele)).collect(Collectors.toList());
        orgIds.retainAll(resOrg);
        if (resOrg.isEmpty()) {
            String joined = String.join((CharSequence)";", this.getOrgName(resOrg));
            this.p.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u201c\u51ed\u8bc1\u65ad\u53f7\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650", (String)"VoucherNumCheckUtil_7", (String)"fi-gl-formplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u65e0\u201c\u51ed\u8bc1\u65ad\u53f7\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VoucherNumCheckUtil_8", (String)"fi-gl-formplugin", (Object[])new Object[0]), joined), MessageTypes.Default);
            return false;
        }
        if (!noPermOrg.isEmpty()) {
            String joined = String.join((CharSequence)";", this.getOrgName(noPermOrg));
            if (show) {
                this.p.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u201c\u51ed\u8bc1\u65ad\u53f7\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650", (String)"VoucherNumCheckUtil_7", (String)"fi-gl-formplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7%1$s\uff0c\u65e0\u201c\u51ed\u8bc1\u65ad\u53f7\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VoucherNumCheckUtil_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), joined), MessageTypes.Default);
            } else {
                this.validateMsg = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7%1$s\uff0c\u65e0\u201c\u51ed\u8bc1\u65ad\u53f7\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VoucherNumCheckUtil_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), joined);
            }
            return true;
        }
        return true;
    }

    public List<String> getOrgName(List<Long> orgIds) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_org", (String)"name", (QFilter[])new QFilter("id", "in", orgIds).toArray());
        return query.stream().map(dynamicObject -> dynamicObject.getString("name")).collect(Collectors.toList());
    }
}

