/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportRowSet;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.IReportView;
import kd.bos.report.ReportShowParameter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bd.service.budgetaccounting.dao.VoucherDaoImpl;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.QFBuilder;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.constant.Voucher;
import kd.fi.gl.enums.GLBillParamEnum;
import kd.fi.gl.util.AssgrpFilterUtil;
import kd.fi.gl.util.AssgrpRelationUtil;
import kd.fi.gl.util.GLApp;
import org.apache.commons.collections4.CollectionUtils;

public class VoucherUtil {
    private static final String CUR_DATE_PERIOD_CACHE = "cur_date_period_cache";
    private static final Consumer<BillShowParameter> EMPTY_CONSUMER = obj -> {};
    private static final String FLEXFIELDCACHE = "local-flexfield-cache";
    private static final String FlexEntityCahcheKey = "flex-entity-key";

    public static void hyperSublidger(DynamicObject voucher, long acctId, long curId, IFormView view, Long accountTableId) {
        if (acctId == 0L) {
            return;
        }
        DynamicObject book = voucher.getDynamicObject("book");
        FilterInfo filter = new FilterInfo();
        long orgID = voucher.getLong("org_id");
        DynamicObjectType orgType = voucher.getDynamicObject("org").getDynamicObjectType();
        DynamicObjectCollection orgDyos = new DynamicObjectCollection(orgType, null, Collections.singletonList(BusinessDataServiceHelper.load((Object[])new Object[]{orgID}, (DynamicObjectType)orgType)[0]));
        filter.addFilterItem("orgs", (Object)orgDyos);
        filter.addFilterItem("orgview", null);
        filter.addFilterItem("searchtype", (Object)"1");
        filter.addFilterItem("book", book.getPkValue());
        filter.addFilterItem("booktype", (Object)voucher.getLong("booktype_id"));
        filter.addFilterItem("periodtype", (Object)book.getLong("periodtype.id"));
        filter.addFilterItem("startperiod", voucher.get("period"));
        filter.addFilterItem("endperiod", voucher.get("period"));
        if (curId == 0L) {
            return;
        }
        filter.addFilterItem("currency", (Object)curId);
        filter.addFilterItem("accounttable", (Object)accountTableId);
        DynamicObject acct = BusinessDataServiceHelper.loadSingleFromCache((Object)acctId, (String)"bd_accountview", (String)"level");
        filter.addFilterItem("accountlevel", (Object)acct.getInt("level"));
        filter.addFilterItem("showleafaccount", (Object)true);
        filter.addFilterItem("account", (Object)acctId);
        ReportShowParameter report = new ReportShowParameter();
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filter);
        report.setQueryParam(queryParam);
        VoucherUtil.showForm("gl_rpt_subledger", ShowType.MainNewTabPage, (FormShowParameter)report, null, view);
    }

    public static void hyperSubsidiaryledger(DynamicObject voucher, long acctId, long curId, DynamicObject assgrp, BigDecimal qty, IFormView view, Long accountTableId) {
        if (acctId == 0L) {
            return;
        }
        QFilter idFilter = new QFilter("id", "=", (Object)acctId);
        DynamicObject masterActDyn = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"masterid", (QFilter[])idFilter.toArray());
        DynamicObject period = voucher.getDynamicObject("period");
        Date endDate = period.getDate("enddate");
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("enable", "=", (Object)Boolean.TRUE);
        qfBuilder.add("masterid", "=", (Object)masterActDyn.getLong("masterid"));
        qfBuilder.add("startdate", "<=", (Object)endDate);
        qfBuilder.add("enddate", ">=", (Object)endDate);
        qfBuilder.add(AccountUtils.getAccountDataFilter((long)voucher.getLong("org_id"), (long)accountTableId));
        Optional<DynamicObject> latestVersionAccount = Optional.ofNullable(QueryServiceHelper.queryOne((String)"bd_accountview", (String)"id", (QFilter[])qfBuilder.toArray()));
        long l = acctId = latestVersionAccount.isPresent() ? latestVersionAccount.get().getLong("id") : acctId;
        if (assgrp == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u4e3a\u7a7a\uff0c\u4e0d\u652f\u6301\u8054\u67e5\u8f85\u52a9\u660e\u7ec6\u8d26\u3002", (String)"VoucherUtil_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        ReportShowParameter report = new ReportShowParameter();
        DynamicObject book = voucher.getDynamicObject("book");
        FilterInfo filter = new FilterInfo();
        filter.addFilterItem("org", (Object)voucher.getLong("org_id"));
        filter.addFilterItem("book", (Object)book);
        filter.addFilterItem("periodtype", (Object)book.getLong("periodtype.id"));
        filter.addFilterItem("booktype", (Object)voucher.getLong("booktype_id"));
        filter.addFilterItem("startperiod", (Object)voucher.getDynamicObject("period"));
        filter.addFilterItem("endperiod", (Object)voucher.getDynamicObject("period"));
        filter.addFilterItem("currency", (Object)curId);
        filter.addFilterItem("accounttable", (Object)accountTableId);
        filter.addFilterItem("account", (Object)acctId);
        DynamicObject acct = BusinessDataServiceHelper.loadSingleFromCache((Object)acctId, (String)"bd_accountview", (String)"level");
        filter.addFilterItem("accountlevel", (Object)acct.getInt("level"));
        if (BigDecimal.ZERO.compareTo(qty) != 0) {
            filter.addFilterItem("showqty", (Object)true);
        }
        List flexFilter = filter.getFlexFilterItems();
        JSONObject valueJson = JSONObject.parseObject((String)assgrp.getString("value"));
        Set ks = valueJson.keySet();
        Set entries = valueJson.entrySet();
        for (Map.Entry entry : entries) {
            String k = (String)entry.getKey();
            QFilter q = new QFilter("flexfield", "=", (Object)k);
            Map asstacttypes = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (String)"number,valuetype,valuesource,assistanttype", (QFilter[])new QFilter[]{q});
            if (asstacttypes.isEmpty()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"VoucherUtil_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            if (asstacttypes.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u6570\u636e\u5f02\u5e38\uff0cflexfield=%s\u91cd\u590d\u3002", (String)"VoucherUtil_2", (String)"fi-gl-formplugin", (Object[])new Object[]{k}));
            }
            HashSet vals = new HashSet();
            vals.add(entry.getValue());
            flexFilter.add(new FilterItemInfo(k, vals, "in"));
        }
        filter.setFlexFilterItems(flexFilter);
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filter);
        report.setQueryParam(queryParam);
        VoucherUtil.showForm("gl_rpt_subsidiaryledger", ShowType.MainNewTabPage, (FormShowParameter)report, null, view);
    }

    public static void showForm(String formId, ShowType showType, FormShowParameter formShowParameter, CloseCallBack closeCallBack, IFormView formView) {
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(showType);
        if (null != closeCallBack) {
            formShowParameter.setCloseCallBack(closeCallBack);
        }
        formView.showForm(formShowParameter);
    }

    public static void hyperVoucher(long voucherId, IFormView view) {
        VoucherUtil.hyperVoucher(voucherId, view, EMPTY_CONSUMER);
    }

    public static void hyperVoucher(long voucherId, IFormView view, Consumer<BillShowParameter> customAction) {
        DynamicObject voucherDyn = QueryServiceHelper.queryOne((String)"gl_voucher", (String)"org", (QFilter[])new QFilterBuilder().addEqual("id", (Object)voucherId).toArray(new QFilter[0]));
        if (voucherDyn != null) {
            VoucherUtil.hyperVoucher(voucherDyn.getLong("org"), voucherId, view, customAction);
        }
    }

    public static void hyperVoucher(long orgId, long voucherId, IFormView view) {
        VoucherUtil.hyperVoucher(orgId, voucherId, view, EMPTY_CONSUMER);
    }

    public static void hyperVoucher(long orgId, long voucherId, IFormView view, List<Object> pkIds) {
        String ids = SerializationUtils.toJsonString(pkIds);
        VoucherUtil.hyperVoucher(orgId, voucherId, view, (Consumer<BillShowParameter>)((Consumer)param -> param.getCustomParams().put("navigation_billids", ids)));
    }

    public static void hyperVoucher(long orgId, long voucherId, IFormView view, Consumer<BillShowParameter> customAction) {
        if (!QueryServiceHelper.exists((String)"gl_voucher", (Object)voucherId)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"VoucherUtil_6", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("gl_voucher");
        showParameter.setPkId((Object)voucherId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        long userId = RequestContext.get().getCurrUserId();
        int i = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)"83bfebc8000017ac", (String)"gl_voucher", (String)"4715a0df000000ac");
        PermissionService impl = (PermissionService)ServiceFactory.getService(PermissionService.class);
        boolean hasPerm = impl.matchDataRule(userId, "83bfebc8000017ac", "gl_voucher", "4715a0df000000ac", new QFilter("id", "=", (Object)voucherId).toArray());
        boolean isModify = true;
        QFilter filter = impl.getOperationRuleFilter("83bfebc8000017ac", "gl_voucher", "modify", Long.valueOf(0L));
        if (null != filter) {
            QFilter fid = new QFilter("id", "=", (Object)voucherId);
            isModify = QueryServiceHelper.exists((String)"gl_voucher", (QFilter[])new QFilter[]{fid, filter});
        }
        if (i == 1 && isModify && hasPerm) {
            showParameter.setBillStatus(BillOperationStatus.EDIT);
            showParameter.setStatus(OperationStatus.EDIT);
        } else {
            showParameter.setBillStatus(BillOperationStatus.VIEW);
            showParameter.setStatus(OperationStatus.VIEW);
        }
        if (customAction != null) {
            customAction.accept((Object)showParameter);
        }
        view.showForm((FormShowParameter)showParameter);
    }

    @Deprecated
    public static List<Object> getVoucherIdList(IReportListModel reportModel, String idColumnNumber) {
        AbstractReportListModel listModel = (AbstractReportListModel)reportModel;
        int rowCount = listModel.getRowCount();
        ReportRowSet rowSet = listModel.getReportTaskResult().getData(0, rowCount);
        HashSet<Object> idset = new HashSet<Object>(rowCount);
        while (rowSet.next()) {
            Object obj = rowSet.getObject(idColumnNumber);
            if (obj == null || "0".equals(obj) || "".equals(obj)) continue;
            idset.add(obj);
        }
        ArrayList<Object> list = new ArrayList<Object>(idset);
        return list;
    }

    public static List<Object> getVoucherIdList(IReportListModel reportModel, String idColumnNumber, int curIndex) {
        AbstractReportListModel listModel = (AbstractReportListModel)reportModel;
        int rowCount = listModel.getRowCount();
        int start = curIndex > 50 ? curIndex - 50 : 0;
        int end = rowCount > curIndex + 50 ? curIndex + 50 : rowCount;
        int limit = end - start;
        ReportRowSet rowSet = listModel.getReportTaskResult().getData(start, limit);
        ArrayList<Object> ids = new ArrayList<Object>(limit);
        while (rowSet.next()) {
            Object obj = rowSet.getObject(idColumnNumber);
            if (obj == null || "0".equals(obj) || "".equals(obj) || ids.contains(obj)) continue;
            ids.add(obj);
        }
        return ids;
    }

    public static void showPrintSetting(IFormView view) {
        String type = "";
        String formId = view.getFormShowParameter().getFormId();
        if (view instanceof IListView) {
            ListShowParameter listParam = (ListShowParameter)view.getFormShowParameter();
            formId = listParam.getBillFormId();
            type = IListView.class.getSimpleName();
        } else {
            type = view instanceof IReportView ? IReportView.class.getSimpleName() : IFormView.class.getSimpleName();
        }
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("gl_printsetting");
        param.setCustomParam("formid", (Object)formId);
        param.setCustomParam("formtype", (Object)type);
        view.showForm(param);
    }

    public static void showAssgrpDefVal(IDataModel model, IFormView view) {
        DynamicObject accounttable;
        DynamicObject accountbook;
        ListShowParameter list = new ListShowParameter();
        list.setLookUp(Boolean.FALSE.booleanValue());
        list.setBillFormId("gl_assgrpdefval");
        list.setFormId("gl_assgrpdefvallist");
        list.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("600px");
        list.getOpenStyle().setInlineStyleCss(css);
        list.setMultiSelect(Boolean.TRUE.booleanValue());
        list.setShowTitle(Boolean.FALSE.booleanValue());
        list.setHasRight(Boolean.TRUE.booleanValue());
        Long orgid = (Long)model.getValue("org_id");
        if (orgid <= 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"VoucherUtil_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        Long bookid = (Long)model.getValue("book_id");
        Long accounttableid = 0L;
        if (bookid > 0L && (accountbook = BusinessDataServiceHelper.loadSingle((Object)bookid, (String)"gl_accountbook", (String)"accounttable")) != null && (accounttable = accountbook.getDynamicObject("accounttable")) != null) {
            accounttableid = accounttable.getLong("id");
        }
        if (accounttableid <= 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u79d1\u76ee\u8868\u3002", (String)"VoucherUtil_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("org", orgid);
        params.put("accounttable", accounttableid);
        params.put("book", bookid);
        list.setCustomParams(params);
        view.showForm((FormShowParameter)list);
    }

    public static void setAssgrpByRelation(AbstractBillPlugIn p, String fromflex, Object newValue, String key, IDataModel model) {
        String entity;
        DynamicObject nv;
        String finorginfo;
        FlexEdit c = null;
        c = key.startsWith("$$mcfassgrp__") ? (FlexEdit)p.getControl("mcfassgrp") : (FlexEdit)p.getControl("assgrp");
        Map<String, String> map = VoucherUtil.getFlexField(p.getPageCache());
        boolean isAB = VoucherUtil.isAccountBank(fromflex, map);
        if (isAB && null != (finorginfo = VoucherUtil.getFinorginfo((FlexEntityType)c.getFlexModel().getDataEntityType(), map)) && null != (nv = (DynamicObject)newValue)) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)nv.getLong("id"))};
            DynamicObject acctbank = QueryServiceHelper.queryOne((String)"am_accountbank", (String)"bank", (QFilter[])filters);
            c.getFlexModel().setValue(finorginfo, (Object)acctbank.getLong("bank"));
        }
        if ((entity = VoucherUtil.getFlexToEntity(fromflex, p.getPageCache())) != null) {
            if (key.startsWith("$$mcfassgrp__")) {
                VoucherUtil.getAssgrpValByRelation((AbstractFormPlugin)p, "mcfassgrp", fromflex, entity, newValue, model);
            } else if (key.startsWith("$$assgrp__")) {
                VoucherUtil.getAssgrpValByRelation((AbstractFormPlugin)p, "assgrp", fromflex, entity, newValue, model);
            }
        }
    }

    private static Map<String, String> getFlexField(IPageCache cache) {
        String flexfield = cache.get(FLEXFIELDCACHE);
        if (flexfield == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            ArrayList<String> source = new ArrayList<String>();
            source.add("bd_finorginfo");
            source.add("am_accountbank");
            source.add("bd_accountbanks");
            QFilter[] filter = new QFilter[]{new QFilter("valuesource", "in", source)};
            DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_asstacttype", (String)"flexfield,assistanttype,valuetype,valuesource", (QFilter[])filter);
            for (DynamicObject obj : col) {
                map.put(obj.getString("flexfield"), obj.getString("valuesource"));
            }
            cache.put(FLEXFIELDCACHE, SerializationUtils.toJsonString(map));
            return map;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)flexfield, Map.class);
        return map;
    }

    private static boolean isAccountBank(String flexfield, Map<String, String> map) {
        return map.containsKey(flexfield) && (map.get(flexfield).equals("am_accountbank") || map.get(flexfield).equals("bd_accountbanks"));
    }

    private static String getFinorginfo(FlexEntityType type, Map<String, String> map) {
        DynamicPropertyCollection ps = (DynamicPropertyCollection)type.getProperties();
        String finorginfo = "bd_finorginfo";
        String flexfield = null;
        for (Map.Entry<String, String> key2v : map.entrySet()) {
            if (!key2v.getValue().equals(finorginfo)) continue;
            flexfield = key2v.getKey();
            break;
        }
        if (flexfield == null) {
            return null;
        }
        for (IDataEntityProperty p : ps) {
            if (!p.getAlias().endsWith(flexfield)) continue;
            return p.getName();
        }
        return null;
    }

    private static String getFlexToEntity(String flexfield, IPageCache cache) {
        String cacheVal = cache.get(FlexEntityCahcheKey);
        if (cacheVal != null) {
            Map map = (Map)SerializationUtils.fromJsonString((String)cacheVal, Map.class);
            if (map.get(flexfield) != null) {
                return (String)map.get(flexfield);
            }
            String entityByFlex = VoucherUtil.getEntityByFlex(flexfield);
            if (entityByFlex != null) {
                map.put(flexfield, entityByFlex);
                cache.put(FlexEntityCahcheKey, SerializationUtils.toJsonString((Object)map));
                return entityByFlex;
            }
        } else {
            String entityByFlex = VoucherUtil.getEntityByFlex(flexfield);
            if (entityByFlex != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(flexfield, entityByFlex);
                cache.put(FlexEntityCahcheKey, SerializationUtils.toJsonString(map));
                return entityByFlex;
            }
        }
        return null;
    }

    private static String getEntityByFlex(String flexfield) {
        QFilter filters = new QFilter("flexfield", "=", (Object)flexfield);
        DynamicObject loadSingleFromCache = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_asstacttype", (QFilter[])filters.toArray());
        if (loadSingleFromCache != null) {
            String type = loadSingleFromCache.getString("valuetype");
            if ("1".equals(type)) {
                DynamicObject dynamicObject = loadSingleFromCache.getDynamicObject("valuesource");
                return dynamicObject == null ? null : dynamicObject.getString("number");
            }
            if ("2".equals(type)) {
                return "bos_assistantdata_detail";
            }
        }
        return null;
    }

    private static void getAssgrpValByRelation(AbstractFormPlugin p, String flexKey, String fromFlex, String entity, Object fromval, IDataModel model) {
        block6: {
            Long orgid;
            HashSet<String> toflexs;
            String prefix;
            IDataModel flexModel;
            block7: {
                boolean isClear = false;
                if (null == fromval) {
                    isClear = true;
                }
                FlexEdit edit = (FlexEdit)p.getControl(flexKey);
                flexModel = edit.getFlexModel();
                DataEntityPropertyCollection properties = flexModel.getDataEntityType().getProperties();
                prefix = "$$" + flexKey + "__";
                String suffix = "_id";
                String fromFelxIdKey = prefix + fromFlex + suffix;
                toflexs = new HashSet<String>();
                for (IDataEntityProperty iDataEntityProperty : properties) {
                    String name = iDataEntityProperty.getName();
                    if (!name.startsWith(prefix) || !name.endsWith(suffix) || name.equals(fromFelxIdKey)) continue;
                    Object value = flexModel.getValue(name);
                    if (isClear && (AssgrpRelationUtil.isValNull((Object)value) || !isClear)) continue;
                    String toflex = name.replace(prefix, "").replace(suffix, "");
                    toflexs.add(toflex);
                }
                if (toflexs.isEmpty()) break block6;
                orgid = (Long)model.getValue("org_id");
                if (orgid <= 0L) {
                    return;
                }
                if (!isClear) break block7;
                Map relationMapByFromFlex = AssgrpRelationUtil.getRelationMapByFromFlex((String)fromFlex, toflexs, (Long)orgid);
                for (String toflex : relationMapByFromFlex.keySet()) {
                    flexModel.setValue(prefix + toflex, null);
                }
                break block6;
            }
            if (!(fromval instanceof DynamicObject)) break block6;
            Object formValPk = ((DynamicObject)fromval).getPkValue();
            Map assgrpValByRelation = AssgrpRelationUtil.getAssgrpValByRelation((String)fromFlex, toflexs, (String)entity, (Object)formValPk, (Long)orgid);
            if ("assgrp".equals(flexKey)) {
                VoucherUtil.existsValInAssgrpFilter(assgrpValByRelation, model);
            }
            for (Map.Entry flexToVal : assgrpValByRelation.entrySet()) {
                flexModel.setValue(prefix + (String)flexToVal.getKey(), flexToVal.getValue());
            }
        }
    }

    private static void existsValInAssgrpFilter(Map<String, Object> assgrpValByRelation, IDataModel model) {
        Long orgid = Long.valueOf(model.getValue("org_id").toString());
        if (orgid > 0L) {
            AccountBookInfo accountBookInfo;
            long accountid = 0L;
            long accounttableid = 0L;
            if (StringUtils.equals((CharSequence)"gl_voucher", (CharSequence)model.getDataEntityType().getName()) || StringUtils.equals((CharSequence)"gl_templatevoucher", (CharSequence)model.getDataEntityType().getName())) {
                long bookid = (Long)model.getValue("book_id");
                if (bookid > 0L) {
                    accountBookInfo = new AccountBookInfo(bookid);
                    accounttableid = accountBookInfo.getAccountTableId();
                }
                if (accounttableid > 0L) {
                    int rowIndex = model.getEntryCurrentRowIndex("entries");
                    accountid = (Long)model.getValue(Voucher.id_((String)"account"), rowIndex);
                }
            } else {
                long booktype = (Long)model.getValue("booktype_id");
                accountBookInfo = new AccountBookInfo(orgid.longValue(), booktype);
                accounttableid = accountBookInfo.getAccountTableId();
                if (accounttableid > 0L) {
                    accountid = (Long)model.getValue(Voucher.id_((String)"account"));
                }
            }
            if (accountid > 0L) {
                Iterator<Map.Entry<String, Object>> iterator = assgrpValByRelation.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> flexToVal = iterator.next();
                    boolean exists = AssgrpFilterUtil.checkAssgrpFilter((long)orgid, (long)accounttableid, (long)accountid, (String)flexToVal.getKey(), (Object)flexToVal.getValue(), (String)"id");
                    if (exists) continue;
                    iterator.remove();
                }
            }
        }
    }

    public static DynamicObject getPeriodId(Date date, Long periodType) {
        SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = dt.format(date);
        StringBuilder sb = new StringBuilder(3);
        sb.append(dateStr);
        sb.append("_");
        sb.append(periodType);
        DynamicObject periodCache = null;
        HashMap<String, DynamicObject> periodCacheMap = (HashMap<String, DynamicObject>)ThreadCache.get((Object)CUR_DATE_PERIOD_CACHE);
        if (periodCacheMap == null) {
            periodCacheMap = new HashMap<String, DynamicObject>(999);
        } else {
            periodCache = (DynamicObject)periodCacheMap.get(sb.toString());
        }
        if (periodCache == null) {
            QFilter beginDateF = new QFilter("begindate", "<=", (Object)date);
            QFilter endDateF = new QFilter("enddate", ">=", (Object)date);
            QFilter typeF = new QFilter("periodtype", "=", (Object)periodType);
            periodCache = QueryServiceHelper.queryOne((String)"bd_period", (String)"id,periodtype.id,periodyear,periodnumber,begindate,enddate,isadjustperiod,number,name", (QFilter[])new QFilter[]{typeF, beginDateF, endDateF});
            periodCacheMap.put(sb.toString(), periodCache);
            ThreadCache.put((Object)CUR_DATE_PERIOD_CACHE, periodCacheMap);
        }
        return periodCache;
    }

    public static boolean isSuppAdjusted(IDataModel model) {
        String suppstatus = (String)model.getValue("suppstatus");
        return suppstatus != null && (suppstatus.equals("b") || suppstatus.equals("c"));
    }

    public static boolean isEntryCountExceedsThreshold(Collection<Object> voucherIds) {
        if (CollectionUtils.isEmpty(voucherIds)) {
            return false;
        }
        String threshold = BillParamUtil.getStringValue((String)"83bfebc8000017ac", (String)"fi.gl.voucher.async.threshold", (String)"100000");
        Collection castVoucherIds = CollectionUtils.collect(voucherIds, Long.class::cast);
        Collection entryCounts = VoucherDaoImpl.getInstance().getMaxSeqMap(castVoucherIds).values();
        return entryCounts.stream().mapToLong(Long::longValue).sum() > Long.parseLong(threshold);
    }

    public static void copyLimit(IFormView view, BeforeDoOperationEventArgs e) {
        Object voucherId;
        if (!GLBillParamEnum.VOUCHER_COPY_LIMIT_ENABLE.getBooleanValue() || view == null) {
            return;
        }
        ListSelectedRowCollection listSelectedBillRows = e.getListSelectedData().getBillListSelectedRowCollection();
        if (view instanceof IListView && listSelectedBillRows.size() != 1) {
            return;
        }
        Object object = voucherId = view instanceof IListView ? listSelectedBillRows.get(0).getPrimaryKeyValue() : view.getModel().getValue("id");
        if (VoucherUtil.isEntryCountExceedsThreshold(Collections.singleton(voucherId))) {
            e.setCancel(true);
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u51ed\u8bc1\u5206\u5f55\u884c\u6570\u8fc7\u591a\uff0c\u8bf7\u901a\u8fc7\u5bfc\u51fa\u5bfc\u5165\u8fdb\u884c\u5904\u7406\u3002", (String)"VoucherUtil_7", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
        }
    }
}

