/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.operate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;

@Deprecated
public class VoucherInvoiceView {
    private static final String ER_BD_KDINVOICECLOUDCFG = "er_bd_kdinvoicecloudcfg";
    private static final String EM = "em";
    private static final String ER_DAILYREIMBURSEBILL = "er_dailyreimbursebill";
    private static final String ER_TRIPREIMBURSEBILL = "er_tripreimbursebill";
    private static final String GL_INVOICECLOUDPAGE = "gl_invoicecloudpage";
    private static final String ORG = "org";
    private static final String ENABLE = "enable";
    private static final String TAXREGNUM = "taxregnum";
    private static final String ORG_ID = "orgId";
    private static final String ORG_NAME = "orgName";
    private static final String BILL_NUMBER = "billNumber";
    private static final String COSTCOMPANY_ID = "costcompany.id";
    private static final String COSTCOMPANY_NAME = "costcompany.name";
    private static final String INVOICEENTRY_SERIALNO = "invoiceentry.serialno";
    private static final String CLIENT_ID = "client_id";
    private static final String CLIENT_SECRET = "client_secret";

    public void showInvoice(IFormView view, long voucherId) {
        if (null == view) {
            return;
        }
        Map billIdEntityMap = GLUtil.getVoucherLinkUpBills(Collections.singletonList(voucherId));
        if (billIdEntityMap.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5173\u8054\u5355\u636e\u3002", (String)"VoucherInvoiceView_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        Map entityBillIdSetMap = billIdEntityMap.entrySet().stream().filter(x -> {
            String billEntity = (String)x.getValue();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billEntity);
            if (null != dataEntityType) {
                return dataEntityType.getAppId().equalsIgnoreCase(EM);
            }
            return false;
        }).collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toSet())));
        if (entityBillIdSetMap.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5173\u8054\u5355\u636e\u3002", (String)"VoucherInvoiceView_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Map<String, Object>> invoiceCloudParamList = new ArrayList<Map<String, Object>>(entityBillIdSetMap.size());
        for (Map.Entry entry : entityBillIdSetMap.entrySet()) {
            invoiceCloudParamList.addAll(this.getInvoiceCloudParamList(entry.getKey(), entry.getValue()));
        }
        if (!invoiceCloudParamList.isEmpty()) {
            for (Map map : invoiceCloudParamList) {
                this.showGlInvoiceCouldPage(map, view);
            }
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7535\u5b50\u53d1\u7968\u4fe1\u606f\u3002", (String)"VoucherInvoiceView_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    private List<Map<String, Object>> getInvoiceCloudParamList(String entity, Set<Long> billIdSet) {
        switch (entity) {
            case "er_dailyreimbursebill": 
            case "er_tripreimbursebill": {
                return this.getInvoiceCloudParamListFromErBill(entity, billIdSet);
            }
        }
        return Collections.emptyList();
    }

    private List<Map<String, Object>> getInvoiceCloudParamListFromErBill(String entity, Set<Long> billIdSet) {
        ArrayList<Map<String, Object>> invoiceCloudParamList = new ArrayList<Map<String, Object>>(billIdSet.size());
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", billIdSet);
        HashMap<Long, Map> erBillIdInfoMap = new HashMap<Long, Map>(billIdSet.size());
        ArrayList<Long> orgIdList = new ArrayList<Long>(billIdSet.size());
        try (DataSet erBillDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entity, (String)String.join((CharSequence)",", "id", COSTCOMPANY_ID, COSTCOMPANY_NAME, INVOICEENTRY_SERIALNO), (QFilter[])qfBuilder.toArray(), null);){
            for (Row row : erBillDataSet) {
                String serialNo;
                Long billId = row.getLong("id");
                if (erBillIdInfoMap.containsKey(billId) || StringUtils.isBlank((CharSequence)(serialNo = row.getString(INVOICEENTRY_SERIALNO)))) continue;
                HashMap<String, Object> commonParamMap2 = new HashMap<String, Object>(3);
                orgIdList.add(row.getLong(COSTCOMPANY_ID));
                commonParamMap2.put(ORG_ID, row.getLong(COSTCOMPANY_ID));
                commonParamMap2.put(ORG_NAME, row.getString(COSTCOMPANY_NAME));
                commonParamMap2.put(BILL_NUMBER, entity + "_" + billId);
                erBillIdInfoMap.put(billId, commonParamMap2);
            }
        }
        Map<Long, Map<String, Object>> orgIdInvoiceConfigInfoMap = this.getOrgIdInvoiceConfigInfoMap(orgIdList);
        erBillIdInfoMap.forEach((erBillId, commonParamMap) -> {
            long orgIdLongValue;
            Map invoiceConfigInfoMap;
            Object orgId = commonParamMap.get(ORG_ID);
            if (orgId instanceof Long && (invoiceConfigInfoMap = (Map)orgIdInvoiceConfigInfoMap.get(orgIdLongValue = ((Long)orgId).longValue())) != null) {
                commonParamMap.putAll(invoiceConfigInfoMap);
                invoiceCloudParamList.add((Map<String, Object>)commonParamMap);
            }
        });
        return invoiceCloudParamList;
    }

    private Map<Long, Map<String, Object>> getOrgIdInvoiceConfigInfoMap(List<Long> orgIdList) {
        HashMap orgIdTaxRegNumMap = new HashMap(orgIdList.size());
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(ORG, "in", orgIdList);
        qfBuilder.add(ENABLE, "=", (Object)Boolean.TRUE);
        try (DataSet taxRegNumDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)ER_BD_KDINVOICECLOUDCFG, (String)String.join((CharSequence)",", ORG, TAXREGNUM, CLIENT_ID, CLIENT_SECRET), (QFilter[])qfBuilder.toArray(), null);){
            for (Row row : taxRegNumDataSet) {
                String taxRegNum = row.getString(TAXREGNUM);
                String clientId = row.getString(CLIENT_ID);
                String clientSecret = row.getString(CLIENT_SECRET);
                if (!StringUtils.isNotBlank((CharSequence)taxRegNum)) continue;
                HashMap<String, String> invoiceConfigInfoMap = new HashMap<String, String>(3);
                invoiceConfigInfoMap.put(TAXREGNUM, taxRegNum);
                invoiceConfigInfoMap.put(CLIENT_ID, clientId);
                invoiceConfigInfoMap.put(CLIENT_SECRET, clientSecret);
                orgIdTaxRegNumMap.put(row.getLong(ORG), invoiceConfigInfoMap);
            }
            HashMap hashMap = orgIdTaxRegNumMap;
            return hashMap;
        }
    }

    private void showGlInvoiceCouldPage(Map<String, Object> paramMap, IFormView view) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(GL_INVOICECLOUDPAGE);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParams(paramMap);
        parameter.setShowTitle(true);
        view.showForm(parameter);
    }
}

