/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.consts.MappingTypeEnum;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.util.GLUtil;

public class AccountCompareBalanceRptPlugin
extends AbstractReportListDataPlugin {
    private MulOrgQPRpt qParam;
    Map<Long, Long> sourceToTargetAcc = new HashMap<Long, Long>(40);
    boolean sameTable = false;
    private static final String SELECT_FIELDS = "account.masterid account, currency currencyfor, debitfor, creditfor, endfor, debitlocal, creditlocal";
    private static final String ACCOUNT_TO = "accountto";
    private static final String ACCOUNT_FOR = "accountfor";
    private static final String SUM = "sum";

    public DataSet query(ReportQueryParam queryParam, Object arg1) throws Throwable {
        FilterInfo filterInfo = queryParam.getFilter();
        this.intiParam(filterInfo);
        DataSet oldBalanceSet = this.queryBalance(queryParam, true);
        DataSet newBalanceSet = this.queryBalance(queryParam, false);
        return this.buildAccountRefRst(oldBalanceSet, newBalanceSet);
    }

    private void intiParam(FilterInfo filterInfo) {
        QFilter mappingTypeFilter;
        QFilter goalFilter;
        QFilter srcFilter;
        QFilter enableFilter;
        this.qParam = new MulOrgQPRpt(filterInfo, "gl_balance_compare");
        QFilter amFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountmapping", (Long)filterInfo.getLong("org"));
        Map accountMappingMap = BusinessDataServiceHelper.loadFromCache((String)"bd_accountmapping", (String)"srcacttable,goalacttable,goalacttable.masterid,mappinginfoentry,mappinginfoentry.srcact,mappinginfoentry.goalact,mappinginfoentry.goalact.accounttable", (QFilter[])new QFilter[]{amFilter, enableFilter = new QFilter("enable", "=", (Object)true), srcFilter = new QFilter("srcacttable", "=", (Object)filterInfo.getLong("accounttable")), goalFilter = new QFilter("goalacttable.fbasedataid_id", "=", (Object)filterInfo.getLong("toaccounttable")), mappingTypeFilter = new QFilter("mappingtype", "=", (Object)MappingTypeEnum.PRIMARY_SECONDARY.getValue())});
        if (null != accountMappingMap && accountMappingMap.size() != 0) {
            for (Map.Entry entry : accountMappingMap.entrySet()) {
                for (DynamicObject source : ((DynamicObject)entry.getValue()).getDynamicObjectCollection("mappinginfoentry")) {
                    if (source.getLong("goalact.accounttable.id") != filterInfo.getLong("toaccounttable")) continue;
                    this.sourceToTargetAcc.put(source.getLong("srcact.masterid"), source.getLong("goalact.masterid"));
                }
            }
        } else if (filterInfo.getLong("accounttable") == filterInfo.getLong("toaccounttable")) {
            this.sameTable = true;
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u79d1\u76ee\u5bf9\u7167\u5173\u7cfb\u3002", (String)"AccountCompareBalanceRptPlugin_1", (String)"fi-gl-report", (Object[])new Object[0]));
        }
    }

    private DataSet queryBalance(ReportQueryParam queryParam, boolean isQueryOldBal) {
        FilterInfo filterInfo = queryParam.getFilter();
        QueryParam param = new QueryParam();
        long booktype = 0L;
        String currencyId = filterInfo.getString("currency");
        if (!"basecurrency".equals(currencyId) && !"allcurrency".equals(currencyId)) {
            param.setCurrencyIds(new Long[]{Long.valueOf(currencyId)});
        }
        param.setOnlyLeafAcctBal(true);
        Long acctTblId = 0L;
        Long periodId = filterInfo.getLong("startperiod");
        ArrayList<Long> accounts = new ArrayList<Long>(16);
        DynamicObjectCollection accountcoll = filterInfo.getDynamicObjectCollection("account");
        if (accountcoll != null) {
            for (DynamicObject account : accountcoll) {
                accounts.add(account.getLong("id"));
            }
        }
        DataSet dSet = null;
        if (isQueryOldBal) {
            acctTblId = filterInfo.getLong("accounttable");
            booktype = filterInfo.getLong("booktype");
            if (accounts.size() != 0) {
                param.setAccountFilter(new QFilter("id", "in", accounts));
            }
            dSet = BalanceQueryExecutor.getInstance().getBalance(SELECT_FIELDS, this.qParam.getFilteredChildOrg().toArray(new Long[0]), booktype, acctTblId.longValue(), periodId.longValue(), periodId.longValue(), param);
        } else {
            acctTblId = filterInfo.getLong("toaccounttable");
            booktype = filterInfo.getLong("tobooktype");
            if (accounts.size() != 0 && this.sameTable) {
                param.setAccountFilter(new QFilter("id", "in", accounts));
            } else if (accounts.size() != 0 && this.sourceToTargetAcc.size() != 0) {
                ArrayList<Long> accountTos = new ArrayList<Long>(accounts.size());
                for (Long account : accounts) {
                    accountTos.add(this.sourceToTargetAcc.get(account));
                }
                param.setAccountFilter(new QFilter("id", "in", accountTos));
            }
            dSet = BalanceQueryExecutor.getInstance().getBalance(SELECT_FIELDS, new Long[]{filterInfo.getLong("toorg")}, booktype, acctTblId.longValue(), periodId.longValue(), periodId.longValue(), param);
        }
        List list = GLUtil.getDataSetCols((DataSet)dSet);
        list.remove("debitfor");
        list.remove("creditfor");
        if (isQueryOldBal) {
            list.remove("endfor");
            list.add("case when endfor>0 then endfor else 0.0 end as debitendfor");
            list.add("case when endfor>0 then 0.0 else -1*endfor end as creditendfor");
            list.add("debitfor debitcurfor");
            list.add("creditfor creditcurfor");
        } else {
            list.remove("account");
            list.add("account accountto");
            list.remove("currencyfor");
            list.add("currencyfor currencyto");
            list.remove("endfor");
            list.add("case when endfor>0 then endfor else 0.0 end as debitendto");
            list.add("case when endfor>0 then 0.0 else -1*endfor end as creditendto");
            list.add("debitfor debitcurto");
            list.add("creditfor creditcurto");
        }
        return dSet.select(list.toArray(new String[0]));
    }

    private DataSet buildAccountRefRst(DataSet oldBalanceSet, DataSet newBalanceSet) {
        DataSet resultSet;
        DataSet accountCompareSet = this.getAccountCompareSet();
        List balCols = GLUtil.getDataSetCols((DataSet)oldBalanceSet);
        balCols.remove("account");
        if (accountCompareSet != null) {
            ArrayList<String> compareCols = new ArrayList<String>(8);
            compareCols.add(ACCOUNT_TO);
            compareCols.add(ACCOUNT_FOR);
            JoinDataSet oJoinDataSet = oldBalanceSet.join(accountCompareSet, JoinType.INNER).on("account", ACCOUNT_FOR);
            resultSet = oJoinDataSet.select(balCols.toArray(new String[0]), compareCols.toArray(new String[0])).finish();
        } else {
            balCols.add("account accountto");
            balCols.add("account accountfor");
            resultSet = oldBalanceSet.select(balCols.toArray(new String[0]));
        }
        DataSet sumSet = this.sumOldBalByRef(resultSet);
        resultSet = this.joinNewBalanceSet(newBalanceSet, resultSet);
        return this.diffBalanceSet(resultSet, sumSet);
    }

    private DataSet getAccountCompareSet() {
        RowMeta meta = new RowMeta(new String[]{ACCOUNT_FOR, ACCOUNT_TO}, new DataType[]{DataType.LongType, DataType.LongType});
        ArrayList<Object[]> datas = new ArrayList<Object[]>(1024);
        if (this.sourceToTargetAcc.size() == 0) {
            return null;
        }
        for (Map.Entry<Long, Long> entrys : this.sourceToTargetAcc.entrySet()) {
            datas.add(new Object[]{entrys.getKey(), entrys.getValue()});
        }
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(datas.iterator(), meta);
    }

    private DataSet sumOldBalByRef(DataSet resultSet) {
        ArrayList<String> groupFields = new ArrayList<String>(8);
        groupFields.add(ACCOUNT_TO);
        groupFields.add("currencyfor");
        DataSet sumSet = MulOrgQPRpt.gainSumSet((DataSet)resultSet.copy(), (String[])groupFields.toArray(new String[0]), (String[])new String[]{"debitcurfor", "creditcurfor", "debitendfor", "creditendfor"});
        List cols = GLUtil.getDataSetCols((DataSet)sumSet);
        cols.remove("debitcurfor");
        cols.add("debitcurfor debitcurforsum");
        cols.remove("creditcurfor");
        cols.add("creditcurfor creditcurforsum");
        cols.remove("debitendfor");
        cols.add("debitendfor debitendforsum");
        cols.remove("creditendfor");
        cols.add("creditendfor creditendforsum");
        return sumSet.select(cols.toArray(new String[0]));
    }

    private DataSet joinNewBalanceSet(DataSet newBalanceSet, DataSet resultSet) {
        List leftCols = GLUtil.getDataSetCols((DataSet)resultSet);
        leftCols.remove(ACCOUNT_TO);
        leftCols.add("accountto accounttoleft");
        ArrayList<String> rightCols = new ArrayList<String>(8);
        rightCols.add("debitcurto");
        rightCols.add("creditcurto");
        rightCols.add("debitendto");
        rightCols.add("creditendto");
        rightCols.add("accountto accounttoright");
        rightCols.add("currencyto");
        JoinDataSet nJoinDataSet = resultSet.join(newBalanceSet, JoinType.FULL).on(ACCOUNT_TO, ACCOUNT_TO).on("currencyfor", "currencyto");
        DataSet rstSet = nJoinDataSet.select(leftCols.toArray(new String[0]), rightCols.toArray(new String[0])).finish();
        List rstCols = GLUtil.getDataSetCols((DataSet)rstSet);
        this.replaceNullCol(rstCols, "debitcurto");
        this.replaceNullCol(rstCols, "creditcurto");
        this.replaceNullCol(rstCols, "debitendto");
        this.replaceNullCol(rstCols, "creditendto");
        this.replaceNullCol(rstCols, "debitcurfor");
        this.replaceNullCol(rstCols, "creditcurfor");
        this.replaceNullCol(rstCols, "debitendfor");
        this.replaceNullCol(rstCols, "creditendfor");
        rstCols.remove("accounttoleft");
        rstCols.remove("accounttoright");
        rstCols.add("case when accounttoright is null then accounttoleft else accounttoright end as accountto");
        rstCols.remove("currencyfor");
        rstCols.remove("currencyto");
        rstCols.add("case when currencyfor is null then currencyto else currencyfor end as currencyfor");
        return rstSet.select(rstCols.toArray(new String[0]));
    }

    private void replaceNullCol(List<String> rstCols, String field) {
        rstCols.remove(field);
        rstCols.add(String.format("case when %s is null then 0 else %s end %s", field, field, field));
    }

    private DataSet diffBalanceSet(DataSet resultSet, DataSet sumSet) {
        List cols = GLUtil.getDataSetCols((DataSet)resultSet);
        ArrayList leftCols = new ArrayList(cols.size());
        leftCols.addAll(cols);
        cols.add(String.format("(%s-%s)-(%s-%s) %s", "debitcurto", "creditcurto", "debitcurforsum", "creditcurforsum", "debitdiffcur"));
        cols.add(String.format("(%s-%s)-(%s-%s) %s", "debitendto", "creditendto", "debitendforsum", "creditendforsum", "debitdiffend"));
        JoinDataSet rJoinDataSet = resultSet.join(sumSet, JoinType.LEFT).on(ACCOUNT_TO, ACCOUNT_TO).on("currencyfor", "currencyfor");
        ArrayList<String> rightCol = new ArrayList<String>(4);
        rightCol.add("debitcurforsum");
        rightCol.add("creditcurforsum");
        rightCol.add("debitendforsum");
        rightCol.add("creditendforsum");
        DataSet rstSet = rJoinDataSet.select(leftCols.toArray(new String[0]), rightCol.toArray(new String[0])).finish();
        List rstCols = GLUtil.getDataSetCols((DataSet)rstSet);
        this.replaceNullCol(rstCols, "debitcurforsum");
        this.replaceNullCol(rstCols, "creditcurforsum");
        this.replaceNullCol(rstCols, "debitendforsum");
        this.replaceNullCol(rstCols, "creditendforsum");
        rstSet = rstSet.select(rstCols.toArray(new String[0]));
        rstSet = rstSet.select(cols.toArray(new String[0]));
        List rstCols2 = GLUtil.getDataSetCols((DataSet)rstSet);
        rstCols2.remove("debitdiffend");
        rstCols2.remove("creditdiffend");
        rstCols2.add("case when debitdiffend>0 then debitdiffend else 0.0 end as debitdiffend");
        rstCols2.add("case when debitdiffend>0 then 0.0 else -1*debitdiffend end as creditdiffend");
        return rstSet.select(rstCols2.toArray(new String[0]));
    }
}

