/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.report.ReportHelper;
import kd.fi.gl.util.GLUtil;

public class AdjustVoucherQueryRpt
extends AbstractReportListDataPlugin {
    private DynamicObjectCollection accts;
    private DynamicObject org;
    private DynamicObject booktype;
    private DynamicObject startPeriod;
    private DynamicObject endPeriod;
    private long basecunrreyId = 0L;
    private boolean showassist;
    private String currencyVal;
    private LocalCurrencyConfigVO mulCurConfig;
    private static final String adjusttypesql = "case when accountdc = '1' and afterlocal-beforelocal>0 then '-1' when accountdc = '-1' and afterlocal-beforelocal<0 then '-1' else '1' end";
    private static final String[] selField = new String[]{"vid", "accountid", "name", "assgrp", "endfor", "datefield", "vouchernumber", "forcur", "beforelocal", "adjustrate", "accounttype", "accountdc", "pltype", "feid"};

    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        try {
            this.init(param);
            DataSet voucher = this.getAdjustVoucher();
            ArrayList<Long> voucherIds = new ArrayList<Long>();
            for (Row row : voucher.copy()) {
                voucherIds.add(row.getLong("vid"));
            }
            DataSet adjustlog = this.getAdjustLog(voucherIds);
            DataSet result = voucher.join(adjustlog, JoinType.INNER).on("vid", "voucherid").on("accountid", "account").on("assgrp", "assgrp").on("forcur", "currency").select(selField).finish().addField("endfor*adjustrate", "afterlocal").addField(adjusttypesql, "adjusttype").addField("afterlocal-beforelocal", "adjustamount");
            if (!this.showassist) {
                result = result.groupBy(new String[]{"vid", "datefield", "vouchernumber", "adjustrate", "forcur", "accountid", "name", "adjusttype", "feid"}).sum("endfor").sum("beforelocal").sum("afterlocal").sum("adjustamount").finish();
            }
            result = result.addField("" + this.basecunrreyId, "basecurrency").addField("case when endfor==0 then 0 else beforelocal/endfor end", "beforeadjustrate");
            Iterator iterator = result.copy().iterator();
            BigDecimal totalGet = new BigDecimal(0);
            BigDecimal totalLoss = new BigDecimal(0);
            String id = RequestContext.get().getRequestId();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String adjusttype = row.getString("adjusttype");
                if (adjusttype.equals("1")) {
                    totalLoss = totalLoss.add(row.getBigDecimal("adjustamount").abs());
                }
                if (!adjusttype.equals("-1")) continue;
                totalGet = totalGet.add(row.getBigDecimal("adjustamount").abs());
            }
            BigDecimal total = totalGet.subtract(totalLoss);
            new DistributeCache(CacheModule.report).put(String.format("%s_%s", "AdjustVoucherRptFormPlugin_total_revenue", id), totalGet.toString());
            new DistributeCache(CacheModule.report).put(String.format("%s_%s", "AdjustVoucherRptFormPlugin_total_loss", id), totalLoss.toString());
            new DistributeCache(CacheModule.report).put(String.format("%s_%s", "AdjustVoucherRptFormPlugin_total", id), total.toString());
            Field[] fields = result.getRowMeta().getFields();
            boolean isShowOrgField = Arrays.stream(fields).anyMatch(x -> x.getAlias().equals("org") || x.getAlias().equals("orgid"));
            if (isShowOrgField) {
                result = result.addField("org", "flexorgid");
            } else {
                FilterInfo filterInfo = param.getFilter();
                long orgId = filterInfo.getLong("org");
                result = result.addField(String.valueOf(orgId), "flexorgid");
            }
            return result;
        }
        catch (Exception e) {
            throw new KDBizException(GLUtil.printError((Throwable)e));
        }
    }

    private void init(ReportQueryParam param) {
        FilterInfo filterInfo = param.getFilter();
        this.accts = filterInfo.getDynamicObjectCollection("account");
        this.org = filterInfo.getDynamicObject("org");
        this.booktype = filterInfo.getDynamicObject("booktype");
        if (this.org != null && this.booktype != null) {
            AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)this.org.getLong("id"), (long)this.booktype.getLong("id"));
            this.basecunrreyId = bookInfo.getBaseCurrencyId();
            String mulCurChoose = filterInfo.getString("mulcur");
            Collection configs = LocalCurrencyConfigService.queryEnableCurrencies((long)this.org.getLong("id"), (long)this.booktype.getLong("id"));
            Optional<LocalCurrencyConfigVO> first = configs.stream().filter(configVO -> configVO.getNumber().equals(mulCurChoose)).findFirst();
            first.ifPresent(configVO -> {
                this.mulCurConfig = (LocalCurrencyConfigVO)first.get();
            });
            if (this.mulCurConfig != null) {
                this.basecunrreyId = this.mulCurConfig.getCurrencyId(bookInfo.getOrgId(), bookInfo.getBookTypeId());
            }
        }
        this.startPeriod = filterInfo.getDynamicObject("startperiod");
        this.endPeriod = filterInfo.getDynamicObject("endperiod");
        this.showassist = filterInfo.getBoolean("showassist");
        this.currencyVal = filterInfo.getString("currency");
    }

    private DataSet getAdjustVoucher() {
        String accountNameField = GLUtil.getAcctNameBySysParam((Long)((Long)this.org.getPkValue()));
        String localRateField = this.mulCurConfig == null ? "localrate" : this.mulCurConfig.getVoucherField(MCT.EX_RATE).getMetaId();
        String selectedField = "id vid,billno vouchernumber,bookeddate datefield, entries.seq feid, entries.account.id accountid," + String.format("entries.account.%s name,", accountNameField) + "entries.assgrp assgrp,entries.currency forcur,entries.debitori,entries.creditori,entries." + localRateField + " adjustrate,entries.account.pltype pltype,entries.account.dc accountdc,entries.account.accounttype.accounttype accounttype";
        String orderbys = "";
        DataSet result = VoucherQueryUtils.queryDataSet((String)selectedField, (QFilter[])this.getQFilters(), (String)orderbys, (int)-1);
        return result;
    }

    private QFilter[] getQFilters() {
        List acctMasterIds;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org", "=", this.org.getPkValue()));
        qFilters.add(new QFilter("booktype", "=", this.booktype.getPkValue()));
        qFilters.add(new QFilter("period", ">=", this.startPeriod.getPkValue()).and(new QFilter("period", "<=", this.endPeriod.getPkValue())));
        qFilters.add(new QFilter("sourcetype", "=", (Object)"2"));
        String localDebitField = "debitlocal";
        String localCreditField = "creditlocal";
        if (this.mulCurConfig != null) {
            localDebitField = this.mulCurConfig.getVoucherField(MCT.DEBIT).getMetaId();
            localCreditField = this.mulCurConfig.getVoucherField(MCT.CREDIT).getMetaId();
        }
        qFilters.add(new QFilter("entries." + localDebitField, "!=", (Object)BigDecimal.ZERO).or(new QFilter("entries." + localCreditField, "!=", (Object)BigDecimal.ZERO)));
        QFilter accountFilter = new QFilter("entries.account.ischangecurrency", "=", (Object)"1");
        if (this.accts != null && !(acctMasterIds = GLUtil.getIdsFromDynCollection((DynamicObjectCollection)this.accts, (String)"masterid")).isEmpty()) {
            accountFilter = accountFilter.and(new QFilter("entries.account.masterid", "in", (Object)acctMasterIds));
        }
        if (this.currencyVal != null && !"basecurrency".equals(this.currencyVal) && !"allcurrency".equals(this.currencyVal)) {
            QFilter fcurrency = new QFilter("entries.currency", "=", (Object)Long.parseLong(this.currencyVal));
            accountFilter = accountFilter == null ? fcurrency : accountFilter.and(fcurrency);
        }
        qFilters.add(accountFilter);
        String[] fBillStatus = "B,C".split(",");
        qFilters.add(new QFilter("billstatus", "in", (Object)fBillStatus));
        if (this.mulCurConfig != null) {
            QFilter mulCurFilter = new QFilter(this.mulCurConfig.getVoucherField(MCT.CURRENCY).getMetaId(), "=", (Object)this.mulCurConfig.getCurrencyId(this.org.getLong("id"), this.booktype.getLong("id")));
            qFilters.add(mulCurFilter);
        }
        return qFilters.toArray(new QFilter[0]);
    }

    private DataSet getAdjustLog(List<Long> voucherIds) {
        String selectedField = "voucherid,account,assgrp,currency,endfor,endlocal beforelocal";
        QFilter fid = new QFilter("voucherid", "in", voucherIds);
        if (this.mulCurConfig != null) {
            fid.and(new QFilter("tarmulcur", "=", (Object)this.mulCurConfig.getNumber()));
        } else {
            fid.and(new QFilter("tarmulcur", "=", (Object)" "));
        }
        DataSet result = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_adjustratelog", (String)selectedField, (QFilter[])new QFilter[]{fid}, null);
        return result;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ReportColumn assrpColumn = (ReportColumn)columns.get(2);
        if (this.showassist) {
            assrpColumn.setHide(false);
        }
        columns.add((AbstractReportColumn)ReportHelper.createFlexOrgidColumn());
        return super.getColumns(columns);
    }
}

