/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.fi.gl.report.QueryParamRpt;

public final class GeneralLedgerHelperRpt {
    private static final String CURRENCY_NAME = "currencyname";
    private static final String ENDLOCAL = "endlocal";
    private static final String CREDITLOCAL = "creditlocal";
    private static final String DEBITLOCAL = "debitlocal";
    private static final String ENDFOR = "endfor";
    private static final String DIRECTION = "direction";
    private static final String ENDQTY = "endqty";
    private static final String CREDITFOR = "creditfor";
    private static final String CREDITQTY = "creditqty";
    private static final String DEBITFOR = "debitfor";
    private static final String DEBITQTY = "debitqty";
    private static final String CURRENCYID = "currencyid";
    private static final String CURRENCYLOCALID = "currencylocalid";
    private static final String DESCRIPTION = "description";
    private static final String PERIOD = "period";
    private static final String MEASUREUNIT_NAME = "measureunitname";
    private static final String MEASUREUNIT_ID = "measureunit";

    private GeneralLedgerHelperRpt() {
    }

    private static LocaleString getCurrency() {
        return new LocaleString(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"GeneralLedgerHelperRpt_0", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getPeriod() {
        return new LocaleString(ResManager.loadKDString((String)"\u671f\u95f4", (String)"GeneralLedgerHelperRpt_1", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getDescription() {
        return new LocaleString(ResManager.loadKDString((String)"\u6458\u8981", (String)"GeneralLedgerHelperRpt_2", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getMeasureUnitName() {
        return new LocaleString(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"GeneralLedgerHelperRpt_3", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getDebit() {
        return new LocaleString(ResManager.loadKDString((String)"\u501f\u65b9", (String)"GeneralLedgerHelperRpt_4", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getCredit() {
        return new LocaleString(ResManager.loadKDString((String)"\u8d37\u65b9", (String)"GeneralLedgerHelperRpt_5", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getBalance() {
        return new LocaleString(ResManager.loadKDString((String)"\u4f59\u989d", (String)"GeneralLedgerHelperRpt_6", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getQty() {
        return new LocaleString(ResManager.loadKDString((String)"\u6570\u91cf", (String)"GeneralLedgerHelperRpt_7", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getCurrencyFor() {
        return new LocaleString(ResManager.loadKDString((String)"\u539f\u5e01", (String)"GeneralLedgerHelperRpt_8", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getCurrencyLocal() {
        return new LocaleString(ResManager.loadKDString((String)"\u672c\u4f4d\u5e01", (String)"GeneralLedgerHelperRpt_9", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getMoney() {
        return new LocaleString(ResManager.loadKDString((String)"\u91d1\u989d", (String)"GeneralLedgerHelperRpt_10", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    private static LocaleString getDirection() {
        return new LocaleString(ResManager.loadKDString((String)"\u65b9\u5411", (String)"GeneralLedgerHelperRpt_11", (String)"fi-gl-report", (Object[])new Object[0]));
    }

    public static void addColumns(List<AbstractReportColumn> columns, QueryParamRpt param) {
        ReportColumnGroup debitGroup;
        ReportColumn accountNumber = (ReportColumn)columns.get(0);
        accountNumber.setHyperlink(true);
        ArrayList<Object> list = new ArrayList<Object>(20);
        ReportColumn currency = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getCurrency(), CURRENCYID, "basedata");
        currency.setEntityId("bd_currency");
        currency.setHide(true);
        list.add(currency);
        if (param.isAllCurrency()) {
            ReportColumn currencyname = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getCurrency(), CURRENCY_NAME, "text");
            currencyname.setHyperlink(true);
            list.add(currencyname);
        }
        ReportColumn period = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getPeriod(), PERIOD, "basedata");
        list.add(period);
        ReportColumn description = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getDescription(), DESCRIPTION, "text");
        list.add(description);
        if (param.isShowQty()) {
            ReportColumn measureunitname = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getMeasureUnitName(), MEASUREUNIT_NAME, "text");
            list.add(measureunitname);
        }
        if (param.isShowQty()) {
            if (param.getCurrency() == param.getCurLocal() || param.isSynCurrency()) {
                debitGroup = new ReportColumnGroup();
                debitGroup.setCaption(GeneralLedgerHelperRpt.getDebit());
                GeneralLedgerHelperRpt.setGroupFieldKey(debitGroup, "debitGroup");
                ReportColumn debitQty = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getQty(), DEBITQTY, "qty");
                debitGroup.getChildren().add(debitQty);
                ReportColumn debitLocal = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getMoney(), DEBITLOCAL, "amount");
                debitGroup.getChildren().add(debitLocal);
                list.add(debitGroup);
                ReportColumnGroup creditGroup = new ReportColumnGroup();
                creditGroup.setCaption(GeneralLedgerHelperRpt.getCredit());
                GeneralLedgerHelperRpt.setGroupFieldKey(creditGroup, "creditGroup");
                ReportColumn creditQty = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getQty(), CREDITQTY, "qty");
                creditGroup.getChildren().add(creditQty);
                ReportColumn creditLocal = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getMoney(), CREDITLOCAL, "amount");
                creditGroup.getChildren().add(creditLocal);
                list.add(creditGroup);
                ReportColumnGroup balanceGroup = new ReportColumnGroup();
                balanceGroup.setCaption(GeneralLedgerHelperRpt.getBalance());
                GeneralLedgerHelperRpt.setGroupFieldKey(balanceGroup, "balanceGroup");
                ReportColumn balanceQty = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getQty(), ENDQTY, "qty");
                balanceGroup.getChildren().add(balanceQty);
                ReportColumn balanceDirect = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getDirection(), DIRECTION, "text");
                ReportColumn balanceLocal = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getMoney(), ENDLOCAL, "amount");
                balanceGroup.getChildren().add(balanceDirect);
                balanceGroup.getChildren().add(balanceLocal);
                list.add(balanceGroup);
            } else {
                debitGroup = new ReportColumnGroup();
                debitGroup.setCaption(GeneralLedgerHelperRpt.getDebit());
                GeneralLedgerHelperRpt.setGroupFieldKey(debitGroup, "debitGroup");
                ReportColumn debitQty = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getQty(), DEBITQTY, "qty");
                debitGroup.getChildren().add(debitQty);
                ReportColumn debitFor = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getCurrencyFor(), DEBITFOR, "amount");
                debitGroup.getChildren().add(debitFor);
                ReportColumn debitLocal = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getCurrencyLocal(), DEBITLOCAL, "amount");
                debitGroup.getChildren().add(debitLocal);
                list.add(debitGroup);
                ReportColumnGroup creditGroup = new ReportColumnGroup();
                creditGroup.setCaption(GeneralLedgerHelperRpt.getCredit());
                GeneralLedgerHelperRpt.setGroupFieldKey(creditGroup, "creditGroup");
                ReportColumn creditQty = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getQty(), CREDITQTY, "qty");
                creditGroup.getChildren().add(creditQty);
                ReportColumn creditFor = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getCurrencyFor(), CREDITFOR, "amount");
                creditGroup.getChildren().add(creditFor);
                ReportColumn creditLocal = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getCurrencyLocal(), CREDITLOCAL, "amount");
                creditGroup.getChildren().add(creditLocal);
                list.add(creditGroup);
                ReportColumnGroup balanceGroup = new ReportColumnGroup();
                balanceGroup.setCaption(GeneralLedgerHelperRpt.getBalance());
                GeneralLedgerHelperRpt.setGroupFieldKey(balanceGroup, "balanceGroup");
                ReportColumn balanceQty = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getQty(), ENDQTY, "qty");
                balanceGroup.getChildren().add(balanceQty);
                ReportColumn balanceDirect = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getDirection(), DIRECTION, "text");
                ReportColumn balanceFor = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getCurrencyFor(), ENDFOR, "amount");
                balanceGroup.getChildren().add(balanceDirect);
                balanceGroup.getChildren().add(balanceFor);
                ReportColumn balanceLocal = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getCurrencyLocal(), ENDLOCAL, "amount");
                balanceGroup.getChildren().add(balanceLocal);
                list.add(balanceGroup);
            }
        } else if (param.getCurrency() == param.getCurLocal() || param.isSynCurrency()) {
            ReportColumn debitLocal = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getDebit(), DEBITLOCAL, "amount");
            list.add(debitLocal);
            ReportColumn creditLocal = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getCredit(), CREDITLOCAL, "amount");
            list.add(creditLocal);
            ReportColumnGroup balanceGroup = new ReportColumnGroup();
            balanceGroup.setCaption(GeneralLedgerHelperRpt.getBalance());
            GeneralLedgerHelperRpt.setGroupFieldKey(balanceGroup, "balanceGroup");
            ReportColumn balanceDirect = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getDirection(), DIRECTION, "text");
            ReportColumn balanceLocal = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getMoney(), ENDLOCAL, "amount");
            balanceGroup.getChildren().add(balanceDirect);
            balanceGroup.getChildren().add(balanceLocal);
            list.add(balanceGroup);
        } else {
            debitGroup = new ReportColumnGroup();
            debitGroup.setCaption(GeneralLedgerHelperRpt.getDebit());
            GeneralLedgerHelperRpt.setGroupFieldKey(debitGroup, "debitGroup");
            ReportColumn debitFor = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getCurrencyFor(), DEBITFOR, "amount");
            debitGroup.getChildren().add(debitFor);
            ReportColumn debitLocal = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getCurrencyLocal(), DEBITLOCAL, "amount");
            debitGroup.getChildren().add(debitLocal);
            list.add(debitGroup);
            ReportColumnGroup creditGroup = new ReportColumnGroup();
            creditGroup.setCaption(GeneralLedgerHelperRpt.getCredit());
            GeneralLedgerHelperRpt.setGroupFieldKey(creditGroup, "creditGroup");
            ReportColumn creditFor = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getCurrencyFor(), CREDITFOR, "amount");
            creditGroup.getChildren().add(creditFor);
            ReportColumn creditLocal = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getCurrencyLocal(), CREDITLOCAL, "amount");
            creditGroup.getChildren().add(creditLocal);
            list.add(creditGroup);
            ReportColumnGroup balanceGroup = new ReportColumnGroup();
            balanceGroup.setCaption(GeneralLedgerHelperRpt.getBalance());
            GeneralLedgerHelperRpt.setGroupFieldKey(balanceGroup, "balanceGroup");
            ReportColumn balanceDirect = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getDirection(), DIRECTION, "text");
            ReportColumn balanceFor = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getCurrencyFor(), ENDFOR, "amount");
            balanceGroup.getChildren().add(balanceDirect);
            balanceGroup.getChildren().add(balanceFor);
            ReportColumn balanceLocal = GeneralLedgerHelperRpt.createColumn(GeneralLedgerHelperRpt.getCurrencyLocal(), ENDLOCAL, "amount");
            balanceGroup.getChildren().add(balanceLocal);
            list.add(balanceGroup);
        }
        columns.addAll(list);
    }

    private static void setGroupFieldKey(ReportColumnGroup group, String key) {
        group.setFieldKey(key);
    }

    private static ReportColumn createColumn(LocaleString caption, String fieldKey, String fieldType) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setFieldType(fieldType);
        if ("amount".equals(fieldType)) {
            if (fieldKey.endsWith("local")) {
                column.setCurrencyField(CURRENCYLOCALID);
            } else {
                column.setCurrencyField(CURRENCYID);
            }
        } else if ("qty".equals(fieldType)) {
            column.setMeasureUnitField(MEASUREUNIT_ID);
        }
        return column;
    }
}

