/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.extplugin.PluginProxy;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.gl.report.rowtype.RptRowTypeValue;
import kd.sdk.fi.gl.extpoint.report.IReportRowHideSpi;
import kd.sdk.fi.gl.extpoint.report.ReportParam;
import kd.sdk.fi.gl.extpoint.report.RowType;

public class ReportDsExtProcessHelper {
    public static DataSet doExtProcess(ReportQueryParam queryParam, DataSet result, String entityId) {
        String hasExtProxy = (String)queryParam.getCustomParam().get("hasExtProxy");
        if (StringUtils.isEmpty((String)hasExtProxy)) {
            PluginProxy proxy = PluginProxy.create(IReportRowHideSpi.class, (String)"kd.sdk.fi.gl.extpoint.report.IReportRowHideSpi.needHide");
            hasExtProxy = CollectionUtils.isEmpty((Collection)proxy.getPlugins()) ? "false" : "true";
            queryParam.getCustomParam().put("hasExtProxy", hasExtProxy);
        }
        if (Objects.equals(hasExtProxy, "false")) {
            return result;
        }
        PluginProxy extProxy = PluginProxy.create(IReportRowHideSpi.class, (String)"kd.sdk.fi.gl.extpoint.report.IReportRowHideSpi.needHide");
        ReportParam.ReportType reportType = ReportParam.ReportType.of((String)entityId);
        if (reportType != ReportParam.ReportType.UNSUPPORTED) {
            ReportParam reportParam = new ReportParam(reportType, queryParam);
            final HashSet hideRowTypeValues = new HashSet();
            final RptRowTypeValue rptRowTypeValue = RptRowTypeValue.getInstance((ReportParam.ReportType)reportType);
            for (RowType rowType : RowType.values()) {
                String valueOfType = rptRowTypeValue.getValueOfType(rowType);
                if (valueOfType.equals("-1")) continue;
                extProxy.callReplace(processor -> processor.needHide(reportParam, rowType)).stream().filter(x -> x).findAny().ifPresent(x -> hideRowTypeValues.add(valueOfType));
            }
            if (!hideRowTypeValues.isEmpty()) {
                FilterFunction f = new FilterFunction(){

                    public boolean test(Row row) {
                        return !hideRowTypeValues.contains(row.getString(rptRowTypeValue.getRowTypeField()));
                    }
                };
                if (result.getRowMeta().getFieldIndex(rptRowTypeValue.getRowTypeField(), false) != -1) {
                    result = result.filter(f);
                }
            }
        }
        return result;
    }
}

