/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.acaccountcheck;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.model.Context;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.dataset.GroupKey;
import kd.fi.gl.report.ACAccountCheckRightQueryRptOld;
import kd.fi.gl.report.common.DataSchema;
import kd.fi.gl.report.common.RptUtil;
import kd.fi.gl.report.subsidiary.DetailQuery;
import kd.fi.gl.util.GLUtil;

public class ACAccountCheckDetailQuery
implements DetailQuery<Object> {
    private Context context;
    private int detailSize = -1;
    private int detailLimit;
    private static final Log logger = LogFactory.getLog(ACAccountCheckDetailQuery.class);

    @Override
    public DataSet query(ReportQueryParam param, Object obj, Context context) {
        this.context = context;
        return obj != null ? this.query(param, obj) : GLUtil.getEmptyDS(this.getClass());
    }

    private DataSet query(ReportQueryParam param, Object obj) {
        logger.info("=====ACAccountCheckDetailQuery_qurey_param=====");
        ACAccountCheckRightQueryRptOld rightQueryRpt = new ACAccountCheckRightQueryRptOld(param, obj, this.context);
        DataSet result = rightQueryRpt.query();
        this.detailLimit = rightQueryRpt.voucherDisplayLimit;
        this.detailSize = rightQueryRpt.getDetailSize();
        boolean needRemoveTotalRow = this.detailSize > this.detailLimit && !rightQueryRpt.isExport() && BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.report.acaccountcheck.enableasynctotalcal", (boolean)true);
        this.context.registerContext("totalRowRemoved", (Object)needRemoveTotalRow);
        if (needRemoveTotalRow) {
            Row curBeginRow = null;
            Row vchBeginRow = null;
            Row yearRow = null;
            int i = 0;
            int lastVchRowIndex = -1;
            int lastBeginRowIndex = -1;
            int prePeriodRowIndex = -1;
            for (Row row2 : result.copy()) {
                if ("1".equals(row2.getString("rowtype")) || "3".equals(row2.getString("rowtype"))) {
                    curBeginRow = row2;
                    prePeriodRowIndex = i;
                }
                if ("2".equals(row2.getString("rowtype"))) {
                    lastVchRowIndex = i;
                    vchBeginRow = curBeginRow;
                    lastBeginRowIndex = prePeriodRowIndex;
                }
                ++i;
            }
            yearRow = result.copy().limit(lastVchRowIndex + 1, Integer.MAX_VALUE).filter("rowtype = 4").next();
            assert (yearRow != null);
            String[] groupby = new String[]{"currencycolumn"};
            String sumByStr = "debitfor,creditfor,debitlocal,creditlocal";
            DataSchema sumSchema = DataSchema.getDataSchema(groupby, sumByStr.split(","), result.getRowMeta());
            DataSet lastDimensionVchsDS = result.copy().limit(lastBeginRowIndex + 1, Integer.MAX_VALUE).filter("rowtype = 2");
            lastDimensionVchsDS.forEachRemaining(row -> sumSchema.outPutData(((AbstractRow)row).persist().values()));
            Map<GroupKey, Object[]> vchSumGroups = sumSchema.getData();
            assert (vchSumGroups.size() == 1);
            Object[] vchSumValues = vchSumGroups.entrySet().iterator().next().getValue();
            Object[] yearValues = ((AbstractRow)yearRow).values();
            yearValues = this.sub(sumSchema.getSumIndex(), yearValues, vchSumValues);
            RowMeta rowMeta = result.getRowMeta();
            DataSetBuilder builder = Algo.create((String)(this.getClass().getSimpleName() + "#resultBuild")).createDataSetBuilder(rowMeta);
            builder.append(vchBeginRow);
            builder.append(yearValues);
            CacheHint cacheHint = new CacheHint();
            cacheHint.setTimeout(28800L, TimeUnit.SECONDS);
            this.context.registerContext("beginAndYearCacheID", (Object)builder.build().cache(cacheHint).getCacheId());
            this.context.registerContext("acarowMeta", (Object)SerializationUtils.serializeToBase64((Object)rowMeta));
            result = result.limit(0, lastVchRowIndex + 1);
        }
        return result;
    }

    @Override
    public int getDetailLimit() {
        return this.detailLimit;
    }

    @Override
    public int getDetailDsSize() {
        return this.detailSize;
    }

    public Object[] sub(int[] absIndex, Object[] oldValue, Object[] newValue) {
        for (int index : absIndex) {
            oldValue[index] = RptUtil.subtract(oldValue[index], newValue[index]);
        }
        return oldValue;
    }
}

