/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.acaccountcheck;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.fi.gl.report.common.OutPutIndex;

public class ACAccountCheckOutPutIndex
implements OutPutIndex {
    private int rowTypeIndex;
    private int currencyIndex;
    private int[] debitIndexes;
    private int[] creditIndexes;
    private int[] endIndexes;
    private int periodIndex;
    private int[] grpIndexes;
    private List<String> orderIndexes;
    private String types;
    private RowMeta rowMeta;
    private int descIndex;

    public ACAccountCheckOutPutIndex(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.types = this.initTypes();
        this.initIndexes();
    }

    private void initIndexes() {
        this.rowTypeIndex = this.rowMeta.getFieldIndex("rowtype");
        this.currencyIndex = this.rowMeta.getFieldIndex("currencycolumn", false);
        this.debitIndexes = this.setIndexes("debit");
        this.creditIndexes = this.setIndexes("credit");
        this.endIndexes = this.setIndexes("end");
        this.periodIndex = this.rowMeta.getFieldIndex("period");
        this.descIndex = this.rowMeta.getFieldIndex("desc");
    }

    private String initTypes() {
        StringBuilder sb = new StringBuilder();
        sb.append("local");
        sb.append(",for");
        return sb.toString();
    }

    private int[] setIndexes(String flag) {
        ArrayList<Integer> list = new ArrayList<Integer>(8);
        for (String field : this.merge(flag)) {
            list.add(this.rowMeta.getFieldIndex(field));
        }
        return list.stream().mapToInt(x -> x).toArray();
    }

    private String[] merge(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String pre : prefix.split(",")) {
            for (String suf : this.types.split(",")) {
                list.add(pre + suf);
            }
        }
        return list.toArray(new String[0]);
    }

    public int getRowTypeIndex() {
        return this.rowTypeIndex;
    }

    @Override
    public int getCurrencyIndex() {
        return this.currencyIndex;
    }

    @Override
    public int[] getDebitIndexes() {
        return this.debitIndexes;
    }

    @Override
    public int[] getCreditIndexes() {
        return this.creditIndexes;
    }

    public int[] getEndIndexesArr() {
        return this.endIndexes;
    }

    public int getPeriodIndex() {
        return this.periodIndex;
    }

    public String getTypes() {
        return this.types;
    }

    public int[] getGrpIndexes() {
        return this.grpIndexes;
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public void setGrpIndexes(int[] grpIndexes) {
        this.grpIndexes = grpIndexes;
    }

    public List<String> getOrderIndexes() {
        return this.orderIndexes;
    }

    public void setOrderIndexes(List<String> orderIndexes) {
        this.orderIndexes = orderIndexes;
    }

    public int getDescIndex() {
        return this.descIndex;
    }
}

