/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.acaccountcheck;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.SettableArrayRow;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.model.Context;
import kd.fi.bd.model.schema.property.Prop;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.gl.model.schema.VoucherSchema;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.report.acaccountcheck.ACAccountCheckOutPutIndex;
import kd.fi.gl.report.common.RptUtil;
import kd.fi.gl.report.subsidiary.TotalQuery;
import kd.fi.gl.util.FlexUtils;
import org.apache.commons.lang3.tuple.Triple;

public class ACAccountTotalQuery
implements TotalQuery<Object> {
    private static final Log logger = LogFactory.getLog(ACAccountTotalQuery.class);

    @Override
    public DataSet query(ReportQueryParam queryParam, Object selectedObj, Context context) {
        int i;
        PerformanceWatch watch = new PerformanceWatch(ACAccountTotalQuery.class, "ACAccountTotalQuery_query", false);
        watch.start("SettableArrayRow");
        DataSet beginAndYearDS = Algo.getCacheDataSet((String)((String)context.query("beginAndYearCacheID"))).toDataSet(Algo.create((String)(this.getClass().getSimpleName() + "#rebuild")), false);
        RowMeta rowMeta = beginAndYearDS.getRowMeta();
        Row beginRow = beginAndYearDS.next();
        SettableArrayRow yearRow = new SettableArrayRow(rowMeta, ((AbstractRow)beginAndYearDS.next()).values(), false);
        SettableArrayRow periodRow = null;
        VoucherSchema schema = VoucherSchema.instance;
        List vchFilterArr = (List)SerializationUtils.deSerializeFromBase64((String)((String)context.query("voucherfilter")));
        Collection assistFilterEntries = ReciprocalUtils.buildAssistFilterInfo((FilterInfo)queryParam.getFilter(), (Object)selectedObj);
        Triple vchOrmInfo = FlexUtils.buildDynamicORMAssistOnVoucher((Collection)assistFilterEntries, (boolean)true);
        List<QFilter> vchFilters = vchFilterArr.stream().filter(qfilter -> qfilter != null && !qfilter.getProperty().contains(schema.period.toFullName())).collect(Collectors.toList());
        vchFilters.add(new QFilter("period", "=", yearRow.get(schema.period.toFullName())));
        boolean isbasecurrency = (Boolean)context.query("isbasecurrency");
        if (!isbasecurrency) {
            vchFilters.add(new QFilter("entries.currency", "=", yearRow.get("currencycolumn")));
        }
        watch.stop();
        watch.start("getVchSumRow");
        Row vchSum = this.getVchSumRow(vchFilters, (MainEntityType)vchOrmInfo.getLeft(), rowMeta);
        watch.stop();
        watch.start("copyFields");
        ACAccountCheckOutPutIndex outPutIndex = new ACAccountCheckOutPutIndex(rowMeta);
        periodRow = new SettableArrayRow(rowMeta);
        System.arraycopy(yearRow.values(), 0, periodRow.values(), 0, rowMeta.getFieldCount());
        periodRow.setValue(outPutIndex.getRowTypeIndex(), (Object)"3");
        periodRow.setValue(outPutIndex.getDescIndex(), (Object)ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"GeneralLedgerQueryRpt_1", (String)"fi-gl-report", (Object[])new Object[0]));
        int[] creditIndexes = outPutIndex.getCreditIndexes();
        int[] debitIndexes = outPutIndex.getDebitIndexes();
        int[] endIndexes = outPutIndex.getEndIndexesArr();
        this.copyFields(vchSum, creditIndexes, periodRow, creditIndexes);
        this.copyFields(vchSum, debitIndexes, periodRow, debitIndexes);
        for (i = 0; i < endIndexes.length; ++i) {
            BigDecimal vchSumEnd = (BigDecimal)RptUtil.subtract(periodRow.get(debitIndexes[i]), periodRow.get(creditIndexes[i]));
            periodRow.setValue(endIndexes[i], RptUtil.sum(beginRow.getBigDecimal(endIndexes[i]), vchSumEnd));
        }
        for (i = 0; i < debitIndexes.length; ++i) {
            yearRow.setValue(debitIndexes[i], RptUtil.sum(yearRow.getBigDecimal(debitIndexes[i]), periodRow.getBigDecimal(debitIndexes[i])));
            yearRow.setValue(creditIndexes[i], RptUtil.sum(yearRow.getBigDecimal(creditIndexes[i]), periodRow.getBigDecimal(creditIndexes[i])));
        }
        this.copyFields((Row)periodRow, outPutIndex.getEndIndexesArr(), yearRow, outPutIndex.getEndIndexesArr());
        DataSetBuilder resultBuilder = Algo.create((String)(this.getClass().getSimpleName() + "#resultBuild")).createDataSetBuilder(rowMeta);
        resultBuilder.append((Row)periodRow);
        resultBuilder.append((Row)yearRow);
        watch.stop();
        String show = watch.show();
        logger.info("=====ACAccountTotalQuery_query_show:{}=====", (Object)show);
        return resultBuilder.build();
    }

    @Override
    public DataSet query(ReportQueryParam queryParam, Object selectedObj, DataSet detailDS, Context context) {
        return Algo.create((String)(this.getClass().getName() + "#emptyDs ")).createDataSet(Collections.emptyIterator(), detailDS.getRowMeta());
    }

    private Row getVchSumRow(List<QFilter> vchFilters, MainEntityType mainEntityType, RowMeta rowMeta) {
        VoucherSchema schema = VoucherSchema.instance;
        ORM orm = ORM.create();
        orm.setDataEntityType("gl_voucher", (IDataEntityType)mainEntityType);
        DataSet vouchers = orm.queryDataSet(ACAccountTotalQuery.class.getName(), "gl_voucher", Prop.toSelectFieldStr((Prop[])new Prop[]{schema.debitLocal, schema.creditLocal, schema.creditOri, schema.debitOri, schema.qty, schema.dc}), vchFilters.toArray(new QFilter[0]), null, -1);
        DataSet vchSum = vouchers.addField("case when entries.entrydc='-1' then entries.quantity else 0 end", "creditQty").addField("case when entries.entrydc='1' then entries.quantity else 0 end", "debitQty").select(new String[]{schema.debitLocal.toFullName(), schema.creditLocal.toFullName(), schema.creditOri.toFullName(), schema.debitOri.toFullName(), "creditQty", "debitQty"}).groupBy().sum(schema.debitLocal.toFullName()).sum(schema.creditLocal.toFullName()).sum(schema.creditOri.toFullName()).sum(schema.debitOri.toFullName()).sum("creditQty").sum("debitQty").finish();
        assert (vchSum.hasNext());
        Row vchSumRow = vchSum.next();
        SettableArrayRow row = new SettableArrayRow(rowMeta);
        this.setIfExist(row, rowMeta, "creditlocal", vchSumRow.getBigDecimal(schema.creditLocal.toFullName()));
        this.setIfExist(row, rowMeta, "creditfor", vchSumRow.getBigDecimal(schema.creditOri.toFullName()));
        this.setIfExist(row, rowMeta, "creditqty", vchSumRow.getBigDecimal("creditQty"));
        this.setIfExist(row, rowMeta, "debitlocal", vchSumRow.getBigDecimal(schema.debitLocal.toFullName()));
        this.setIfExist(row, rowMeta, "debitfor", vchSumRow.getBigDecimal(schema.debitOri.toFullName()));
        this.setIfExist(row, rowMeta, "debitqty", vchSumRow.getBigDecimal("debitQty"));
        return row;
    }

    private void setIfExist(SettableArrayRow row, RowMeta rowMeta, String field, BigDecimal value) {
        int fieldIndex = rowMeta.getFieldIndex(field, false);
        if (fieldIndex != -1) {
            row.setValue(fieldIndex, (Object)value);
        }
    }

    private void copyFields(Row src, int[] srcIndexes, SettableArrayRow dst, int[] dstIndexes) {
        for (int i = 0; i < dstIndexes.length; ++i) {
            dst.setValue(dstIndexes[i], src.get(srcIndexes[i]));
        }
    }
}

