/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.accbalance.AccBalBalFunction;
import kd.fi.gl.report.accbalance.AccBalInitBalSelector;
import kd.fi.gl.report.accbalance.AccBalOutPutIndex;
import kd.fi.gl.report.accbalance.AccBalReportQuery;
import kd.fi.gl.report.common.ICollector;
import kd.fi.gl.report.common.OutPutFunction;
import kd.fi.gl.report.common.RptUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.vo.RateBean;

public class AccBalInitBalFunction
implements OutPutFunction {
    private AccBalInitBalSelector selector;
    private AccBalOutPutIndex opIndex;
    private Map<Long, RateBean> orgRateMap;
    private long startPeriod;
    private long endPeriod;
    private Set<Long> periods;
    private boolean isShowPeriod;
    private Map<Long, Long> orgStartPeriodMap;
    private MulOrgQPRpt qpRpt;
    private Map<Long, Long> orgAccMap;

    public AccBalInitBalFunction(AccBalInitBalSelector selector) {
        this.selector = selector;
        AccBalReportQuery reportQuery = selector.getReportQuery();
        this.opIndex = reportQuery.getOutPutIndex();
        this.qpRpt = reportQuery.getQueryParam();
        this.orgRateMap = this.qpRpt.getRateMap();
        this.startPeriod = this.qpRpt.getStartPeriod();
        this.endPeriod = this.qpRpt.getEndPeriod();
        this.orgAccMap = this.getOrgProfitAccMap();
        this.periods = this.qpRpt.getPeriods();
        this.isShowPeriod = this.qpRpt.isShowPeriod();
        this.orgStartPeriodMap = this.qpRpt.getOrgStartPeriodMap();
    }

    private Map<Long, Long> getOrgProfitAccMap() {
        Set<Object> masteridSet = this.selector.getReportQuery().getMasterIdMap().keySet();
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        Set filteredChildOrg = this.qpRpt.getFilteredChildOrg();
        try (DataSet ds = BatchProcessUtil.batchQueryDataSet((Collection)filteredChildOrg, splitOrgList -> {
            QFilter[] filters = new QFilter[]{new QFilter("org", "in", splitOrgList)};
            return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_transplprogram", (String)"org,yearprofitacct.masterid masterid", (QFilter[])filters, (String)"billno");
        });){
            for (Row d : ds) {
                long masterid = d.getLong("masterid");
                result.putIfAbsent(d.getLong("org"), masterid);
            }
        }
        result = result.entrySet().stream().filter(x -> masteridSet.contains(x.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return result;
    }

    @Override
    public void output(Row row, ICollector collector) {
        if (this.isShowPeriod) {
            long orgStartPeriod = this.orgStartPeriodMap.get(row.getLong(this.selector.getOrgIndex()));
            ArrayList results = new ArrayList(16);
            for (Long selectPeriod : this.periods) {
                if (selectPeriod < orgStartPeriod) continue;
                List<Object[]> tmpList = this.output(row, orgStartPeriod, selectPeriod);
                tmpList.stream().forEach(obj -> {
                    Object[] result = this.copyObject((Object[])obj);
                    result[this.opIndex.getPeriodIndex()] = selectPeriod;
                    results.add(result);
                });
            }
            results.stream().forEach(obj -> collector.collect((Object[])obj));
        } else {
            List<Object[]> results = this.output(row, this.startPeriod, this.endPeriod);
            results.stream().forEach(obj -> collector.collect((Object[])obj));
        }
    }

    public List<Object[]> output(Row row, long startPeriod, long endPeriod) {
        ArrayList<Object[]> results = new ArrayList<Object[]>(2);
        Object[] result = new Object[this.opIndex.getFieldCount()];
        int[] groupIndexes = this.selector.getGroupIndexes();
        int[] opGrpIndexes = this.opIndex.getGroupIndexes();
        for (int i = 0; i < opGrpIndexes.length; ++i) {
            result[opGrpIndexes[i]] = row.get(groupIndexes[i]);
        }
        result[this.opIndex.getAccountIndex()] = row.getLong(this.selector.getAccountIndex());
        int countIndex = this.opIndex.getCountIndex();
        if (countIndex != -1) {
            result[countIndex] = 0;
        }
        int[] opYearDebitIndexes = this.opIndex.getYearDebitIndexes();
        int[] opYearCreditIndexes = this.opIndex.getYearCreditIndexes();
        int[] beginDebitIndexes = this.opIndex.getBeginDebitIndexes();
        int[] endDebitIndexes = this.opIndex.getEndDebitIndexes();
        int[] yearProfitDebitIndexes = this.selector.getYearProfitDebitIndexes();
        int[] yearProfitCreditIndexes = this.selector.getYearProfitCreditIndexes();
        int[] yearDebitIndexes = this.selector.getYearDebitIndexes();
        int[] yearCreditIndexes = this.selector.getYearCreditIndexes();
        int length = opYearCreditIndexes.length;
        for (int i = 0; i < length; ++i) {
            BigDecimal debitVal = row.getBigDecimal(yearProfitDebitIndexes[i]).subtract(row.getBigDecimal(yearDebitIndexes[i]));
            BigDecimal creditVal = row.getBigDecimal(yearProfitCreditIndexes[i]).subtract(row.getBigDecimal(yearCreditIndexes[i]));
            if (startPeriod / GLUtil.YEAR_PERIOD_L == endPeriod / GLUtil.YEAR_PERIOD_L) {
                result[opYearDebitIndexes[i]] = debitVal;
                result[opYearCreditIndexes[i]] = creditVal;
            }
            result[beginDebitIndexes[i]] = RptUtil.subtract(debitVal, creditVal);
            result[endDebitIndexes[i]] = result[beginDebitIndexes[i]];
        }
        int[] opYearBDebitIndexes = this.opIndex.getYearBDebitIndexes();
        for (int i = 0; i < length; ++i) {
            Object year = RptUtil.subtract(result[opYearDebitIndexes[i]], result[opYearCreditIndexes[i]]);
            result[opYearBDebitIndexes[i]] = RptUtil.subtract(result[endDebitIndexes[i]], year);
        }
        Map<Integer, Integer> rptLocalIndexMap = this.opIndex.getRptLocalIndexMap();
        int orgIndex = this.selector.getOrgIndex();
        AccBalBalFunction.setRptAmount(row, result, rptLocalIndexMap, this.orgRateMap, orgIndex);
        results.add(result);
        Long org = row.getLong(orgIndex);
        Long profitAcc = this.orgAccMap.get(org);
        if (profitAcc != null && profitAcc != 0L) {
            Set<Integer> rptIdxs = rptLocalIndexMap.keySet();
            List ints = Arrays.asList(opYearDebitIndexes, opYearCreditIndexes, beginDebitIndexes, endDebitIndexes, opYearBDebitIndexes);
            List<Integer> idxList = ints.stream().flatMap(x -> Arrays.stream(x).boxed()).collect(Collectors.toList());
            idxList.addAll(rptIdxs);
            Object[] reverse = this.copyReverse(result, idxList);
            for (int i = 0; i < length; ++i) {
                reverse[opYearDebitIndexes[i]] = result[opYearCreditIndexes[i]];
                reverse[opYearCreditIndexes[i]] = result[opYearDebitIndexes[i]];
            }
            reverse[this.opIndex.getAccountIndex()] = profitAcc;
            results.add(reverse);
        }
        return results;
    }

    private Object[] copyObject(Object[] original) {
        Object[] copy = new Object[original.length];
        System.arraycopy(original, 0, copy, 0, original.length);
        return copy;
    }

    private Object[] copyReverse(Object[] source, List<Integer> idxList) {
        Object[] result = new Object[source.length];
        for (int i = 0; i < source.length; ++i) {
            result[i] = idxList.contains(i) ? RptUtil.subtract(BigDecimal.ZERO, source[i]) : source[i];
        }
        return result;
    }
}

