/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.model.Context;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.service.balance.account.IAccountTreeModel;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.dataset.TreeNode;
import kd.fi.gl.report.AccBalanceHelper;
import kd.fi.gl.report.CurType;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.OrgType;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.ReportHelper;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.accbalance.export.AccBalAccountQuery;
import kd.fi.gl.report.accbalance.export.AccBalRowTransformer;
import kd.fi.gl.report.accbalance.export.BalanceSumService;
import kd.fi.gl.report.assistbalance.export.AssistBalConverter;
import kd.fi.gl.report.export.ExportOption;
import kd.fi.gl.report.export.convert.IDatasetRowTypeConverter;
import kd.fi.gl.report.export.processor.BatchProcessorChain;
import kd.fi.gl.report.export.processor.IBatchTransformer;
import kd.fi.gl.report.export.processor.ReportExcelTransformer;
import kd.fi.gl.util.DataSetHelper;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MulCurReportUtil;

public class AccBalReportExporter {
    private static final Log logger = LogFactory.getLog(AccBalReportExporter.class);
    private MulOrgQPRpt qpRpt;
    private AccBalAccountQuery accBalQuery;
    private BatchProcessorChain<Row, Void> chain;
    private IAccountTreeModel accountModel;
    private AccBalanceHelper accBalanceHelper;
    private boolean exportAssist;
    private Map<Long, Boolean> preAccountLeafMap = new HashMap<Long, Boolean>(64);
    private Map<Long, Long> orgProfitAccMap;
    private static String BALANCE_AMOUNT_FIELD = "yearbdebit,yearbcredit,begindebit,begincredit,debit,credit,enddebit,endcredit,yeardebit,yearcredit";
    private static String INITBALANCE_AMOUNT_FIELD = "yearprofitdebit#,yearprofitcredit#,yeardebit#,yearcredit#";

    public AccBalReportExporter() {
    }

    public AccBalReportExporter(ReportQueryParam reportQueryParam, ReportList reportList, ExportOption exportOption, boolean exportAssist) {
        this.exportAssist = exportAssist;
        this.qpRpt = new MulOrgQPRpt(reportQueryParam.getFilter(), "gl_rpt_accountbalance");
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)this.qpRpt.getEndPeriod(), (String)"bd_period");
        Date endDate = period.getDate("enddate");
        this.qpRpt.setEndDate(endDate);
        if (exportAssist) {
            this.qpRpt.setShowLeafAccount(true);
        } else {
            this.qpRpt.setShowAssist(false);
        }
        this.accBalQuery = new AccBalAccountQuery((QueryParamRpt)this.qpRpt);
        this.accBalanceHelper = new AccBalanceHelper(this.qpRpt);
        this.chain = new BatchProcessorChain.Builder(exportOption, null, (IBatchTransformer)new AccBalRowTransformer(2000)).appendLast((IBatchTransformer)new ReportExcelTransformer(reportList, 2000)).build();
        this.chain.registerContext("qParam", (Object)this.qpRpt);
        AssistBalConverter balRowConverter = new AssistBalConverter();
        this.chain.setDatasetRowTypeConverter((IDatasetRowTypeConverter)balRowConverter);
        this.orgProfitAccMap = this.getOrgProfitAccMap();
    }

    private void initAccountModel(Set<Long> masterIdSet) {
        Long[] orgIds = this.qpRpt.getFilteredChildOrg().toArray(new Long[0]);
        QueryParam param = new QueryParam();
        param.setAccountFilter(new QFilter("id", "in", masterIdSet));
        this.accountModel = IAccountTreeModel.getInstance((Long[])orgIds, (long)this.qpRpt.getAccountTable(), (long)this.qpRpt.getEndPeriod(), (QueryParam)param);
    }

    public Context exportAccountBal() {
        long tick = System.currentTimeMillis();
        try {
            long singleTick;
            QFilter idQFilter;
            int batch = 0;
            LinkedHashSet<Long> batchAcctMasterIdSet = new LinkedHashSet<Long>(8);
            HashSet<Long> selectedAccIdSet = new HashSet<Long>(this.accBalQuery.getIdMap().keySet());
            String preAccountNumber = "";
            if (this.exportAssist) {
                idQFilter = new QFilter("id", "in", selectedAccIdSet);
                QFilter leafQfilter = new QFilter("isleaf", "=", (Object)true);
                idQFilter.and(leafQfilter);
                DataSet accountDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accountview", (String)"id,isleaf,number", (QFilter[])idQFilter.toArray(), (String)"number");
                if (DebugTrace.enable()) {
                    DataSetHelper.logDataSet((String)"accountbal_exportall accountDataSet", (DataSet)accountDataSet);
                }
                while (accountDataSet.hasNext()) {
                    Row row = accountDataSet.next();
                    String accountNumber = row.getString("number");
                    singleTick = System.currentTimeMillis();
                    batchAcctMasterIdSet.add(row.getLong("id"));
                    this.preAccountLeafMap.put(row.getLong("id"), row.getBoolean("isleaf"));
                    this.qpRpt.setMasterIdSet(batchAcctMasterIdSet);
                    DataSet batchDataSet = this.getBatchBalanceDataSet();
                    this.chain.getProcessors().forEach(processor -> processor.reset());
                    RowMeta cachedRowMeta = (RowMeta)this.chain.getContextProp("rowMeta");
                    if (Objects.isNull(cachedRowMeta)) {
                        this.chain.registerRowMeta(batchDataSet.getRowMeta());
                    }
                    this.chain.feed((Iterator)batchDataSet);
                    logger.info("accountbal_exportall batch{},batchSize:{},account top number:{},cost:{}ms", new Object[]{++batch, batchAcctMasterIdSet.size(), accountNumber, System.currentTimeMillis() - singleTick});
                    batchAcctMasterIdSet.clear();
                    this.preAccountLeafMap.clear();
                }
            } else {
                idQFilter = new QFilter("id", "in", selectedAccIdSet);
                DataSet accountDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accountview", (String)"id,isleaf,longnumber", (QFilter[])idQFilter.toArray(), (String)"longnumber");
                if (DebugTrace.enable()) {
                    DataSetHelper.logDataSet((String)"accountbal_exportall accountDataSet", (DataSet)accountDataSet);
                }
                while (accountDataSet.hasNext()) {
                    Row row = accountDataSet.next();
                    String accountNumber = row.getString("longnumber").split("_")[0];
                    if (StringUtils.isNotEmpty((CharSequence)preAccountNumber) && !accountNumber.startsWith(preAccountNumber)) {
                        singleTick = System.currentTimeMillis();
                        this.qpRpt.setMasterIdSet(batchAcctMasterIdSet);
                        DataSet batchDataSet = this.getBatchBalanceDataSet();
                        this.chain.getProcessors().forEach(processor -> processor.reset());
                        RowMeta cachedRowMeta = (RowMeta)this.chain.getContextProp("rowMeta");
                        if (Objects.isNull(cachedRowMeta)) {
                            this.chain.registerRowMeta(batchDataSet.getRowMeta());
                        }
                        this.chain.feed((Iterator)batchDataSet);
                        logger.info("accountbal_exportall batch{},batchSize:{},account top number:{},cost:{}ms", new Object[]{++batch, batchAcctMasterIdSet.size(), preAccountNumber, System.currentTimeMillis() - singleTick});
                        batchAcctMasterIdSet.clear();
                        this.preAccountLeafMap.clear();
                    }
                    batchAcctMasterIdSet.add(row.getLong("id"));
                    preAccountNumber = accountNumber;
                    this.preAccountLeafMap.put(row.getLong("id"), row.getBoolean("isleaf"));
                }
            }
            singleTick = System.currentTimeMillis();
            this.qpRpt.setMasterIdSet(batchAcctMasterIdSet);
            DataSet batchDataSet = this.getBatchBalanceDataSet();
            this.chain.setFinalDataSetFlag(true);
            this.chain.getProcessors().forEach(processor -> processor.reset());
            RowMeta cachedRowMeta = (RowMeta)this.chain.getContextProp("rowMeta");
            if (Objects.isNull(cachedRowMeta)) {
                this.chain.registerRowMeta(batchDataSet.getRowMeta());
            }
            this.chain.feed((Iterator)batchDataSet);
            logger.info("accountbal_exportall batch{},batchSize:{},account top number:{},cost:{}ms", new Object[]{++batch, batchAcctMasterIdSet.size(), preAccountNumber, System.currentTimeMillis() - singleTick});
            logger.info("accountbal_exportall total cost:{}ms", (Object)(System.currentTimeMillis() - tick));
            return this.chain.getContext();
        }
        catch (Throwable e) {
            logger.error(e);
            throw new KDBizException(e.getMessage());
        }
    }

    private DataSet getBatchBalanceDataSet() {
        if (CollectionUtils.isEmpty((Collection)this.qpRpt.getMasterIdSet())) {
            return GLUtil.getEmptyDS(this.getClass());
        }
        DataSet detailBalance = null;
        Set<Long> masterIdSet = this.qpRpt.getMasterIdSet();
        boolean singleQueryFlag = this.getSingleQueryFlag();
        if (singleQueryFlag) {
            HashSet<Long> tmpMasterIdSet = new HashSet<Long>(1);
            for (Long masterId : masterIdSet) {
                if (this.preAccountLeafMap.isEmpty() || !this.preAccountLeafMap.get(masterId).booleanValue()) continue;
                tmpMasterIdSet.add(masterId);
                this.initAccountModel(tmpMasterIdSet);
                detailBalance = Objects.isNull(detailBalance) ? this.getBalanceDataSet(tmpMasterIdSet) : detailBalance.union(this.getBalanceDataSet(tmpMasterIdSet));
                tmpMasterIdSet.clear();
            }
        } else {
            this.initAccountModel(this.preAccountLeafMap.keySet());
            masterIdSet = this.qpRpt.getMasterIdSet().stream().filter(x -> this.preAccountLeafMap.get(x)).collect(Collectors.toSet());
            detailBalance = this.getBalanceDataSet(masterIdSet);
        }
        detailBalance = this.groupBalance(detailBalance, this.exportAssist);
        detailBalance = this.appendSumDetailBalance(detailBalance);
        detailBalance = this.processUnusedAccount(detailBalance);
        detailBalance = this.calculateBalance(detailBalance);
        ArrayList<String> orderFields = new ArrayList<String>(8);
        orderFields.add("number");
        orderFields.add("account");
        if (this.qpRpt.isShowCurrency()) {
            orderFields.add("currency");
        }
        if (this.qpRpt.isShowOrg()) {
            orderFields.add("org");
        }
        if (this.qpRpt.isShowAssist() && this.exportAssist) {
            orderFields.add("assgrp");
        }
        if (this.qpRpt.isShowQty()) {
            orderFields.add("measureunit");
        }
        if (this.qpRpt.isShowComassist() && !this.qpRpt.getComAssistValsList().isEmpty()) {
            this.qpRpt.getComAssistValsList().stream().forEach(x -> orderFields.add((String)x.t1));
        }
        orderFields.add("rowtype");
        detailBalance = detailBalance.orderBy(orderFields.toArray(new String[0]));
        List fields = GLUtil.getDataSetCols((DataSet)detailBalance);
        DataSet totalBalance = this.calculateTotalDataSet(detailBalance);
        totalBalance = totalBalance.select(fields.toArray(fields.toArray(new String[0])));
        if (this.qpRpt.isShowQty() && !this.qpRpt.isShowAssist() && !this.qpRpt.isShowComassist()) {
            detailBalance = detailBalance.filter("isqty = true or rowtype <> 4");
        }
        if (this.exportAssist) {
            detailBalance = detailBalance.filter(this.buildAssistDetailFilterStr());
        }
        detailBalance = detailBalance.union(totalBalance);
        if (this.qpRpt.isShowComassist() && !this.qpRpt.getComAssistValsList().isEmpty()) {
            for (Tuple2 tuple : this.qpRpt.getComAssistValsList()) {
                fields.remove(tuple.t1);
                fields.add("case when isleaf=true then " + (String)tuple.t1 + " else 0 end as " + (String)tuple.t1 + "id");
            }
        }
        detailBalance = detailBalance.select(fields.toArray(fields.toArray(new String[0])));
        detailBalance = this.accBalanceHelper.addOtherFields(detailBalance);
        return detailBalance;
    }

    public String buildAssistDetailFilterStr() {
        StringBuilder filterBuilder = new StringBuilder("isassist = true or rowtype <> 4");
        if (this.qpRpt.isShowComassist() && !this.qpRpt.getComAssistValsList().isEmpty()) {
            List comAssistValsList = this.qpRpt.getComAssistValsList();
            for (int i = 0; i < comAssistValsList.size(); ++i) {
                filterBuilder.append(" or ");
                filterBuilder.append((String)((Tuple2)comAssistValsList.get((int)i)).t1);
                filterBuilder.append(" <> 0");
            }
        }
        if (this.qpRpt.isShowQty()) {
            filterBuilder.append(" or measureunit <> 0");
        }
        return filterBuilder.toString();
    }

    private DataSet appendSumDetailBalance(DataSet detailBalance) {
        boolean sumOrigiCur = CurType.FOREIGN == this.qpRpt.getCurType();
        boolean sumLocalCur = OrgType.VIRTUAL_M != this.qpRpt.getOrgType();
        ArrayList<String> groups = new ArrayList<String>(8);
        List<String> sums = this.getSumFields(detailBalance);
        sums.removeIf(x -> x.endsWith("qty"));
        DataSet orgDataSet = null;
        if (this.qpRpt.isShowOrg() && (this.qpRpt.isShowQty() || this.qpRpt.isShowComassist() || this.qpRpt.isShowAssist())) {
            groups.clear();
            groups.add("account");
            if (this.qpRpt.isShowCurrency()) {
                groups.add("currency");
            }
            groups.add("org");
            orgDataSet = MulOrgQPRpt.gainSumSet((DataSet)detailBalance, (String[])groups.toArray(new String[0]), (String[])sums.toArray(new String[0]));
            orgDataSet = orgDataSet.addField("3", "rowtype");
        }
        DataSet currencyDataSet = null;
        if (this.qpRpt.isShowCurrency() && (this.qpRpt.isShowOrg() || this.qpRpt.isShowQty() || this.qpRpt.isShowComassist() || this.qpRpt.isShowAssist())) {
            groups.clear();
            groups.add("account");
            groups.add("currency");
            if (!sumLocalCur) {
                sums.removeIf(x -> x.endsWith("local"));
            }
            currencyDataSet = MulOrgQPRpt.gainSumSet((DataSet)detailBalance, (String[])groups.toArray(new String[0]), (String[])sums.toArray(new String[0]));
            currencyDataSet = currencyDataSet.addField("2", "rowtype");
        }
        DataSet accountDataSet = null;
        if (this.qpRpt.isShowCurrency() || this.qpRpt.isShowOrg() || this.qpRpt.isShowQty() || this.qpRpt.isShowComassist() || this.qpRpt.isShowAssist()) {
            groups.clear();
            groups.add("account");
            if (!sumOrigiCur) {
                sums.removeIf(x -> x.endsWith("for"));
            }
            if (!sumLocalCur) {
                sums.removeIf(x -> x.endsWith("local"));
            }
            accountDataSet = MulOrgQPRpt.gainSumSet((DataSet)detailBalance, (String[])groups.toArray(new String[0]), (String[])sums.toArray(new String[0]));
            accountDataSet = accountDataSet.addField("1", "rowtype");
        }
        detailBalance = detailBalance.addField("4", "rowtype");
        if (Objects.nonNull(orgDataSet)) {
            detailBalance = detailBalance.union(orgDataSet);
        }
        if (Objects.nonNull(currencyDataSet)) {
            detailBalance = detailBalance.union(currencyDataSet);
        }
        if (Objects.nonNull(accountDataSet)) {
            detailBalance = detailBalance.union(accountDataSet);
        }
        return detailBalance;
    }

    private DataSet processUnusedAccount(DataSet detailBalance) {
        if (this.exportAssist) {
            return detailBalance;
        }
        if (!(this.qpRpt.isNoZeroAmount() || this.qpRpt.isNoZeroBalance() || this.qpRpt.isNoZeroYearBal() || this.qpRpt.isShowLeafAccount() || this.qpRpt.isHideUnused())) {
            HashSet<Long> masterIdSet = new HashSet<Long>(16);
            QFilter accountIdQFilter = new QFilter("id", "in", this.preAccountLeafMap.keySet());
            if (this.qpRpt.isShowLeafAccount()) {
                accountIdQFilter.and(new QFilter("isleaf", "=", (Object)true));
            } else {
                accountIdQFilter.and(new QFilter("level", "<=", (Object)this.qpRpt.getAccountLevel()));
            }
            try (DataSet accountDataSet = QueryServiceHelper.queryDataSet((String)AccBalReportExporter.class.getName(), (String)"bd_accountview", (String)"id,longnumber,level", (QFilter[])accountIdQFilter.toArray(), (String)"longnumber");){
                if (DebugTrace.enable()) {
                    DataSetHelper.logDataSet((String)"accountbal_exportall generate empty row base account", (DataSet)accountDataSet);
                }
                while (accountDataSet.hasNext()) {
                    Row row = accountDataSet.next();
                    masterIdSet.add(row.getLong("id"));
                }
            }
            HashSet<Long> balanceAccountSet = new HashSet<Long>(64);
            DataSet detailBlanceCopy = detailBalance.copy();
            while (detailBlanceCopy.hasNext()) {
                balanceAccountSet.add(detailBlanceCopy.next().getLong("account"));
            }
            masterIdSet.removeAll(balanceAccountSet);
            if (!CollectionUtils.isEmpty(masterIdSet)) {
                return this.generateEmptyDataSet(detailBalance, masterIdSet);
            }
        }
        return detailBalance;
    }

    private DataSet generateEmptyDataSet(DataSet detailBalance, Set<Long> masterIdSet) {
        ArrayList<Object[]> emptyRowValues = new ArrayList<Object[]>(masterIdSet.size() + 1);
        RowMeta rowMeta = detailBalance.getRowMeta();
        for (Long account : masterIdSet) {
            HashMap<String, Object> defaultValue = new HashMap<String, Object>(1);
            defaultValue.put("account", account);
            defaultValue.put("_tag_leaf", true);
            defaultValue.put("rowtype", "4");
            emptyRowValues.add(ReportHelper.gainEmptyRow(rowMeta, defaultValue));
        }
        DataSet emptyDetailBalance = Algo.create((String)this.getClass().getName()).createDataSet(emptyRowValues.iterator(), rowMeta);
        detailBalance = detailBalance.union(emptyDetailBalance);
        return detailBalance;
    }

    private DataSet groupBalance(DataSet balanceDataSet, Boolean exportAssist) {
        List<String> groups = this.getGroupFields(exportAssist);
        groups.add("_tag_leaf");
        List<String> sums = this.getSumFields(balanceDataSet);
        return MulOrgQPRpt.gainSumSet((DataSet)balanceDataSet, (String[])groups.toArray(new String[0]), (String[])sums.toArray(new String[0]));
    }

    private DataSet calculateTotalDataSet(DataSet detailBalance) {
        boolean sumOrigiCur = CurType.FOREIGN == this.qpRpt.getCurType();
        boolean sumLocalCur = OrgType.VIRTUAL_M != this.qpRpt.getOrgType();
        List<String> sums = this.getSumFields(detailBalance);
        if (!sumOrigiCur) {
            sums.removeIf(x -> x.endsWith("for"));
        }
        if (!sumLocalCur) {
            sums.removeIf(x -> x.endsWith("local"));
        }
        sums.removeIf(x -> x.endsWith("qty") || x.endsWith("price"));
        DataSet totalBalance = detailBalance.filter("_tag_leaf= true");
        totalBalance = MulOrgQPRpt.gainSumSet((DataSet)totalBalance, (String[])new String[0], (String[])sums.toArray(new String[0]));
        totalBalance = this.appendAccountInfo(totalBalance, true);
        return totalBalance;
    }

    private List<String> getGroupFields(boolean exportAssist) {
        ArrayList<String> groupFields = new ArrayList<String>(8);
        groupFields.add("account");
        if (this.qpRpt.isShowCurrency()) {
            groupFields.add("currency");
        }
        if (this.qpRpt.isShowOrg()) {
            groupFields.add("org");
        }
        if (this.qpRpt.isShowAssist() && exportAssist) {
            groupFields.add("assgrp");
        }
        if (this.qpRpt.isShowQty()) {
            groupFields.add("measureunit");
        }
        if (this.qpRpt.isShowComassist() && !this.qpRpt.getComAssistValsList().isEmpty()) {
            this.qpRpt.getComAssistValsList().stream().forEach(x -> groupFields.add((String)x.t1));
        }
        return groupFields;
    }

    private List<String> getSumFields(DataSet balanceDataSet) {
        Field[] fieldArr;
        ArrayList<String> sumFields = new ArrayList<String>(8);
        for (Field field : fieldArr = balanceDataSet.getRowMeta().getFields()) {
            String name = field.getName().toLowerCase();
            if (!(field.getDataType() instanceof BigDecimalType) && !"count".equalsIgnoreCase(name)) continue;
            sumFields.add(name);
        }
        return sumFields;
    }

    private DataSet calculateBalance(DataSet balanceDataSet) {
        balanceDataSet = this.appendAccountInfo(balanceDataSet, false);
        if (!(!this.qpRpt.isShowComassist() && !this.qpRpt.isShowAssist() || this.qpRpt.isShowQty() || this.qpRpt.isQueryCurrency() || this.qpRpt.isShowOrg())) {
            if (this.qpRpt.isShowComassist() && !this.qpRpt.getComAssistValsList().isEmpty() && this.qpRpt.isShowAssist()) {
                balanceDataSet = balanceDataSet.filter("isleaf = true or assgrp <> 0 or " + this.buildCommonAssistFilterStr());
            } else {
                if (this.qpRpt.isShowAssist()) {
                    balanceDataSet = balanceDataSet.filter("isleaf = true or assgrp <> 0");
                }
                if (this.qpRpt.isShowComassist() && !this.qpRpt.getComAssistValsList().isEmpty()) {
                    balanceDataSet = balanceDataSet.filter("isleaf = true or " + this.buildCommonAssistFilterStr());
                }
            }
        }
        List fields = GLUtil.getDataSetCols((DataSet)balanceDataSet);
        if (this.qpRpt.isQueryCurrency()) {
            fields.remove("beginfor");
            fields.remove("endfor");
        }
        if (this.qpRpt.isShowQty()) {
            fields.remove("beginqty");
            fields.remove("endqty");
        }
        fields.remove("beginlocal");
        fields.remove("endlocal");
        if (this.qpRpt.isShowDataByDC()) {
            if (this.qpRpt.isQueryCurrency()) {
                fields.add("case dc when '1' then endfor - yeardebitfor + yearcreditfor else 0.0 end as yearbdebitfor");
                fields.add("case dc when '1' then 0.0 else -1.0*(endfor - yeardebitfor + yearcreditfor) end as yearbcreditfor");
                fields.add("case dc when '1' then beginfor else 0.0 end as begindebitfor");
                fields.add("case dc when '1' then 0.0 else -1.0*beginfor end as begincreditfor");
                fields.add("case dc when '1' then endfor else 0.0 end as enddebitfor");
                fields.add("case dc when '1' then 0.0 else -1.0*endfor end as endcreditfor");
            }
            if (this.qpRpt.isShowQty()) {
                fields.add("case dc when '1' then endqty - yeardebitqty + yearcreditqty else 0.0 end as yearbdebitqty");
                fields.add("case dc when '1' then 0.0 else  -1.0*(endqty - yeardebitqty + yearcreditqty) end as yearbcreditqty");
                fields.add("case dc when '1' then beginqty else 0.0 end as begindebitqty");
                fields.add("case dc when '1' then 0.0 else -1.0*beginqty end as begincreditqty");
                fields.add("case dc when '1' then endqty else 0.0 end as enddebitqty");
                fields.add("case dc when '1' then 0.0 else -1.0*endqty end as endcreditqty");
            }
            if (this.qpRpt.isShowRpt()) {
                fields.add("case dc when '1' then endrpt - yeardebitrpt + yearcreditrpt else 0.0 end as yearbdebitrpt");
                fields.add("case dc when '1' then 0.0 else  -1.0*(endrpt - yeardebitrpt + yearcreditrpt) end as yearbcreditrpt");
                fields.add("case dc when '1' then beginrpt else 0.0 end as begindebitrpt");
                fields.add("case dc when '1' then 0.0 else -1.0*beginrpt end as begincreditrpt");
                fields.add("case dc when '1' then endrpt else 0.0 end as enddebitrpt");
                fields.add("case dc when '1' then 0.0 else -1.0*endrpt end as endcreditrpt");
            }
            fields.add("case dc when '1' then endlocal - yeardebitlocal + yearcreditlocal else 0.0 end as yearbdebitlocal");
            fields.add("case dc when '1' then 0.0 else -1.0*(endlocal - yeardebitlocal + yearcreditlocal) end as yearbcreditlocal");
            fields.add("case dc when '1' then beginlocal else 0.0 end as begindebitlocal");
            fields.add("case dc when '1' then 0.0 else -1.0*beginlocal end as begincreditlocal");
            fields.add("case dc when '1' then endlocal else 0.0 end as enddebitlocal");
            fields.add("case dc when '1' then 0.0 else -1.0*endlocal end as endcreditlocal");
        } else {
            if (this.qpRpt.isQueryCurrency()) {
                fields.add("case  when endfor - yeardebitfor + yearcreditfor > 0 then endfor - yeardebitfor + yearcreditfor else 0.0 end as yearbdebitfor");
                fields.add("case  when endfor - yeardebitfor + yearcreditfor < 0  then -1*(endfor - yeardebitfor + yearcreditfor) else 0.0 end as yearbcreditfor");
                fields.add("case when beginfor>0 then beginfor else 0.0 end as begindebitfor");
                fields.add("case when beginfor<0 then -1.0*beginfor else 0.0 end as begincreditfor");
                fields.add("case when endfor>0 then endfor else 0.0 end as enddebitfor");
                fields.add("case when endfor<0 then -1.0*endfor else 0.0 end as endcreditfor");
            }
            if (this.qpRpt.isShowQty()) {
                fields.add("case  when endqty - yeardebitqty + yearcreditqty > 0  then endqty - yeardebitqty + yearcreditqty else 0.0 end as yearbdebitqty");
                fields.add("case  when endqty - yeardebitqty + yearcreditqty < 0  then -1*(endqty - yeardebitqty + yearcreditqty) else 0.0 end as yearbcreditqty");
                fields.add("case when beginqty>0 then beginqty else 0.0 end as begindebitqty");
                fields.add("case when beginqty<0 then -1.0*beginqty else 0.0 end as begincreditqty");
                fields.add("case when endqty>0 then endqty else 0.0 end as enddebitqty");
                fields.add("case when endqty<0 then -1.0*endqty else 0.0 end as endcreditqty");
            }
            if (this.qpRpt.isShowRpt()) {
                fields.add("case  when endrpt - yeardebitrpt + yearcreditrpt > 0  then endrpt - yeardebitrpt + yearcreditrpt else 0.0 end as yearbdebitrpt");
                fields.add("case  when endrpt - yeardebitrpt + yearcreditrpt < 0  then -1*(endrpt - yeardebitrpt + yearcreditrpt) else 0.0 end as yearbcreditrpt");
                fields.add("case when beginrpt>0 then beginrpt else 0.0 end as begindebitrpt");
                fields.add("case when beginrpt<0 then -1.0*beginrpt else 0.0 end as begincreditrpt");
                fields.add("case when endrpt>0 then endrpt else 0.0 end as enddebitrpt");
                fields.add("case when endrpt<0 then -1.0*endrpt else 0.0 end as endcreditrpt");
            }
            fields.add("case  when endlocal - yeardebitlocal + yearcreditlocal > 0  then endlocal - yeardebitlocal + yearcreditlocal else 0.0 end as yearbdebitlocal");
            fields.add("case  when endlocal - yeardebitlocal + yearcreditlocal < 0  then -1.0*(endlocal - yeardebitlocal + yearcreditlocal) else 0.0 end as yearbcreditlocal");
            fields.add("case when beginlocal>0 then beginlocal else 0.0 end as begindebitlocal");
            fields.add("case when beginlocal<0 then -1.0*beginlocal else 0.0 end as begincreditlocal");
            fields.add("case when endlocal>0 then endlocal else 0.0 end as enddebitlocal");
            fields.add("case when endlocal<0 then -1.0*endlocal else 0.0 end as endcreditlocal");
        }
        balanceDataSet = balanceDataSet.select(fields.toArray(new String[0]));
        if (this.qpRpt.isShowQty() && this.qpRpt.isShowPrice()) {
            String[] fieldNames;
            fields = ReportUtils.getDataSetCols((DataSet)balanceDataSet);
            for (String fieldName : fieldNames = BALANCE_AMOUNT_FIELD.split(",")) {
                String casePrice = "";
                casePrice = this.qpRpt.isQueryCurrency() ? "case when " + fieldName + "for!=0 and " + fieldName + "qty!=0 then abs(" + fieldName + "for/" + fieldName + "qty) else 0 end as " + fieldName + "price" : "case when " + fieldName + "local!=0 and " + fieldName + "qty!=0 then abs(" + fieldName + "local/" + fieldName + "qty) else 0 end as " + fieldName + "price";
                fields.add(casePrice);
            }
            balanceDataSet = balanceDataSet.select(fields.toArray(new String[0]));
        }
        return balanceDataSet;
    }

    private DataSet getBalanceDataSet(Set<Long> masterIdSet) {
        QueryParam param = new QueryParam();
        if (!this.qpRpt.isSynCurrency() && !this.qpRpt.isAllCurrency()) {
            param.setCurrencyIds(new Long[]{this.qpRpt.getCurrency()});
        }
        QFilter accountFilter = new QFilter("id", "in", masterIdSet);
        param.setAccountFilter(accountFilter);
        if (this.qpRpt.isShowComassist()) {
            param.getCustomFilter().addAll(this.qpRpt.getComAssistFiltersForBal());
        }
        param.setOnlyLeafAcctBal(true);
        param.setAddAmountFilter(false);
        param.setSubstractPL(this.qpRpt.isSubstractPL());
        Long[] orgIds = this.qpRpt.getFilteredChildOrg().toArray(new Long[0]);
        ArrayList<String> selList = new ArrayList<String>(8);
        selList.add("account");
        selList.add("account.isleaf");
        if (this.qpRpt.isQueryCurrency()) {
            selList.add("currency");
        }
        if (this.qpRpt.isShowComassist() && !this.qpRpt.getComAssistValsList().isEmpty()) {
            this.qpRpt.getComAssistValsList().stream().forEach(x -> selList.add((String)x.t1));
        }
        selList.add("org");
        if (this.qpRpt.isShowAssist() && this.exportAssist) {
            selList.add("assgrp");
        }
        if (this.qpRpt.isShowQty()) {
            selList.add("measureunit");
        }
        selList.add("count");
        String amountField = "begin#,debit#,credit#,yeardebit#,yearcredit#,end#";
        String mulcur = this.qpRpt.getFilterInfo().getString("mulcur");
        MulCurReportUtil.addBalanceAmountFields(selList, (String)amountField, (String)mulcur);
        if (this.qpRpt.isQueryCurrency()) {
            Collections.addAll(selList, amountField.replace("#", "for").split(","));
        }
        if (this.qpRpt.isShowQty()) {
            Collections.addAll(selList, amountField.replace("#", "qty").split(","));
        }
        String selectFields = ((Object)selList).toString().replace("[", "").replace("]", "");
        DataSet originalBalance = BalanceQueryExecutor.getInstance().getBalance(selectFields, orgIds, this.qpRpt.getBookType(), this.qpRpt.getAccountTable(), this.qpRpt.getStartPeriod(), this.qpRpt.getEndPeriod(), param, this.accountModel);
        final RowMeta rowMeta = originalBalance.getRowMeta();
        final Map<Long, TreeNode> accIdMap = this.accBalQuery.getIdMap();
        if (this.qpRpt.getChildOrg().size() != 1 || this.qpRpt.getPorg() != ((Long)this.qpRpt.getChildOrg().iterator().next()).longValue()) {
            originalBalance = originalBalance.map(new MapFunction(){

                public Object[] map(Row row) {
                    int accountIndex;
                    Object[] data = ((AbstractRow)row).values();
                    Optional treeNode = AccBalReportExporter.this.getAccountTreeNode((Long)data[accountIndex = rowMeta.getFieldIndex("account")]);
                    long l = treeNode.isPresent() ? ((TreeNode)treeNode.get()).getId() : 0L;
                    data[accountIndex] = l;
                    return data;
                }

                public RowMeta getResultRowMeta() {
                    return rowMeta;
                }
            });
        }
        if (!this.qpRpt.isShowLeafAccount() && !this.exportAssist) {
            originalBalance = originalBalance.map(new MapFunction(){

                public Object[] map(Row row) {
                    Object[] data = ((AbstractRow)row).values();
                    int accountIndex = rowMeta.getFieldIndex("account");
                    TreeNode account = (TreeNode)accIdMap.get(data[accountIndex]);
                    while ((Integer)account.getPropValue("level") > AccBalReportExporter.this.qpRpt.getAccountLevel()) {
                        account = (TreeNode)accIdMap.get(account.getParentId());
                    }
                    data[accountIndex] = account.getId();
                    return data;
                }

                public RowMeta getResultRowMeta() {
                    return rowMeta;
                }
            });
        }
        if (this.qpRpt.isSubstractPL()) {
            masterIdSet.retainAll(this.orgProfitAccMap.values());
            if (!CollectionUtils.isEmpty(masterIdSet)) {
                originalBalance = this.substractPL(originalBalance, masterIdSet);
            }
        }
        originalBalance = this.filterBalance(originalBalance);
        if (this.qpRpt.isShowRpt()) {
            originalBalance = originalBalance.addField("org", "orgid");
            originalBalance = this.qpRpt.addCurRptField(originalBalance);
            originalBalance = originalBalance.removeFields(new String[]{"orgid"});
        }
        List fields = ReportUtils.getDataSetCols((DataSet)originalBalance);
        originalBalance = !this.qpRpt.isShowLeafAccount() && !this.exportAssist && !Objects.equals(this.qpRpt.getAccountLevel(), 1) ? BalanceSumService.sumAccountBalance(originalBalance.copy(), this.accountModel, param, "id", String.join((CharSequence)",", fields), -1) : originalBalance.addField("true", "_tag_leaf");
        return originalBalance;
    }

    private Optional<TreeNode> getAccountTreeNode(Long accountId) {
        Map<Long, TreeNode> allAccIdMap = this.accBalQuery.getAllAccIdMap();
        Map<String, TreeNode> accNumIdMap = this.accBalQuery.getAccNumIdMap();
        Map<Long, TreeNode> accIdMap = this.accBalQuery.getIdMap();
        TreeNode account = accIdMap.get(accountId);
        if (account != null) {
            return Optional.of(account);
        }
        account = allAccIdMap.get(accountId);
        int i = 0;
        while (account != null && accNumIdMap.get(account.getPropValue("number")) == null) {
            account = allAccIdMap.get(account.getId()).getParent();
            if (++i < 15) continue;
            logger.info("foreach 15 time still not found, force quit");
            return Optional.empty();
        }
        if (account == null) {
            logger.info("accountId " + accountId + "not found!");
            return Optional.empty();
        }
        if (accIdMap.get(account.getId()) == null) {
            account = accNumIdMap.get(account.getPropValue("number"));
        }
        return Optional.of(account);
    }

    private DataSet filterBalance(DataSet originalBalance) {
        String filterStr = "1=1";
        if (this.qpRpt.isNoZeroYearBal()) {
            filterStr = this.qpRpt.isNoZeroAmount() && this.qpRpt.isNoZeroBalance() ? "count > 0 or " + this.buildNoZeroBalFilterStr() + " or " + this.buildNoZeroYearBalFilterStr() : (this.qpRpt.isNoZeroAmount() ? "count > 0 or " + this.buildNoZeroYearBalFilterStr() : (this.qpRpt.isNoZeroBalance() ? this.buildNoZeroBalFilterStr() + " or " + this.buildNoZeroYearBalFilterStr() : this.buildNoZeroYearBalFilterStr()));
        } else if (this.qpRpt.isNoZeroAmount() && this.qpRpt.isNoZeroBalance()) {
            filterStr = "count > 0 or " + this.buildNoZeroBalFilterStr();
        } else {
            if (this.qpRpt.isNoZeroAmount()) {
                filterStr = "count > 0";
            }
            if (this.qpRpt.isNoZeroBalance()) {
                filterStr = this.buildNoZeroBalFilterStr();
            }
        }
        originalBalance = originalBalance.filter(filterStr);
        if (!this.qpRpt.isHideUnused()) {
            originalBalance = this.filterDefaultNoZeroBal(originalBalance);
        }
        return originalBalance;
    }

    public String buildCommonAssistFilterStr() {
        StringBuilder filterBuilder = new StringBuilder();
        List comAssistValsList = this.qpRpt.getComAssistValsList();
        for (int i = 0; i < comAssistValsList.size(); ++i) {
            if (i == 0) {
                filterBuilder.append((String)((Tuple2)comAssistValsList.get((int)i)).t1);
                filterBuilder.append(" <> 0");
                continue;
            }
            filterBuilder.append(" or ");
            filterBuilder.append((String)((Tuple2)comAssistValsList.get((int)i)).t1);
            filterBuilder.append(" <> 0");
        }
        return filterBuilder.toString();
    }

    public String buildNoZeroBalFilterStr() {
        StringBuilder filterBuilder = new StringBuilder("endlocal <> 0");
        if (this.qpRpt.isQueryCurrency()) {
            filterBuilder.append(" or endfor <> 0");
        }
        if (this.qpRpt.isShowQty()) {
            filterBuilder.append(" or endqty <> 0");
        }
        return filterBuilder.toString();
    }

    public String buildNoZeroYearBalFilterStr() {
        StringBuilder filterBuilder = new StringBuilder("yearcreditlocal <> 0 or yeardebitlocal <> 0");
        if (this.qpRpt.isQueryCurrency()) {
            filterBuilder.append(" or yeardebitfor <> 0 or yearcreditfor <> 0");
        }
        if (this.qpRpt.isShowQty()) {
            filterBuilder.append(" or yeardebitqty <> 0 or yearcreditqty <> 0");
        }
        return filterBuilder.toString();
    }

    public DataSet filterDefaultNoZeroBal(DataSet originalBalance) {
        StringBuilder filterBuilder = new StringBuilder();
        List<String> sums = this.getSumFields(originalBalance);
        for (int i = 0; i < sums.size(); ++i) {
            if (i == 0) {
                filterBuilder.append(sums.get(i));
                filterBuilder.append(" <> 0");
                continue;
            }
            filterBuilder.append(" or ");
            filterBuilder.append(sums.get(i));
            filterBuilder.append(" <> 0");
        }
        return originalBalance.filter(filterBuilder.toString());
    }

    private DataSet appendAccountInfo(DataSet balanceDataSet, boolean isTotal) {
        if (isTotal) {
            balanceDataSet = balanceDataSet.removeFields(new String[]{"rowtype"});
            balanceDataSet = balanceDataSet.addField("9", "rowtype");
            balanceDataSet = balanceDataSet.addNullField(new String[]{"account", "number"}).addField("'" + AccBalReportExporter.getTotalName() + "'", "name").addNullField(new String[]{"dc", "isleaf", "isqty", "isassist"});
        } else {
            String accountNameField = GLUtil.getAcctNameBySysParam((Long)this.qpRpt.getPorg());
            String selectFields = String.format("id account, dc, %s name, number, isleaf, isqty, level, isassist, longnumber", accountNameField);
            QFilter idQFilter = new QFilter("id", "in", this.preAccountLeafMap.keySet());
            DataSet accountDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accountview", (String)selectFields, (QFilter[])idQFilter.toArray(), null);
            if (!this.qpRpt.isShowLeafAccount()) {
                accountDataSet = accountDataSet.filter("level <=" + this.qpRpt.getAccountLevel());
            }
            List fields = ReportUtils.getDataSetCols((DataSet)balanceDataSet);
            fields.remove("account");
            balanceDataSet = balanceDataSet.join(accountDataSet, JoinType.INNER).on("account", "account").select(fields.toArray(new String[0]), new String[]{"account", "number", "name", "dc", "isleaf", "isassist", "isqty"}).finish();
        }
        return balanceDataSet;
    }

    private static String getTotalName() {
        return ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AbstractCollector_1", (String)"fi-gl-report", (Object[])new Object[0]);
    }

    private DataSet substractPL(DataSet originalBalance, Set<Long> masterIdSet) {
        DataSet initBalance = this.getInitBalanceDataSet(masterIdSet);
        List fields = GLUtil.getDataSetCols((DataSet)originalBalance);
        initBalance = initBalance.select(fields.toArray(new String[0]));
        return originalBalance.union(initBalance);
    }

    private DataSet getInitBalanceDataSet(Set<Long> masterIdSet) {
        ArrayList<String> groupList = new ArrayList<String>(8);
        ArrayList<String> selList = new ArrayList<String>(8);
        if (this.qpRpt.isQueryCurrency()) {
            groupList.add("currency");
        }
        if (this.qpRpt.isShowComassist() && !this.qpRpt.getComAssistValsList().isEmpty()) {
            this.qpRpt.getComAssistValsList().stream().forEach(x -> groupList.add((String)x.t1));
        }
        groupList.add("org");
        if (this.exportAssist) {
            groupList.add("assgrp");
        }
        if (this.qpRpt.isShowQty()) {
            groupList.add("measureunit");
        }
        selList.addAll(groupList);
        String mulcur = this.qpRpt.getFilterInfo().getString("mulcur");
        MulCurReportUtil.addInitBalanceLocalAmountField(selList, (String)mulcur);
        if (this.qpRpt.isQueryCurrency()) {
            Collections.addAll(selList, INITBALANCE_AMOUNT_FIELD.replace("#", "for").split(","));
        }
        if (this.qpRpt.isShowQty()) {
            Collections.addAll(selList, INITBALANCE_AMOUNT_FIELD.replace("#", "qty").split(","));
        }
        String selectFields = ((Object)selList).toString().replace("[", "").replace("]", "");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        Set<Long> filteredChildOrg = this.getInitBalanceFilterOrgs(masterIdSet);
        qFilters.add(new QFilter("org", "in", filteredChildOrg));
        qFilters.add(new QFilter("booktype", "=", (Object)this.qpRpt.getBookType()));
        qFilters.add(new QFilter("accounttable", "=", (Object)this.qpRpt.getAccountTable()));
        if (this.qpRpt.getAccountList() != null) {
            qFilters.add(new QFilter("account.masterid", "in", this.accBalQuery.getMasterIdMap().keySet()));
        }
        qFilters.add(new QFilter("account.pltype", "!=", (Object)"0"));
        if (!this.qpRpt.isSynCurrency() && !this.qpRpt.isAllCurrency()) {
            qFilters.add(new QFilter("currency", "=", (Object)this.qpRpt.getCurrency()));
        }
        qFilters.addAll(this.qpRpt.getComAssistFiltersForBill(key -> key));
        DataSet initBalance = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_initbalance", (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]), null);
        if (this.qpRpt.isQueryCurrency()) {
            groupList.add("0.0 debitfor");
            groupList.add("0.0 creditfor");
            groupList.add("yearprofitcreditfor - yearcreditfor yeardebitfor");
            groupList.add("yearprofitdebitfor - yeardebitfor yearcreditfor");
            groupList.add("yeardebitfor - yearprofitdebitfor + yearprofitcreditfor - yearcreditfor beginfor");
            groupList.add("yeardebitfor - yearprofitdebitfor + yearprofitcreditfor - yearcreditfor endfor");
        }
        if (this.qpRpt.isShowQty()) {
            groupList.add("0.0 debitqty");
            groupList.add("0.0 creditqty");
            groupList.add("yearprofitcreditqty - yearcreditqty yeardebitqty");
            groupList.add("yearprofitdebitqty - yeardebitqty yearcreditqty");
            groupList.add("yeardebitqty - yearprofitdebitqty + yearprofitcreditqty - yearcreditqty beginqty");
            groupList.add("yeardebitqty - yearprofitdebitqty + yearprofitcreditqty - yearcreditqty endqty");
        }
        groupList.add("0.0 debitlocal");
        groupList.add("0.0 creditlocal");
        groupList.add("yearprofitcreditlocal - yearcreditlocal yeardebitlocal");
        groupList.add("yearprofitdebitlocal - yeardebitlocal yearcreditlocal");
        groupList.add("yeardebitlocal - yearprofitdebitlocal + yearprofitcreditlocal - yearcreditlocal beginlocal");
        groupList.add("yeardebitlocal - yearprofitdebitlocal + yearprofitcreditlocal - yearcreditlocal endlocal");
        initBalance = initBalance.select(groupList.toArray(groupList.toArray(new String[0])));
        initBalance = initBalance.addField("0", "count");
        Long account = masterIdSet.iterator().next();
        initBalance = initBalance.addField(String.valueOf(account), "account");
        Optional<TreeNode> treeNode = this.getAccountTreeNode(account);
        Boolean isLeaf = treeNode.isPresent() ? (Boolean)treeNode.get().getPropValue("isleaf") : Boolean.TRUE;
        initBalance = initBalance.addField(String.valueOf(isLeaf), "account.isleaf");
        return initBalance;
    }

    private Set<Long> getInitBalanceFilterOrgs(Set<Long> masterIdSet) {
        Set filteredChildOrg = this.qpRpt.getFilteredChildOrg();
        QFilter btFilter = new QFilter("bookstype", "=", (Object)this.qpRpt.getBookType());
        long periodYear = this.qpRpt.getStartPeriod() / GLUtil.YEAR_PERIOD_L % 10000L;
        QFilter periodFilter = new QFilter("startperiod.periodyear", "=", (Object)periodYear);
        QFilter endFilter = new QFilter("isendinit", "=", (Object)true);
        DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"org", (QFilter[])new QFilter[]{btFilter, periodFilter, endFilter});
        Set closedInitOrgs = books.stream().mapToLong(x -> x.getLong("org")).boxed().collect(Collectors.toSet());
        filteredChildOrg.retainAll(closedInitOrgs);
        Set profitOrgs = this.orgProfitAccMap.entrySet().stream().filter(x -> masterIdSet.contains(x.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
        filteredChildOrg.retainAll(profitOrgs);
        return filteredChildOrg;
    }

    private Map<Long, Long> getOrgProfitAccMap() {
        Map<Long, Long> result = new HashMap<Long, Long>();
        if (!this.qpRpt.isSubstractPL()) {
            return result;
        }
        Set filteredChildOrg = this.qpRpt.getFilteredChildOrg();
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", (Object)filteredChildOrg)};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_transplprogram", (String)"org,yearprofitacct.masterid masterid", (QFilter[])filters, (String)"billno");){
            for (Row d : ds) {
                long masterid = d.getLong("masterid");
                result.putIfAbsent(d.getLong("org"), masterid);
            }
        }
        result = result.entrySet().stream().filter(x -> this.accBalQuery.getMasterIdMap().containsKey(x.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return result;
    }

    private boolean getSingleQueryFlag() {
        return this.exportAssist || this.qpRpt.isShowOrg() || this.orgProfitAccMap.values().retainAll(this.qpRpt.getMasterIdSet()) && this.qpRpt.isSubstractPL();
    }

    public void setAccBalQuery(AccBalAccountQuery accBalQuery) {
        this.accBalQuery = accBalQuery;
    }

    public void setQpRpt(MulOrgQPRpt qpRpt) {
        this.qpRpt = qpRpt;
    }

    public void setChain(BatchProcessorChain<Row, Void> chain) {
        this.chain = chain;
    }

    public void setOrgProfitAccMap(Map<Long, Long> orgProfitAccMap) {
        this.orgProfitAccMap = orgProfitAccMap;
    }

    public void setAccBalanceHelper(AccBalanceHelper accBalanceHelper) {
        this.accBalanceHelper = accBalanceHelper;
    }

    public void setExportAssist(boolean exportAssist) {
        this.exportAssist = exportAssist;
    }
}

